/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.org.cache.es;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.query.es.EsBatchValue;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.business.service.query.es.storage.EsResultVo;
import kd.hr.hbp.business.service.query.es.storage.EsStorage;
import kd.hr.hbp.business.service.query.es.storage.EsStorageFactory;

public class ReportEsStorageService {
    private static final String HR_REPORT_INDEX_REGIN = "hr";
    private static final String INDEX_TYPE_NAME = "t_data";

    public static EsStorage getEsStorage() {
        EsStorage esStorage = EsStorageFactory.getStorage((String)HR_REPORT_INDEX_REGIN);
        if (esStorage == null) {
            throw new KDBizException("getEsStorage_is_null");
        }
        return esStorage;
    }

    public static void createIndex(String indexName) {
        EsStorage esStorage = ReportEsStorageService.getEsStorage();
        esStorage.createIndex(HR_REPORT_INDEX_REGIN, indexName, null);
    }

    public static boolean deleteIndex(String indexName) {
        EsStorage esStorage = ReportEsStorageService.getEsStorage();
        return esStorage.deleteIndex(indexName);
    }

    public static void batchSave(String indexName, EsBatchValue ... values) {
        EsStorage esStorage = ReportEsStorageService.getEsStorage();
        esStorage.batchSave(indexName, INDEX_TYPE_NAME, values);
    }

    public static void deleteByQuery(String indexName, List<QFilter> filters) {
        if (filters == null) {
            throw new KDBizException("QFilters_can_not_be_null");
        }
        EsStorage esStorage = ReportEsStorageService.getEsStorage();
        esStorage.deleteByQuery(indexName, INDEX_TYPE_NAME, filters.stream().map(ReportEsStorageService::convertToEsFilter).collect(Collectors.toList()));
    }

    public static EsResultVo queryByFilters(String indexName, String[] selectFields, List<QFilter> filters, boolean score, int start, int size) {
        if (filters == null || filters.isEmpty()) {
            throw new KDBizException("QFilters_can_not_be_empty");
        }
        if (selectFields == null || selectFields.length == 0) {
            throw new KDBizException("selectFields_can_not_be_empty");
        }
        EsStorage esStorage = ReportEsStorageService.getEsStorage();
        return esStorage.query(indexName, INDEX_TYPE_NAME, selectFields, filters.stream().map(ReportEsStorageService::convertToEsFilter).collect(Collectors.toList()), null, score, start, size);
    }

    private static EsFilterField convertToEsFilter(QFilter qFilter) {
        return new EsFilterField(qFilter.getProperty(), qFilter.getCP(), new Object[]{qFilter.getValue()});
    }

    public static boolean ping() throws IOException {
        EsStorage esStorage = ReportEsStorageService.getEsStorage();
        return esStorage.ping();
    }

    public static boolean removeIndices(String indexPrefix) {
        EsStorage esStorage = ReportEsStorageService.getEsStorage();
        return esStorage.removeIndices(indexPrefix);
    }
}

