/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.org.func;

import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.RowX;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.datastore.metadata.model.RptMetaFieldMap;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXField;
import kd.hr.hrptmc.business.repcalculate.org.model.AdminOrg;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import org.apache.commons.collections.CollectionUtils;

public class AdminOrgFlatMapFunction
extends FlatMapFunction {
    private static final long serialVersionUID = 4568015498390258294L;
    private RowMeta rowMeta;
    private int adminOrgLongNumberAliasIndex;
    private int[] adminOrgNumberAliasIndexArray;
    private int[] adminOrgNameAliasIndexArray;
    private int adminOrgIdAliasIndex;
    private Map<String, AdminOrg> longNumberOrgMap;
    private String adminOrgFieldPrefixAlias;
    private boolean isShowAllSubOrg;
    private List<Long> selectOrgIds;
    private List<RptMetaFieldMap> storeFieldMapList;

    public AdminOrgFlatMapFunction(AdminOrgSummaryInfo adminOrgSummaryInfo, RowMeta rowMeta) {
        this.init(adminOrgSummaryInfo, rowMeta, null);
    }

    public AdminOrgFlatMapFunction(AdminOrgSummaryInfo adminOrgSummaryInfo, RowMeta rowMeta, List<RptMetaFieldMap> storeFieldMapList) {
        this.init(adminOrgSummaryInfo, rowMeta, storeFieldMapList);
    }

    public final void init(AdminOrgSummaryInfo adminOrgSummaryInfo, RowMeta rowMeta, List<RptMetaFieldMap> storeFieldMapList) {
        this.storeFieldMapList = storeFieldMapList;
        this.rowMeta = rowMeta;
        this.adminOrgLongNumberAliasIndex = rowMeta.getFieldIndex("ROW_FIELD_ADMIN_ORG_LONG_NUMBER");
        String adminOrgSelectField = adminOrgSummaryInfo.getAdminOrgSelectField();
        boolean isAlgoX = false;
        int idFieldIndex = rowMeta.getFieldIndex(adminOrgSelectField, false);
        if (idFieldIndex == -1) {
            String orgIdAlgoXAlias = AlgoXFieldInfo.replaceAlgoxAlias((String)adminOrgSelectField);
            idFieldIndex = rowMeta.getFieldIndex(orgIdAlgoXAlias, false);
            if (idFieldIndex == -1) {
                idFieldIndex = rowMeta.getFieldIndex(AlgoXField.buildAlgoXAliasExtend(orgIdAlgoXAlias, orgIdAlgoXAlias));
            }
            this.adminOrgIdAliasIndex = idFieldIndex;
            this.adminOrgFieldPrefixAlias = AlgoXFieldInfo.replaceAlgoxAlias((String)adminOrgSummaryInfo.getAdminOrgFieldPrefix());
            isAlgoX = true;
        } else {
            this.adminOrgIdAliasIndex = idFieldIndex;
            this.adminOrgFieldPrefixAlias = adminOrgSummaryInfo.getAdminOrgFieldPrefix();
        }
        String docSplit = isAlgoX ? "_DOC_SPLIT_" : ".";
        this.longNumberOrgMap = adminOrgSummaryInfo.getAdminLongNumberMap();
        this.adminOrgNumberAliasIndexArray = IntStream.range(0, rowMeta.getFieldCount()).filter(index -> HRStringUtils.isNotEmpty((String)rowMeta.getField(index).getAlias()) && rowMeta.getField(index).getAlias().startsWith(this.adminOrgNumberAlias(adminOrgSummaryInfo, docSplit))).toArray();
        this.adminOrgNameAliasIndexArray = IntStream.range(0, rowMeta.getFieldCount()).filter(index -> HRStringUtils.isNotEmpty((String)rowMeta.getField(index).getAlias()) && rowMeta.getField(index).getAlias().startsWith(this.adminOrgNameAlias(adminOrgSummaryInfo, docSplit))).toArray();
        this.isShowAllSubOrg = adminOrgSummaryInfo.getTreeShow() || adminOrgSummaryInfo.getSelectEmpty();
        this.selectOrgIds = adminOrgSummaryInfo.getAdminOrgIds();
    }

    private String adminOrgNameAlias(AdminOrgSummaryInfo adminOrgSummaryInfo, String docSplit) {
        if (this.storeFieldMapList == null || this.storeFieldMapList.isEmpty()) {
            return this.adminOrgFieldPrefixAlias + docSplit + "name";
        }
        for (RptMetaFieldMap rptMetaFieldMap : this.storeFieldMapList) {
            if (!HRStringUtils.equals((String)rptMetaFieldMap.getMetaFieldNumber(), (String)adminOrgSummaryInfo.getAdminOrgSelectField())) continue;
            String originNum = rptMetaFieldMap.getFieldAlias().replace(docSplit + "id", docSplit + "name");
            for (RptMetaFieldMap metaFieldMap : this.storeFieldMapList) {
                if (!HRStringUtils.equals((String)metaFieldMap.getFieldAlias(), (String)originNum)) continue;
                return metaFieldMap.getMetaFieldNumber();
            }
        }
        return this.adminOrgFieldPrefixAlias + docSplit + "name";
    }

    private String adminOrgNumberAlias(AdminOrgSummaryInfo adminOrgSummaryInfo, String docSplit) {
        if (this.storeFieldMapList == null || this.storeFieldMapList.isEmpty()) {
            return this.adminOrgFieldPrefixAlias + docSplit + "number";
        }
        for (RptMetaFieldMap rptMetaFieldMap : this.storeFieldMapList) {
            if (!HRStringUtils.equals((String)rptMetaFieldMap.getMetaFieldNumber(), (String)adminOrgSummaryInfo.getAdminOrgSelectField())) continue;
            String originNum = rptMetaFieldMap.getFieldAlias().replace(docSplit + "id", docSplit + "number");
            for (RptMetaFieldMap metaFieldMap : this.storeFieldMapList) {
                if (!HRStringUtils.equals((String)metaFieldMap.getFieldAlias(), (String)originNum)) continue;
                return metaFieldMap.getMetaFieldNumber();
            }
        }
        return this.adminOrgFieldPrefixAlias + docSplit + "name";
    }

    public void flatMap(RowX rowX, Collector collector) {
        String orgStructLongNumber = rowX.getString(this.adminOrgLongNumberAliasIndex);
        String[] structNumbers = orgStructLongNumber.split("!");
        String tmpStructLongNumber = "";
        for (int i = 0; i < structNumbers.length; ++i) {
            tmpStructLongNumber = i == 0 ? structNumbers[i] : tmpStructLongNumber + "!" + structNumbers[i];
            AdminOrg org = this.longNumberOrgMap.get(tmpStructLongNumber);
            if (org == null || !this.isShowAllSubOrg && CollectionUtils.isNotEmpty(this.selectOrgIds) && !this.selectOrgIds.contains(org.getOrgId())) continue;
            RowX newRow = rowX.copy();
            newRow.set(this.adminOrgLongNumberAliasIndex, (Object)tmpStructLongNumber);
            Long nowOrgId = rowX.getLong(this.adminOrgIdAliasIndex);
            if (nowOrgId.longValue() != org.getOrgId()) {
                newRow.set(this.adminOrgIdAliasIndex, (Object)org.getOrgId());
                for (int adminOrgNumberAliasIndex : this.adminOrgNumberAliasIndexArray) {
                    newRow.set(adminOrgNumberAliasIndex, org.getShowValue("number"));
                }
                for (int adminOrgNameAliasIndex : this.adminOrgNameAliasIndexArray) {
                    newRow.set(adminOrgNameAliasIndex, org.getShowValue("name"));
                }
            }
            collector.collect(newRow);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

