/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.org.func;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXField;
import kd.hr.hrptmc.business.repcalculate.org.model.AdminOrg;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;

public class AdminOrgLongNumberMapFunction
extends MapFunction {
    private static final long serialVersionUID = -1024307095090558523L;
    private static final Log LOGGER = LogFactory.getLog(AdminOrgLongNumberMapFunction.class);
    private final Map<Long, AdminOrg> adminOrgIdMap;
    private final RowMeta rowMeta;
    private final int adminOrgIdFieldIndex;
    private final int adminLongNumberIndex;
    private final int originalAdminOrgIdIndex;

    public AdminOrgLongNumberMapFunction(AdminOrgSummaryInfo adminOrgSummaryInfo, RowMeta rowMeta) {
        String orgIdAlgoXAlias;
        this.adminOrgIdMap = adminOrgSummaryInfo.getAdminOrgIdMap();
        this.rowMeta = rowMeta;
        String adminOrgSelectField = adminOrgSummaryInfo.getAdminOrgSelectField();
        int idFieldIndex = rowMeta.getFieldIndex(adminOrgSelectField, false);
        if (idFieldIndex == -1 && (idFieldIndex = rowMeta.getFieldIndex(orgIdAlgoXAlias = AlgoXFieldInfo.replaceAlgoxAlias((String)adminOrgSelectField), false)) == -1) {
            idFieldIndex = rowMeta.getFieldIndex(AlgoXField.buildAlgoXAliasExtend(orgIdAlgoXAlias, orgIdAlgoXAlias));
        }
        this.adminOrgIdFieldIndex = idFieldIndex;
        RowMeta resultRowMeta = this.getResultRowMeta();
        this.adminLongNumberIndex = resultRowMeta.getFieldIndex("ROW_FIELD_ADMIN_ORG_LONG_NUMBER");
        this.originalAdminOrgIdIndex = resultRowMeta.getFieldIndex("ROW_FIELD_ADMIN_ORG_ORIGINAL_ID");
    }

    public RowX map(RowX rowX) {
        Long orgId = rowX.getLong(this.adminOrgIdFieldIndex);
        RowX newRow = new RowX(this.getResultRowMeta().getFieldCount());
        AdminOrg org = this.adminOrgIdMap.get(orgId);
        String structLongNumber = "";
        if (org == null) {
            LOGGER.info("get_org_is_null_from_id_ {}", (Object)orgId);
        } else {
            structLongNumber = org.getStructLongNumber();
        }
        for (int index = 0; index < rowX.values().length; ++index) {
            newRow.set(index, rowX.get(index));
        }
        newRow.set(this.adminLongNumberIndex, (Object)structLongNumber);
        newRow.set(this.originalAdminOrgIdIndex, (Object)orgId);
        return newRow;
    }

    public final RowMeta getResultRowMeta() {
        Field[] oldFields = this.rowMeta.getFields();
        ArrayList fieldList = Lists.newArrayList(Arrays.asList(oldFields));
        Set fieldNameSet = fieldList.stream().map(Field::getName).collect(Collectors.toSet());
        Field structLongNumberField = new Field("ROW_FIELD_ADMIN_ORG_LONG_NUMBER", (DataType)DataType.StringType);
        Field originalAdminOrgIdField = new Field("ROW_FIELD_ADMIN_ORG_ORIGINAL_ID", (DataType)DataType.LongType);
        if (fieldNameSet.add(structLongNumberField.getName())) {
            fieldList.add(structLongNumberField);
        }
        if (fieldNameSet.add(originalAdminOrgIdField.getName())) {
            fieldList.add(originalAdminOrgIdField);
        }
        return new RowMeta(fieldList.toArray(new Field[0]));
    }
}

