/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.org.func;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class AdminOrgReduceFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -6591929955265547429L;
    private final RowMeta rowMeta;
    private final Set<String> presetIndexFields;

    public AdminOrgReduceFunction(RowMeta rowMeta, Set<String> presetIndexFields) {
        this.rowMeta = rowMeta;
        this.presetIndexFields = presetIndexFields;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Field[] fields = this.rowMeta.getFields();
        RowX resultRowX = new RowX(fields.length);
        for (RowX rowX : iterable) {
            for (int index = 0; index < fields.length; ++index) {
                String aliasName = fields[index].getName();
                if (aliasName.contains("\u03b1") && !this.presetIndexFields.contains(aliasName.split("\u03b1")[0])) {
                    this.setTotalCalculateResultRowX(resultRowX, rowX, index, aliasName);
                    continue;
                }
                Object value = rowX.get(index);
                if (value == null) continue;
                resultRowX.set(index, value);
            }
        }
        collector.collect(resultRowX);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private void setTotalCalculateResultRowX(RowX resultRowX, RowX rowX, int index, String aliasName) {
        String[] tempArr = aliasName.split("\u03b1");
        String fieldName = tempArr[0];
        String calculateSuffix = tempArr[1];
        if ("sum".equals(calculateSuffix) || "count".equals(calculateSuffix)) {
            this.setTotalSumCalculateResultRowX(resultRowX, rowX, index);
        }
        if ("avg".equals(calculateSuffix)) {
            this.setTotalAvgCalculateResultRowX(resultRowX, rowX, index, fieldName);
        }
    }

    private BigDecimal setTotalSumCalculateResultRowX(RowX resultRowX, RowX rowX, int index) {
        BigDecimal calculateVal = rowX.getBigDecimal(index);
        BigDecimal nowVal = resultRowX.getBigDecimal(index);
        if (nowVal == null) {
            nowVal = BigDecimal.ZERO;
        }
        nowVal = nowVal.add(calculateVal == null ? BigDecimal.ZERO : calculateVal);
        resultRowX.set(index, this.convertBigDecimalValueType(nowVal, index));
        return nowVal;
    }

    public void setTotalAvgCalculateResultRowX(RowX resultRowX, RowX rowX, int index, String fieldName) {
        String avgSumFieldName = fieldName + '\u03b1' + "avgsum";
        int avgSumIndex = this.rowMeta.getFieldIndex(avgSumFieldName);
        BigDecimal sumVal = this.setTotalSumCalculateResultRowX(resultRowX, rowX, avgSumIndex);
        String countFieldName = fieldName + '\u03b1' + "avgcount";
        int countFieldIndex = this.rowMeta.getFieldIndex(countFieldName);
        BigDecimal countVal = this.setTotalSumCalculateResultRowX(resultRowX, rowX, countFieldIndex);
        if (countVal.equals(BigDecimal.ZERO)) {
            resultRowX.set(index, null);
            return;
        }
        BigDecimal avgVal = sumVal.divide(countVal, 10, RoundingMode.HALF_DOWN);
        resultRowX.set(index, (Object)avgVal);
    }

    private Object convertBigDecimalValueType(BigDecimal bigDecimal, int fieldIndex) {
        Field field = this.rowMeta.getField(fieldIndex);
        Number resultValue = DataType.IntegerType.equals((Object)field.getDataType()) ? (Number)bigDecimal.intValue() : (Number)(DataType.LongType.equals((Object)field.getDataType()) ? Long.valueOf(bigDecimal.longValue()) : bigDecimal);
        return resultValue;
    }
}

