/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.org.handler;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.util.TraceIdUtil;
import kd.hr.hrptmc.business.repcalculate.ReportCalculateHandler;
import kd.hr.hrptmc.business.repcalculate.algox.helper.AlgoxJobKeyHelper;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.org.func.AdminOrgFlatMapFunction;
import kd.hr.hrptmc.business.repcalculate.org.func.AdminOrgLongNumberMapFunction;
import kd.hr.hrptmc.business.repcalculate.org.func.AdminOrgReduceFunction;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;

public class AdminOrgGroupHandler
extends ReportCalculateHandler {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgGroupHandler.class);
    private static final String SESSION_JOB_NAME = "HR_REPORT_ADMIN_ORG_JOB_GROUP";
    private static final String SESSION_JOB_TITLE = "HR_REPORT_ADMIN_ORG_JOB_GROUP_TITLE";
    private final AdminOrgSummaryInfo adminOrgSummaryInfo;
    private String algoXJobKey;

    public AdminOrgGroupHandler(ReportCalculateInfo calculateInfo) {
        super(calculateInfo);
        this.adminOrgSummaryInfo = calculateInfo.getAdminOrgSummaryInfo();
        if (calculateInfo.getAnObjRelId() == null || calculateInfo.getAnObjRelId() == 0L) {
            return;
        }
        this.algoXJobKey = calculateInfo.getReportId() != null && calculateInfo.getReportId() != 0L ? AlgoxJobKeyHelper.getRepAlgoxJobKeyByReportmanage(calculateInfo.getReportId()) : AlgoxJobKeyHelper.getRepAlgoxJobKeyByAnalyseObject(calculateInfo.getAnObjRelId());
    }

    @Override
    public DataSet doHandler(DataSet dataSet) {
        if (this.checkNeedOrgGroup()) {
            this.calculateInfo.getCostTimeHelper().nestedStart();
            String traceId = TraceIdUtil.getCurrentTraceIdString();
            JobSession session = AlgoX.createSession((String)(SESSION_JOB_NAME + this.algoXJobKey + "_" + traceId), (String)(SESSION_JOB_TITLE + this.algoXJobKey + "_" + traceId));
            DataSet resultDataSet = dataSet;
            LOGGER.info("[repcalculate-ALGOX] AdminOrgGroupHandler doHandler algoXJobKey:{}", (Object)this.algoXJobKey);
            if (this.adminOrgSummaryInfo.getAdminOrgIdMap() != null && this.adminOrgSummaryInfo.getAdminLongNumberMap() != null) {
                Set<String> presetIndexFields = this.calculateInfo.getRowFieldList().stream().filter(field -> field instanceof PresetIndexField).map(ReportField::getUniqueKey).collect(Collectors.toSet());
                DataSetX dataSetX = session.fromInput((Input)new DataSetInput(dataSet));
                int fieldIndex = dataSetX.getRowMeta().getFieldIndex("ROW_FIELD_ADMIN_ORG_LONG_NUMBER", false);
                DataSetX addLongStructNumberDataSetX = dataSetX;
                RowMeta newRowMeta = dataSetX.getRowMeta();
                if (fieldIndex < 0) {
                    addLongStructNumberDataSetX = dataSetX.map((MapFunction)new AdminOrgLongNumberMapFunction(this.adminOrgSummaryInfo, dataSetX.getRowMeta()));
                    newRowMeta = addLongStructNumberDataSetX.getRowMeta();
                }
                DataSetX newResultDataSetX = addLongStructNumberDataSetX;
                if (!this.adminOrgSummaryInfo.getHasDoneFlatMap()) {
                    newResultDataSetX = addLongStructNumberDataSetX.flatMap((FlatMapFunction)new AdminOrgFlatMapFunction(this.adminOrgSummaryInfo, newRowMeta, this.calculateInfo.getStoreFieldMapList()));
                }
                newResultDataSetX = newResultDataSetX.groupBy(new String[]{"ROW_FIELD_ADMIN_ORG_LONG_NUMBER"}).reduceGroup((GroupReduceFunction)new AdminOrgReduceFunction(newRowMeta, presetIndexFields)).orderBy(new String[]{"ROW_FIELD_ADMIN_ORG_LONG_NUMBER"});
                DataSetOutput output = new DataSetOutput(newResultDataSetX.getRowMeta());
                String id = output.getId();
                newResultDataSetX.output((Output)output);
                session.commit(600, TimeUnit.SECONDS);
                resultDataSet = session.readDataSet(id);
            }
            this.calculateInfo.getCostTimeHelper().logCost("AdminOrgGroupHandler", "AdminOrgGroupHandler");
            return this.doNext(resultDataSet);
        }
        return this.doNext(dataSet);
    }

    private boolean checkNeedOrgGroup() {
        return this.adminOrgSummaryInfo != null && this.adminOrgSummaryInfo.getTreeShow() && this.adminOrgSummaryInfo.getIncludeSubOrg();
    }
}

