/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import org.springframework.util.DigestUtils;

public class CacheUtils {
    public static String generateCacheKey(Long id, List<QFilter> qFilters, List<ReportField> rowFieldList, List<ReportField> columnFieldList, boolean isIncludeSubOrg) {
        StringBuilder sb = new StringBuilder();
        sb.append(id);
        if (qFilters != null) {
            qFilters.stream().filter(Objects::nonNull).forEach(qFilter -> sb.append(qFilter.toSerializedString()));
        }
        List rowList = rowFieldList.stream().filter(field -> !field.isDependField()).collect(Collectors.toList());
        List colList = columnFieldList.stream().filter(field -> !field.isDependField()).collect(Collectors.toList());
        sb.append(rowList);
        sb.append(colList);
        sb.append("isIncludeSubOrg=").append(isIncludeSubOrg);
        String key = sb.append(RequestContext.get().getCurrUserId()).toString();
        return DigestUtils.md5DigestAsHex((byte[])key.getBytes());
    }

    public static void putPageCache(String pageId, String key, Object value) {
        PageCache pageCache = new PageCache(pageId);
        if (value instanceof String) {
            pageCache.put(key, (String)value);
        } else {
            pageCache.put(key, JSONObject.toJSONString((Object)value));
        }
    }

    public static <T> List<T> getListFromPageCache(String pageId, String key, Class<T> clazz) {
        PageCache pageCache = new PageCache(pageId);
        String valueStr = pageCache.get(key);
        if (HRStringUtils.isEmpty((String)valueStr)) {
            return null;
        }
        return JSONArray.parseArray((String)valueStr, clazz);
    }
}

