/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.model.DimensionData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.FieldSortInfo;

public class DimensionAllValueHelper {
    private static final Log LOGGER = LogFactory.getLog(DimensionAllValueHelper.class);
    private static long DIMENSION_MAX_DATA_COUNT = 1000L;
    protected final HRComplexObjContext complexObjContext;
    protected final Set<String> entityNumberSet = Sets.newHashSetWithExpectedSize((int)16);

    public DimensionAllValueHelper(HRComplexObjContext complexObjContext) {
        this.complexObjContext = complexObjContext;
        this.entityNumberSet.add(complexObjContext.getEntityNumber());
        List joinRelationList = complexObjContext.getJoinRelationList();
        if (joinRelationList != null && !joinRelationList.isEmpty()) {
            for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
                if (joinRelation == null) continue;
                this.entityNumberSet.add(joinRelation.getRelEntityNumber());
            }
        }
        if (complexObjContext.getDimensionMaxDataCount() > 0L) {
            DIMENSION_MAX_DATA_COUNT = complexObjContext.getDimensionMaxDataCount();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @ExcludeFromJacocoGeneratedReport
    protected List<DimensionData> getEnumAllValue(String entityNumber, String propertyName, boolean isCustomOrder) {
        ComboProp property;
        block9: {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            if (propertyName.contains(".")) {
                String[] splitValue = propertyName.split("\\.");
                String propName = splitValue[0];
                DynamicProperty prop = dataEntityType.getProperty(propName);
                if (prop == null && splitValue.length > 1) {
                    propName = splitValue[1];
                    prop = dataEntityType.getProperty(propName);
                }
                if (prop == null && splitValue.length > 2) {
                    propName = splitValue[2];
                    prop = dataEntityType.getProperty(propName);
                }
                if (prop instanceof EntryProp) {
                    EntityType entityType = (EntityType)dataEntityType.getAllEntities().get(propName);
                    if (entityType != null && splitValue.length > 1) {
                        String entryPropertyName = splitValue[splitValue.length - 1];
                        property = (ComboProp)entityType.getProperty(entryPropertyName);
                        break block9;
                    } else {
                        LOGGER.error(MessageFormat.format("get_entry_property_error_propertyName_is_{0}", propertyName));
                        return new ArrayList<DimensionData>(0);
                    }
                }
                if (!(prop instanceof ComboProp)) {
                    LOGGER.error(MessageFormat.format("get_entry_property_error_propertyName_is_{0}", propertyName));
                    return new ArrayList<DimensionData>(0);
                }
                property = (ComboProp)prop;
            } else {
                property = (ComboProp)dataEntityType.getProperty(propertyName);
            }
        }
        if (property == null) {
            LOGGER.error(MessageFormat.format("get_combo_property_is_null_propertyName_is_{0}", propertyName));
            return new ArrayList<DimensionData>(0);
        }
        return property.getComboItems().stream().map(item -> new DimensionData(item.getValue(), item.getName().getLocaleValue(), isCustomOrder, null)).collect(Collectors.toList());
    }

    protected List<DimensionData> getBaseDataAllValue(FieldComplexType fieldComplexType, String entityNumber, String propertyName, boolean isCustomOrder) {
        DynamicProperty isCurrentProperty;
        String realPropertyName;
        HRBaseServiceHelper baseDataHelper = new HRBaseServiceHelper(entityNumber);
        String[] splitArray = propertyName.split("\\.");
        if (splitArray.length < 2) {
            return new ArrayList<DimensionData>(0);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DynamicProperty property = dataEntityType.getProperty(realPropertyName = splitArray[1]);
        if (property == null && splitArray.length > 2) {
            realPropertyName = splitArray[2];
            property = dataEntityType.getProperty(realPropertyName);
        }
        if (property == null) {
            LOGGER.error(MessageFormat.format("get_baseData_property_is_null_entityNumber_is_{0},propertyName_is_{1}", entityNumber, propertyName));
            return new ArrayList<DimensionData>(0);
        }
        ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
        String finalPropertyName = realPropertyName;
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)10);
        DynamicProperty enableProperty = dataEntityType.getProperty("enable");
        if (enableProperty != null) {
            qFilterList.add(new QFilter("enable", "=", (Object)"1"));
        }
        if ((FieldComplexType.HIS_BASE_DATA == fieldComplexType || FieldComplexType.ADMIN_ORG == fieldComplexType) && (isCurrentProperty = dataEntityType.getProperty("iscurrentversion")) != null) {
            qFilterList.add(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1')));
        }
        DynamicObject[] dbData = baseDataHelper.queryOriginalArray(primaryKey.getName() + "," + finalPropertyName, qFilterList.toArray(new QFilter[0]));
        return Arrays.stream(dbData).map(dy -> new DimensionData(dy.getString(primaryKey.getName()), dy.getString(finalPropertyName), isCustomOrder, null)).collect(Collectors.toList());
    }

    protected List<Map<String, DimensionData>> exhaustAllDimensionData(Collection<String> fieldAliases, Map<String, List<DimensionData>> allDimensionDataMap) {
        long count = 1L;
        for (Map.Entry<String, List<DimensionData>> allDimensionDataEntry : allDimensionDataMap.entrySet()) {
            int size = allDimensionDataEntry.getValue().size();
            LOGGER.info("DimensionData_alias_is_{},count_is_{}", (Object)allDimensionDataEntry.getKey(), (Object)size);
            LOGGER.info("DimensionData_alias_is_{},value_is_{}", (Object)allDimensionDataEntry.getKey(), allDimensionDataEntry.getValue());
            count *= (long)size;
        }
        LOGGER.info("DimensionData_totalCount_is_{}", (Object)count);
        if (count > DIMENSION_MAX_DATA_COUNT) {
            throw new KDBizException(ResManager.loadKDString((String)MessageFormat.format("\u7ef4\u5ea6\u6570\u91cf\u8d85\u8fc7{0}\u3002", DIMENSION_MAX_DATA_COUNT), (String)"DimensionAllValueHelper_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
        ArrayList returnDimensionDataMap = Lists.newArrayListWithExpectedSize((int)((int)count));
        for (String fieldAlias : fieldAliases) {
            List<DimensionData> allDimensionDataSet = allDimensionDataMap.get(fieldAlias);
            ArrayList tempList = Lists.newArrayListWithExpectedSize((int)((returnDimensionDataMap.size() + 1) * allDimensionDataSet.size()));
            tempList.addAll(returnDimensionDataMap);
            returnDimensionDataMap.clear();
            for (DimensionData DimensionData2 : allDimensionDataSet) {
                HashMap currentDimMap = Maps.newHashMapWithExpectedSize((int)1);
                currentDimMap.put(fieldAlias, DimensionData2);
                if (!tempList.isEmpty()) {
                    for (Map preDimMap : tempList) {
                        HashMap dimMap = Maps.newHashMapWithExpectedSize((int)(preDimMap.size() + 1));
                        dimMap.putAll(preDimMap);
                        dimMap.putAll(currentDimMap);
                        returnDimensionDataMap.add(dimMap);
                    }
                    continue;
                }
                returnDimensionDataMap.add(currentDimMap);
            }
        }
        return returnDimensionDataMap;
    }

    @ExcludeFromJacocoGeneratedReport
    protected String getEntityNumberFromFullPath(String fieldFullPath) {
        String entityNumber = fieldFullPath.split("\\.")[0];
        if (!(this.entityNumberSet.contains(entityNumber) || this.complexObjContext.getVirtualEntity().booleanValue() && MetadataDao.checkNumber((String)entityNumber))) {
            entityNumber = this.complexObjContext.getEntityNumber();
        }
        return entityNumber;
    }

    protected String getRealFieldNameFromFullPath(String entityNumber, String fieldFullPath) {
        return fieldFullPath.replaceFirst(entityNumber + "\\.", "");
    }

    public static List<Map<String, Object>> convertToObjMapList(List<Map<String, DimensionData>> DimensionData2) {
        return DimensionData2.stream().map(aliasToDimMap -> {
            HashMap dimMap = Maps.newHashMapWithExpectedSize((int)aliasToDimMap.size());
            for (Map.Entry aliasToDimensionDataEntry : aliasToDimMap.entrySet()) {
                dimMap.put(aliasToDimensionDataEntry.getKey(), ((DimensionData)aliasToDimensionDataEntry.getValue()).getValue());
            }
            return dimMap;
        }).collect(Collectors.toList());
    }

    protected List<DimensionData> distinctDimensionData(ReportField reportField, List<DimensionData> dimensionData) {
        Map distinctDimensionMap = dimensionData.stream().collect(Collectors.toMap(dimension -> {
            if (reportField == null) {
                return dimension.getValue();
            }
            if (SortEnum.CUSTOM.getValue().equals(reportField.getSortord())) {
                return dimension.getId();
            }
            return dimension.getValue();
        }, Function.identity(), (d1, d2) -> {
            if (reportField == null) {
                return d1;
            }
            String fieldType = reportField.getFieldType();
            String sort = reportField.getSortord();
            String compareValue1 = d1.getValue();
            String compareValue2 = d2.getValue();
            FieldSortInfo fieldSort = reportField.getFieldSort();
            if (fieldSort != null) {
                fieldType = fieldSort.getFieldType();
                sort = fieldSort.getSort();
                compareValue1 = d1.getReferToOrderValue();
                compareValue2 = d2.getReferToOrderValue();
            }
            if (compareValue2 == null || "".equals(compareValue2) || "null".equals(compareValue2)) {
                return d1;
            }
            int compareResult = DimensionData.sortCompareTo((String)fieldType, (String)sort, (Object)compareValue1, (Object)compareValue2);
            if (compareResult > 0) {
                return d2;
            }
            return d1;
        }));
        return Lists.newArrayList(distinctDimensionMap.values());
    }
}

