/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hrptmc.business.repdesign.field.ReportField;

public class ReportFieldMethodInvokeUtil {
    private static final Log LOGGER = LogFactory.getLog(ReportFieldMethodInvokeUtil.class);

    public static <T extends ReportField> Set<String> invokeSetMethod(T reportField, String methodName) {
        try {
            Method method = reportField.getClass().getMethod(methodName, new Class[0]);
            Object methodResult = method.invoke(reportField, new Object[0]);
            if (methodResult instanceof Set) {
                return (Set)methodResult;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error((Throwable)e);
        }
        return new HashSet<String>(0);
    }

    public static <T extends ReportField, R> R invokeMethod(T reportField, String methodName, Class<R> returnType) {
        try {
            Method method = reportField.getClass().getMethod(methodName, new Class[0]);
            Object result = method.invoke(reportField, new Object[0]);
            return returnType.cast(result);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error((Throwable)e);
            return null;
        }
    }
}

