/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.utils;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.MainEntityType;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.LatitudeField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;

public class ReportFieldUtils {
    public static String getIndexCalcFunction(ReportField field) {
        String calcFunction = null;
        if (field instanceof EntityPrimitiveIndexField) {
            EntityPrimitiveIndexField primitiveIndexField = (EntityPrimitiveIndexField)field;
            calcFunction = primitiveIndexField.getCalcFunction();
        } else if (field instanceof AggregateIndexField) {
            AggregateIndexField aggregateIndexField = (AggregateIndexField)field;
            if (aggregateIndexField.isIndexField()) {
                calcFunction = aggregateIndexField.getCalcFunction();
            }
        } else if (field instanceof PresetIndexField) {
            calcFunction = "avg";
            return calcFunction;
        }
        return calcFunction;
    }

    public static String genGroupByCalFieldAlias(String fieldAlias, String calFunction) {
        return fieldAlias + "\u03b1" + calFunction;
    }

    public static HRComplexObjFieldInfo entityField2ComplexField(EntityPropField field) {
        HRComplexObjFieldInfo fieldInfo = new HRComplexObjFieldInfo(field.getPropFullPath(), "1", field.getFieldAlias());
        fieldInfo.setDataType(DataTypeEnum.of((String)field.getFieldType()));
        fieldInfo.setDependField(field.isDependField());
        fieldInfo.setTimeZoneInfo(field.getTimeZoneInfo());
        return fieldInfo;
    }

    public static HRComplexObjFieldInfo aggregateIndexField2ComplexField(AggregateIndexField field) {
        HRComplexObjFieldInfo fieldInfo = new HRComplexObjFieldInfo(field.getCalcFormulaInfo(), "3", field.getFieldAlias());
        fieldInfo.setDataType(DataTypeEnum.of((String)field.getFieldType()));
        fieldInfo.setRefFieldAliasSet(field.getDependentFieldSet());
        fieldInfo.setDependField(field.isDependField());
        return fieldInfo;
    }

    public static HRComplexObjFieldInfo presetIndexField2ComplexField(PresetIndexField field) {
        HRComplexObjFieldInfo fieldInfo = new HRComplexObjFieldInfo(field.getFieldAlias(), "4", field.getFieldAlias());
        fieldInfo.setDataType(DataTypeEnum.BIGDECIMAL);
        fieldInfo.setDependField(field.isDependField());
        return fieldInfo;
    }

    public static List<HRComplexObjFieldInfo> getGroupByComplexFieldsWithDepend(List<ReportField> groupFieldList) {
        return groupFieldList.stream().filter(field -> {
            if (field instanceof LatitudeField) {
                return true;
            }
            if (field instanceof AggregateIndexField) {
                return ((AggregateIndexField)field).isLatitudeField();
            }
            return false;
        }).sorted(Comparator.comparingInt(ReportField::getFieldSeq)).map(field -> {
            if (field instanceof LatitudeField) {
                return ReportFieldUtils.entityField2ComplexField((EntityPropField)field);
            }
            return ReportFieldUtils.aggregateIndexField2ComplexField((AggregateIndexField)field);
        }).collect(Collectors.toList());
    }

    public static List<HRComplexObjFieldInfo> getGroupByComplexObjFieldInfos(List<ReportField> latitudeFieldList, Set<String> transLatitude) {
        return latitudeFieldList.stream().filter(reportField -> !reportField.isDependField()).filter(reportField -> !transLatitude.contains(reportField.getUniqueKey())).map(reportField -> {
            if (reportField instanceof LatitudeField) {
                return ReportFieldUtils.entityField2ComplexField((EntityPropField)reportField);
            }
            return ReportFieldUtils.aggregateIndexField2ComplexField((AggregateIndexField)reportField);
        }).collect(Collectors.toList());
    }

    public static void addBaseDataIdField(ReportField reportField, MainEntityTypeUtil mainEntityTypeUtil, Set<String> latitudeUKs, List<ReportField> copyFieldList, Map<String, Integer> pkIdIndexMap) {
        LatitudeField latitudeField;
        String fieldAlias;
        if (reportField instanceof LatitudeField && (fieldAlias = (latitudeField = (LatitudeField)reportField).getFieldAlias()).indexOf(46) > 0 && (FieldComplexType.ADMIN_ORG == latitudeField.getFieldComplexType() || FieldComplexType.BASE_DATA == latitudeField.getFieldComplexType() || FieldComplexType.HIS_BASE_DATA == latitudeField.getFieldComplexType()) && (fieldAlias.endsWith(".name") || fieldAlias.endsWith(".number"))) {
            String pkFieldAlias = fieldAlias.substring(0, fieldAlias.lastIndexOf(46) + 1) + "id";
            if (!latitudeUKs.contains(pkFieldAlias)) {
                String baseDataNumber = latitudeField.getBaseDataNumber();
                MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(baseDataNumber);
                Class propertyType = mainEntityType.getPrimaryKey().getPropertyType();
                String pkType = propertyType == String.class ? "string" : "long";
                latitudeUKs.add(pkFieldAlias);
                String propFullPath = latitudeField.getPropFullPath();
                String pkFieldFullPath = propFullPath.substring(0, propFullPath.lastIndexOf(46) + 1) + "id";
                LatitudeField pkLatitudeField = new LatitudeField();
                pkLatitudeField.setPropFullPath(pkFieldFullPath);
                pkLatitudeField.setFieldAlias(pkFieldAlias);
                pkLatitudeField.setUniqueKey(pkFieldAlias);
                pkLatitudeField.setFieldType(pkType);
                pkLatitudeField.setBaseDataNumber(baseDataNumber);
                pkLatitudeField.setFieldComplexType(latitudeField.getFieldComplexType());
                pkLatitudeField.setDependField(latitudeField.isDependField());
                pkLatitudeField.setSortord(SortEnum.NONE.getValue());
                pkLatitudeField.setSortSeq(latitudeField.getSortSeq());
                copyFieldList.add(pkLatitudeField);
                pkIdIndexMap.put(pkFieldAlias, copyFieldList.size() - 1);
            } else {
                Integer index = pkIdIndexMap.get(pkFieldAlias);
                ReportField pkIdField = null;
                if (index != null) {
                    pkIdField = copyFieldList.get(index);
                } else {
                    Optional<ReportField> optional = copyFieldList.stream().filter(field -> field.getFieldAlias().equals(pkFieldAlias)).findAny();
                    if (optional.isPresent()) {
                        pkIdField = optional.get();
                    }
                }
                if (pkIdField != null && pkIdField.isDependField()) {
                    pkIdField.setDependField(latitudeField.isDependField());
                }
            }
        }
    }
}

