/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.field.LatitudeField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.FieldSortInfo;

public class SortFieldUtil {
    private static final Log LOGGER = LogFactory.getLog(SortFieldUtil.class);

    public static void initSortField(HRComplexObjContext context, List<ReportField> fieldList) {
        SortFieldUtil.initSortField(context, fieldList, null);
    }

    public static void initSortField(HRComplexObjContext context, List<ReportField> fieldList, Long rptPk) {
        SortFieldUtil.initSortField(context, fieldList, rptPk, null);
    }

    public static void initSortField(HRComplexObjContext context, List<ReportField> fieldList, Long rptPk, Set<String> excludeFieldUnk) {
        String orderBy = fieldList.stream().filter(rptField -> HRStringUtils.isNotEmpty((String)rptField.getSortord()) && (excludeFieldUnk == null || !excludeFieldUnk.contains(rptField.getUniqueKey())) && !SortEnum.NONE.getValue().equals(rptField.getSortord())).map(rptField -> rptField.getFieldAlias() + " " + rptField.getSortord()).collect(Collectors.joining(","));
        context.setOrderBy(orderBy);
        List<SortFieldInfo> sortFieldInfoList = SortFieldUtil.genSortFieldInfos(fieldList, rptPk, excludeFieldUnk);
        context.setSortFieldInfoList(sortFieldInfoList);
    }

    public static List<SortFieldInfo> genSortFieldInfos(List<ReportField> fieldList, Long rptPk) {
        return SortFieldUtil.genSortFieldInfos(fieldList, rptPk, Collections.emptySet());
    }

    public static List<SortFieldInfo> genSortFieldInfos(List<ReportField> fieldList, Long rptPk, Set<String> excludeFieldUnk) {
        List<ReportField> newFieldList;
        int index = 0;
        LOGGER.info("before_sort_field_{}", fieldList);
        if (fieldList.stream().anyMatch(field -> field.getSortSeq() != null)) {
            LOGGER.info("ad_sort");
            newFieldList = fieldList.stream().filter(reportField -> reportField.getSortSeq() != null).sorted(Comparator.comparingInt(ReportField::getSortSeq).thenComparing(ReportField::isDependField, (o1, o2) -> {
                if (o1 != null && !o1.booleanValue()) {
                    return 1;
                }
                return -1;
            }).thenComparing(ReportField::getUniqueKey, (o1, o2) -> {
                if (o1.endsWith("_sorthelplati")) {
                    return 1;
                }
                if (o2.endsWith("_sorthelplati")) {
                    return 1;
                }
                return 0;
            })).collect(Collectors.toList());
        } else {
            newFieldList = fieldList;
        }
        LOGGER.info("after_sort_field_{}", newFieldList);
        ArrayList<SortFieldInfo> sortFieldInfoList = new ArrayList<SortFieldInfo>(10);
        HashMap<String, SortFieldInfo> sortFieldInfoMap = new HashMap<String, SortFieldInfo>(16);
        for (ReportField rptField : newFieldList) {
            SortFieldInfo sortFieldInfo;
            if (HRStringUtils.isEmpty((String)rptField.getSortord()) || SortEnum.NONE.getValue().equals(rptField.getSortord()) || excludeFieldUnk != null && excludeFieldUnk.contains(rptField.getUniqueKey())) continue;
            FieldSortInfo depSortField = rptField.getFieldSort();
            if (depSortField != null && (sortFieldInfo = (SortFieldInfo)sortFieldInfoMap.get(depSortField.getNumber() + "_sorthelplati")) != null) {
                sortFieldInfo.addDependSortSourceField(rptField.getFieldAlias());
            }
            sortFieldInfo = new SortFieldInfo(rptField.getFieldAlias(), rptField.getSortord());
            sortFieldInfo.setSeq(index++);
            sortFieldInfo.setReportId(rptPk);
            sortFieldInfo.setFieldId(rptField.getFieldId());
            if (SortEnum.CUSTOM.getValue().equals(rptField.getSortord()) && rptField.getCustomSort() != null) {
                sortFieldInfo.setValueType(rptField.getCustomSort().getValueType());
                sortFieldInfo.setValue(rptField.getCustomSort().getValue());
            }
            sortFieldInfo.setDependSort(rptField.isDependField());
            sortFieldInfo.setDataType(DataTypeEnum.of((String)rptField.getFieldType()));
            sortFieldInfoList.add(sortFieldInfo);
            sortFieldInfoMap.putIfAbsent(rptField.getUniqueKey(), sortFieldInfo);
        }
        return sortFieldInfoList;
    }

    public static List<ReportField> resetDepSortField(List<ReportField> reportFields) {
        for (ReportField reportField : reportFields) {
            if (!SortEnum.FIELD.getValue().equals(reportField.getSortord())) {
                reportField.setFieldSort(null);
            }
            if (SortEnum.CUSTOM.getValue().equals(reportField.getSortord())) continue;
            reportField.setCustomSort(null);
        }
        boolean existsFieldSort = reportFields.stream().anyMatch(field -> SortEnum.FIELD.getValue().equals(field.getSortord()));
        if (existsFieldSort) {
            ArrayList copyColumnFieldList = Lists.newArrayListWithExpectedSize((int)reportFields.size());
            HashSet uniqueKeys = Sets.newHashSetWithExpectedSize((int)16);
            for (ReportField reportField : reportFields) {
                FieldSortInfo fieldSort = reportField.getFieldSort();
                if (SortEnum.FIELD.getValue().equals(reportField.getSortord()) && fieldSort != null) {
                    if (fieldSort.getNumber().equals(reportField.getFieldAlias())) {
                        reportField.setSortord(fieldSort.getSort());
                    } else {
                        if (uniqueKeys.add(fieldSort.getNumber() + "_sorthelplati")) {
                            LatitudeField latitudeField = new LatitudeField();
                            latitudeField.setFieldAlias(fieldSort.getNumber());
                            latitudeField.setUniqueKey(fieldSort.getNumber() + "_sorthelplati");
                            latitudeField.setFieldType(fieldSort.getFieldType());
                            latitudeField.setPropFullPath(fieldSort.getNumber());
                            latitudeField.setSortord(fieldSort.getSort());
                            latitudeField.setDependField(true);
                            copyColumnFieldList.add(latitudeField);
                        }
                        reportField.setSortord(SortEnum.ASC.getValue());
                    }
                }
                copyColumnFieldList.add(reportField);
            }
            return copyColumnFieldList;
        }
        return reportFields;
    }
}

