/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;

public class ReportPermissionService
implements ReportManageConstants {
    private static final HRBaseServiceHelper PERMISSION_HELPER = new HRBaseServiceHelper("hrcs_entityforbid");
    private static final HRBaseServiceHelper RPT_DIM_MAP_HELPER = new HRBaseServiceHelper("hrptc_rptdimmap");
    private static final HRBaseServiceHelper USER_PERM_HELPER = new HRBaseServiceHelper("hrptc_userperm");
    private static final HRBaseServiceHelper RPT_ALOC_PERM_HELPER = new HRBaseServiceHelper("hrptc_rptalocperm");
    private static final HRBaseServiceHelper RPT_PERM_DATA_HELPER = new HRBaseServiceHelper("hrptc_rptpermdata");

    public static void disablePermission(String rptManageNumber) {
        DynamicObject permDy = PERMISSION_HELPER.generateEmptyDynamicObject();
        permDy.set("app", (Object)"2VKJ94YEM7AU");
        permDy.set("entitytypeid", (Object)rptManageNumber);
        permDy.set("permitem", (Object)" ");
        permDy.set("forbidtype", (Object)"3");
        permDy.set("issyspreset", (Object)"1");
        PERMISSION_HELPER.saveOne(permDy);
    }

    public static void enablePermission(String rptManageNumber) {
        PERMISSION_HELPER.deleteByFilter(new QFilter[]{new QFilter("entitytypeid", "=", (Object)rptManageNumber)});
    }

    public static void updateRptCtrPerm(long rptManageId) {
        Map<Long, Map<String, String>> reportRefField = ReportManageService.getPermFieldIdMap(rptManageId);
        DynamicObject rptDimMapDy = RPT_DIM_MAP_HELPER.loadDynamicObject(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
        if (rptDimMapDy == null) {
            return;
        }
        DynamicObjectCollection rptDimMapEntry = rptDimMapDy.getDynamicObjectCollection("entryentity");
        rptDimMapEntry.removeIf(dy -> !reportRefField.containsKey(dy.getLong("aoqfield.id")));
        RPT_DIM_MAP_HELPER.saveOne(rptDimMapDy);
        DynamicObject rptAlocPermDy = RPT_ALOC_PERM_HELPER.loadDynamicObject(new QFilter("rptmanage", "=", (Object)rptManageId));
        if (null == rptAlocPermDy) {
            return;
        }
        DynamicObjectCollection rptAlocPermEntry = rptAlocPermDy.getDynamicObjectCollection("rptpermdataentry");
        rptAlocPermEntry.removeIf(rptAlocPermEntryDy -> !reportRefField.containsKey(rptAlocPermEntryDy.getLong("queryfield.id")));
        RPT_ALOC_PERM_HELPER.saveOne(rptAlocPermDy);
    }

    public static void delRptCtrPerm(Long rptManageId) {
        RPT_DIM_MAP_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
        ReportPermissionService.delRptPerm(rptManageId);
    }

    public static void updateRptPerm(long rptManageId, List<Long> queryFieldIds) {
        RPT_PERM_DATA_HELPER.deleteByFilter(new QFilter[]{new QFilter("report", "=", (Object)rptManageId), new QFilter("queryfield.id", "not in", queryFieldIds)});
    }

    public static void delRptPerm(long rptManageId) {
        RPT_ALOC_PERM_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
    }

    private static void delRptAlocPermIfEmpty(long rptManageId) {
        DynamicObject rptAlocPermDy = RPT_ALOC_PERM_HELPER.loadDynamicObject(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
        if (null == rptAlocPermDy) {
            return;
        }
        if (rptAlocPermDy.getDynamicObjectCollection("rptpermdataentry").isEmpty()) {
            RPT_ALOC_PERM_HELPER.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)rptManageId)});
        }
    }

    public static void delUserAlocPermIfEmpty(List<Long> userPermIds) {
        DynamicObject[] userPermDys = USER_PERM_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", userPermIds)});
        USER_PERM_HELPER.delete(Arrays.stream(userPermDys).filter(dy -> dy.getDynamicObjectCollection("rptpermdataentry").isEmpty()).map(dy -> dy.getLong("id")).toArray());
    }

    public static boolean checkPermission(long rptManageId) {
        return RPT_PERM_DATA_HELPER.isExists(new QFilter[]{new QFilter("report", "=", (Object)rptManageId)});
    }

    public static boolean checkPermission(List<Long> rptManageIds) {
        return RPT_PERM_DATA_HELPER.isExists(new QFilter[]{new QFilter("report", "in", rptManageIds)});
    }

    public static boolean checkPermission(long rptManageId, List<Long> queryFieldIds) {
        return RPT_PERM_DATA_HELPER.isExists(new QFilter[]{new QFilter("report", "=", (Object)rptManageId), new QFilter("queryfield.id", "in", queryFieldIds)});
    }

    public static DynamicObject[] getUserAloc(Set<Long> userIds) {
        return USER_PERM_HELPER.query("id, user.id", new QFilter[]{new QFilter("user", "in", userIds)});
    }

    public static DynamicObject saveUserAloc(long userId) {
        DynamicObject dy = USER_PERM_HELPER.generateEmptyDynamicObject();
        dy.set("user", (Object)userId);
        return (DynamicObject)USER_PERM_HELPER.saveOne(dy);
    }

    public static DynamicObject genUserAloc(long id) {
        DynamicObject dy = USER_PERM_HELPER.generateEmptyDynamicObject();
        dy.set("id", (Object)id);
        return dy;
    }

    public static boolean isExistsRptAlocByRptId(long rptManageId) {
        return RPT_ALOC_PERM_HELPER.isExists(new QFilter("rptmanage", "=", (Object)rptManageId));
    }

    public static void saveRptAloc(long rptManageId) {
        DynamicObject dy = RPT_ALOC_PERM_HELPER.generateEmptyDynamicObject();
        dy.set("rptmanage", (Object)rptManageId);
        RPT_ALOC_PERM_HELPER.saveOne(dy);
    }

    public static DynamicObject delRptAloc(long rptManageId) {
        DynamicObject dy = RPT_ALOC_PERM_HELPER.generateEmptyDynamicObject();
        dy.set("rptmanage", (Object)rptManageId);
        return (DynamicObject)RPT_ALOC_PERM_HELPER.saveOne(dy);
    }

    public static Long getRptIdByRptAlocPerm(long rptAlocPermId) {
        DynamicObject dy = RPT_ALOC_PERM_HELPER.queryOriginalOne("rptmanage.id", (Object)rptAlocPermId);
        return dy.getLong("rptmanage.id");
    }

    public static DynamicObject[] getRptPermData(long userId, long rptManageId) {
        return RPT_PERM_DATA_HELPER.query("queryfield.id,permgroup,includesub,startdate,enddate,adminorgstruct.id,queryfield.fieldalias,queryfield.controltype,queryfield.complextype,data", new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("report", "=", (Object)rptManageId), new QFilter("nolimit", "=", (Object)"0")});
    }

    public static DynamicObject[] getRptPermData(long userId, long rptManageId, long queryFieldId) {
        return RPT_PERM_DATA_HELPER.query("nolimit,permgroup,includesub,startdate,enddate,adminorgstruct.id,queryfield.fieldalias,queryfield.controltype,queryfield.complextype,data", new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("report", "=", (Object)rptManageId), new QFilter("queryfield", "=", (Object)queryFieldId)});
    }

    public static DynamicObject[] getRptPermData(long userId, long rptManageId, String fieldAlias) {
        return RPT_PERM_DATA_HELPER.query("nolimit,permgroup,includesub,startdate,enddate,adminorgstruct.id,queryfield.fieldalias,queryfield.controltype,queryfield.complextype,data", new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("report", "=", (Object)rptManageId), new QFilter("queryfield.fieldalias", "=", (Object)fieldAlias)});
    }

    public static DynamicObject[] getRptPermData(long userId, long rptManageId, long queryFieldId, long structId) {
        return RPT_PERM_DATA_HELPER.query("nolimit,permgroup,includesub,startdate,enddate,adminorgstruct.id,queryfield.fieldalias,queryfield.controltype,queryfield.complextype,data", new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("report", "=", (Object)rptManageId), new QFilter("queryfield", "=", (Object)queryFieldId), new QFilter("adminorgstruct", "=", (Object)structId)});
    }

    public static DynamicObject[] getRptPermData(long userId, long rptManageId, String fieldAlias, long structId) {
        return RPT_PERM_DATA_HELPER.query("nolimit,permgroup,includesub,startdate,enddate,adminorgstruct.id,queryfield.fieldalias,queryfield.controltype,queryfield.complextype,data", new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("report", "=", (Object)rptManageId), new QFilter("queryfield.fieldalias", "=", (Object)fieldAlias), new QFilter("adminorgstruct", "=", (Object)structId)});
    }

    public static DynamicObject[] getRptPermDataWithAll(long userId, long rptManageId) {
        return RPT_PERM_DATA_HELPER.query("nolimit,permgroup,includesub,startdate,enddate,adminorgstruct.id,queryfield.fieldalias,queryfield.controltype,queryfield.complextype,data", new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("report", "=", (Object)rptManageId)});
    }
}

