/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.TimeZoneInfo;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.center.utils.ReportCenterAdminOrgFilterUtil;
import kd.hr.hrptmc.business.repdesign.util.SchemeFilterDateUtils;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.QuerySchemeValueBo;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.enums.EnumOperatorEnum;

public class ReportQuerySchemeRuleService {
    private static final Log LOGGER = LogFactory.getLog(ReportQuerySchemeRuleService.class);

    public static QFilter matchBaseData(QuerySchemeValueBo querySchemeValueBo) {
        String baseDataId = querySchemeValueBo.getBaseDataId();
        baseDataId = ReportCenterAdminOrgFilterUtil.getAdminOrgBoIdForQueryScheme(querySchemeValueBo, baseDataId);
        String compare = querySchemeValueBo.getCompare();
        String fieldAlias = querySchemeValueBo.getQuerySchemeFieldBo().getFieldAlias();
        if (fieldAlias.contains("\u03b4")) {
            fieldAlias = fieldAlias.substring(0, fieldAlias.indexOf("\u03b4"));
        }
        String propertyPrefix = fieldAlias.substring(0, fieldAlias.lastIndexOf(46));
        ArrayList<Object> ids = new ArrayList<Object>();
        boolean isLong = false;
        switch (Objects.requireNonNull(EnumOperatorEnum.getEnum((String)compare))) {
            case EQUAL: {
                if (HRStringUtils.isEmpty((String)baseDataId)) {
                    return null;
                }
                try {
                    Long.parseLong(baseDataId);
                    isLong = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (isLong) {
                    return new QFilter(propertyPrefix + ".id", "in", (Object)Lists.newArrayList((Object[])new Long[]{Long.parseLong(baseDataId)}));
                }
                return new QFilter(propertyPrefix + ".id", "in", (Object)Lists.newArrayList((Object[])new String[]{baseDataId}));
            }
            case NOT_EQUAL: {
                if (HRStringUtils.isEmpty((String)baseDataId)) {
                    return null;
                }
                try {
                    Long.parseLong(baseDataId);
                    isLong = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (isLong) {
                    return new QFilter(propertyPrefix + ".id", "!=", (Object)Long.parseLong(baseDataId));
                }
                return new QFilter(propertyPrefix + ".id", "!=", (Object)baseDataId);
            }
            case IN: 
            case CONTAINS: {
                if (HRStringUtils.isEmpty((String)baseDataId)) {
                    return null;
                }
                for (String str : baseDataId.split(",")) {
                    if (!HRStringUtils.isNotEmpty((String)str)) continue;
                    try {
                        Long.parseLong(str);
                        isLong = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (isLong) {
                        ids.add(Long.parseLong(str));
                        continue;
                    }
                    ids.add(str);
                }
                return new QFilter(propertyPrefix + ".id", "in", ids);
            }
            case NOT_IN: 
            case NOT_CONTAINS: {
                if (HRStringUtils.isEmpty((String)baseDataId)) {
                    return null;
                }
                for (String str : baseDataId.split(",")) {
                    if (!HRStringUtils.isNotEmpty((String)str)) continue;
                    try {
                        Long.parseLong(str);
                        isLong = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (isLong) {
                        ids.add(Long.parseLong(str));
                        continue;
                    }
                    ids.add(str);
                }
                return new QFilter(propertyPrefix + ".id", "not in", ids);
            }
            case IS_NULL: {
                return new QFilter(fieldAlias, "=", (Object)QEmptyValue.value).or(new QFilter(ReportQuerySchemeRuleService.removeBaseDataKey(fieldAlias) + ".id", "=", (Object)QEmptyValue.value));
            }
            case IS_NOT_NULL: {
                return new QFilter(fieldAlias, "is not null", null).and(new QFilter(fieldAlias, "!=", (Object)"").and(new QFilter(fieldAlias, "!=", (Object)" ")));
            }
        }
        return null;
    }

    public static QFilter matchEnum(QuerySchemeValueBo querySchemeValueBo) {
        String compare = querySchemeValueBo.getCompare();
        String value = querySchemeValueBo.getValue();
        String fieldAlias = querySchemeValueBo.getQuerySchemeFieldBo().getFieldAlias();
        String controlType = querySchemeValueBo.getQuerySchemeFieldBo().getControlType();
        if (fieldAlias.contains("\u03b4")) {
            fieldAlias = fieldAlias.substring(0, fieldAlias.indexOf("\u03b4"));
        }
        switch (Objects.requireNonNull(EnumOperatorEnum.getEnum((String)compare))) {
            case EQUAL: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                return new QFilter(fieldAlias, "=", (Object)value);
            }
            case NOT_EQUAL: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                return new QFilter(fieldAlias, "!=", (Object)value);
            }
            case IN: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                String[] split = value.split(",");
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(split));
                list.remove("");
                if (list.size() != 0) {
                    return new QFilter(fieldAlias, "in", list);
                }
                return null;
            }
            case CONTAINS: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                if (HRStringUtils.equals((String)controlType, (String)FieldControlType.MUL_COMBO.getValue())) {
                    String[] mulSplit = value.split(",");
                    ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(mulSplit));
                    arrayList.remove("");
                    if (arrayList.size() != 0) {
                        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
                        for (String s : arrayList) {
                            qFilter.and(new QFilter(fieldAlias, "like", (Object)("%," + s + ",%")));
                        }
                        return new QFilter(fieldAlias, "like", (Object)value);
                    }
                } else {
                    return new QFilter(fieldAlias, "like", (Object)value);
                }
                return null;
            }
            case NOT_IN: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                String[] splitNot = value.split(",");
                ArrayList<String> listNot = new ArrayList<String>(Arrays.asList(splitNot));
                listNot.remove("");
                if (listNot.size() != 0) {
                    return new QFilter(fieldAlias, "not in", listNot);
                }
                return null;
            }
            case NOT_CONTAINS: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                return new QFilter(fieldAlias, "not like", (Object)value);
            }
            case IS_NULL: {
                return new QFilter(fieldAlias, "=", (Object)QEmptyValue.value);
            }
            case IS_NOT_NULL: {
                if (fieldAlias.endsWith(SplitDateTypeEnum.FN_MONTH.getKey()) || fieldAlias.endsWith(SplitDateTypeEnum.SN_MONTH.getKey()) || fieldAlias.endsWith(SplitDateTypeEnum.FN_QUARTER.getKey()) || fieldAlias.endsWith(SplitDateTypeEnum.SN_QUARTER.getKey()) || fieldAlias.endsWith(SplitDateTypeEnum.FN_DAY.getKey()) || fieldAlias.endsWith(SplitDateTypeEnum.SN_DAY.getKey())) {
                    return new QFilter(fieldAlias, "is not null", null);
                }
                return new QFilter(fieldAlias, "is not null", null).and(new QFilter(fieldAlias, "!=", (Object)"").and(new QFilter(fieldAlias, "!=", (Object)" ")));
            }
        }
        return null;
    }

    private static String removeBaseDataKey(String param) {
        return param.substring(0, param.lastIndexOf("."));
    }

    public static QFilter matchDate(QuerySchemeValueBo querySchemeValueBo) throws ParseException {
        String compare = querySchemeValueBo.getCompare();
        String value = querySchemeValueBo.getValue();
        String secondDateType = querySchemeValueBo.getSecondDateType();
        String fieldAlias = querySchemeValueBo.getQuerySchemeFieldBo().getFieldAlias();
        TimeZoneInfo timeZoneInfo = querySchemeValueBo.getQuerySchemeFieldBo().getTimeZoneInfo();
        if (fieldAlias.contains("\u03b4")) {
            fieldAlias = fieldAlias.substring(0, fieldAlias.indexOf("\u03b4"));
        }
        Date[] dates = new Date[2];
        switch (Objects.requireNonNull(EnumOperatorEnum.getEnum((String)compare))) {
            case EQUAL: {
                if (SchemeFilterDateUtils.equalOrNotDate(value, fieldAlias, secondDateType, dates, timeZoneInfo)) {
                    return null;
                }
                return new QFilter(fieldAlias, ">=", (Object)dates[0]).and(new QFilter(fieldAlias, "<=", (Object)dates[1]));
            }
            case NOT_EQUAL: {
                if (SchemeFilterDateUtils.equalOrNotDate(value, fieldAlias, secondDateType, dates, timeZoneInfo)) {
                    return null;
                }
                return new QFilter(fieldAlias, "<=", (Object)dates[0]).or(new QFilter(fieldAlias, ">=", (Object)dates[1]));
            }
            case SCOPE: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                String[] split = value.split(",");
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(split));
                if (list.size() != 0) {
                    SchemeFilterDateUtils.getDateByScope(dates, fieldAlias, list, timeZoneInfo);
                    return new QFilter(fieldAlias, ">=", (Object)dates[0]).and(new QFilter(fieldAlias, "<=", (Object)dates[1]));
                }
                return null;
            }
            case GREATER_THAN: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                if (SchemeFilterDateUtils.equalOrNotDate(value, fieldAlias, secondDateType, dates, timeZoneInfo)) {
                    return null;
                }
                return new QFilter(fieldAlias, ">", (Object)dates[1]);
            }
            case GREATER_OR_EQUAL: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                if (SchemeFilterDateUtils.equalOrNotDate(value, fieldAlias, secondDateType, dates, timeZoneInfo)) {
                    return null;
                }
                return new QFilter(fieldAlias, ">=", (Object)dates[0]);
            }
            case LESS_THAN: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                if (SchemeFilterDateUtils.equalOrNotDate(value, fieldAlias, secondDateType, dates, timeZoneInfo)) {
                    return null;
                }
                return new QFilter(fieldAlias, "<", (Object)dates[0]);
            }
            case LESS_OR_EQUAL: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                if (SchemeFilterDateUtils.equalOrNotDate(value, fieldAlias, secondDateType, dates, timeZoneInfo)) {
                    return null;
                }
                return new QFilter(fieldAlias, "<=", (Object)dates[1]);
            }
            case TODAY: {
                SchemeFilterDateUtils.getDateByValue(new Date(), dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)dates[0]).and(new QFilter(fieldAlias, "<=", (Object)dates[1]));
            }
            case LESS_TODAY: {
                SchemeFilterDateUtils.getDateByValue(new Date(), dates, timeZoneInfo);
                return new QFilter(fieldAlias, "<=", (Object)dates[0]);
            }
            case LESS_OR_EQUALS_TODAY: {
                SchemeFilterDateUtils.getDateByValue(new Date(), dates, timeZoneInfo);
                return new QFilter(fieldAlias, "<=", (Object)dates[1]);
            }
            case GREATER_TODAY: {
                SchemeFilterDateUtils.getDateByValue(new Date(), dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)dates[1]);
            }
            case GREATER_OR_EQUALS_TODAY: {
                SchemeFilterDateUtils.getDateByValue(new Date(), dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)dates[0]);
            }
            case YESTERDAY: {
                SchemeFilterDateUtils.getDateByValue(HRDateTimeUtils.addDay((Date)new Date(), (long)-1L), dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)dates[0]).and(new QFilter(fieldAlias, "<=", (Object)dates[1]));
            }
            case TOMORROW: {
                SchemeFilterDateUtils.getDateByValue(HRDateTimeUtils.addDay((Date)new Date(), (long)1L), dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)dates[0]).and(new QFilter(fieldAlias, "<=", (Object)dates[1]));
            }
            case THIS_WEEK: {
                SchemeFilterDateUtils.getDateByWeek(dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)dates[0]).and(new QFilter(fieldAlias, "<", (Object)dates[1]));
            }
            case LAST_WEEK: {
                SchemeFilterDateUtils.getDateByWeek(dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.addDay((Date)dates[0], (long)-7L)).and(new QFilter(fieldAlias, "<", (Object)HRDateTimeUtils.addDay((Date)dates[1], (long)-7L)));
            }
            case NEXT_WEEK: {
                SchemeFilterDateUtils.getDateByWeek(dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.addDay((Date)dates[0], (long)7L)).and(new QFilter(fieldAlias, "<", (Object)HRDateTimeUtils.addDay((Date)dates[1], (long)7L)));
            }
            case THIS_MONTH: {
                SchemeFilterDateUtils.getDateByMonth(dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)dates[0]).and(new QFilter(fieldAlias, "<", (Object)HRDateTimeUtils.addDay((Date)dates[1], (long)1L)));
            }
            case LAST_MONTH: {
                SchemeFilterDateUtils.getDateByMonth(dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.addMonth((Date)dates[0], (int)-1)).and(new QFilter(fieldAlias, "<", (Object)HRDateTimeUtils.addMonth((Date)HRDateTimeUtils.addDay((Date)dates[1], (long)1L), (int)-1)));
            }
            case NEXT_MONTH: {
                SchemeFilterDateUtils.getDateByMonth(dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.addMonth((Date)dates[0], (int)1)).and(new QFilter(fieldAlias, "<", (Object)HRDateTimeUtils.addMonth((Date)HRDateTimeUtils.addDay((Date)dates[1], (long)1L), (int)1)));
            }
            case LAST3MONTH: {
                SchemeFilterDateUtils.getDateByValue(new Date(), dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.addMonth((Date)dates[0], (int)-3)).and(new QFilter(fieldAlias, "<=", (Object)dates[1]));
            }
            case NEXT3MONTH: {
                SchemeFilterDateUtils.getDateByValue(new Date(), dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)dates[0]).and(new QFilter(fieldAlias, "<=", (Object)HRDateTimeUtils.addMonth((Date)dates[1], (int)3)));
            }
            case LAST1MONTH: {
                SchemeFilterDateUtils.getDateByValue(new Date(), dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.addMonth((Date)dates[0], (int)-1)).and(new QFilter(fieldAlias, "<=", (Object)dates[1]));
            }
            case NEXT1MONTH: {
                SchemeFilterDateUtils.getDateByValue(new Date(), dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)dates[0]).and(new QFilter(fieldAlias, "<=", (Object)HRDateTimeUtils.addMonth((Date)dates[1], (int)1)));
            }
            case THIS_QUARTER: {
                SchemeFilterDateUtils.getDateByQuarter(dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)dates[0]).and(new QFilter(fieldAlias, "<", (Object)dates[1]));
            }
            case LAST_QUARTER: {
                SchemeFilterDateUtils.getDateByQuarter(dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.addMonth((Date)dates[0], (int)-3)).and(new QFilter(fieldAlias, "<", (Object)HRDateTimeUtils.addMonth((Date)dates[1], (int)-3)));
            }
            case NEXT_QUARTER: {
                SchemeFilterDateUtils.getDateByQuarter(dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.addMonth((Date)dates[0], (int)3)).and(new QFilter(fieldAlias, "<", (Object)HRDateTimeUtils.addMonth((Date)dates[1], (int)3)));
            }
            case THIS_YEAR: {
                SchemeFilterDateUtils.getDateByYear(dates, HRDateTimeUtils.format((Date)new Date(), (String)"yyyy"), timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)dates[0]).and(new QFilter(fieldAlias, "<=", (Object)dates[1]));
            }
            case LAST_YEAR: {
                SchemeFilterDateUtils.getDateByYear(dates, HRDateTimeUtils.format((Date)new Date(), (String)"yyyy"), timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.addYear((Date)dates[0], (int)-1)).and(new QFilter(fieldAlias, "<=", (Object)HRDateTimeUtils.addYear((Date)dates[1], (int)-1)));
            }
            case NEXT_YEAR: {
                SchemeFilterDateUtils.getDateByYear(dates, HRDateTimeUtils.format((Date)new Date(), (String)"yyyy"), timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.addYear((Date)dates[0], (int)1)).and(new QFilter(fieldAlias, "<=", (Object)HRDateTimeUtils.addYear((Date)dates[1], (int)1)));
            }
            case LAST3DAY: {
                SchemeFilterDateUtils.getDateByValue(new Date(), dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.addDay((Date)dates[0], (long)-2L)).and(new QFilter(fieldAlias, "<=", (Object)dates[1]));
            }
            case LAST7DAY: {
                SchemeFilterDateUtils.getDateByValue(new Date(), dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.addDay((Date)dates[0], (long)-6L)).and(new QFilter(fieldAlias, "<=", (Object)dates[1]));
            }
            case LAST15DAY: {
                SchemeFilterDateUtils.getDateByValue(new Date(), dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.addDay((Date)dates[0], (long)-14L)).and(new QFilter(fieldAlias, "<=", (Object)dates[1]));
            }
            case LAST60DAY: {
                SchemeFilterDateUtils.getDateByValue(new Date(), dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.addDay((Date)dates[0], (long)-59L)).and(new QFilter(fieldAlias, "<=", (Object)dates[1]));
            }
            case MONTH2TODAY: {
                SchemeFilterDateUtils.getDateByMonth(dates, timeZoneInfo);
                Calendar startCal = Calendar.getInstance();
                startCal.setTime(new Date());
                SchemeFilterDateUtils.setTime(startCal, 11, 0, 12, 0, 13, 0, 14, 0);
                return new QFilter(fieldAlias, ">=", (Object)dates[0]).and(new QFilter(fieldAlias, "<", (Object)HRDateTimeUtils.addDay((Date)startCal.getTime(), (long)1L)));
            }
            case YEAR2TODAY: {
                SchemeFilterDateUtils.getDateByYear2Today(dates, timeZoneInfo);
                return new QFilter(fieldAlias, ">=", (Object)dates[0]).and(new QFilter(fieldAlias, "<=", (Object)dates[1]));
            }
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    public static QFilter matchText(QuerySchemeValueBo querySchemeValueBo) {
        String compare = querySchemeValueBo.getCompare();
        String value = querySchemeValueBo.getValue();
        String fieldAlias = querySchemeValueBo.getQuerySchemeFieldBo().getFieldAlias();
        if (fieldAlias.contains("\u03b4")) {
            fieldAlias = fieldAlias.substring(0, fieldAlias.indexOf("\u03b4"));
        }
        switch (Objects.requireNonNull(EnumOperatorEnum.getEnum((String)compare))) {
            case EQUAL: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                return new QFilter(fieldAlias, "=", (Object)value);
            }
            case NOT_EQUAL: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                return new QFilter(fieldAlias, "!=", (Object)value);
            }
            case IN: 
            case CONTAINS: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                return new QFilter(fieldAlias, "like", (Object)("%" + value + "%"));
            }
            case NOT_IN: 
            case NOT_CONTAINS: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                return new QFilter(fieldAlias, "not like", (Object)("%" + value + "%"));
            }
            case STARTS_WITH: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                return new QFilter(fieldAlias, "like", (Object)(value + "%"));
            }
            case ENDS_WITH: {
                if (HRStringUtils.isEmpty((String)value)) {
                    return null;
                }
                return new QFilter(fieldAlias, "like", (Object)("%" + value));
            }
            case IS_NULL: {
                return new QFilter(fieldAlias, "is null", null);
            }
            case IS_NOT_NULL: {
                return new QFilter(fieldAlias, "is not null", null);
            }
        }
        return null;
    }

    public static QFilter matchNumber(QuerySchemeValueBo querySchemeValueBo) {
        String compare = querySchemeValueBo.getCompare();
        String value = querySchemeValueBo.getValue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        String fieldAlias = querySchemeValueBo.getQuerySchemeFieldBo().getFieldAlias();
        if (fieldAlias.contains("\u03b4")) {
            fieldAlias = fieldAlias.substring(0, fieldAlias.indexOf("\u03b4"));
        }
        switch (Objects.requireNonNull(EnumOperatorEnum.getEnum((String)compare))) {
            case EQUAL: {
                return new QFilter(fieldAlias, "=", (Object)new BigDecimal(value));
            }
            case NOT_EQUAL: 
            case GREATER_THAN: 
            case GREATER_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_OR_EQUAL: {
                return new QFilter(fieldAlias, compare, (Object)new BigDecimal(value));
            }
            case BETWEEN: {
                String[] number = value.split(",");
                return new QFilter(fieldAlias, ">=", (Object)new BigDecimal(number[0])).and(new QFilter(fieldAlias, "<=", (Object)new BigDecimal(number[1])));
            }
        }
        return new QFilter(fieldAlias, "=", (Object)new BigDecimal(value));
    }

    public static QFilter matchBoolean(QuerySchemeValueBo querySchemeValueBo) {
        String compare = querySchemeValueBo.getCompare();
        String value = querySchemeValueBo.getValue();
        String fieldAlias = querySchemeValueBo.getQuerySchemeFieldBo().getFieldAlias();
        if (fieldAlias.contains("\u03b4")) {
            fieldAlias = fieldAlias.substring(0, fieldAlias.indexOf("\u03b4"));
        }
        if (Objects.requireNonNull(EnumOperatorEnum.getEnum((String)compare)) == EnumOperatorEnum.NOT_EQUAL) {
            return new QFilter(fieldAlias, "!=", (Object)value);
        }
        return new QFilter(fieldAlias, "=", (Object)value);
    }
}

