/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hrptmc.business.repdesign.ReportPermissionService;

public class RptPermService {
    private static final Log LOGGER = LogFactory.getLog(RptPermService.class);

    public static QFilter getRptPerm(long userId, long rptManageId) {
        DynamicObject[] rptPermDataDys = ReportPermissionService.getRptPermData(userId, rptManageId);
        if (rptPermDataDys == null || rptPermDataDys.length == 0) {
            return null;
        }
        Date startDate = rptPermDataDys[0].getDate("startdate");
        Date endDate = rptPermDataDys[0].getDate("enddate");
        Date today = HRDateTimeUtils.getNowDate();
        if (startDate.after(today) || endDate.before(today)) {
            LOGGER.info("qFilter:1!=1");
            return QFilter.of((String)"1!=1", (Object[])new Object[0]);
        }
        HashMap<String, ArrayList<DynamicObject>> rptPermGroupMap = new HashMap<String, ArrayList<DynamicObject>>(16);
        for (DynamicObject rptPermDataDy : rptPermDataDys) {
            String permGroup = rptPermDataDy.getString("permgroup");
            ArrayList<DynamicObject> rptPermGroupList = (ArrayList<DynamicObject>)rptPermGroupMap.get(permGroup);
            if (null == rptPermGroupList) {
                rptPermGroupList = new ArrayList<DynamicObject>(10);
            }
            rptPermGroupList.add(rptPermDataDy);
            rptPermGroupMap.put(permGroup, rptPermGroupList);
        }
        QFilter qFilter = null;
        for (Map.Entry entry : rptPermGroupMap.entrySet()) {
            QFilter permGroupQFilter = null;
            ArrayList<Long> adminOrgIdList = new ArrayList<Long>(10);
            String adminOrgFieldAlias = "";
            for (DynamicObject rptPermDataDy : (List)entry.getValue()) {
                DynamicObject queryFieldDy = rptPermDataDy.getDynamicObject("queryfield");
                String fieldAlias = queryFieldDy.getString("fieldalias");
                String data = rptPermDataDy.getString("data");
                String[] values = data.split(",");
                QFilter queryFieldQFilter = null;
                if (RptPermService.isBaseData(queryFieldDy.getString("complextype"))) {
                    fieldAlias = RptPermService.trans2Id(fieldAlias);
                    DynamicObject orgStructDy = rptPermDataDy.getDynamicObject("adminorgstruct");
                    if (null != orgStructDy) {
                        adminOrgFieldAlias = fieldAlias;
                        if (rptPermDataDy.getBoolean("includesub")) {
                            long orgStructId = orgStructDy.getLong("id");
                            Set<Long> adminOrgIds = RptPermService.getAdminOrgIdsIncludeSub(orgStructId, values);
                            adminOrgIdList.addAll(adminOrgIds);
                        } else {
                            adminOrgIdList.addAll(Arrays.stream(values).map(Long::parseLong).collect(Collectors.toList()));
                        }
                    } else {
                        try {
                            queryFieldQFilter = new QFilter(fieldAlias, "in", Arrays.stream(values).map(Long::parseLong).collect(Collectors.toList()));
                        }
                        catch (NumberFormatException e) {
                            queryFieldQFilter = new QFilter(fieldAlias, "in", Arrays.stream(values).collect(Collectors.toList()));
                        }
                    }
                } else if (FieldControlType.MUL_COMBO.getValue().equals(queryFieldDy.getString("controltype"))) {
                    queryFieldQFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
                    for (String value : values) {
                        queryFieldQFilter.or(new QFilter(fieldAlias, "like", (Object)("%," + value + ",%")));
                    }
                } else if (FieldControlType.COMBO.getValue().equals(queryFieldDy.getString("controltype"))) {
                    queryFieldQFilter = new QFilter(fieldAlias, "in", Arrays.stream(values).collect(Collectors.toList()));
                }
                permGroupQFilter = null == permGroupQFilter ? queryFieldQFilter : permGroupQFilter.and(queryFieldQFilter);
            }
            if (!adminOrgIdList.isEmpty()) {
                QFilter adminOrgQFilter = new QFilter(adminOrgFieldAlias, "in", adminOrgIdList);
                permGroupQFilter = null == permGroupQFilter ? adminOrgQFilter : permGroupQFilter.and(adminOrgQFilter);
            }
            qFilter = null == qFilter ? permGroupQFilter : qFilter.or(permGroupQFilter);
        }
        LOGGER.info("qFilter:{}", (Object)(qFilter == null ? null : qFilter.toString()));
        return qFilter;
    }

    private static Set<Long> getAdminOrgIdsIncludeSub(long orgStructId, String[] values) {
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStructProjectService", (String)"queryStructInfoByProId", (Object[])new Object[]{Arrays.stream(values).map(Long::parseLong).collect(Collectors.toList()), new Date(), orgStructId, false});
        List structLongNumbers = result.values().stream().map(map -> (String)map.get("structlongnumber")).sorted().collect(Collectors.toList());
        ArrayList<String> queryLongNumbers = new ArrayList<String>(structLongNumbers.size());
        for (String structLongNumber : structLongNumbers) {
            boolean isAdd = true;
            for (String queryLongNumber : queryLongNumbers) {
                if (!structLongNumber.startsWith(queryLongNumber + "!")) continue;
                isAdd = false;
                break;
            }
            if (!isAdd) continue;
            queryLongNumbers.add(structLongNumber);
        }
        QFilter queryQFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
        List qFilters = queryLongNumbers.stream().map(str -> new QFilter("structlongnumber", "like", (Object)(str + "%"))).collect(Collectors.toList());
        for (QFilter qFilter : qFilters) {
            queryQFilter.or(qFilter);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorghrstruct");
        DynamicObject[] adminOrgDys = helper.queryOriginalArray("adminorg.id", new QFilter[]{queryQFilter});
        return Arrays.stream(adminOrgDys).map(dy -> dy.getLong("adminorg.id")).collect(Collectors.toSet());
    }

    private static boolean isBaseData(String complexType) {
        return FieldComplexType.BASE_DATA.getValue().equals(complexType) || FieldComplexType.ADMIN_ORG.getValue().equals(complexType) || FieldComplexType.HIS_BASE_DATA.getValue().equals(complexType);
    }

    private static String trans2Id(String fieldAlias) {
        if (fieldAlias.endsWith(".name")) {
            fieldAlias = fieldAlias.substring(0, fieldAlias.lastIndexOf(".name")) + ".id";
        } else if (fieldAlias.endsWith(".number")) {
            fieldAlias = fieldAlias.substring(0, fieldAlias.lastIndexOf(".number")) + ".id";
        }
        return fieldAlias;
    }

    public static QFilter getQueryFieldPerm(long userId, long rptManageId, long queryFieldId) {
        DynamicObject[] rptPermDataDys = ReportPermissionService.getRptPermData(userId, rptManageId, queryFieldId);
        return RptPermService.getQueryFieldPerm(rptPermDataDys);
    }

    public static QFilter getQueryFieldPerm(long userId, long rptManageId, long queryFieldId, long structId) {
        DynamicObject[] rptPermDataDys = ReportPermissionService.getRptPermData(userId, rptManageId, queryFieldId, structId);
        QFilter qFilter = RptPermService.getQueryFieldPerm(rptPermDataDys);
        LOGGER.info("qFilter:{}", (Object)(qFilter == null ? null : qFilter.toString()));
        return qFilter;
    }

    public static QFilter getQueryFieldPerm(long userId, long rptManageId, String fieldAlias) {
        DynamicObject[] rptPermDataDys = ReportPermissionService.getRptPermData(userId, rptManageId, fieldAlias);
        QFilter qFilter = RptPermService.getQueryFieldPerm(rptPermDataDys);
        LOGGER.info("qFilter:{}", (Object)(qFilter == null ? null : qFilter.toString()));
        return qFilter;
    }

    public static QFilter getQueryFieldPerm(long userId, long rptManageId, String fieldAlias, long structId) {
        DynamicObject[] rptPermDataDys = ReportPermissionService.getRptPermData(userId, rptManageId, fieldAlias, structId);
        QFilter qFilter = RptPermService.getQueryFieldPerm(rptPermDataDys);
        LOGGER.info("qFilter:{}", (Object)(qFilter == null ? null : qFilter.toString()));
        return qFilter;
    }

    public static Set<Long> getStructIds(long userId, long rptManageId, long queryFieldId) {
        DynamicObject[] rptPermDataDys;
        HashSet<Long> structId = new HashSet<Long>(10);
        for (DynamicObject dy : rptPermDataDys = ReportPermissionService.getRptPermData(userId, rptManageId, queryFieldId)) {
            if (null == dy.getDynamicObject("adminorgstruct")) continue;
            structId.add(dy.getDynamicObject("adminorgstruct").getLong("id"));
        }
        return structId;
    }

    public static Map<String, QFilter> getQueryFieldPerm(long userId, long rptManageId) {
        DynamicObject[] rptPermDataDys = ReportPermissionService.getRptPermDataWithAll(userId, rptManageId);
        Map<String, List<DynamicObject>> rptPermDataMap = Arrays.stream(rptPermDataDys).collect(Collectors.groupingBy(rpd -> rpd.getString("queryfield.fieldalias")));
        HashMap permQFilterMap = Maps.newHashMapWithExpectedSize((int)rptPermDataMap.size());
        for (Map.Entry<String, List<DynamicObject>> entry : rptPermDataMap.entrySet()) {
            QFilter queryFieldPerm = RptPermService.getQueryFieldPerm(entry.getValue().toArray(new DynamicObject[0]));
            permQFilterMap.put(entry.getKey(), queryFieldPerm);
        }
        return permQFilterMap;
    }

    private static QFilter getQueryFieldPerm(DynamicObject[] rptPermDataDys) {
        if (rptPermDataDys == null || rptPermDataDys.length == 0) {
            return null;
        }
        Date startDate = rptPermDataDys[0].getDate("startdate");
        Date endDate = rptPermDataDys[0].getDate("enddate");
        Date today = HRDateTimeUtils.getNowDate();
        if (startDate.after(today) || endDate.before(today)) {
            LOGGER.info("qFilter:1!=1");
            return QFilter.of((String)"1!=1", (Object[])new Object[0]);
        }
        DynamicObject rptPermData = Arrays.stream(rptPermDataDys).filter(dy -> dy.getBoolean("nolimit")).findAny().orElse(null);
        if (rptPermData != null) {
            return null;
        }
        HashSet<Long> ids = new HashSet<Long>(100);
        for (DynamicObject rptPermDataDy : rptPermDataDys) {
            DynamicObject queryFieldDy = rptPermDataDy.getDynamicObject("queryfield");
            String data = rptPermDataDy.getString("data");
            String[] values = data.split(",");
            if (!RptPermService.isBaseData(queryFieldDy.getString("complextype"))) continue;
            if (rptPermDataDy.getBoolean("includesub")) {
                long orgStructId = rptPermDataDy.getDynamicObject("adminorgstruct").getLong("id");
                ids.addAll(RptPermService.getAdminOrgIdsIncludeSub(orgStructId, values));
                continue;
            }
            try {
                ids.addAll(Arrays.stream(values).map(Long::parseLong).collect(Collectors.toSet()));
            }
            catch (NumberFormatException e) {
                ids.addAll(Arrays.stream(values).collect(Collectors.toSet()));
            }
        }
        return new QFilter("id", "in", ids);
    }
}

