/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign.datastore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.configoperator.DtsConfigOperator;
import kd.bos.dts.configoperator.DtsConfigOperatorFactory;
import kd.bos.dts.configoperator.DtsConfigOperatorInfo;
import kd.bos.dts.enmu.DtsDestTypeEnum;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.datastore.DataStoreLogService;
import kd.hr.hrptmc.business.datastore.IDataStoreService;
import kd.hr.hrptmc.business.datastore.metadata.model.RptFormMetadataContent;
import kd.hr.hrptmc.business.datastore.metadata.model.RptMetaFieldMap;
import kd.hr.hrptmc.business.datastore.metadata.model.RptMetadataContentBaseMsg;
import kd.hr.hrptmc.business.datastore.metadata.service.RptMetadataService;
import kd.hr.hrptmc.business.datastore.model.BatchQueryAndSaveDataBo;
import kd.hr.hrptmc.business.datastore.physicaltable.PhysicalTableHandler;
import kd.hr.hrptmc.business.datastore.physicaltable.RptPhysicalTableHandlerCreator;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreType;
import kd.hr.hrptmc.business.datastore.queryservice.ReportDataExtractQueryService;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.datastore.FieldDataStoreBO;
import kd.hr.hrptmc.business.repdesign.datastore.FieldDataStoreInfo;
import kd.hr.hrptmc.business.repdesign.datastore.IndexBo;
import kd.hr.hrptmc.business.repdesign.datastore.ReportDataStoreFieldService;
import kd.hr.hrptmc.business.repdesign.datastore.ReportDataStoreServiceHelper;
import kd.hr.hrptmc.business.repdesign.datastore.ReportDtsBusinessType;
import kd.hr.hrptmc.business.repdesign.datastore.SortFieldDataStoreBO;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.util.QFilterUtils;
import kd.hr.hrptmc.common.constant.repdesign.RepQueryConfigConstants;
import kd.hr.hrptmc.common.model.anobj.JoinEntityBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;

public class ReportDataStoreService
implements IDataStoreService,
RepQueryConfigConstants {
    private static final Log LOGGER = LogFactory.getLog(ReportDataStoreService.class);
    private String mainEntityNum = null;
    private final DynamicObject reportDyn;
    private final DynamicObject config;
    private final ReportDataStoreFieldService dataStoreFieldService;
    private static final HRBaseServiceHelper CONFIG_SERVICE_HELPER = new HRBaseServiceHelper("hrptmc_paramconfig");
    private final DataStoreLogService dataStoreLogService;

    public DynamicObject getConfig() {
        return this.config;
    }

    public ReportDataStoreService(Long reportId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_reportmanage");
        this.reportDyn = serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)reportId));
        this.config = ReportManageService.getParamConfigWithSchedule(reportId);
        long anObjId = this.reportDyn.getLong("anobjid.id");
        AnalyseObjectService instance = AnalyseObjectService.getInstance();
        List<JoinEntityBo> joinEntityBos = instance.queryAndAssembleJoinEntities(anObjId);
        for (JoinEntityBo joinEntityBo : joinEntityBos) {
            if (!"main".equals(joinEntityBo.getType())) continue;
            this.mainEntityNum = joinEntityBo.getEntityNumber();
        }
        this.dataStoreFieldService = new ReportDataStoreFieldService(this.reportDyn, joinEntityBos);
        this.dataStoreLogService = new DataStoreLogService(reportId, true);
    }

    @Override
    public boolean beforeExecute() {
        String status = this.config.getString("schedulestatus");
        if ("1".equals(status)) {
            return this.isDirtyData(this.reportDyn.getLong("id"));
        }
        this.config.set("schedulestatus", (Object)"1");
        CONFIG_SERVICE_HELPER.saveOne(this.config);
        return true;
    }

    @Override
    public void execute() {
        String newEntityNum = this.config.getString("newentitynum");
        String newTable = this.config.getString("newtable");
        FieldDataStoreBO dataStoreBO = this.dataStoreFieldService.getField();
        this.generateMetadata(dataStoreBO);
        if (!HRStringUtils.isEmpty((String)newEntityNum)) {
            ReportDataStoreServiceHelper.deleteMetadataAndTable(newEntityNum, newTable);
        }
        this.saveDTSConfig();
        LOGGER.info("ReportDataStoreService_execute_finish");
        this.dataStoreLogService.insertLog(this.config.getString("newentitynum"), this.config.getString("newtable"));
    }

    @Override
    public void endExecute() {
    }

    @Override
    public void endSyn() {
        this.config.set("schedulestatus", (Object)"2");
        CONFIG_SERVICE_HELPER.saveOne(this.config);
        this.dataStoreLogService.end();
        long reportId = this.reportDyn.getLong("id");
        try (TXHandle txHandle = TX.requiresNew();){
            ReportDataStoreServiceHelper.deleteDtsConfig(reportId, this.mainEntityNum);
        }
    }

    private void generateMetadata(FieldDataStoreBO dataStoreBO) {
        List<FieldInfo> storeFieldList = dataStoreBO.getStoreFieldInfoList();
        if (storeFieldList.isEmpty()) {
            LOGGER.info("ReportDataStoreService_execute_fieldIsEmpty!");
            return;
        }
        RptMetadataService service = RptMetadataService.getInstance();
        String entityNum = this.generateEntityNum();
        String tableName = this.generateTableName(entityNum);
        RptMetadataContentBaseMsg contentBaseMsg = new RptMetadataContentBaseMsg(entityNum, entityNum, "3+JJD4IUAS56", "hros", tableName);
        long anObjId = this.reportDyn.getDynamicObject("anobjid").getLong("id");
        RptFormMetadataContent rptFormMetadataContent = service.generateMetaData(contentBaseMsg, anObjId, storeFieldList);
        PhysicalTableHandler handler = RptPhysicalTableHandlerCreator.getHandler(rptFormMetadataContent);
        handler.createTable();
        List<RptMetaFieldMap> metaFieldList = this.getMetaFieldList(rptFormMetadataContent);
        this.creatIndex(dataStoreBO, metaFieldList, handler, entityNum, tableName);
        service.bindTable(rptFormMetadataContent);
        this.handleConfig(entityNum, tableName);
        this.generateMapping(metaFieldList);
        LOGGER.info("ReportDataStoreService_generateMetadata_success,entityNum:{},tableName:{}", (Object)entityNum, (Object)tableName);
    }

    private List<RptMetaFieldMap> getMetaFieldList(RptFormMetadataContent rptFormMetadataContent) {
        List<RptMetaFieldMap> metaFieldMapList = rptFormMetadataContent.getMetaFieldMapList();
        LOGGER.info("ReportDataStoreService_generateMapping:{}", metaFieldMapList);
        return metaFieldMapList;
    }

    private void creatIndex(FieldDataStoreBO dataStoreBO, List<RptMetaFieldMap> metaFieldList, PhysicalTableHandler handler, String entityNum, String tableName) {
        ArrayList<IndexBo> indexBoList = new ArrayList<IndexBo>(10);
        List<SortFieldDataStoreBO> sortFieldInfoList = dataStoreBO.getSortFieldInfoList();
        Map<String, RptMetaFieldMap> metaFieldMap = metaFieldList.stream().collect(Collectors.toMap(RptMetaFieldMap::getFieldAlias, mf -> mf, (k1, k2) -> k1));
        String idxPre = "IDX_";
        for (int i = 0; i < sortFieldInfoList.size(); ++i) {
            SortFieldDataStoreBO sortFieldDataStoreBO = sortFieldInfoList.get(i);
            ArrayList sortFieldNumList = new ArrayList(sortFieldInfoList.size());
            this.addIdxField(sortFieldDataStoreBO.getSortFieldInfoList(), sortFieldNumList, metaFieldMap, false);
            if (sortFieldNumList.isEmpty()) continue;
            indexBoList.add(new IndexBo(idxPre + entityNum.toUpperCase(Locale.ROOT) + "_S_" + sortFieldDataStoreBO.getType() + i, tableName, sortFieldNumList.toArray(new String[0])));
        }
        List<FieldDataStoreInfo> filterFieldInfoList = dataStoreBO.getFilterFieldInfoList();
        int orgCount = 0;
        for (FieldInfo fieldInfo : filterFieldInfoList) {
            if (!this.isAdminOrg(fieldInfo)) continue;
            String string = QFilterUtils.prop2Id(fieldInfo.getNumber());
            indexBoList.add(new IndexBo(idxPre + entityNum.toUpperCase(Locale.ROOT) + "_FO_" + orgCount, tableName, metaFieldMap.get(string).getTableFieldName()));
            ++orgCount;
        }
        List<FieldDataStoreInfo> filterExtFieldInfoList = dataStoreBO.getFilterExtFieldInfoList();
        orgCount = 0;
        for (FieldInfo fieldInfo : filterExtFieldInfoList) {
            if (!this.isAdminOrg(fieldInfo)) continue;
            String idProp = QFilterUtils.prop2Id(fieldInfo.getNumber());
            indexBoList.add(new IndexBo(idxPre + entityNum.toUpperCase(Locale.ROOT) + "_FEO_" + orgCount, tableName, metaFieldMap.get(idProp).getTableFieldName()));
            ++orgCount;
        }
        ArrayList arrayList = new ArrayList(filterFieldInfoList.size() + filterExtFieldInfoList.size());
        filterFieldInfoList.forEach(info -> {
            if (info.isMustInput() && !this.isAdminOrg((FieldInfo)info)) {
                filterMustFieldInfoList.add(info);
            }
        });
        filterExtFieldInfoList.forEach(info -> {
            if (info.isMustInput() && !this.isAdminOrg((FieldInfo)info)) {
                filterMustFieldInfoList.add(info);
            }
        });
        arrayList.sort(FieldDataStoreInfo::compareTo);
        ArrayList<String> arrayList2 = new ArrayList<String>(sortFieldInfoList.size());
        this.addIdxField(new ArrayList<FieldInfo>(arrayList), arrayList2, metaFieldMap, true);
        if (!arrayList2.isEmpty()) {
            indexBoList.add(new IndexBo(idxPre + entityNum.toUpperCase(Locale.ROOT) + "_F_MI", tableName, arrayList2.toArray(new String[0])));
        }
        List<List<FieldInfo>> distinctFieldInfoLists = dataStoreBO.getDistinctFieldInfoList();
        int distinctCount = 0;
        for (List<FieldInfo> distinctFieldInfoList : distinctFieldInfoLists) {
            ArrayList<String> distinctFieldNumList = new ArrayList<String>(distinctFieldInfoList.size());
            this.addDistinctIdxField(new ArrayList<FieldInfo>(distinctFieldInfoList), distinctFieldNumList, metaFieldMap);
            if (distinctFieldNumList.isEmpty()) continue;
            indexBoList.add(new IndexBo(idxPre + entityNum.toUpperCase(Locale.ROOT) + "_DI_MI" + distinctCount++, tableName, distinctFieldNumList.toArray(new String[0])));
        }
        this.optimizeIndex(indexBoList);
        if (!indexBoList.isEmpty()) {
            handler.createIndex(indexBoList);
        }
    }

    private void optimizeIndex(List<IndexBo> indexBoList) {
        indexBoList.sort(IndexBo::compareTo);
        LOGGER.info("Before optimizeIndex:{}", indexBoList);
        Iterator<IndexBo> iterator = indexBoList.iterator();
        ArrayList<String> indexKeyList = new ArrayList<String>(10);
        while (iterator.hasNext()) {
            IndexBo indexBo = iterator.next();
            CharSequence[] indexFields = this.optimizeIdxField(indexBo.getFieldNames());
            indexBo.setFieldNames((String[])indexFields);
            String indexKey = String.join((CharSequence)",", indexFields);
            if (indexKeyList.contains(indexKey)) {
                iterator.remove();
                continue;
            }
            boolean addKey = true;
            for (String key : indexKeyList) {
                if (!key.startsWith(indexKey)) continue;
                iterator.remove();
                addKey = false;
                break;
            }
            if (!addKey) continue;
            indexKeyList.add(indexKey);
        }
        LOGGER.info("After optimizeIndex:{}", indexBoList);
    }

    private String[] optimizeIdxField(String ... fieldNames) {
        String[] tempNames;
        if (fieldNames.length > 5) {
            tempNames = new String[5];
            System.arraycopy(fieldNames, 0, tempNames, 0, 5);
        } else {
            tempNames = fieldNames;
        }
        return tempNames;
    }

    private boolean isAdminOrg(FieldInfo fieldInfo) {
        return FieldComplexType.ADMIN_ORG.getValue().equals(fieldInfo.getComplexType()) && (fieldInfo.getNumber().endsWith(".number") || fieldInfo.getNumber().endsWith(".name"));
    }

    private void handleConfig(String entityNum, String tableName) {
        this.config.set("newentitynum", (Object)entityNum);
        this.config.set("newtable", (Object)tableName);
        CONFIG_SERVICE_HELPER.saveOne(this.config);
    }

    private void generateMapping(List<RptMetaFieldMap> metaFieldList) {
        long reportId = this.reportDyn.getLong("id");
        ReportManageService.deleteReportMappings(reportId);
        DynamicObjectCollection col = new DynamicObjectCollection();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_reportmapping");
        for (RptMetaFieldMap rptMetaFieldMap : metaFieldList) {
            String metaFieldNumber = rptMetaFieldMap.getMetaFieldNumber();
            String fieldControlType = rptMetaFieldMap.getFieldControlType();
            String tableFieldType = rptMetaFieldMap.getTableFieldType();
            int fieldLength = rptMetaFieldMap.getFieldLength();
            String fieldAlias = rptMetaFieldMap.getFieldAlias();
            String fieldNumberAlias = rptMetaFieldMap.getFieldNumberAlias();
            DynamicObject mappingDyn = serviceHelper.generateEmptyDynamicObject();
            mappingDyn.set("report", (Object)reportId);
            mappingDyn.set("numberalias", (Object)fieldNumberAlias);
            mappingDyn.set("fieldalias", (Object)fieldAlias);
            mappingDyn.set("metadatafieldkey", (Object)metaFieldNumber);
            mappingDyn.set("metadatacontrolkey", (Object)fieldControlType);
            mappingDyn.set("tablefieldtype", (Object)tableFieldType);
            mappingDyn.set("tablefieldlength", (Object)fieldLength);
            col.add((Object)mappingDyn);
        }
        serviceHelper.save(col);
    }

    @Override
    public void batchSynData(List<Object> idList) {
        if (this.isTermination()) {
            return;
        }
        try {
            this.executeBatchSynData(idList);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            this.dataStoreLogService.error(e.toString());
            long reportId = this.reportDyn.getLong("id");
            ThreadPools.executeOnce((String)"ReportDataStoreService_batchSynData_error", () -> {
                ReportDataStoreServiceHelper.deleteDtsConfig(reportId, this.mainEntityNum);
                this.config.set("schedulestatus", (Object)"3");
                CONFIG_SERVICE_HELPER.saveOne(this.config);
            });
            throw new KDBizException(e.getMessage());
        }
    }

    private void executeBatchSynData(List<Object> idList) {
        int querySize;
        this.setUserId();
        long time0 = System.currentTimeMillis();
        long reportId = this.reportDyn.getLong("id");
        long anObjId = this.reportDyn.getLong("anobjid.id");
        AnalyseObjectService instance = AnalyseObjectService.getInstance();
        List<QueryFieldBo> allQueryFieldBoList = instance.queryAndAssembleQueryFields(anObjId);
        ArrayList newQFilterList = Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "in", idList)});
        List<QFilter> qFilters = instance.getQueryQFilter(anObjId, allQueryFieldBoList);
        List<QFilter> dataFilters = ReportDataStoreServiceHelper.getDataFilter(this.reportDyn.getString("datafilter"), allQueryFieldBoList);
        newQFilterList.addAll(qFilters);
        newQFilterList.addAll(dataFilters);
        List<RptMetaFieldMap> rptMetaFieldMapList = this.queryFieldMapList(reportId);
        FieldDataStoreBO dataStoreBO = this.dataStoreFieldService.getField();
        List<FieldInfo> entityIdFieldList = this.getEntityIdFieldList(anObjId, rptMetaFieldMapList, this.mainEntityNum);
        dataStoreBO.getStoreFieldInfoList().addAll(entityIdFieldList);
        Map<String, RptMetaFieldMap> mappingFieldMap = rptMetaFieldMapList.stream().collect(Collectors.toMap(RptMetaFieldMap::getFieldNumberAlias, mi -> mi));
        Map<String, Map<Object, Integer>> customSortMap = ReportDataStoreServiceHelper.getCustomSortMap(reportId);
        String newEntityNum = this.config.getString("newentitynum");
        HRBaseServiceHelper newServiceHelper = new HRBaseServiceHelper(newEntityNum);
        RptMetaFieldMap idRptMetaFieldMap = mappingFieldMap.get("id");
        if (idRptMetaFieldMap != null) {
            newServiceHelper.deleteByFilter(new QFilter[]{new QFilter(idRptMetaFieldMap.getMetaFieldNumber(), "in", idList)});
        }
        long time1 = System.currentTimeMillis();
        LOGGER.info("ReportDataStoreService_batchSynData_prepare_time:{}", (Object)(time1 - time0));
        int start = 0;
        try (TXHandle txHandle = TX.requiresNew();){
            BatchQueryAndSaveDataBo bo;
            int fieldSize = dataStoreBO.getStoreFieldInfoList().size();
            int queryCount = MAX_SIZE / fieldSize;
            ReportDataExtractQueryService queryService = new ReportDataExtractQueryService();
            while ((querySize = this.batchQueryAndSaveData(bo = new BatchQueryAndSaveDataBo(anObjId, reportId, newServiceHelper, mappingFieldMap, dataStoreBO, customSortMap, newQFilterList, queryService, start, queryCount, null, idList))) >= queryCount) {
                start += queryCount;
            }
        }
        long time2 = System.currentTimeMillis();
        LOGGER.info("ReportDataStoreService_batchSynData_queryAndSave_time:{}", (Object)(time2 - time1));
        LOGGER.info("ReportDataStoreService_batchSynData_time:{}", (Object)(time2 - time0));
        this.dataStoreLogService.updateCount(start += querySize);
    }

    @Override
    public String getMainEntityNumber() {
        return this.mainEntityNum;
    }

    @Override
    public String generateEntityNumPre() {
        return "hrom_re_";
    }

    private void saveDTSConfig() {
        long reportId = this.reportDyn.getLong("id");
        ReportDataStoreServiceHelper.deleteDtsConfig(reportId, this.mainEntityNum);
        String mappingRule = ReportDataStoreServiceHelper.getMappingRule(reportId);
        String businessType = new ReportDtsBusinessType().getBusinessTypeCode();
        DtsConfigOperatorInfo dtsConfigOperatorInfo = new DtsConfigOperatorInfo();
        dtsConfigOperatorInfo.setEntityNumber(this.mainEntityNum);
        dtsConfigOperatorInfo.setDtsDestType(DtsDestTypeEnum.FULLTEXT);
        dtsConfigOperatorInfo.setRegion("hr");
        dtsConfigOperatorInfo.setMappingRule(mappingRule);
        dtsConfigOperatorInfo.setBusinessType(businessType);
        dtsConfigOperatorInfo.setEnable("1");
        dtsConfigOperatorInfo.setEntityFields(new String[]{"id"});
        DtsConfigOperator dtsConfigOperator = DtsConfigOperatorFactory.getDefault();
        dtsConfigOperator.saveDtsConfig(dtsConfigOperatorInfo);
    }

    private boolean isDirtyData(long reportId) {
        return this.isWarningDtsConfig(this.mainEntityNum, ReportDataStoreServiceHelper.getMappingRule(reportId));
    }

    private boolean isTermination() {
        return HRStringUtils.equals((String)"3", (String)this.config.getString("schedulestatus"));
    }

    private void addIdxField(List<FieldInfo> fieldInfoList, List<String> fieldNumList, Map<String, RptMetaFieldMap> metaFieldMap, boolean prop2Id) {
        for (FieldInfo fieldInfo : fieldInfoList) {
            String fieldAlias = prop2Id ? QFilterUtils.prop2Id(fieldInfo.getNumber()) : fieldInfo.getNumber();
            this.addTableFieldName(fieldNumList, fieldAlias, metaFieldMap);
        }
    }

    private void addDistinctIdxField(List<FieldInfo> fieldInfoList, List<String> fieldNumList, Map<String, RptMetaFieldMap> metaFieldMap) {
        for (FieldInfo fieldInfo : fieldInfoList) {
            String fieldAlias;
            String propId = QFilterUtils.prop2Id(fieldInfo.getNumber());
            if (propId.equals(fieldAlias = fieldInfo.getNumber())) {
                this.addTableFieldName(fieldNumList, fieldAlias, metaFieldMap);
                continue;
            }
            this.addTableFieldName(fieldNumList, propId, metaFieldMap);
            this.addTableFieldName(fieldNumList, fieldAlias, metaFieldMap);
        }
    }

    private void addTableFieldName(List<String> fieldNumList, String fieldAlias, Map<String, RptMetaFieldMap> metaFieldMap) {
        RptMetaFieldMap rptMetaFieldMap = metaFieldMap.get(fieldAlias);
        LOGGER.info("fieldAlias:{}", (Object)fieldAlias);
        LOGGER.info("metaFieldMap:{}", metaFieldMap);
        if (null != rptMetaFieldMap && !fieldNumList.contains(rptMetaFieldMap.getTableFieldName()) && !ReportDataStoreType.TEXT.getType().equals(rptMetaFieldMap.getTableFieldType())) {
            fieldNumList.add(rptMetaFieldMap.getTableFieldName());
        }
    }

    private List<RptMetaFieldMap> queryFieldMapList(long reportId) {
        DynamicObject[] reportMappings = ReportManageService.getReportMappings(reportId);
        ArrayList fieldMaps = Lists.newArrayListWithCapacity((int)reportMappings.length);
        for (DynamicObject fieldMapDy : reportMappings) {
            String numberAlias = fieldMapDy.getString("numberalias");
            String fieldAlias = fieldMapDy.getString("fieldalias");
            String metaFieldNumber = fieldMapDy.getString("metadatafieldkey");
            int fieldLength = fieldMapDy.getInt("tablefieldlength");
            String fieldControlType = fieldMapDy.getString("metadatacontrolkey");
            String tableFieldType = fieldMapDy.getString("tablefieldtype");
            RptMetaFieldMap rptMetaFieldMapBo = new RptMetaFieldMap(fieldAlias, numberAlias, metaFieldNumber, null, fieldLength, fieldControlType, tableFieldType);
            fieldMaps.add(rptMetaFieldMapBo);
        }
        return fieldMaps;
    }
}

