/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign.hisversion;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.hisversion.ReportHisVersionConfigBo;
import kd.hr.hrptmc.business.repdesign.info.DimensionFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.IndexFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBillHeadInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;

public class ReportHisVersionService {
    private final String ENTITY_REPORT_CONFIG_HIS = "hrptmc_reportconfighis";
    private final String REPORT_ID = "reportid";
    private final String START_TIME = "starttime";
    private final String END_TIME = "endtime";
    private final HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportconfighis");
    private final HRBaseServiceHelper reportManageHelper = new HRBaseServiceHelper("hrptmc_reportmanage");
    private static final Log LOGGER = LogFactory.getLog(ReportHisVersionService.class);
    private static volatile ReportHisVersionService service = null;

    private ReportHisVersionService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportHisVersionService getInstance() {
        if (service != null) return service;
        Class<ReportHisVersionService> clazz = ReportHisVersionService.class;
        synchronized (ReportHisVersionService.class) {
            if (service != null) return service;
            service = new ReportHisVersionService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public Map<String, Object> getReportNumberAndName(long reportId, Date versionTime) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        try {
            QFilter qFilter = new QFilter("reportid", "=", (Object)reportId);
            qFilter.and(new QFilter("starttime", "<=", (Object)versionTime));
            qFilter.and(new QFilter("endtime", ">", (Object)versionTime));
            DynamicObject reportDy = this.helper.queryOne("name, number", qFilter);
            if (reportDy == null && (reportDy = this.reportManageHelper.queryOne("name, number", new QFilter[]{new QFilter("id", "=", (Object)reportId)})) == null) {
                return null;
            }
            result.put("number", reportDy.getString("number"));
            OrmLocaleValue name = (OrmLocaleValue)reportDy.getLocaleString("name");
            result.put("name", AnalyseObjectUtil.getLocaleString((OrmLocaleValue)name));
        }
        catch (Exception exception) {
            LOGGER.error("ReportHisVersionService getReportNumberAndName error:", (Throwable)exception);
            result.put("number", "");
            result.put("name", new LocaleString(""));
        }
        return result;
    }

    public ReportHisVersionConfigBo getReportHisVersionConfigBo(long reportId, Date versionTime) {
        String presetIndexStr;
        String dateSplitStr;
        ReportHisVersionConfigBo reportHisVersionConfigBo = new ReportHisVersionConfigBo();
        QFilter qFilter = new QFilter("reportid", "=", (Object)reportId);
        qFilter.and(new QFilter("starttime", "<=", (Object)versionTime));
        qFilter.and(new QFilter("endtime", ">", (Object)versionTime));
        DynamicObject versionDy = this.helper.loadDynamicObject(qFilter);
        if (versionDy == null) {
            return null;
        }
        reportHisVersionConfigBo.setReportId(reportId);
        long anObjId = versionDy.getLong("anobjid");
        reportHisVersionConfigBo.setAnObjId(anObjId);
        String reportName = versionDy.getLocaleString("name").getLocaleValue();
        reportHisVersionConfigBo.setReportName(reportName);
        String reportNum = versionDy.getString("number");
        reportHisVersionConfigBo.setReportNumber(reportNum);
        String reportConfigStr = versionDy.getString("rptmanageconfig");
        ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)reportConfigStr, ReportManageConfigInfo.class);
        reportHisVersionConfigBo.setReportManageConfigInfo(reportManageConfigInfo);
        String calculateFieldStr = versionDy.getString("calculatefield");
        if (HRStringUtils.isNotEmpty((String)calculateFieldStr)) {
            reportHisVersionConfigBo.setCalculateFieldBos(JSON.parseArray((String)calculateFieldStr, CalculateFieldBo.class));
        }
        if (HRStringUtils.isNotEmpty((String)(dateSplitStr = versionDy.getString("datesplit")))) {
            reportHisVersionConfigBo.setDateSpiltFields(JSON.parseArray((String)dateSplitStr, DimensionFieldInfo.class));
        }
        if (HRStringUtils.isNotEmpty((String)(presetIndexStr = versionDy.getString("presetindex")))) {
            List presetIndexes = JSON.parseArray((String)presetIndexStr, IndexFieldInfo.class);
            reportHisVersionConfigBo.setPresetIndexes(presetIndexes);
        }
        return reportHisVersionConfigBo;
    }

    public void saveReportHisVersionConfigBo(DynamicObject reportManageDy, ReportManageConfigInfo reportManageConfigInfo, ReportManageConfigInfo originalManageConfigIno, ReportBillHeadInfo originalReportHeadInfo) {
        try {
            long reportId = reportManageDy.getLong("id");
            DynamicObject versionDy = this.helper.generateEmptyDynamicObject();
            versionDy.set("reportid", (Object)reportId);
            versionDy.set("anobjid", (Object)Long.parseLong(reportManageConfigInfo.getAssignObj().getAnObj().getId()));
            versionDy.set("name", reportManageDy.get("name"));
            versionDy.set("number", reportManageDy.get("number"));
            this.setConfigData(versionDy, reportManageConfigInfo);
            versionDy.set("starttime", (Object)new Date());
            Calendar calendar = Calendar.getInstance();
            calendar.set(2999, 11, 31);
            versionDy.set("endtime", (Object)calendar.getTime());
            versionDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            DynamicObject lastVersionDy = this.helper.queryOne("starttime, endtime", new QFilter[]{new QFilter("reportid", "=", (Object)reportId)}, "starttime desc");
            if (lastVersionDy != null) {
                lastVersionDy.set("endtime", (Object)versionDy.getDate("starttime"));
                this.helper.saveOne(lastVersionDy);
            } else if (reportManageDy.getDataEntityState().getFromDatabase()) {
                DynamicObject originVersionDy = this.helper.generateEmptyDynamicObject();
                originVersionDy.set("reportid", (Object)reportId);
                originVersionDy.set("anobjid", (Object)originalReportHeadInfo.getAnObjId());
                originVersionDy.set("name", (Object)originalReportHeadInfo.getName());
                originVersionDy.set("number", (Object)originalReportHeadInfo.getNumber());
                this.setConfigData(originVersionDy, originalManageConfigIno);
                originVersionDy.set("starttime", (Object)reportManageDy.getDate("createtime"));
                originVersionDy.set("endtime", (Object)versionDy.getDate("starttime"));
                originVersionDy.set("creator", (Object)versionDy.getLong("creator"));
                this.helper.saveOne(originVersionDy);
            }
            this.helper.saveOne(versionDy);
        }
        catch (Exception exception) {
            LOGGER.error("ReportHisVersionService saveReportHisVersionConfigBo error: ", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u62a5\u8868\u914d\u7f6e\u7248\u672c\u8bb0\u5f55\u5f02\u5e38\u3002", (String)"ReportHisVersionService_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
    }

    private void setConfigData(DynamicObject versionDy, ReportManageConfigInfo reportManageConfigInfo) {
        List presetIndexes;
        List dateSplitFields;
        List<CalculateFieldBo> reportCalFields = reportManageConfigInfo.getAssignObj().getReportCalFields();
        if (reportCalFields != null) {
            versionDy.set("calculatefield", (Object)SerializationUtils.toJsonString(reportCalFields));
        }
        if (!(dateSplitFields = reportManageConfigInfo.getAssignObj().getDimensionList().stream().filter(DimensionFieldInfo::getSplitDate).collect(Collectors.toList())).isEmpty()) {
            versionDy.set("datesplit", (Object)SerializationUtils.toJsonString(dateSplitFields));
        }
        if (!(presetIndexes = reportManageConfigInfo.getAssignObj().getIndexList().stream().filter(index -> HRStringUtils.equals((String)index.getFieldSrc(), (String)"2")).collect(Collectors.toList())).isEmpty()) {
            versionDy.set("presetindex", (Object)SerializationUtils.toJsonString(presetIndexes));
        }
        reportManageConfigInfo.setAssignObj(null);
        reportManageConfigInfo.setReportDetail(null);
        List<WorkRptInfo> workRpt = reportManageConfigInfo.getWorkRpt();
        for (int i = 0; i < workRpt.size(); ++i) {
            workRpt.get(i).setShow(i == 0);
        }
        versionDy.set("rptmanageconfig", (Object)SerializationUtils.toJsonString((Object)reportManageConfigInfo));
    }

    public void updateVersionWhenDeleteReport(long reportId) {
        DynamicObject lastVersionDy = this.helper.queryOne("starttime, endtime", new QFilter[]{new QFilter("reportid", "=", (Object)reportId)}, "starttime desc");
        if (lastVersionDy != null) {
            lastVersionDy.set("endtime", (Object)new Date());
            this.helper.saveOne(lastVersionDy);
        }
    }
}

