/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign.jump;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.MergeInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.RptFilterInfo;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.repdesign.jump.ReportJumpConfigBo;

public class ReportJumpConfigService
implements ReportManageConstants,
ReportManageConstants.RptJumpConfigConstants {
    private static volatile ReportJumpConfigService service = null;
    private final HRBaseServiceHelper jumpConfigHelper = new HRBaseServiceHelper("hrptmc_reportjump");
    private static final String PAGE_KEY_JUMP_CONFIG = "ReportJumpConfigKey";
    private static final Log LOGGER = LogFactory.getLog(ReportJumpConfigService.class);

    private ReportJumpConfigService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportJumpConfigService getInstance() {
        if (service != null) return service;
        Class<ReportJumpConfigService> clazz = ReportJumpConfigService.class;
        synchronized (ReportJumpConfigService.class) {
            if (service != null) return service;
            service = new ReportJumpConfigService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public void addJumpQFilters(RptFilterInfo rptFilterInfo, IFormView view) {
        List jumpQFilters;
        if (!"true".equals(view.getFormShowParameter().getCustomParam("mark_is_report_jump_view"))) {
            return;
        }
        List whereFilters = (List)view.getFormShowParameter().getCustomParam("reportWhereFilters");
        if (whereFilters != null && !whereFilters.isEmpty()) {
            whereFilters.forEach(qFilterStr -> rptFilterInfo.addWhereQFilter(QFilter.fromSerializedString((String)qFilterStr)));
        }
        if ((jumpQFilters = (List)view.getFormShowParameter().getCustomParam("jumpQFilters")) == null || jumpQFilters.isEmpty()) {
            LOGGER.info("ReportPreview Add JumpQFilter Filter is Null.");
            return;
        }
        LOGGER.info("ReportPreview Add JumpQFilter start transfer");
        long startTime = System.currentTimeMillis();
        jumpQFilters.forEach(qFilterStr -> rptFilterInfo.addWhereQFilter(QFilter.fromSerializedString((String)qFilterStr)));
        LOGGER.info("ReportPreview Add JumpQFilter whereQFilters: {}, cost time: {}", rptFilterInfo.getWhereQFilter(), (Object)(System.currentTimeMillis() - startTime));
    }

    public void setTableHeadHyperLink(ReportConfigInfo reportConfigInfo, ReportInfo reportInfo) {
        List<ReportJumpConfigBo> reportJumpConfigList = reportConfigInfo.getReportJumpConfigList();
        if (reportJumpConfigList == null || reportJumpConfigList.isEmpty()) {
            return;
        }
        HashSet hyperLinkFields = Sets.newHashSetWithExpectedSize((int)16);
        reportJumpConfigList.forEach(config -> {
            String[] split = config.getRuleGroup().split(",");
            hyperLinkFields.addAll(Arrays.asList(split));
        });
        List<ReportHeadRowInfo> hf = reportInfo.getHead().getHf();
        for (ReportHeadRowInfo reportHeadRowInfo : hf) {
            this.setHeadHyperLink(reportHeadRowInfo, hyperLinkFields);
        }
    }

    private void setHeadHyperLink(ReportHeadRowInfo rowInfo, Set<String> hyperLinkFields) {
        List<ReportHeadRowInfo> children = rowInfo.getChildren();
        if (children == null || children.isEmpty()) {
            String codeAlias = rowInfo.getCodeAlias();
            if (codeAlias.contains("\u03b2")) {
                codeAlias = codeAlias.substring(codeAlias.indexOf("\u03b2") + 1);
            }
            if (hyperLinkFields.contains(codeAlias)) {
                rowInfo.setHyperLink(true);
            }
        } else {
            for (ReportHeadRowInfo child : children) {
                this.setHeadHyperLink(child, hyperLinkFields);
            }
        }
    }

    public void updateJumpConfigCache(MergeInfo rowColTransposition, ReportConfigInfo reportConfigInfo) {
        List<ReportJumpConfigBo> reportJumpConfigList = reportConfigInfo.getReportJumpConfigList();
        if (reportJumpConfigList == null || reportJumpConfigList.isEmpty()) {
            return;
        }
        HashSet pivotFields = Sets.newHashSetWithExpectedSize((int)16);
        for (RowFieldInfo header : rowColTransposition.getHeaders()) {
            String numberAlias = header.getGroupName().getNumberAlias();
            pivotFields.add(numberAlias);
            header._getChildFields().forEach(field -> pivotFields.add(field.getNumberAlias()));
        }
        for (String pivotField : pivotFields) {
            this.updateJumpConfigCache(pivotField, reportConfigInfo);
        }
    }

    public void updateJumpConfigCache(String deleteFieldAlias, ReportConfigInfo reportConfigInfo) {
        List<ReportJumpConfigBo> reportJumpConfigList = reportConfigInfo.getReportJumpConfigList();
        if (reportJumpConfigList == null || reportJumpConfigList.isEmpty()) {
            return;
        }
        if ("2".equals(reportConfigInfo.getType()) || "3".equals(reportConfigInfo.getType()) || "4".equals(reportConfigInfo.getType())) {
            reportJumpConfigList.clear();
            return;
        }
        Iterator<ReportJumpConfigBo> iterator = reportJumpConfigList.iterator();
        while (iterator.hasNext()) {
            ReportJumpConfigBo reportJumpConfigBo = iterator.next();
            String ruleGroup = reportJumpConfigBo.getRuleGroup();
            List ruleGroupList = Arrays.stream(ruleGroup.split(",")).collect(Collectors.toList());
            ruleGroupList.remove(deleteFieldAlias);
            if (ruleGroupList.isEmpty()) {
                iterator.remove();
                continue;
            }
            List jumpRuleEntry = reportJumpConfigBo.getJumpRuleEntry();
            jumpRuleEntry.removeIf(row -> HRStringUtils.equals((String)row.getSourceField(), (String)deleteFieldAlias));
        }
    }

    public FormShowParameter chartClickLink(Map<String, String> allFieldData, ReportManageConfigInfo reportManageConfigInfo, List<String> whereFilters) {
        List<ReportJumpConfigBo> reportJumpConfigList = reportManageConfigInfo.getReportConfig().getReportJumpConfigList();
        if (reportJumpConfigList == null || reportJumpConfigList.isEmpty()) {
            return null;
        }
        long anObjId = Long.parseLong(reportManageConfigInfo.getAssignObj().getAnObj().getId());
        Long reportId = Long.valueOf(reportJumpConfigList.get(0).getJumpReportId());
        DynamicObject reportDy = ReportManageService.getRptManage(reportId, anObjId);
        if (reportDy == null) {
            return null;
        }
        if (!reportJumpConfigList.get(0).getCarryFilter()) {
            whereFilters = Collections.emptyList();
        }
        List<QFilter> qFilters = this.getQFilters(reportManageConfigInfo, allFieldData);
        return this.getJumpFormShowParameter(reportId, reportDy.getString("name"), qFilters, whereFilters);
    }

    private List<QFilter> getQFilters(ReportManageConfigInfo reportManageConfigInfo, Map<String, String> allFieldData) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(allFieldData.size());
        Map<String, QueryFieldBo> fieldBoMap = reportManageConfigInfo.getAssignObj().getQueryFields().stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, field -> field));
        for (Map.Entry<String, String> entry : allFieldData.entrySet()) {
            String originFieldAlias = AnalyseObjectUtil.getOriginFieldAlias((String)entry.getKey());
            QFilter qFilter = this.getQFilter(fieldBoMap.get(originFieldAlias), originFieldAlias, entry.getValue());
            if (null == qFilter) continue;
            qFilters.add(qFilter);
        }
        return qFilters;
    }

    private QFilter getQFilter(QueryFieldBo queryFieldBo, String originFieldAlias, String dimValue) {
        Object transferValue;
        if (queryFieldBo == null) {
            return null;
        }
        List enumList = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)queryFieldBo.getData())) {
            enumList = (List)SerializationUtils.fromJsonString((String)queryFieldBo.getData(), List.class);
        }
        if ((transferValue = this.transferValue(dimValue, queryFieldBo.getValueType(), queryFieldBo.getControlType(), enumList)) instanceof String && (HRStringUtils.equals((String)((String)transferValue), (String)"null") || StringUtils.isEmpty((Object)transferValue))) {
            return new QFilter(originFieldAlias, "=", (Object)QEmptyValue.value).or(new QFilter(this.subStringFieldAlias(queryFieldBo, originFieldAlias), "=", (Object)QEmptyValue.value));
        }
        return new QFilter(originFieldAlias, "=", transferValue);
    }

    private FormShowParameter getJumpFormShowParameter(Long reportId, String reportName, List<QFilter> qFilters, List<String> whereFilters) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrptmc_report_preview");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("mark_is_report_jump_view", (Object)"true");
        showParameter.setCustomParam("reportId", (Object)reportId);
        showParameter.setCustomParam("reportName", (Object)reportName);
        showParameter.setCaption(reportName);
        if (!CollectionUtils.isEmpty(whereFilters)) {
            showParameter.setCustomParam("reportWhereFilters", whereFilters);
        }
        showParameter.setHasRight(true);
        LOGGER.info("ReportJumpConfig_clickLink qfilter: {}", qFilters);
        List qFilterStrList = qFilters.stream().map(QFilter::toSerializedString).collect(Collectors.toList());
        showParameter.setCustomParam("jumpQFilters", qFilterStrList);
        return showParameter;
    }

    public FormShowParameter clickLink(String clickField, List<Map<String, String>> dataList, ReportManageConfigInfo reportManageConfigInfo, List<String> whereFilters) {
        ReportConfigInfo reportConfigInfo = reportManageConfigInfo.getReportConfig();
        List<ReportJumpConfigBo> reportJumpConfigList = reportConfigInfo.getReportJumpConfigList();
        if (reportJumpConfigList == null || reportJumpConfigList.isEmpty()) {
            return null;
        }
        String fieldAlias = clickField;
        String pivotAlias = null;
        if (clickField.contains("\u03b2")) {
            pivotAlias = clickField.substring(0, clickField.indexOf("\u03b2"));
            fieldAlias = clickField.substring(clickField.indexOf("\u03b2") + 1);
        }
        ReportJumpConfigBo currentReportJumpConfig = null;
        for (ReportJumpConfigBo reportJumpConfigBo : reportJumpConfigList) {
            String[] split = reportJumpConfigBo.getRuleGroup().split(",");
            List<String> groupFields = Arrays.asList(split);
            if (!groupFields.contains(fieldAlias)) continue;
            currentReportJumpConfig = reportJumpConfigBo;
            break;
        }
        if (currentReportJumpConfig == null) {
            return null;
        }
        long anObjId = Long.parseLong(reportManageConfigInfo.getAssignObj().getAnObj().getId());
        Long reportId = Long.valueOf(currentReportJumpConfig.getJumpReportId());
        DynamicObject reportDy = ReportManageService.getRptManage(reportId, anObjId);
        if (reportDy == null) {
            return null;
        }
        if (!currentReportJumpConfig.getCarryFilter()) {
            whereFilters = Collections.emptyList();
        }
        try {
            List<QFilter> qFilters = this.generateJumpQFilters(currentReportJumpConfig, pivotAlias, dataList, reportManageConfigInfo);
            return this.getJumpFormShowParameter(reportId, reportDy.getString("name"), qFilters, whereFilters);
        }
        catch (Exception exception) {
            LOGGER.error("ReportJumpConfigService clickLink error: ", (Throwable)exception);
            return null;
        }
    }

    private List<QFilter> generateJumpQFilters(ReportJumpConfigBo currentReportJumpConfig, String pivotAlias, List<Map<String, String>> dataList, ReportManageConfigInfo reportManageConfigInfo) {
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)10);
        Map columnMap = reportManageConfigInfo.getColumns().stream().collect(Collectors.toMap(FieldInfo::getNumberAlias, Function.identity()));
        Map<String, Map<String, Object>> fieldMap = this.transferDataMap(dataList, reportManageConfigInfo);
        Map<String, QueryFieldBo> fieldBoMap = reportManageConfigInfo.getAssignObj().getQueryFields().stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, field -> field));
        for (ReportJumpConfigBo.ReportJumpRuleEntryBo reportJumpRuleEntryBo : currentReportJumpConfig.getJumpRuleEntry()) {
            String type = reportJumpRuleEntryBo.getType();
            String sourceField = reportJumpRuleEntryBo.getSourceField();
            String targetField = reportJumpRuleEntryBo.getTargetField();
            if (HRStringUtils.equals((String)type, (String)"field")) {
                Object value;
                FieldInfo colField = (FieldInfo)columnMap.get(sourceField);
                if (colField != null) {
                    int dimValIndex;
                    if (pivotAlias == null) continue;
                    String[] dimValues = pivotAlias.split("\u03b5");
                    for (dimValIndex = 0; dimValIndex < reportManageConfigInfo.getColumns().size(); ++dimValIndex) {
                        String numberAlias = reportManageConfigInfo.getColumns().get(dimValIndex).getNumberAlias();
                        if (HRStringUtils.equals((String)colField.getNumberAlias(), (String)numberAlias)) break;
                    }
                    QueryFieldBo queryFieldBo = fieldBoMap.get(colField.getNumber());
                    String dimValue = dimValues[dimValIndex];
                    String originFieldAlias = AnalyseObjectUtil.getOriginFieldAlias((String)targetField);
                    QFilter qFilter = this.getQFilter(queryFieldBo, originFieldAlias, dimValue);
                    if (null == qFilter) continue;
                    qFilters.add(qFilter);
                    continue;
                }
                Map<String, Object> fieldDataMap = fieldMap.get(sourceField);
                if (fieldDataMap == null) continue;
                Set values = (Set)fieldDataMap.get("value");
                Map originalData = (Map)fieldDataMap.get("originalData");
                if (originalData.get("isGroupField") != null && ((Boolean)originalData.get("isGroupField")).booleanValue()) {
                    AnObjGroupField groupField = (AnObjGroupField)originalData.get("groupField");
                    StringBuilder groupItemIdSb = new StringBuilder();
                    for (String value2 : values) {
                        String groupItemId = AnObjGroupFieldService.getInstance().findGroupItemIdByName(value2, groupField);
                        groupItemIdSb.append(groupItemId).append(",");
                    }
                    QFilter groupFieldQFilter = AnObjGroupFieldService.getInstance().getGroupFieldQFilter(groupItemIdSb.substring(0, groupItemIdSb.length() - 1), groupField);
                    qFilters.add(groupFieldQFilter);
                    continue;
                }
                String valueType = (String)originalData.get("valueType");
                String controlType = (String)originalData.get("controlType");
                String data = (String)originalData.get("data");
                List enumList = Lists.newArrayListWithCapacity((int)10);
                if (HRStringUtils.isNotEmpty((String)data)) {
                    enumList = (List)SerializationUtils.fromJsonString((String)data, List.class);
                }
                ArrayList transferValues = Lists.newArrayListWithCapacity((int)10);
                for (String value3 : values) {
                    Object transferValue = this.transferValue(value3, valueType, controlType, enumList);
                    transferValues.add(transferValue);
                }
                String originFieldAlias = AnalyseObjectUtil.getOriginFieldAlias((String)targetField);
                QueryFieldBo queryFieldBo = fieldBoMap.get(originFieldAlias);
                QFilter qFilter = transferValues.size() == 1 ? ((value = transferValues.get(0)) == null || value instanceof String && (HRStringUtils.isEmpty((String)((String)value)) || HRStringUtils.equals((String)((String)value), (String)"null")) ? new QFilter(originFieldAlias, "=", (Object)QEmptyValue.value).or(new QFilter(this.subStringFieldAlias(queryFieldBo, originFieldAlias), "=", (Object)QEmptyValue.value)) : new QFilter(originFieldAlias, "=", value)) : new QFilter(originFieldAlias, "in", (Object)transferValues);
                qFilters.add(qFilter);
                continue;
            }
            List<QueryFieldBo> queryFields = reportManageConfigInfo.getAssignObj().getQueryFields();
            List<AnObjGroupField> anObjGroupFields = reportManageConfigInfo.getAssignObj().getAnObjGroupFields();
            this.transferValueQFilter(qFilters, queryFields, anObjGroupFields, targetField, sourceField);
        }
        return qFilters;
    }

    private String subStringFieldAlias(QueryFieldBo queryFieldBo, String originFieldAlias) {
        if (queryFieldBo != null && AnalyseObjectUtil.isBaseDataType((String)queryFieldBo.getComplexType()) && originFieldAlias.contains(".")) {
            return originFieldAlias.substring(0, originFieldAlias.lastIndexOf("."));
        }
        return originFieldAlias;
    }

    private Map<String, Map<String, Object>> transferDataMap(List<Map<String, String>> dataList, ReportManageConfigInfo reportManageConfigInfo) {
        HashMap finalMap = Maps.newHashMapWithExpectedSize((int)16);
        if (dataList.isEmpty()) {
            return finalMap;
        }
        Map queryFieldBoMap = reportManageConfigInfo.getAssignObj().getQueryFields().stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, Function.identity()));
        Map anObjGroupFieldMap = reportManageConfigInfo.getAssignObj().getAnObjGroupFields().stream().collect(Collectors.toMap(AnObjGroupField::getNumber, Function.identity()));
        Set<String> fieldAliasSet = dataList.get(0).keySet();
        fieldAliasSet.removeIf(field -> HRStringUtils.equals((String)field, (String)"No"));
        for (String fieldAliasKey : fieldAliasSet) {
            AnObjGroupField groupField;
            QueryFieldBo queryFieldBo;
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            HashSet values = Sets.newHashSetWithExpectedSize((int)16);
            for (Map<String, String> dataMap : dataList) {
                Map valueMap;
                Object valueObj;
                String valueStr = dataMap.get(fieldAliasKey);
                String value = "";
                if (HRStringUtils.isNotEmpty((String)valueStr) && (valueObj = (valueMap = (Map)SerializationUtils.fromJsonString((String)valueStr, Map.class)).get("value")) instanceof String) {
                    value = valueObj.toString();
                }
                values.add(value);
            }
            resultMap.put("value", values);
            String originFieldAlias = AnalyseObjectUtil.getOriginFieldAlias((String)fieldAliasKey);
            if (originFieldAlias.contains("!")) {
                originFieldAlias = originFieldAlias.split("!")[0];
            }
            if ((queryFieldBo = (QueryFieldBo)queryFieldBoMap.get(originFieldAlias)) != null) {
                HashMap originDataMap = Maps.newHashMapWithExpectedSize((int)16);
                originDataMap.put("valueType", queryFieldBo.getValueType());
                originDataMap.put("controlType", queryFieldBo.getControlType());
                originDataMap.put("data", queryFieldBo.getData());
                resultMap.put("originalData", originDataMap);
            }
            if ((groupField = (AnObjGroupField)anObjGroupFieldMap.get(originFieldAlias)) != null) {
                HashMap originDataMap = Maps.newHashMapWithExpectedSize((int)16);
                originDataMap.put("isGroupField", true);
                originDataMap.put("groupField", groupField);
                resultMap.put("originalData", originDataMap);
            }
            finalMap.put(fieldAliasKey, resultMap);
        }
        return finalMap;
    }

    @ExcludeFromJacocoGeneratedReport
    public boolean setJumpRuleSourceFieldDisplayName(List<ReportJumpConfigBo> reportJumpConfigList, ReportManageConfigInfo reportManageConfigInfo) {
        if (reportJumpConfigList == null || reportJumpConfigList.isEmpty()) {
            return false;
        }
        boolean hasNotExistReportId = false;
        List<QueryFieldBo> queryFields = reportManageConfigInfo.getAssignObj().getQueryFields();
        Map<String, QueryFieldBo> queryFieldMap = queryFields.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, field -> field));
        List targetReportIds = reportJumpConfigList.stream().map(config -> Long.valueOf(config.getJumpReportId())).collect(Collectors.toList());
        HRBaseServiceHelper reportHelper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObjectCollection reportDys = reportHelper.queryOriginalCollection("id, anobjid.id", new QFilter[]{new QFilter("id", "in", targetReportIds)});
        Map<Long, Long> existReportToAnObjIdMap = reportDys.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("anobjid.id")));
        long anObjId = Long.parseLong(reportManageConfigInfo.getAssignObj().getAnObj().getId());
        Iterator<ReportJumpConfigBo> iterator = reportJumpConfigList.iterator();
        while (iterator.hasNext()) {
            ReportJumpConfigBo reportJumpConfigBo = iterator.next();
            Long jumpReportId = Long.valueOf(reportJumpConfigBo.getJumpReportId());
            Long jumpReportAnObjId = existReportToAnObjIdMap.get(jumpReportId);
            if (jumpReportAnObjId == null || anObjId != jumpReportAnObjId) {
                iterator.remove();
                hasNotExistReportId = true;
                continue;
            }
            List jumpRuleEntry = reportJumpConfigBo.getJumpRuleEntry();
            for (ReportJumpConfigBo.ReportJumpRuleEntryBo reportJumpRuleEntryBo : jumpRuleEntry) {
                String targetField = reportJumpRuleEntryBo.getTargetField();
                String originTargetField = AnalyseObjectUtil.getOriginFieldAlias((String)targetField);
                QueryFieldBo queryFieldBo = queryFieldMap.get(originTargetField);
                if (!HRStringUtils.equals((String)reportJumpRuleEntryBo.getType(), (String)"value") || !HRStringUtils.isEmpty((String)reportJumpRuleEntryBo.getSourceFieldDisplayName()) || !AnalyseObjectUtil.isBaseDataType((String)queryFieldBo.getComplexType()) || !queryFieldBo.getFieldAlias().endsWith(".name") && !queryFieldBo.getFieldAlias().endsWith(".number")) continue;
                String dataId = reportJumpRuleEntryBo.getSourceField();
                String baseDataNum = queryFieldBo.getBaseDataNum();
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseDataNum);
                ArrayList idValues = Lists.newArrayListWithCapacity((int)10);
                if (dataId.contains(",")) {
                    String[] dataIds;
                    for (String id : dataIds = dataId.split(",")) {
                        Object idValue = this.getIdValue(id, dataEntityType);
                        idValues.add(idValue);
                    }
                } else {
                    Object idValue = this.getIdValue(dataId, dataEntityType);
                    idValues.add(idValue);
                }
                HRBaseServiceHelper helper = new HRBaseServiceHelper(baseDataNum);
                DynamicObject[] dys = helper.queryOriginalArray("name", new QFilter[]{new QFilter("id", "in", (Object)idValues)});
                StringBuilder nameSb = new StringBuilder();
                Arrays.stream(dys).map(dy -> dy.getString("name")).forEach(name -> nameSb.append((String)name).append(','));
                if (nameSb.length() <= 0) continue;
                reportJumpRuleEntryBo.setSourceFieldDisplayName(nameSb.substring(0, nameSb.length() - 1));
            }
        }
        return hasNotExistReportId;
    }

    private Object getIdValue(String id, MainEntityType dataEntityType) {
        Class propertyType = dataEntityType.getPrimaryKey().getPropertyType();
        Object idVal = id;
        if (propertyType == Long.class || propertyType == Long.TYPE) {
            idVal = Long.valueOf(id);
        }
        return idVal;
    }

    public Object transferValue(String value, String valueType, String controlType, List<Map<String, Object>> enumList) {
        if (HRStringUtils.equals((String)controlType, (String)FieldControlType.COMBO.getValue()) || HRStringUtils.equals((String)controlType, (String)FieldControlType.MUL_COMBO.getValue()) || HRStringUtils.equals((String)controlType, (String)FieldControlType.CHECKBOX.getValue())) {
            String currentLang = RequestContext.get().getLang().name();
            Optional<Map> enumItemOp = enumList.stream().filter(enumItem -> {
                Map map = (Map)enumItem.get("name");
                Optional<Map.Entry> any = map.entrySet().stream().filter(entry -> HRStringUtils.equals((String)currentLang, (String)((String)entry.getKey()))).findAny();
                return any.filter(stringStringEntry -> HRStringUtils.equals((String)((String)stringStringEntry.getValue()), (String)value)).isPresent();
            }).findAny();
            if (enumItemOp.isPresent()) {
                return enumItemOp.get().get("value");
            }
            return value;
        }
        DataTypeEnum valueTypeEnum = DataTypeEnum.of((String)valueType);
        switch (valueTypeEnum) {
            case INTEGER: {
                if (HRStringUtils.isNotEmpty((String)value)) {
                    return Integer.valueOf(value);
                }
                return null;
            }
            case LONG: {
                if (HRStringUtils.isNotEmpty((String)value)) {
                    return Long.valueOf(value);
                }
                return null;
            }
            case STRING: 
            case LOCALESTRING: {
                return value;
            }
            case DATETIME: {
                if (HRStringUtils.isNotEmpty((String)value)) {
                    try {
                        return HRDateTimeUtils.parseDate((String)value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
            case BOOLEAN: {
                if (HRStringUtils.isNotEmpty((String)value)) {
                    return Boolean.valueOf(value);
                }
                return null;
            }
        }
        return value;
    }

    private void transferValueQFilter(List<QFilter> qFilters, List<QueryFieldBo> queryFields, List<AnObjGroupField> anObjGroupFields, String targetField, String sourceField) {
        Optional<AnObjGroupField> anObjGroupFieldOp;
        String originTargetField = AnalyseObjectUtil.getOriginFieldAlias((String)targetField);
        Optional<QueryFieldBo> sourceFieldOp = queryFields.stream().filter(field -> HRStringUtils.equals((String)originTargetField, (String)field.getFieldAlias())).findAny();
        if (sourceFieldOp.isPresent()) {
            QueryFieldBo sourceFieldBo = sourceFieldOp.get();
            if (HRStringUtils.equals((String)sourceFieldBo.getValueType(), (String)DataTypeEnum.DATETIME.getDataTypeKey())) {
                String[] dateValSp = sourceField.split(",");
                try {
                    Date startDate = HRDateTimeUtils.parseDate((String)dateValSp[0]);
                    Date endDate = HRDateTimeUtils.parseDate((String)dateValSp[1]);
                    qFilters.add(new QFilter(originTargetField, ">=", (Object)startDate).and(targetField, "<=", (Object)endDate));
                    return;
                }
                catch (Exception exception) {
                    LOGGER.error((Throwable)exception);
                }
            } else {
                if (AnalyseObjectUtil.isBaseDataType((String)sourceFieldBo.getComplexType()) && (sourceFieldBo.getFieldAlias().endsWith(".name") || sourceFieldBo.getFieldAlias().endsWith(".number"))) {
                    String baseDataNum = sourceFieldBo.getBaseDataNum();
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseDataNum);
                    ArrayList idValues = Lists.newArrayListWithCapacity((int)10);
                    if (sourceField.contains(",")) {
                        String[] dataIds;
                        for (String id : dataIds = sourceField.split(",")) {
                            Object idValue = this.getIdValue(id, dataEntityType);
                            idValues.add(idValue);
                        }
                    } else {
                        Object idValue = this.getIdValue(sourceField, dataEntityType);
                        idValues.add(idValue);
                    }
                    String idFieldAlias = originTargetField.substring(0, originTargetField.lastIndexOf(".")) + ".id";
                    qFilters.add(new QFilter(idFieldAlias, "in", (Object)idValues));
                    return;
                }
                qFilters.add(new QFilter(targetField, "=", (Object)sourceField));
                return;
            }
        }
        if ((anObjGroupFieldOp = anObjGroupFields.stream().filter(field -> HRStringUtils.equals((String)originTargetField, (String)field.getNumber())).findAny()).isPresent()) {
            QFilter groupFieldQFilter = AnObjGroupFieldService.getInstance().getGroupFieldQFilter(sourceField, anObjGroupFieldOp.get());
            qFilters.add(groupFieldQFilter);
        }
    }

    public List<Map<String, Object>> queryReportsByAnObjId(long anObjId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject[] reportDys = helper.query("id, number, name", new QFilter[]{new QFilter("anobjid", "=", (Object)anObjId)});
        ArrayList result = Lists.newArrayListWithExpectedSize((int)reportDys.length);
        for (DynamicObject reportDy : reportDys) {
            HashMap reportMap = Maps.newHashMapWithExpectedSize((int)3);
            reportMap.put("id", reportDy.getString("id"));
            reportMap.put("number", reportDy.getString("number"));
            reportMap.put("name", reportDy.getLocaleString("name"));
            result.add(reportMap);
        }
        return result;
    }

    @ExcludeFromJacocoGeneratedReport
    public List<ReportJumpConfigBo> queryReportJumpConfig(long workRptId) {
        DynamicObject[] reportJumpConfigDys = this.jumpConfigHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("workrpt", "=", (Object)workRptId)});
        List<Object> reportJumpConfigBos = Lists.newArrayListWithExpectedSize((int)reportJumpConfigDys.length);
        for (DynamicObject reportJumpConfigDy : reportJumpConfigDys) {
            ReportJumpConfigBo reportJumpConfigBo = new ReportJumpConfigBo();
            reportJumpConfigBo.setId(reportJumpConfigDy.getString("id"));
            reportJumpConfigBo.setReportId(reportJumpConfigDy.getDynamicObject("report").getString("id"));
            reportJumpConfigBo.setCarryFilter(reportJumpConfigDy.getBoolean("carryfilter"));
            reportJumpConfigBo.setRuleGroup(reportJumpConfigDy.getString("rulegroup"));
            reportJumpConfigBo.setIndex(reportJumpConfigDy.getInt("index"));
            DynamicObject jumpReportDy = reportJumpConfigDy.getDynamicObject("jumpreport");
            if (jumpReportDy != null) {
                reportJumpConfigBo.setJumpReportId(reportJumpConfigDy.getDynamicObject("jumpreport").getString("id"));
            } else {
                reportJumpConfigBo.setJumpReportId("0");
            }
            DynamicObjectCollection jumpRuleCol = reportJumpConfigDy.getDynamicObjectCollection("jumpruleentry");
            ArrayList jumpRuleEntry = Lists.newArrayListWithExpectedSize((int)jumpRuleCol.size());
            for (DynamicObject jumpRuleDy : jumpRuleCol) {
                ReportJumpConfigBo.ReportJumpRuleEntryBo jumpRuleEntryBo = new ReportJumpConfigBo.ReportJumpRuleEntryBo();
                jumpRuleEntryBo.setId(jumpRuleDy.getString("id"));
                jumpRuleEntryBo.setType(jumpRuleDy.getString("type"));
                jumpRuleEntryBo.setSourceField(jumpRuleDy.getString("sourcefield"));
                jumpRuleEntryBo.setTargetField(jumpRuleDy.getString("targetfield"));
                jumpRuleEntry.add(jumpRuleEntryBo);
            }
            reportJumpConfigBo.setJumpRuleEntry((List)jumpRuleEntry);
            reportJumpConfigBos.add(reportJumpConfigBo);
        }
        reportJumpConfigBos = reportJumpConfigBos.stream().sorted(Comparator.comparing(ReportJumpConfigBo::getIndex)).collect(Collectors.toList());
        return reportJumpConfigBos;
    }

    public void saveReportJumpConfig(long reportId, long workRptId, List<ReportJumpConfigBo> reportJumpConfigBos) {
        this.jumpConfigHelper.deleteByFilter(new QFilter[]{new QFilter("workrpt", "=", (Object)workRptId)});
        if (reportJumpConfigBos == null || reportJumpConfigBos.isEmpty()) {
            return;
        }
        int index = 1;
        DynamicObjectCollection addCol = new DynamicObjectCollection();
        for (ReportJumpConfigBo reportJumpConfigBo : reportJumpConfigBos) {
            DynamicObject newDy = this.jumpConfigHelper.generateEmptyDynamicObject();
            newDy.set("report", (Object)reportId);
            newDy.set("workrpt", (Object)workRptId);
            this.setJumpConfigValue(newDy, index++, reportJumpConfigBo);
            addCol.add((Object)newDy);
        }
        this.jumpConfigHelper.save(addCol);
    }

    @ExcludeFromJacocoGeneratedReport
    private void setJumpConfigValue(DynamicObject dy, int index, ReportJumpConfigBo reportJumpConfigBo) {
        dy.set("index", (Object)index);
        dy.set("rulegroup", (Object)reportJumpConfigBo.getRuleGroup());
        dy.set("jumpreport", (Object)Long.valueOf(reportJumpConfigBo.getJumpReportId()));
        dy.set("carryfilter", (Object)reportJumpConfigBo.getCarryFilter());
        DynamicObjectCollection newJumpRuleCol = this.jumpConfigHelper.generateEmptyEntryCollection(dy, "jumpruleentry");
        for (ReportJumpConfigBo.ReportJumpRuleEntryBo reportJumpRuleEntryBo : reportJumpConfigBo.getJumpRuleEntry()) {
            DynamicObject newJumpRuleDy = this.jumpConfigHelper.generateEmptyEntryDynamicObject("jumpruleentry");
            newJumpRuleDy.set("type", (Object)reportJumpRuleEntryBo.getType());
            newJumpRuleDy.set("sourcefield", (Object)reportJumpRuleEntryBo.getSourceField());
            newJumpRuleDy.set("targetfield", (Object)reportJumpRuleEntryBo.getTargetField());
            newJumpRuleCol.add((Object)newJumpRuleDy);
        }
        dy.set("jumpruleentry", (Object)newJumpRuleCol);
    }
}

