/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repdesign.util;

import java.text.ParseException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import kd.bos.ext.hr.util.query.DateTimeUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.complexobj.TimeZoneInfo;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.common.DateTimeFieldTimeZoneUtil;

public class SchemeFilterDateUtils {
    private static final Log LOGGER = LogFactory.getLog(SchemeFilterDateUtils.class);

    public static void getDateByYear(Date[] dates, String str, TimeZoneInfo timeZoneInfo) {
        Calendar startCal = Calendar.getInstance();
        SchemeFilterDateUtils.setTime(startCal, 1, Integer.parseInt(str), 2, 0, 5, 1, 11, 0);
        startCal.set(12, 0);
        startCal.set(13, 0);
        startCal.set(14, 0);
        dates[0] = startCal.getTime();
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(dates[0]);
        SchemeFilterDateUtils.setTime(endCal, 11, 23, 12, 59, 13, 59, 14, 999);
        dates[1] = DateTimeUtils.addDay((Date)DateTimeUtils.addYear((Date)endCal.getTime(), (int)1), (long)-1L);
        SchemeFilterDateUtils.dateFormat(dates, timeZoneInfo);
    }

    public static void getDateByQuarter(Date[] dates, String str, TimeZoneInfo timeZoneInfo) {
        Calendar cal = Calendar.getInstance();
        SchemeFilterDateUtils.setTime(cal, 11, 0, 12, 0, 13, 0, 14, 0);
        cal.set(5, 1);
        String[] split = str.split("-");
        String year = split[0];
        String quarter = split[1];
        cal.set(1, Integer.parseInt(year));
        switch (quarter) {
            case "Q1": {
                cal.set(2, 0);
                break;
            }
            case "Q2": {
                cal.set(2, 3);
                break;
            }
            case "Q3": {
                cal.set(2, 6);
                break;
            }
            case "Q4": {
                cal.set(2, 9);
                break;
            }
        }
        dates[0] = cal.getTime();
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(dates[0]);
        SchemeFilterDateUtils.setTime(endCal, 11, 23, 12, 59, 13, 59, 14, 999);
        dates[1] = DateTimeUtils.addDay((Date)DateTimeUtils.addMonth((Date)endCal.getTime(), (int)3), (long)-1L);
        SchemeFilterDateUtils.dateFormat(dates, timeZoneInfo);
    }

    public static void getDateByMonth(Date[] dates, String str, TimeZoneInfo timeZoneInfo) {
        String[] split = str.split("-");
        String year = split[0];
        String month = split[1];
        Calendar cal = Calendar.getInstance();
        SchemeFilterDateUtils.setTime(cal, 1, Integer.parseInt(year), 2, Integer.parseInt(month) - 1, 5, 1, 11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        dates[0] = cal.getTime();
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(dates[0]);
        SchemeFilterDateUtils.setTime(endCal, 11, 23, 12, 59, 13, 59, 14, 999);
        dates[1] = DateTimeUtils.addDay((Date)DateTimeUtils.addMonth((Date)endCal.getTime(), (int)1), (long)-1L);
        SchemeFilterDateUtils.dateFormat(dates, timeZoneInfo);
    }

    public static void setTime(Calendar endCal, int hourOfDay, int i1, int minute, int i2, int second, int i3, int millisecond, int i4) {
        endCal.set(hourOfDay, i1);
        endCal.set(minute, i2);
        endCal.set(second, i3);
        endCal.set(millisecond, i4);
    }

    public static void getDateByScope(Date[] dates, List<String> str, TimeZoneInfo timeZoneInfo) {
        try {
            Date date;
            try {
                dates[0] = DateTimeUtils.parseDate((String)str.get(0), (String)"yyyy-MM-dd");
                date = DateTimeUtils.parseDate((String)str.get(1), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                String format = DateTimeFieldTimeZoneUtil.getUserDateFormat();
                dates[0] = DateTimeUtils.parseDate((String)str.get(0), (String)format);
                date = DateTimeUtils.parseDate((String)str.get(1), (String)format);
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            SchemeFilterDateUtils.setTime(cal, 11, 23, 12, 59, 13, 59, 14, 999);
            dates[1] = cal.getTime();
            SchemeFilterDateUtils.dateFormat(dates, timeZoneInfo);
        }
        catch (ParseException e) {
            LOGGER.error((Throwable)e);
        }
    }

    public static void getDateByValue(Date value, Date[] dates, TimeZoneInfo timeZoneInfo) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(value);
        SchemeFilterDateUtils.setTime(startCal, 11, 0, 12, 0, 13, 0, 14, 0);
        dates[0] = startCal.getTime();
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(value);
        SchemeFilterDateUtils.setTime(endCal, 11, 23, 12, 59, 13, 59, 14, 999);
        dates[1] = endCal.getTime();
        SchemeFilterDateUtils.dateFormat(dates, timeZoneInfo);
    }

    private static void dateFormat(Date[] dates, TimeZoneInfo timeZoneInfo) {
        try {
            if (null != timeZoneInfo && 1 == timeZoneInfo.getTimeZoneTransType()) {
                String format = DateTimeFieldTimeZoneUtil.getUserDateTimeFormat();
                TimeZone timeZone = TimeZone.getTimeZone(timeZoneInfo.getTimeZone());
                dates[0] = DateTimeUtils.parseDate((String)DateTimeUtils.format((Date)dates[0], (String)format), (String)format, (TimeZone)timeZone);
                dates[1] = DateTimeUtils.parseDate((String)DateTimeUtils.format((Date)dates[1], (String)format), (String)format, (TimeZone)timeZone);
            }
        }
        catch (ParseException e) {
            LOGGER.error((Throwable)e);
        }
    }

    public static void getDateByQuarter(Date[] dates, TimeZoneInfo timeZoneInfo) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(new Date());
        int quarter = instance.get(2) / 3 + 1;
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, 1);
        switch (quarter) {
            case 1: {
                calendar.set(2, 0);
                break;
            }
            case 2: {
                calendar.set(2, 3);
                break;
            }
            case 3: {
                calendar.set(2, 6);
                break;
            }
            case 4: {
                calendar.set(2, 9);
                break;
            }
        }
        dates[0] = calendar.getTime();
        dates[1] = DateTimeUtils.addMonth((Date)dates[0], (int)3);
        SchemeFilterDateUtils.dateFormat(dates, timeZoneInfo);
    }

    public static void getDateByYear2Today(Date[] dates, TimeZoneInfo timeZoneInfo) {
        Calendar startCal = Calendar.getInstance();
        SchemeFilterDateUtils.setTime(startCal, 1, Integer.parseInt(HRDateTimeUtils.format((Date)new Date(), (String)"yyyy")), 2, 0, 5, 1, 11, 0);
        startCal.set(12, 0);
        startCal.set(13, 0);
        startCal.set(14, 0);
        dates[0] = startCal.getTime();
        Calendar instance = Calendar.getInstance();
        instance.setTime(new Date());
        SchemeFilterDateUtils.setTime(instance, 11, 23, 12, 59, 13, 59, 14, 999);
        dates[1] = instance.getTime();
        SchemeFilterDateUtils.dateFormat(dates, timeZoneInfo);
    }

    public static void getDateByWeek(Date[] dates, TimeZoneInfo timeZoneInfo) {
        LocalDate today = LocalDate.now();
        LocalDate monday = today.with(DayOfWeek.MONDAY);
        LocalDate sunday = today.with(DayOfWeek.SUNDAY);
        dates[0] = Date.from(monday.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        dates[1] = HRDateTimeUtils.addDay((Date)Date.from(sunday.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()), (long)1L);
        SchemeFilterDateUtils.dateFormat(dates, timeZoneInfo);
    }

    public static void getDateByMonth(Date[] dates, TimeZoneInfo timeZoneInfo) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, 1);
        dates[0] = calendar.getTime();
        calendar.add(2, 1);
        calendar.set(5, 0);
        dates[1] = calendar.getTime();
        SchemeFilterDateUtils.dateFormat(dates, timeZoneInfo);
    }

    public static boolean equalOrNotDate(String value, String fieldAlias, String secondDateType, Date[] dates, TimeZoneInfo timeZoneInfo) throws ParseException {
        if (HRStringUtils.isEmpty((String)value)) {
            return true;
        }
        if (fieldAlias.endsWith(SplitDateTypeEnum.FN_YEAR_MONTH.getKey()) || fieldAlias.endsWith(SplitDateTypeEnum.SN_YEAR_MONTH.getKey()) || HRStringUtils.equals((String)secondDateType, (String)"month")) {
            SchemeFilterDateUtils.getDateByMonth(dates, value, timeZoneInfo);
        } else if (fieldAlias.endsWith(SplitDateTypeEnum.FN_YEAR_QUARTER.getKey()) || fieldAlias.endsWith(SplitDateTypeEnum.SN_YEAR_QUARTER.getKey()) || HRStringUtils.equals((String)secondDateType, (String)"quarter")) {
            SchemeFilterDateUtils.getDateByQuarter(dates, value, timeZoneInfo);
        } else if (fieldAlias.endsWith(SplitDateTypeEnum.FN_YEAR.getKey()) || fieldAlias.endsWith(SplitDateTypeEnum.SN_YEAR.getKey()) || HRStringUtils.equals((String)secondDateType, (String)"year")) {
            SchemeFilterDateUtils.getDateByYear(dates, value, timeZoneInfo);
        } else {
            SchemeFilterDateUtils.getDateByValue(HRDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd"), dates, timeZoneInfo);
        }
        return false;
    }

    public static void getDateByScope(Date[] dates, String fieldAlias, List<String> str, TimeZoneInfo timeZoneInfo) {
        try {
            if (fieldAlias.endsWith(SplitDateTypeEnum.FN_YEAR_MONTH.getKey()) || fieldAlias.endsWith(SplitDateTypeEnum.SN_YEAR_MONTH.getKey())) {
                Date[] dates1 = new Date[2];
                SchemeFilterDateUtils.getDateByMonth(dates1, str.get(0), timeZoneInfo);
                dates[0] = dates1[0];
                Date[] dates2 = new Date[2];
                SchemeFilterDateUtils.getDateByMonth(dates2, str.get(1), timeZoneInfo);
                dates[1] = dates2[1];
            } else if (fieldAlias.endsWith(SplitDateTypeEnum.FN_YEAR_QUARTER.getKey()) || fieldAlias.endsWith(SplitDateTypeEnum.SN_YEAR_QUARTER.getKey())) {
                Date[] dates1 = new Date[2];
                SchemeFilterDateUtils.getDateByQuarter(dates1, str.get(0), timeZoneInfo);
                dates[0] = dates1[0];
                Date[] dates2 = new Date[2];
                SchemeFilterDateUtils.getDateByQuarter(dates2, str.get(1), timeZoneInfo);
                dates[1] = dates2[1];
            } else if (fieldAlias.endsWith(SplitDateTypeEnum.FN_YEAR.getKey()) || fieldAlias.endsWith(SplitDateTypeEnum.SN_YEAR.getKey())) {
                dates[0] = DateTimeUtils.parseDate((String)str.get(0), (String)"yyyy");
                dates[1] = HRDateTimeUtils.addYear((Date)DateTimeUtils.parseDate((String)str.get(1), (String)"yyyy"), (int)1);
            } else {
                dates[0] = DateTimeUtils.parseDate((String)str.get(0), (String)"yyyy-MM-dd");
                Date date = DateTimeUtils.parseDate((String)str.get(1), (String)"yyyy-MM-dd");
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                SchemeFilterDateUtils.setTime(cal, 11, 23, 12, 59, 13, 59, 14, 999);
                dates[1] = cal.getTime();
            }
        }
        catch (ParseException e) {
            LOGGER.error((Throwable)e);
        }
    }
}

