/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.swc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.virtulentity.VirtualFieldInfo;
import kd.hr.hrptmc.common.constant.swc.SalaryRptItemTypeEnum;

public class SalaryCalResultRptEntityResolveService {
    private List<String> calPersonFields = new ArrayList<String>(10);
    private Map<String, List<String>> itemUniqueCodeMap = new HashMap<String, List<String>>(16);
    private Map<String, List<Long>> itemMap = new HashMap<String, List<Long>>(16);
    private Map<String, DataType> dataTypeMap = new HashMap<String, DataType>(16);
    private Map<String, String> itemDataTypeMap = new HashMap<String, String>(16);
    private Map<String, String> itemCodeMap = new HashMap<String, String>(16);
    private List<String> noItemDataCodeList = new ArrayList<String>(10);

    public SalaryCalResultRptEntityResolveService(List<VirtualFieldInfo> virtualFieldList) {
        this.initFieldInfo(virtualFieldList);
        for (Map.Entry<String, List<String>> itemUniqueData : this.itemUniqueCodeMap.entrySet()) {
            this.setItemData(itemUniqueData.getKey(), itemUniqueData.getValue());
        }
    }

    private void setItemData(String code, List<String> itemUniqueCodes) {
        SalaryRptItemTypeEnum itemTypeEnum = SalaryRptItemTypeEnum.getEnumByCode((String)code);
        if (itemUniqueCodes.isEmpty()) {
            return;
        }
        HRBaseServiceHelper itemSlHelper = new HRBaseServiceHelper(itemTypeEnum.getEntityCode());
        QFilter qFilter = new QFilter("uniquecode", "in", itemUniqueCodes);
        DynamicObject[] itemDys = itemSlHelper.query("id,uniquecode,datatype.showtype,datatype.storagetype", qFilter.toArray());
        ArrayList<Long> ids = new ArrayList<Long>(itemUniqueCodes.size());
        HashSet<String> existsUniqueCodes = new HashSet<String>(10);
        for (DynamicObject item : itemDys) {
            ids.add(item.getLong("id"));
            String key = itemTypeEnum.getCode() + "_" + item.getLong("id");
            String storageType = item.getString("datatype.storagetype");
            String showType = item.getString("datatype.showtype");
            String uniqueCode = item.getString("uniquecode");
            existsUniqueCodes.add(uniqueCode);
            this.dataTypeMap.put(key, this.getDataType(showType));
            this.itemDataTypeMap.put(key, storageType);
            this.itemCodeMap.put(uniqueCode, key);
        }
        HashSet<String> tmpUniqueCodes = new HashSet<String>(itemUniqueCodes);
        tmpUniqueCodes.removeAll(existsUniqueCodes);
        this.noItemDataCodeList.addAll(tmpUniqueCodes);
        if (ids.size() > 0) {
            this.itemMap.put(itemTypeEnum.getCode(), ids);
        }
    }

    private DataType getDataType(String showtype) {
        StringType value;
        switch (showtype) {
            case "text": {
                value = DataType.StringType;
                break;
            }
            case "num": {
                value = DataType.BigDecimalType;
                break;
            }
            case "int": {
                value = DataType.IntegerType;
                break;
            }
            case "amount": {
                value = DataType.BigDecimalType;
                break;
            }
            case "date": {
                value = DataType.DateType;
                break;
            }
            case "bool": {
                value = DataType.BooleanType;
                break;
            }
            default: {
                value = DataType.StringType;
            }
        }
        return value;
    }

    private void initFieldInfo(List<VirtualFieldInfo> selectedFieldInfoList) {
        for (VirtualFieldInfo fieldInfo : selectedFieldInfoList) {
            String fieldNumber = fieldInfo.getNumber();
            if (StringUtils.isEmpty((CharSequence)fieldNumber)) continue;
            if (fieldNumber.startsWith(SalaryRptItemTypeEnum.ITEMSL.getUniqueCodePrefix())) {
                this.addItemUniqueCodes(fieldNumber, SalaryRptItemTypeEnum.ITEMSL);
                continue;
            }
            if (fieldNumber.startsWith(SalaryRptItemTypeEnum.ITEMFT.getUniqueCodePrefix())) {
                this.addItemUniqueCodes(fieldNumber, SalaryRptItemTypeEnum.ITEMFT);
                continue;
            }
            if (fieldNumber.startsWith(SalaryRptItemTypeEnum.ITEMSP.getUniqueCodePrefix())) {
                this.addItemUniqueCodes(fieldNumber, SalaryRptItemTypeEnum.ITEMSP);
                continue;
            }
            if (fieldNumber.startsWith(SalaryRptItemTypeEnum.ITEMBS.getUniqueCodePrefix())) {
                this.addItemUniqueCodes(fieldNumber, SalaryRptItemTypeEnum.ITEMBS);
                continue;
            }
            this.calPersonFields.add(fieldNumber);
        }
    }

    private void addItemUniqueCodes(String fieldNumber, SalaryRptItemTypeEnum itemTypeEnum) {
        List<String> uniqueCodes = this.itemUniqueCodeMap.get(itemTypeEnum.getCode());
        if (uniqueCodes == null) {
            uniqueCodes = new ArrayList<String>();
            this.itemUniqueCodeMap.put(itemTypeEnum.getCode(), uniqueCodes);
        }
        uniqueCodes.add(fieldNumber);
    }

    public List<String> getCalPersonFields() {
        return this.calPersonFields;
    }

    public void setCalPersonFields(List<String> calPersonFields) {
        this.calPersonFields = calPersonFields;
    }

    public Map<String, List<Long>> getItemMap() {
        return this.itemMap;
    }

    public void setItemMap(Map<String, List<Long>> itemMap) {
        this.itemMap = itemMap;
    }

    public Map<String, DataType> getDataTypeMap() {
        return this.dataTypeMap;
    }

    public void setDataTypeMap(Map<String, DataType> dataTypeMap) {
        this.dataTypeMap = dataTypeMap;
    }

    public Map<String, String> getItemDataTypeMap() {
        return this.itemDataTypeMap;
    }

    public void setItemDataTypeMap(Map<String, String> itemDataTypeMap) {
        this.itemDataTypeMap = itemDataTypeMap;
    }

    public Map<String, String> getItemCodeMap() {
        return this.itemCodeMap;
    }

    public void setItemCodeMap(Map<String, String> itemCodeMap) {
        this.itemCodeMap = itemCodeMap;
    }

    public List<String> getNoItemDataCodeList() {
        return this.noItemDataCodeList;
    }

    public void setNoItemDataCodeList(List<String> noItemDataCodeList) {
        this.noItemDataCodeList = noItemDataCodeList;
    }
}

