/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.swc;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.HashJoinDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.hr.hrptmc.common.constant.swc.SalaryRptItemTypeEnum;
import org.apache.commons.lang3.ArrayUtils;

public class SalaryCalResultRptQueryHelper {
    private static final String HSAS_SALARYDETAILRPTQUERY = "hsas_salarydetailrptquery";
    public static final String SPLIT_CODE = "_";

    public DataSet buildDetailDataSet(QFilter[] qFilters, String orderBys, int start, int limit, List<String> calPersonFields, Map<String, List<Long>> itemMap, Map<String, DataType> dataTypeMap, Map<String, String> itemDataTypeMap) {
        QueryEntityType queryEntityType = this.getQueryEntityType();
        List<Long> pkList = this.getCalPersonIds(queryEntityType, qFilters, orderBys, start, limit);
        return this.buildDetailDataSet(queryEntityType, pkList, calPersonFields, itemMap, dataTypeMap, itemDataTypeMap);
    }

    public QueryEntityType getQueryEntityType() {
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)HSAS_SALARYDETAILRPTQUERY);
        return queryEntityType;
    }

    public List<Long> getCalPersonIds(QFilter[] qFilters, String orderBys, int start, int limit) {
        return this.getCalPersonIds(this.getQueryEntityType(), qFilters, orderBys, start, limit);
    }

    public List<Long> getCalPersonIds(QueryEntityType queryEntityType, QFilter[] qFilters, String orderBys, int start, int limit) {
        List pkObjList = HRQueryEntityHelper.getInstance().queryAllPkByKSql(this.getQueryEntityType(), qFilters, orderBys, start, limit);
        List<Object> pkList = Lists.newArrayListWithExpectedSize((int)16);
        if (pkObjList != null) {
            pkList = pkObjList.stream().map(obj -> Long.parseLong(obj.toString())).collect(Collectors.toList());
        }
        return pkList;
    }

    public DataSet buildDetailDataSet(String queryEntityCode, List<Long> ids, List<String> calPersonFields, Map<String, List<Long>> itemMap, Map<String, DataType> dataTypeMap, Map<String, String> itemDataTypeMap) {
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)queryEntityCode);
        ArrayList<Long> pkList = new ArrayList<Long>(ids);
        return this.buildDetailDataSet(queryEntityType, pkList, calPersonFields, itemMap, dataTypeMap, itemDataTypeMap);
    }

    public DataSet buildDetailDataSet(QueryEntityType queryEntityType, List<Long> pkList, List<String> calPersonFields, Map<String, List<Long>> itemMap, Map<String, DataType> dataTypeMap, Map<String, String> itemDataTypeMap) {
        if (!calPersonFields.contains("id")) {
            calPersonFields.add("id");
        }
        String selectProperties = String.join((CharSequence)",", calPersonFields);
        QFilter qFilter = new QFilter("id", "in", pkList);
        DataSet dataSet = HRQueryEntityHelper.getInstance().getQueryDataSet(queryEntityType, selectProperties, new QFilter[]{qFilter}, "");
        if (dataSet == null) {
            return null;
        }
        if (itemMap == null || itemMap.size() == 0) {
            return dataSet;
        }
        HashJoinDataSet hashJoinDataSet = null;
        for (Map.Entry<String, List<Long>> itemEntry : itemMap.entrySet()) {
            DataSet entryDataSet = this.buildEntryData(itemEntry.getKey(), itemEntry.getValue(), pkList, dataTypeMap, itemDataTypeMap);
            Object[] fieldNames = entryDataSet.getRowMeta().getFieldNames();
            fieldNames = (String[])ArrayUtils.remove((Object[])fieldNames, (int)0);
            if (hashJoinDataSet == null) {
                hashJoinDataSet = dataSet.hashJoin(entryDataSet.toHashTable("calpersonid"), "id", (String[])fieldNames, true);
                continue;
            }
            hashJoinDataSet = hashJoinDataSet.addHashTable(entryDataSet.toHashTable("calpersonid"), "id", (String[])fieldNames, true);
        }
        if (hashJoinDataSet != null) {
            return hashJoinDataSet.selectLeftFields(dataSet.getRowMeta().getFieldNames()).finish();
        }
        return dataSet;
    }

    public DataSet buildDetailDataSet(QueryEntityType queryEntityType, List<Long> pkList, List<String> calPersonFields) {
        return this.buildDetailDataSet(queryEntityType, pkList, calPersonFields, null, null, null);
    }

    private DataSet buildEntryData(String itemKey, List<Long> itemIds, Collection pkList, Map<String, DataType> dataTypeMap, Map<String, String> itemDataTypeMap) {
        SalaryRptItemTypeEnum itemEnum = SalaryRptItemTypeEnum.getEnumByCode((String)itemKey);
        QFilter entryFilter = new QFilter(itemEnum.getWholeItemFieldCode(), "in", itemIds);
        QFilter calPersonFilter = new QFilter("calpersonid", "in", (Object)pkList);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hsas_caltable");
        DataSet dataSet = helper.queryDataSet("QueryServiceHelper.hsas_caltable", itemEnum.getSelectProperties(), new QFilter[]{calPersonFilter, entryFilter});
        return this.transferEntry(itemEnum, dataSet, itemIds, dataTypeMap, itemDataTypeMap);
    }

    private DataSet transferEntry(SalaryRptItemTypeEnum itemEnum, DataSet dataSet, List<Long> itemIds, Map<String, DataType> dataTypeMap, Map<String, String> itemDataTypeMap) {
        RowMeta rowMeta = this.buildEntryRowMeta(itemEnum, itemIds, dataTypeMap);
        Collection<Object[]> coll = this.buildEntryDataColl(itemEnum, dataSet, itemIds, itemDataTypeMap, rowMeta);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        DataSet resultDataSet = Algo.create((String)this.getClass().getName()).createDataSet(new Input[]{inputs});
        return resultDataSet;
    }

    private RowMeta buildEntryRowMeta(SalaryRptItemTypeEnum itemEnum, List<Long> itemIds, Map<String, DataType> dataTypeMap) {
        ArrayList columnKeys = Lists.newArrayListWithCapacity((int)itemIds.size());
        ArrayList columnTypes = Lists.newArrayListWithCapacity((int)itemIds.size());
        columnKeys.add("calpersonid");
        columnTypes.add(DataType.LongType);
        for (Long salaryItemId : itemIds) {
            String columnKey = itemEnum.getCode() + SPLIT_CODE + salaryItemId;
            columnKeys.add(columnKey);
            DataType dataType = dataTypeMap.get(columnKey);
            columnTypes.add(dataType);
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])columnKeys.toArray(new String[0]), (DataType[])columnTypes.toArray(new DataType[0]));
        return rowMeta;
    }

    private Collection<Object[]> buildEntryDataColl(SalaryRptItemTypeEnum itemEnum, DataSet dataSet, List<Long> itemIds, Map<String, String> itemDataTypeMap, RowMeta rowMeta) {
        ArrayList coll = Lists.newArrayListWithCapacity((int)16);
        HashMap map = new HashMap(16);
        for (Row tmpRow : dataSet) {
            HashMap<String, Object> rowMap = null;
            Long tmpRowId = tmpRow.getLong("calpersonid");
            if (map.get(tmpRowId) != null) {
                rowMap = (HashMap<String, Object>)map.get(tmpRowId);
            } else {
                rowMap = new HashMap<String, Object>(16);
                map.put(tmpRowId, rowMap);
            }
            String salaryItemId = tmpRow.getString(itemEnum.getWholeItemFieldCode());
            String columnKey = itemEnum.getCode() + SPLIT_CODE + salaryItemId;
            rowMap.put(columnKey, tmpRow.get(itemEnum.getWholeValueFieldCode(itemDataTypeMap.get(columnKey))));
        }
        for (Map.Entry rowEntry : map.entrySet()) {
            Long calPersonId = (Long)rowEntry.getKey();
            Map dataMap = (Map)rowEntry.getValue();
            Object[] obj = new Object[rowMeta.getFieldCount()];
            obj[0] = calPersonId;
            int index = 1;
            for (Long salaryItemId : itemIds) {
                String columnKey = itemEnum.getCode() + SPLIT_CODE + salaryItemId;
                String itemDataTypeStr = itemDataTypeMap.get(columnKey);
                obj[index] = "num".equals(itemDataTypeStr) || "amount".equals(itemDataTypeStr) ? (dataMap.get(columnKey) != null ? dataMap.get(columnKey) : BigDecimal.ZERO) : dataMap.get(columnKey);
                ++index;
            }
            coll.add(obj);
        }
        return coll;
    }

    public Long getTotalCount(QFilter[] qFilters) {
        List list = HRQueryEntityHelper.getInstance().queryAllPkByKSql(this.getQueryEntityType(), qFilters, null);
        if (list != null) {
            return list.size();
        }
        return 0L;
    }
}

