/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.swc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.property.AddressProp;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.property.UserProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.entity.property.HisModelBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.model.OrderField;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.virtulentity.IVirtualEntityService;
import kd.hr.hbp.business.virtulentity.VirtualConfigInfo;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.virtulentity.SummaryQueryResultInfo;
import kd.hr.hbp.common.model.virtulentity.TotalRowValueInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualEntityQueryParamInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualFieldInfo;
import kd.hr.hbp.common.model.virtulentity.dimvalue.BaseDataDimensionValueInfo;
import kd.hr.hbp.common.model.virtulentity.dimvalue.DimensionValueInfo;
import kd.hr.hrptmc.business.swc.SalaryCalResultRptEntityResolveService;
import kd.hr.hrptmc.business.swc.SalaryCalResultRptQueryHelper;
import kd.hr.hrptmc.common.constant.swc.SalaryRptItemTypeEnum;
import org.jetbrains.annotations.NotNull;

public class SalaryCalResultRptServiceImpl
implements IVirtualEntityService {
    int dataLimit = 1000;
    int batchLimit = 500;

    public VirtualConfigInfo getVirtualConfig() {
        return null;
    }

    public DataSet getDetailReportData(VirtualEntityQueryParamInfo queryParamInfo) {
        QFilter[] qFilters = this.getFilters(queryParamInfo);
        String orderBy = this.getOrderBy(queryParamInfo);
        SalaryCalResultRptEntityResolveService service = new SalaryCalResultRptEntityResolveService(queryParamInfo.getSelectedFieldInfoList());
        List<String> calPersonFields = service.getCalPersonFields();
        Map<String, List<Long>> itemMap = service.getItemMap();
        Map<String, DataType> dataTypeMap = service.getDataTypeMap();
        Map<String, String> itemDataTypeMap = service.getItemDataTypeMap();
        DataSet dataSet = new SalaryCalResultRptQueryHelper().buildDetailDataSet(qFilters, orderBy, queryParamInfo.getStart(), queryParamInfo.getLimit(), calPersonFields, itemMap, dataTypeMap, itemDataTypeMap);
        return this.buildResultDataSet(dataSet, queryParamInfo.getSelectedFieldInfoList(), service.getItemCodeMap(), service.getNoItemDataCodeList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<DimensionValueInfo>> getSummaryReportColumnDimensionData(VirtualEntityQueryParamInfo queryParamInfo) {
        List columnDimensionList = queryParamInfo.getColumnDimensionList();
        if (columnDimensionList == null || columnDimensionList.size() == 0) {
            return new ArrayList<List<DimensionValueInfo>>(0);
        }
        QFilter[] qFilters = this.getFilters(queryParamInfo);
        SalaryCalResultRptEntityResolveService service = new SalaryCalResultRptEntityResolveService(queryParamInfo.getColumnDimensionList());
        List<String> calPersonFields = service.getCalPersonFields();
        Map<String, List<Long>> itemMap = service.getItemMap();
        Map<String, DataType> dataTypeMap = service.getDataTypeMap();
        Map<String, String> itemDataTypeMap = service.getItemDataTypeMap();
        if (!(calPersonFields != null && calPersonFields.size() != 0 || itemMap != null && itemMap.size() != 0)) {
            return new ArrayList<List<DimensionValueInfo>>(0);
        }
        SalaryCalResultRptQueryHelper helper = new SalaryCalResultRptQueryHelper();
        QueryEntityType queryEntityType = helper.getQueryEntityType();
        List<Long> pkList = helper.getCalPersonIds(queryEntityType, qFilters, null, 0, this.dataLimit);
        pkList = pkList.stream().map(obj -> Long.parseLong(obj.toString())).collect(Collectors.toList());
        List pkLists = Lists.partition(pkList, (int)this.batchLimit);
        ArrayList<List<DimensionValueInfo>> list = new ArrayList<List<DimensionValueInfo>>(10);
        try (DataSet resultDataSet = null;){
            List<String> selectList = this.getQueryFieldList(queryParamInfo.getColumnDimensionList(), service.getItemCodeMap());
            String[] selectProperties = selectList.toArray(new String[0]);
            int size = pkLists.size();
            for (int i = 0; i < size; ++i) {
                List subPkList = (List)pkLists.get(i);
                try (DataSet dataSet = null;){
                    dataSet = helper.buildDetailDataSet(queryEntityType, (List<Long>)subPkList, calPersonFields, itemMap, dataTypeMap, itemDataTypeMap);
                    if (dataSet == null) continue;
                    dataSet = this.buildResultDataSet(dataSet, queryParamInfo.getColumnDimensionList(), service.getItemCodeMap(), service.getNoItemDataCodeList());
                    dataSet = dataSet.groupBy(selectProperties).finish();
                    if (resultDataSet == null) {
                        resultDataSet = dataSet.copy();
                        continue;
                    }
                    resultDataSet = resultDataSet.union(dataSet).groupBy(selectProperties).finish();
                    continue;
                }
            }
            if (resultDataSet == null) {
                ArrayList<List<DimensionValueInfo>> i = new ArrayList<List<DimensionValueInfo>>(0);
                return i;
            }
            while (resultDataSet.hasNext()) {
                ArrayList<Object> dataList = new ArrayList<Object>(10);
                Row row = resultDataSet.next();
                for (VirtualFieldInfo virtualFieldInfo : queryParamInfo.getColumnDimensionList()) {
                    Object dimValueObj = row.get(virtualFieldInfo.getNumber());
                    if (dimValueObj instanceof DynamicObject) {
                        DynamicObject dimValue = (DynamicObject)dimValueObj;
                        dataList.add(new BaseDataDimensionValueInfo(String.valueOf(dimValue.getLong("id")), dimValue.getString("name"), dimValue.getString("number")));
                        continue;
                    }
                    dataList.add(new DimensionValueInfo(String.valueOf(dimValueObj), String.valueOf(dimValueObj)));
                }
                list.add(dataList);
            }
        }
        return list;
    }

    public SummaryQueryResultInfo getSummaryReportData(VirtualEntityQueryParamInfo queryParamInfo) {
        List<Object> subKeyList;
        QFilter[] qFilters = this.getFilters(queryParamInfo);
        int start = queryParamInfo.getStart();
        int limit = queryParamInfo.getLimit();
        List<VirtualFieldInfo> groupFieldList = this.getGroupFieldInfoList(queryParamInfo);
        SalaryCalResultRptEntityResolveService group_service = new SalaryCalResultRptEntityResolveService(groupFieldList);
        List<String> group_calPersonFields = group_service.getCalPersonFields();
        Map<String, List<Long>> group_itemMap = group_service.getItemMap();
        Map<String, DataType> group_dataTypeMap = group_service.getDataTypeMap();
        Map<String, String> group_itemDataTypeMap = group_service.getItemDataTypeMap();
        SalaryCalResultRptQueryHelper helper = new SalaryCalResultRptQueryHelper();
        QueryEntityType queryEntityType = helper.getQueryEntityType();
        List<Long> pkList = helper.getCalPersonIds(queryEntityType, qFilters, null, 0, this.dataLimit);
        List pkLists = Lists.partition(pkList, (int)this.batchLimit);
        HashMap<String, ArrayList<Long>> dimDataIdMap = new HashMap<String, ArrayList<Long>>();
        int size = pkLists.size();
        for (int i = 0; i < size; ++i) {
            List subPkList = (List)pkLists.get(i);
            DataSet dataSet = helper.buildDetailDataSet(queryEntityType, (List<Long>)subPkList, group_calPersonFields, group_itemMap, group_dataTypeMap, group_itemDataTypeMap);
            if (dataSet == null) continue;
            List<String> selectProperties = this.getQueryFieldAliasList(groupFieldList, group_service.getItemCodeMap());
            if (!selectProperties.contains("id")) {
                selectProperties.add("id");
            }
            dataSet = dataSet.select(selectProperties.toArray(new String[0]));
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                StringBuilder dimKeyBuilder = new StringBuilder();
                for (VirtualFieldInfo groupField : groupFieldList) {
                    dimKeyBuilder.append(row.get(groupField.getNumber()));
                }
                Long id = row.getLong("id");
                String dimKey = dimKeyBuilder.toString();
                ArrayList<Long> idList = (ArrayList<Long>)dimDataIdMap.get(dimKey);
                if (idList == null) {
                    idList = new ArrayList<Long>();
                    dimDataIdMap.put(dimKey, idList);
                }
                idList.add(id);
            }
        }
        ArrayList keyList = new ArrayList(dimDataIdMap.keySet());
        SalaryCalResultRptEntityResolveService service = new SalaryCalResultRptEntityResolveService(queryParamInfo.getSelectedFieldInfoList());
        List<String> calPersonFields = service.getCalPersonFields();
        Map<String, List<Long>> itemMap = service.getItemMap();
        Map<String, DataType> dataTypeMap = service.getDataTypeMap();
        Map<String, String> itemDataTypeMap = service.getItemDataTypeMap();
        ArrayList<Long> subIds = new ArrayList<Long>();
        if (limit < 0) {
            subKeyList = keyList;
        } else {
            start = start < 0 ? 0 : start;
            int end = limit + start;
            if (keyList.size() <= start) {
                DataSet dataSet = this.createEmptyDataSet(queryParamInfo.getSelectedFieldInfoList());
                SummaryQueryResultInfo summaryQueryResultInfo = new SummaryQueryResultInfo(dataSet, true);
                return summaryQueryResultInfo;
            }
            end = keyList.size() < end ? keyList.size() : end;
            subKeyList = keyList.subList(start, end);
        }
        for (String subKey : subKeyList) {
            subIds.addAll((Collection)dimDataIdMap.get(subKey));
        }
        int batchIndex = queryParamInfo.getSummaryQueryParamInfo().getSummaryQueryBatchNo();
        List batchPkLists = Lists.partition(subIds, (int)this.batchLimit);
        List currBatchPkList = batchPkLists.size() > batchIndex + 1 ? (List)batchPkLists.get(batchIndex) : new ArrayList();
        boolean isAllData = currBatchPkList == null || currBatchPkList.size() < this.batchLimit;
        DataSet dataSet = helper.buildDetailDataSet(queryEntityType, subIds, calPersonFields, itemMap, dataTypeMap, itemDataTypeMap);
        DataSet rsDataSet = this.buildResultDataSet(dataSet, queryParamInfo.getSelectedFieldInfoList(), service.getItemCodeMap(), service.getNoItemDataCodeList());
        SummaryQueryResultInfo summaryQueryResultInfo = new SummaryQueryResultInfo(rsDataSet, isAllData);
        return summaryQueryResultInfo;
    }

    public TotalRowValueInfo getTotalRow(VirtualEntityQueryParamInfo queryParamInfo) {
        QFilter[] qFilters = this.getFilters(queryParamInfo);
        SalaryCalResultRptEntityResolveService service = new SalaryCalResultRptEntityResolveService(queryParamInfo.getSelectedFieldInfoList());
        SalaryCalResultRptQueryHelper helper = new SalaryCalResultRptQueryHelper();
        QueryEntityType queryEntityType = helper.getQueryEntityType();
        List<Long> pkList = helper.getCalPersonIds(queryEntityType, qFilters, null, 0, this.dataLimit);
        int batchIndex = queryParamInfo.getSummaryQueryParamInfo().getSummaryQueryBatchNo();
        List batchPkLists = Lists.partition(pkList, (int)this.batchLimit);
        List<Long> currBatchPkList = batchPkLists.size() > batchIndex + 1 ? (List)batchPkLists.get(batchIndex) : new ArrayList();
        boolean isAllData = currBatchPkList == null || currBatchPkList.size() < this.batchLimit;
        DataSet dataSet = helper.buildDetailDataSet(queryEntityType, currBatchPkList, service.getCalPersonFields(), service.getItemMap(), service.getDataTypeMap(), service.getItemDataTypeMap());
        return new TotalRowValueInfo(this.buildResultDataSet(dataSet, queryParamInfo.getSelectedFieldInfoList(), service.getItemCodeMap(), service.getNoItemDataCodeList()), isAllData);
    }

    public Long getTotalCount(VirtualEntityQueryParamInfo queryParamInfo) {
        QFilter[] qFilters = this.getFilters(queryParamInfo);
        return new SalaryCalResultRptQueryHelper().getTotalCount(qFilters);
    }

    public List<OrderField> getOrderFields() {
        return null;
    }

    @NotNull
    private QFilter[] getFilters(VirtualEntityQueryParamInfo queryParamInfo) {
        ArrayList qFilterList = new ArrayList(10);
        List reportFilterList = queryParamInfo.getReportFilterList();
        if (reportFilterList != null && !reportFilterList.isEmpty()) {
            qFilterList.addAll(reportFilterList);
        }
        QFilter[] qFilters = new QFilter[qFilterList.size()];
        int index = 0;
        for (QFilter qFilter : qFilterList) {
            qFilters[index++] = qFilter;
        }
        return qFilters;
    }

    @NotNull
    private String getOrderBy(VirtualEntityQueryParamInfo queryParamInfo) {
        StringBuilder orderBySb = new StringBuilder();
        LinkedHashMap sortFieldInfoList = queryParamInfo.getSortFieldsMap();
        for (Map.Entry entry : sortFieldInfoList.entrySet()) {
            orderBySb.append((String)entry.getKey()).append(' ').append((String)entry.getValue()).append(',');
        }
        int indexPoint = orderBySb.lastIndexOf(",");
        if (indexPoint != -1) {
            orderBySb.deleteCharAt(indexPoint);
        }
        return orderBySb.toString();
    }

    @NotNull
    private List<String> getQueryFieldAliasList(List<VirtualFieldInfo> fieldInfoList, Map<String, String> itemCodeMap) {
        ArrayList<String> selectProperties = new ArrayList<String>(fieldInfoList.size());
        for (VirtualFieldInfo fieldInfo : fieldInfoList) {
            String itemKey = itemCodeMap.get(fieldInfo.getNumber());
            if (StringUtils.isNotBlank((CharSequence)itemKey)) {
                selectProperties.add(itemKey + " " + fieldInfo.getNumber());
                continue;
            }
            selectProperties.add(fieldInfo.getNumber());
        }
        return selectProperties;
    }

    @NotNull
    private List<String> getQueryFieldList(List<VirtualFieldInfo> fieldInfoList, Map<String, String> itemCodeMap) {
        ArrayList<String> selectProperties = new ArrayList<String>(fieldInfoList.size());
        for (VirtualFieldInfo fieldInfo : fieldInfoList) {
            selectProperties.add(fieldInfo.getNumber());
        }
        return selectProperties;
    }

    @NotNull
    private List<VirtualFieldInfo> getGroupFieldInfoList(VirtualEntityQueryParamInfo queryParamInfo) {
        ArrayList<VirtualFieldInfo> groupFieldList = new ArrayList<VirtualFieldInfo>(10);
        for (VirtualFieldInfo fieldInfo : queryParamInfo.getSelectedFieldInfoList()) {
            if (!fieldInfo.isGroupField()) continue;
            groupFieldList.add(fieldInfo);
        }
        return groupFieldList;
    }

    private DataSet buildResultDataSet(DataSet dataSet, List<VirtualFieldInfo> fieldInfoList, Map<String, String> itemCodeMap, List<String> noItemDataCodes) {
        if (dataSet == null) {
            return this.createEmptyDataSet(fieldInfoList);
        }
        List<String> selectProperties = this.getQueryFieldAliasList(fieldInfoList, itemCodeMap);
        if (!noItemDataCodes.isEmpty()) {
            dataSet = dataSet.addNullField(noItemDataCodes.toArray(new String[0]));
        }
        return dataSet.select(selectProperties.toArray(new String[0]));
    }

    public DataSet createEmptyDataSet(List<VirtualFieldInfo> fieldInfoList) {
        ArrayList columnKeys = Lists.newArrayListWithExpectedSize((int)fieldInfoList.size());
        ArrayList columnTypes = Lists.newArrayListWithExpectedSize((int)fieldInfoList.size());
        for (VirtualFieldInfo fieldInfo : fieldInfoList) {
            DateType dataType;
            DataTypeEnum fieldValueType = fieldInfo.getFieldValueType();
            columnKeys.add(fieldInfo.getNumber());
            switch (fieldValueType) {
                case DATETIME: {
                    dataType = DataType.DateType;
                    break;
                }
                case BIGDECIMAL: {
                    dataType = DataType.BigDecimalType;
                    break;
                }
                case STRING: {
                    dataType = DataType.StringType;
                    break;
                }
                case LONG: {
                    dataType = DataType.LongType;
                    break;
                }
                case BOOLEAN: {
                    dataType = DataType.BooleanType;
                    break;
                }
                case INTEGER: {
                    dataType = DataType.IntegerType;
                    break;
                }
                case LOCALESTRING: {
                    dataType = DataType.StringType;
                    break;
                }
                default: {
                    dataType = DataType.StringType;
                }
            }
            columnTypes.add(dataType);
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])columnKeys.toArray(new String[0]), (DataType[])columnTypes.toArray(new DataType[0]));
        CollectionInput inputs = new CollectionInput(rowMeta, new ArrayList());
        return Algo.create((String)this.getClass().getName()).createDataSet(new Input[]{inputs});
    }

    public DynamicObjectCollection getAllVirtualFieldCollection() {
        DynamicObjectCollection coll = new DynamicObjectCollection();
        SalaryCalResultRptQueryHelper helper = new SalaryCalResultRptQueryHelper();
        coll.addAll((Collection)this.getQueryVirtualFields(helper.getQueryEntityType()));
        coll.addAll((Collection)this.getItemVirtualFields());
        return coll;
    }

    private DynamicObjectCollection getItemVirtualFields() {
        SalaryRptItemTypeEnum[] itemTypeEnums;
        DynamicObjectCollection coll = new DynamicObjectCollection();
        HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper("hrptmirtentfields");
        for (SalaryRptItemTypeEnum itemTypeEnum : itemTypeEnums = SalaryRptItemTypeEnum.values()) {
            DynamicObject[] itemDys;
            HRBaseServiceHelper itemSlHelper = new HRBaseServiceHelper(itemTypeEnum.getEntityCode());
            QFilter qFilter = new QFilter("status", "=", (Object)"C");
            qFilter.and("enable", "=", (Object)"1");
            for (DynamicObject item : itemDys = itemSlHelper.query("id,number,name,uniquecode,datatype.showtype,datatype.storagetype", qFilter.toArray())) {
                DynamicObject dynamicObject = dataServiceHelper.generateEmptyDynamicObject();
                dynamicObject.set("fieldnumber", (Object)item.getString("uniquecode"));
                dynamicObject.set("fieldname", (Object)item.getString("name"));
                dynamicObject.set("fieldpath", (Object)"");
                String showType = item.getString("datatype.showtype");
                dynamicObject.set("fieldvaluetype", this.getItemFieldvaluetype(showType));
                dynamicObject.set("controltype", this.getItemControlType(showType));
                dynamicObject.set("complextype", this.getItemFlexType(showType));
                dynamicObject.set("iscommonfield", (Object)false);
                dynamicObject.set("group", (Object)0);
                coll.add((Object)dynamicObject);
            }
        }
        return coll;
    }

    private Object getItemFlexType(String showType) {
        return "normal";
    }

    private Object getItemControlType(String showType) {
        if (showType.equals("text")) {
            return "TextField";
        }
        if (showType.equals("num")) {
            return "DecimalField";
        }
        if (showType.equals("int")) {
            return "IntegerField";
        }
        if (showType.equals("amount")) {
            return "DecimalField";
        }
        if (showType.equals("date")) {
            return "DateField";
        }
        if (showType.equals("bool")) {
            return "CheckBoxField";
        }
        return "TextField";
    }

    private Object getItemFieldvaluetype(String showType) {
        if (showType.equals("text")) {
            return "string";
        }
        if (showType.equals("num")) {
            return "bigdecimal";
        }
        if (showType.equals("int")) {
            return "integer";
        }
        if (showType.equals("amount")) {
            return "bigdecimal";
        }
        if (showType.equals("date")) {
            return "datetime";
        }
        if (showType.equals("bool")) {
            return "boolean";
        }
        return "string";
    }

    @NotNull
    private DynamicObjectCollection getQueryVirtualFields(QueryEntityType queryEntityType) {
        List selectFields = queryEntityType.getSelectFields();
        MainEntityType queryMainEntityType = queryEntityType.getMainEntityType();
        List allJoinEntityType = queryEntityType.getAllJoinEntityType();
        Map<String, MainEntityType> entityTypeMap = allJoinEntityType.stream().collect(Collectors.toMap(DynamicObjectType::getName, e -> e));
        entityTypeMap.put(queryMainEntityType.getName(), queryMainEntityType);
        DynamicObjectCollection coll = new DynamicObjectCollection();
        HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper("hrptmc_virtentfields");
        for (QuerySelectField selectField : selectFields) {
            DynamicObject dynamicObject = dataServiceHelper.generateEmptyDynamicObject();
            dynamicObject.set("fieldnumber", (Object)selectField.getAlias());
            dynamicObject.set("fieldname", (Object)selectField.getDisplayName());
            dynamicObject.set("fieldpath", (Object)selectField.getAlias());
            String[] paths = selectField.getAlias().split("\\.");
            Object fieldProperty = null;
            MainEntityType entityType = null;
            int index = 0;
            for (String path : paths) {
                if (index == paths.length - 1) {
                    if (index == 0) {
                        entityType = queryMainEntityType;
                        fieldProperty = entityType.getProperty(path);
                    } else {
                        fieldProperty = entityType != null && fieldProperty == null ? entityType.getProperty(path) : this.getFieldProperty((IDataEntityProperty)fieldProperty, path);
                    }
                } else if (index == 0) {
                    entityType = entityTypeMap.get(path);
                    if (entityType == null) {
                        entityType = queryMainEntityType;
                        fieldProperty = entityType.getProperty(path);
                    }
                } else {
                    fieldProperty = entityType != null && fieldProperty == null ? entityType.getProperty(path) : this.getFieldProperty((IDataEntityProperty)fieldProperty, path);
                }
                ++index;
            }
            dynamicObject.set("fieldvaluetype", (Object)this.getFieldvaluetype((IDataEntityProperty)fieldProperty));
            dynamicObject.set("controltype", (Object)this.getControlType((IDataEntityProperty)fieldProperty));
            dynamicObject.set("complextype", (Object)this.getFlexType((IDataEntityProperty)fieldProperty));
            dynamicObject.set("iscommonfield", (Object)true);
            dynamicObject.set("group", (Object)0);
            coll.add((Object)dynamicObject);
        }
        return coll;
    }

    private String getFlexType(IDataEntityProperty fieldProperty) {
        if (fieldProperty instanceof HisModelBasedataProp) {
            return "hisbasedata";
        }
        if (fieldProperty instanceof BasedataProp) {
            return "basedata";
        }
        if (fieldProperty instanceof OrgProp) {
            return "adminorg";
        }
        return "normal";
    }

    private String getControlType(IDataEntityProperty fieldProperty) {
        String controlType = FieldControlType.TEXT.getValue();
        if (fieldProperty instanceof MuliLangTextProp) {
            controlType = FieldControlType.MUL_LANG_TEXT.getValue();
        } else if (fieldProperty instanceof BigIntProp) {
            controlType = FieldControlType.BIGINT.getValue();
        } else if (fieldProperty instanceof IntegerProp) {
            controlType = FieldControlType.INTEGER.getValue();
        } else if (fieldProperty instanceof DateProp) {
            controlType = FieldControlType.DATE.getValue();
        } else if (fieldProperty instanceof DateTimeProp) {
            controlType = FieldControlType.DATE_TIME.getValue();
        } else if (fieldProperty instanceof TimeProp) {
            controlType = FieldControlType.TIME.getValue();
        } else if (fieldProperty instanceof MulComboProp) {
            controlType = FieldControlType.MUL_COMBO.getValue();
        } else if (fieldProperty instanceof ComboProp) {
            controlType = FieldControlType.COMBO.getValue();
        } else if (fieldProperty instanceof DecimalProp) {
            controlType = FieldControlType.DECIMAL.getValue();
        } else if (fieldProperty instanceof BooleanProp) {
            controlType = FieldControlType.CHECKBOX.getValue();
        } else if (fieldProperty instanceof LargeTextProp) {
            controlType = FieldControlType.LARGE_TEXT.getValue();
        } else if (fieldProperty instanceof AdminDivisionProp) {
            controlType = FieldControlType.ADMIN_DIVISION.getValue();
        } else if (fieldProperty instanceof AddressProp) {
            controlType = FieldControlType.ADDRESS.getValue();
        } else if (fieldProperty instanceof UserProp) {
            controlType = FieldControlType.USER.getValue();
        } else if (fieldProperty instanceof OrgProp) {
            controlType = FieldControlType.ORG.getValue();
        } else if (fieldProperty instanceof HisModelBasedataProp) {
            controlType = FieldControlType.HIS_BASE_DATA.getValue();
        } else if (fieldProperty instanceof BasedataProp) {
            controlType = FieldControlType.BASE_DATA.getValue();
        } else if (fieldProperty instanceof TextProp) {
            controlType = FieldControlType.TEXT.getValue();
        }
        return controlType;
    }

    private String getFieldvaluetype(IDataEntityProperty fieldProperty) {
        if (fieldProperty instanceof BooleanProp) {
            return "boolean";
        }
        if (fieldProperty instanceof TextProp || fieldProperty instanceof ComboProp) {
            return "string";
        }
        if (fieldProperty instanceof BigIntProp || fieldProperty instanceof LongProp || fieldProperty instanceof BasedataProp) {
            return "long";
        }
        if (fieldProperty instanceof IntegerProp) {
            return "integer";
        }
        if (fieldProperty instanceof DecimalProp) {
            return "bigdecimal";
        }
        if (fieldProperty instanceof DateTimeProp) {
            return "datetime";
        }
        throw new KDBizException(String.format("unexpectedly fieldProperty type for getFieldvaluetype:%s!", fieldProperty));
    }

    private IDataEntityProperty getFieldProperty(IDataEntityProperty fieldProperty, String path) {
        if (fieldProperty instanceof BasedataProp) {
            DataEntityPropertyCollection propertyColl = ((BasedataProp)fieldProperty).getComplexType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : propertyColl) {
                if (!iDataEntityProperty.getName().equals(path)) continue;
                return iDataEntityProperty;
            }
            throw new KDBizException(String.format("the ComplexProperty %s of %s is not exists!", path, fieldProperty));
        }
        throw new KDBizException("fieldProperty type error!");
    }
}

