/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.id.ID;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.enums.ReportSortTypeEnum;
import kd.hr.hbp.business.service.complexobj.util.MapCacheUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.task.ReportSortDataSyncAbstractTask;
import kd.hr.hrptmc.business.task.ReportSortService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class ReportCommonSortDataSyncTask
extends ReportSortDataSyncAbstractTask {
    private static final Log LOGGER = LogFactory.getLog(ReportCommonSortDataSyncTask.class);
    private final HRBaseServiceHelper commonSortHelper = new HRBaseServiceHelper("hrptmc_commonsort");
    private Set<String> langNumSet;
    private boolean fullSync = true;
    private final Map<String, Map<String, List<Object>>> sortDataMap = new HashMap<String, Map<String, List<Object>>>(16);

    @Override
    protected Set<Long> getWaitSyncRptPk(Map<String, Object> map) {
        Object rptManage = map.get("rptmanage");
        HashSet<Long> rtpPkSet = new HashSet(16);
        if (rptManage instanceof Long && (Long)rptManage > 0L) {
            Long rtpPk = (Long)rptManage;
            rtpPkSet.add(rtpPk);
            this.fullSync = false;
        } else {
            ReportSortService reportSortService = new ReportSortService();
            rtpPkSet = reportSortService.getAllRptPkSet();
        }
        return rtpPkSet;
    }

    @Override
    protected void doSync(DBRoute dbRoute, Map<Long, Set<String>> rptFieldMap, String bizSortTable) {
        HashMap<String, Set> entityFieldsMap = new HashMap<String, Set>(16);
        Set<Long> rptPKSet = rptFieldMap.keySet();
        for (Long l : rptPKSet) {
            try {
                DynamicObjectCollection commonSortField = ReportManageService.getCommonSortAndFieldSortField(l);
                for (DynamicObject dynamicObject : commonSortField) {
                    String fieldType;
                    MainEntityType dataEntityType;
                    String entityNumber = dynamicObject.getString("entitynumber");
                    if (HRStringUtils.isEmpty((String)entityNumber) || (dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber)) == null || "basedata".equals(fieldType = dynamicObject.getString("fieldtype")) && dbRoute.getRouteKey().equals(dataEntityType.getDBRouteKey())) continue;
                    String entityField = dynamicObject.getString("entityfield");
                    Set fieldSet = MapCacheUtil.getMapSetVal(entityFieldsMap, (Object)entityNumber);
                    fieldSet.add(entityField);
                    entityFieldsMap.put(entityNumber, fieldSet);
                }
            }
            catch (Exception e) {
                LOGGER.error("Report-sort-data-sync:common sort entity field deal exception, reportPK:" + l, (Throwable)e);
            }
        }
        LOGGER.info("Report-sort-data-sync:common need sync entityField:{}", entityFieldsMap);
        if (MapUtils.isEmpty(entityFieldsMap)) {
            return;
        }
        for (Map.Entry entry : entityFieldsMap.entrySet()) {
            String entityNumber = (String)entry.getKey();
            try {
                Map<String, List<Object>> fieldPksMap = this.syncSingleBdSortData(entityNumber, (Set)entry.getValue());
                if (MapUtils.isEmpty(fieldPksMap)) continue;
                this.sortDataMap.put(entityNumber, fieldPksMap);
            }
            catch (Exception e) {
                LOGGER.error("Report-sort-data-sync:common bd data query exception,entityNumber:" + entityNumber, (Throwable)e);
            }
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("entitynumber", "in", entityFieldsMap.keySet())};
        DynamicObject[] dynamicObjectArray = this.commonSortHelper.queryOriginalArray("id,entitynumber,entityfield,fieldtype,valuetype,locale", qFilters);
        List<Object[]> dataList = this.genSortData(dynamicObjectArray);
        Set<Long> deleteSortFieldIds = null;
        if (!this.fullSync) {
            deleteSortFieldIds = Arrays.stream(dynamicObjectArray).map(dyo -> dyo.getLong("id")).collect(Collectors.toSet());
        }
        this.syncDataToDb(this.fullSync, bizSortTable, dbRoute, dataList, deleteSortFieldIds);
    }

    @Override
    protected ReportSortTypeEnum getSortTypeEnum() {
        return ReportSortTypeEnum.COMMON_SORT;
    }

    private List<Object[]> genSortData(DynamicObject[] dynamicObjects) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String curEntityNumber = dynamicObject.getString("entitynumber");
            Map<String, List<Object>> fieldPKsMap = this.sortDataMap.get(curEntityNumber);
            if (MapUtils.isEmpty(fieldPKsMap)) continue;
            String curField = dynamicObject.getString("entityfield");
            List<Object> list = fieldPKsMap.get(curField);
            if (list == null) {
                String curLocalId = dynamicObject.getString("locale");
                list = fieldPKsMap.get(curField + "_l." + curLocalId);
            }
            if (CollectionUtils.isEmpty(list)) continue;
            LOGGER.info("Report-sort-data-sync:common gen sort data, entityNumber:{},field:{}", (Object)curEntityNumber, (Object)curField);
            String curValType = dynamicObject.getString("valuetype");
            long curPk = dynamicObject.getLong("id");
            for (int i = 0; i < list.size(); ++i) {
                Object pkVal = list.get(i);
                Object[] objects = new Object[5];
                objects[0] = 0L;
                objects[1] = curPk;
                if ("long".equals(curValType)) {
                    objects[2] = Long.valueOf(String.valueOf(pkVal));
                    objects[3] = " ";
                } else {
                    objects[2] = 0L;
                    objects[3] = String.valueOf(pkVal);
                }
                objects[4] = i;
                dataList.add(objects);
            }
        }
        long[] longIds = ID.genLongIds((int)dataList.size());
        for (int i = 0; i < dataList.size(); ++i) {
            ((Object[])dataList.get((int)i))[0] = longIds[i];
        }
        return dataList;
    }

    private Map<String, List<Object>> syncSingleBdSortData(String entityNumber, Set<String> fieldSet) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (dataEntityType == null) {
            return null;
        }
        String table = dataEntityType.getAlias();
        if (HRStringUtils.isEmpty((String)table)) {
            return null;
        }
        String mulangTable = table + "_l";
        String pkAlias = dataEntityType.getPrimaryKey().getAlias();
        String dbRouteKey = dataEntityType.getDBRouteKey();
        HashMap<String, List<Object>> sortMap = new HashMap<String, List<Object>>(16);
        Map<String, List<Object>> loadSortMap = this.sortDataMap.get(entityNumber);
        if (loadSortMap == null) {
            loadSortMap = new HashMap<String, List<Object>>(0);
        }
        for (String field : fieldSet) {
            List<Object> cachePkList = loadSortMap.get(field);
            if (CollectionUtils.isNotEmpty(cachePkList)) {
                sortMap.put(field, cachePkList);
                continue;
            }
            DynamicProperty property = dataEntityType.getProperty(field);
            if (property.isDbIgnore()) continue;
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                List comboItems = comboProp.getComboItems();
                Set<String> langNumSet = this.getLangNumSet();
                for (String langNum : langNumSet) {
                    String cacheKey = field + "_l." + langNum;
                    List<Object> mulangFieldPks = loadSortMap.get(cacheKey);
                    if (CollectionUtils.isNotEmpty(mulangFieldPks)) {
                        sortMap.put(cacheKey, mulangFieldPks);
                        continue;
                    }
                    List valList = comboItems.stream().sorted(Comparator.comparing(item -> (String)item.getName().getItem(langNum))).map(ValueMapItem::getValue).collect(Collectors.toList());
                    sortMap.put(cacheKey, valList);
                }
                continue;
            }
            if (property instanceof MuliLangTextProp) {
                Set<String> langNumSet = this.getLangNumSet();
                for (String langNum : langNumSet) {
                    String cacheKey = field + "_l." + langNum;
                    List<Object> mulangFieldPks = loadSortMap.get(cacheKey);
                    if (CollectionUtils.isNotEmpty(mulangFieldPks)) {
                        sortMap.put(cacheKey, mulangFieldPks);
                        continue;
                    }
                    String querySql = "select " + pkAlias + " from " + mulangTable + " where flocaleid = '" + langNum + "' order by " + property.getAlias();
                    List<Object> pkList = this.queryFieldList(dbRouteKey, querySql, "fid");
                    sortMap.put(cacheKey, pkList);
                }
                continue;
            }
            String querySql = "select " + pkAlias + " from " + table + " order by " + property.getAlias();
            List<Object> pkList = this.queryFieldList(dbRouteKey, querySql, "fid");
            sortMap.put(field, pkList);
        }
        return sortMap;
    }

    private List<Object> queryFieldList(String dbRouteKey, String sql, String field) {
        return (List)HRDBUtil.query((DBRoute)DBRoute.of((String)dbRouteKey), (String)sql, (Object[])new Object[0], rs -> {
            ArrayList<Object> list = new ArrayList<Object>(10);
            while (rs.next()) {
                list.add(rs.getObject(field));
            }
            return list;
        });
    }

    private Set<String> getLangNumSet() {
        if (this.langNumSet == null) {
            InteServiceImpl intService = new InteServiceImpl();
            this.langNumSet = intService.getEnabledLang().stream().map(EnabledLang::getNumber).collect(Collectors.toSet());
        }
        return this.langNumSet;
    }
}

