/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.task;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.DBConfigUtil;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.complexobj.util.MapCacheUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class ReportSortService {
    private static final Log LOGGER = LogFactory.getLog(ReportSortService.class);
    private final Map<String, String> entityDbRouteCache = new HashMap<String, String>(16);
    private final DBConfigUtil dbConfigUtil = new DBConfigUtil();
    private final MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();

    public Set<Long> getAllRptPkSet() {
        HRBaseServiceHelper reportManageHelper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject[] ids = reportManageHelper.query("id", null);
        return Arrays.stream(ids).map(dyo -> dyo.getLong("id")).collect(Collectors.toSet());
    }

    public Map<String, Map<Long, Set<String>>> batchRptEntityByDbRoute(Set<Long> rptIds) {
        Set entitys;
        Map<Long, Long> rptAnObjMap = ReportSortService.getRptAnObjMap(rptIds);
        Map<Long, Set<String>> anObjJoinEntity = ReportSortService.getAnObjEntityMap(rptAnObjMap.values());
        HashMap<String, Map> dbAnObjEntityMap = new HashMap<String, Map>(16);
        for (Map.Entry<Long, Set<String>> entry : anObjJoinEntity.entrySet()) {
            Long anObjPk = entry.getKey();
            try {
                Set<String> entityNumberSet = entry.getValue();
                for (String entityNumber : entityNumberSet) {
                    String dbRouteKey = this.getDBRouteKey(entityNumber);
                    String appNumber = this.getAppNumber(entityNumber);
                    String key = dbRouteKey + ":" + appNumber;
                    Map mapSetVal = MapCacheUtil.getMapMapVal(dbAnObjEntityMap, (Object)key);
                    entitys = MapCacheUtil.getMapSetVal((Map)mapSetVal, (Object)anObjPk);
                    entitys.add(entityNumber);
                    mapSetVal.put(anObjPk, entitys);
                    dbAnObjEntityMap.put(key, mapSetVal);
                }
            }
            catch (Exception e) {
                LOGGER.error("report_sort_data_sync fail joinentity dealFail: anObjPk:{}", (Object)anObjPk);
            }
        }
        HashMap<String, Map<Long, Set<String>>> dbRptEntityMap = new HashMap<String, Map<Long, Set<String>>>(16);
        for (Map.Entry dbEntry : dbAnObjEntityMap.entrySet()) {
            String dbRouteKey = (String)dbEntry.getKey();
            Map anObjEntityMap = (Map)dbEntry.getValue();
            for (Map.Entry<Long, Long> entry : rptAnObjMap.entrySet()) {
                Long rptId = entry.getKey();
                Long anObjId = entry.getValue();
                if (!anObjEntityMap.containsKey(anObjId)) continue;
                Map rtpEntityMap = MapCacheUtil.getMapMapVal(dbRptEntityMap, (Object)dbRouteKey);
                entitys = MapCacheUtil.getMapSetVal((Map)rtpEntityMap, (Object)rptId);
                rtpEntityMap.put(rptId, entitys);
                dbRptEntityMap.put(dbRouteKey, rtpEntityMap);
            }
        }
        return dbRptEntityMap;
    }

    private static Map<Long, Long> getRptAnObjMap(Set<Long> rptIds) {
        HRBaseServiceHelper reportManageHelper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject[] rptDyos = reportManageHelper.queryOriginalArray("id,anobjid", new QFilter[]{new QFilter("id", "in", rptIds)});
        Map<Long, Long> rptAnObjMap = Arrays.stream(rptDyos).collect(Collectors.toMap(dyo -> dyo.getLong("id"), dyo -> dyo.getLong("anobjid")));
        return rptAnObjMap;
    }

    private static Map<Long, Set<String>> getAnObjEntityMap(Collection<Long> anObjList) {
        if (anObjList.isEmpty()) {
            return Collections.emptyMap();
        }
        String anObjSql = "select fanobjid, fentitynumber, ftype from t_hrptmc_anobjjoinentity a where exists (select fid from t_hrptmc_analysisobject b where a.fanobjid = b.fid and b.fisvirtualentity = '0' and b.fid in (" + anObjList.stream().map(String::valueOf).collect(Collectors.joining(",")) + "))";
        HashMap<Long, Set<String>> anObjJoinEntity = new HashMap<Long, Set<String>>(16);
        HRDBUtil.query((DBRoute)DBRoute.of((String)"hmp"), (String)anObjSql, null, rs -> {
            while (rs.next()) {
                long anObjId = rs.getLong("fanobjid");
                Set mapSetVal = MapCacheUtil.getMapSetVal((Map)anObjJoinEntity, (Object)anObjId);
                mapSetVal.add(rs.getString("fentitynumber"));
                anObjJoinEntity.put(anObjId, mapSetVal);
            }
            return null;
        });
        return anObjJoinEntity;
    }

    private boolean isDiffDBRoute(Set<String> entityNumbers) {
        String dbRouteKey = null;
        for (String entityNumber : entityNumbers) {
            String curSharingId;
            String sharingId;
            String curDBRouteKey = this.getDBRouteKey(entityNumber);
            if (dbRouteKey == null) {
                dbRouteKey = curDBRouteKey;
                continue;
            }
            if (dbRouteKey.equals(curDBRouteKey) || (sharingId = this.dbConfigUtil.getDBConfigSharingId(dbRouteKey)).equals(curSharingId = this.dbConfigUtil.getDBConfigSharingId(curDBRouteKey))) continue;
            return true;
        }
        return false;
    }

    public String getAppNumber(String entityNumber) {
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            return "";
        }
        MainEntityType dataEntityType = this.mainEntityTypeUtil.getMainEntityType(entityNumber);
        return dataEntityType.getBizAppNumber();
    }

    public String getDBRouteKey(String entityNumber) {
        MainEntityType dataEntityType;
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            return "";
        }
        String dbRouteKey = this.entityDbRouteCache.get(entityNumber);
        if (HRStringUtils.isEmpty((String)dbRouteKey) && (dataEntityType = this.mainEntityTypeUtil.getMainEntityType(entityNumber)) != null) {
            dbRouteKey = dataEntityType.getDBRouteKey();
            this.entityDbRouteCache.put(entityNumber, dbRouteKey);
        }
        return dbRouteKey;
    }
}

