/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.complexobj.enums.ReportSortTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.task.RptVirEtySortDataSyncTask;
import kd.hr.hrptmc.business.task.SortDataSyncTaskInfo;
import org.apache.commons.collections.MapUtils;

public class RptVirEtyComSortDataSyncTask
extends RptVirEtySortDataSyncTask {
    private static final Log LOGGER = LogFactory.getLog(RptVirEtyComSortDataSyncTask.class);
    private Set<String> langNumSet;
    private final Map<String, Map<String, List<Object>>> sortDataMap = new HashMap<String, Map<String, List<Object>>>(16);
    private DynamicObjectCollection rptComRefColl;

    @Override
    protected Set<Long> getWaitSyncRptPk(Map<String, Object> map) {
        Set<Long> rtpPkSet = super.getWaitSyncRptPk(map);
        HRBaseServiceHelper rptComRefHelper = new HRBaseServiceHelper("hrptmc_rptcomref");
        this.rptComRefColl = rptComRefHelper.queryOriginalCollection("commonsort,rptmanage", new QFilter[]{new QFilter("rptmanage", "in", rtpPkSet)});
        rtpPkSet = this.rptComRefColl.stream().map(dy -> dy.getLong("rptmanage")).collect(Collectors.toSet());
        LOGGER.info("virtual_commonSort_sync_rptPK:{}", rtpPkSet);
        return rtpPkSet;
    }

    private Map<DBRoute, SortDataSyncTaskInfo> getSortDataSyncTaskMap(DynamicObjectCollection rptComSortColl) {
        HashMap<DBRoute, SortDataSyncTaskInfo> sortDataSyncTaskMap = new HashMap<DBRoute, SortDataSyncTaskInfo>();
        for (DynamicObject commonSortDy : rptComSortColl) {
            String entityNumber = commonSortDy.getString("entitynumber");
            String sortFieldNumber = commonSortDy.getString("entityfield");
            String dbRouteKey = this.getDBRouteKey(entityNumber);
            DBRoute dbRoute = DBRoute.of((String)this.getDBRouteKey(entityNumber));
            String bizSortTable = this.getBizSortTableByDbRouteKey(dbRouteKey, ReportSortTypeEnum.COMMON_SORT.getSortType());
            if (StringUtils.isEmpty((String)bizSortTable)) {
                LOGGER.info("virtual_commonSort_sync_skip,noRegister bizSortTable,dbRouteKey:{}", (Object)dbRouteKey);
                continue;
            }
            SortDataSyncTaskInfo sortDataSyncTaskInfo = sortDataSyncTaskMap.getOrDefault(dbRoute, new SortDataSyncTaskInfo(bizSortTable));
            sortDataSyncTaskInfo.addFieldNumber(entityNumber, sortFieldNumber);
            sortDataSyncTaskMap.put(dbRoute, sortDataSyncTaskInfo);
        }
        return sortDataSyncTaskMap;
    }

    @Override
    protected void syncSingleReport(Long rptId) {
        LOGGER.info("virtual_commonSort_sync_start:{}", (Object)rptId);
        List commonSortIds = this.rptComRefColl.stream().filter(dy -> rptId.longValue() == dy.getLong("rptmanage")).map(dy -> dy.getLong("commonsort")).collect(Collectors.toList());
        LOGGER.info("virtual_commonSort_sync_commonSortIds:{}", commonSortIds);
        HRBaseServiceHelper rptComSortHelper = new HRBaseServiceHelper("hrptmc_commonsort");
        DynamicObjectCollection rptComSortColl = rptComSortHelper.queryOriginalCollection("id,entitynumber,entityfield,fieldtype,valuetype,locale", new QFilter[]{new QFilter("id", "in", commonSortIds)});
        Map<DBRoute, SortDataSyncTaskInfo> sortDataSyncTaskMap = this.getSortDataSyncTaskMap(rptComSortColl);
        LOGGER.info("virtual_commonSort_sync_sortDataSyncTaskMap:{}", sortDataSyncTaskMap);
        for (Map.Entry<DBRoute, SortDataSyncTaskInfo> sortDataSyncTaskEntry : sortDataSyncTaskMap.entrySet()) {
            DBRoute dbRoute = sortDataSyncTaskEntry.getKey();
            SortDataSyncTaskInfo sortDataSyncTaskInfo = sortDataSyncTaskEntry.getValue();
            String bizSortTable = sortDataSyncTaskInfo.getBizSortTable();
            LOGGER.info("virtual_commonSort_sync_dbRoute:{}", (Object)dbRoute.getRouteKey());
            for (Map.Entry<String, Set<String>> entityFieldEntry : sortDataSyncTaskInfo.getEntityFieldNumberMap().entrySet()) {
                String entityNumber = entityFieldEntry.getKey();
                Map<String, List<Object>> fieldPksMap = this.syncSingleBdSortData(entityNumber, entityFieldEntry.getValue());
                if (MapUtils.isEmpty(fieldPksMap)) continue;
                this.sortDataMap.put(entityNumber, fieldPksMap);
            }
            Set fieldNumberSet = sortDataSyncTaskInfo.getEntityFieldNumberMap().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            DynamicObject[] dynamicObjects = (DynamicObject[])rptComSortColl.stream().filter(dy -> fieldNumberSet.contains(dy.getString("entityfield"))).toArray(DynamicObject[]::new);
            LOGGER.info("virtual_commonSort_sync_fieldNumberSet:{}", fieldNumberSet);
            List<Object[]> sortDataList = this.genSortData(dynamicObjects);
            LOGGER.info("virtual_commonSort_sync_sortDataList:{}", sortDataList);
            Set<Long> deleteSortFieldIds = Arrays.stream(dynamicObjects).map(dyo -> dyo.getLong("id")).collect(Collectors.toSet());
            LOGGER.info("virtual_commonSort_sync_deleteSortFieldIds:{}", deleteSortFieldIds);
            this.syncDataToDb(bizSortTable, dbRoute, sortDataList, deleteSortFieldIds);
        }
        LOGGER.info("virtual_commonSort_sync_end:{}", (Object)rptId);
    }

    @Override
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Set<Long> rptIds = this.getWaitSyncRptPk(map);
        if (CollectionUtils.isEmpty(rptIds)) {
            return;
        }
        for (Long rptId : rptIds) {
            this.syncSingleReport(rptId);
        }
    }

    private List<Object[]> genSortData(DynamicObject[] dynamicObjects) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String curEntityNumber = dynamicObject.getString("entitynumber");
            Map<String, List<Object>> fieldPKsMap = this.sortDataMap.get(curEntityNumber);
            if (MapUtils.isEmpty(fieldPKsMap)) continue;
            String curField = dynamicObject.getString("entityfield");
            List<Object> list = fieldPKsMap.get(curField);
            if (list == null) {
                String curLocalId = dynamicObject.getString("locale");
                list = fieldPKsMap.get(curField + "_l." + curLocalId);
            }
            if (CollectionUtils.isEmpty(list)) continue;
            LOGGER.info("virtual_commonSort_sync,entityNumber:{},field:{}", (Object)curEntityNumber, (Object)curField);
            String curValType = dynamicObject.getString("valuetype");
            long curPk = dynamicObject.getLong("id");
            for (int i = 0; i < list.size(); ++i) {
                Object pkVal = list.get(i);
                Object[] objects = new Object[5];
                objects[0] = 0L;
                objects[1] = curPk;
                if ("long".equals(curValType)) {
                    objects[2] = pkVal;
                    objects[3] = " ";
                } else {
                    objects[2] = 0L;
                    objects[3] = pkVal;
                }
                objects[4] = i;
                dataList.add(objects);
            }
        }
        long[] longIds = ID.genLongIds((int)dataList.size());
        for (int i = 0; i < dataList.size(); ++i) {
            ((Object[])dataList.get((int)i))[0] = longIds[i];
        }
        return dataList;
    }

    private Map<String, List<Object>> syncSingleBdSortData(String entityNumber, Set<String> fieldSet) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (dataEntityType == null) {
            return null;
        }
        String table = dataEntityType.getAlias();
        if (HRStringUtils.isEmpty((String)table)) {
            return null;
        }
        String mulangTable = table + "_l";
        String pkAlias = dataEntityType.getPrimaryKey().getAlias();
        String dbRouteKey = dataEntityType.getDBRouteKey();
        HashMap<String, List<Object>> sortMap = new HashMap<String, List<Object>>(16);
        Map<String, List<Object>> loadSortMap = this.sortDataMap.get(entityNumber);
        if (loadSortMap == null) {
            loadSortMap = new HashMap<String, List<Object>>(0);
        }
        for (String field : fieldSet) {
            List<Object> cachePkList = loadSortMap.get(field);
            if (CollectionUtils.isNotEmpty(cachePkList)) {
                sortMap.put(field, cachePkList);
                continue;
            }
            DynamicProperty property = dataEntityType.getProperty(field);
            if (property.isDbIgnore()) continue;
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                List comboItems = comboProp.getComboItems();
                Set<String> langNumSet = this.getLangNumSet();
                for (String langNum : langNumSet) {
                    String cacheKey = field + "_l." + langNum;
                    List<Object> mulangFieldPks = loadSortMap.get(cacheKey);
                    if (CollectionUtils.isNotEmpty(mulangFieldPks)) {
                        sortMap.put(cacheKey, mulangFieldPks);
                        continue;
                    }
                    List valList = comboItems.stream().sorted(Comparator.comparing(item -> (String)item.getName().getItem(langNum))).map(ValueMapItem::getValue).collect(Collectors.toList());
                    sortMap.put(cacheKey, valList);
                }
                continue;
            }
            if (property instanceof MuliLangTextProp) {
                Set<String> langNumSet = this.getLangNumSet();
                for (String langNum : langNumSet) {
                    String cacheKey = field + "_l." + langNum;
                    List<Object> mulangFieldPks = loadSortMap.get(cacheKey);
                    if (CollectionUtils.isNotEmpty(mulangFieldPks)) {
                        sortMap.put(cacheKey, mulangFieldPks);
                        continue;
                    }
                    String querySql = "select " + pkAlias + " from " + mulangTable + " where flocaleid = '" + langNum + "' order by " + property.getAlias();
                    List<Object> pkList = this.queryFieldId(dbRouteKey, querySql);
                    sortMap.put(cacheKey, pkList);
                }
                continue;
            }
            String querySql = "select " + pkAlias + " from " + table + " order by " + property.getAlias();
            List<Object> pkList = this.queryFieldId(dbRouteKey, querySql);
            sortMap.put(field, pkList);
        }
        return sortMap;
    }

    private List<Object> queryFieldId(String dbRouteKey, String sql) {
        return (List)HRDBUtil.query((DBRoute)DBRoute.of((String)dbRouteKey), (String)sql, (Object[])new Object[0], rs -> {
            ArrayList<Object> list = new ArrayList<Object>(10);
            while (rs.next()) {
                list.add(rs.getObject("fid"));
            }
            return list;
        });
    }

    private Set<String> getLangNumSet() {
        if (this.langNumSet == null) {
            InteServiceImpl intService = new InteServiceImpl();
            this.langNumSet = intService.getEnabledLang().stream().map(EnabledLang::getNumber).collect(Collectors.toSet());
        }
        return this.langNumSet;
    }
}

