/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.task;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.complexobj.enums.ReportSortTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hrptmc.business.task.RptVirEtySortDataSyncTask;
import kd.hr.hrptmc.business.task.SortDataSyncTaskInfo;

public class RptVirEtyCustSortDataSyncTask
extends RptVirEtySortDataSyncTask {
    private static final Log LOGGER = LogFactory.getLog(RptVirEtyCustSortDataSyncTask.class);
    private DynamicObjectCollection rptCustSortColl;

    @Override
    protected Set<Long> getWaitSyncRptPk(Map<String, Object> map) {
        Set<Long> rtpPkSet = super.getWaitSyncRptPk(map);
        HRBaseServiceHelper customSortHelper = new HRBaseServiceHelper("hrptmc_customsort");
        this.rptCustSortColl = customSortHelper.queryOriginalCollection("id,entitynumber,entityfield,rptmanage", new QFilter[]{new QFilter("rptmanage", "in", rtpPkSet)});
        rtpPkSet = this.rptCustSortColl.stream().map(dy -> dy.getLong("rptmanage")).collect(Collectors.toSet());
        LOGGER.info("virtual_customSort_sync_rptPK:{}", rtpPkSet);
        return rtpPkSet;
    }

    @Override
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Set<Long> rptIds = this.getWaitSyncRptPk(map);
        if (CollectionUtils.isEmpty(rptIds)) {
            return;
        }
        for (Long rptId : rptIds) {
            this.syncSingleReport(rptId);
        }
    }

    private Map<DBRoute, SortDataSyncTaskInfo> getSortDataSyncTaskMap(List<DynamicObject> customSortDys) {
        HashMap sortDataSyncTaskMap = Maps.newHashMapWithExpectedSize((int)customSortDys.size());
        for (DynamicObject customSortDy : customSortDys) {
            String entityNumber = customSortDy.getString("entitynumber");
            Long sortFieldId = customSortDy.getLong("id");
            String dbRouteKey = this.getDBRouteKey(entityNumber);
            DBRoute dbRoute = DBRoute.of((String)this.getDBRouteKey(entityNumber));
            String bizSortTable = this.getBizSortTableByDbRouteKey(dbRouteKey, ReportSortTypeEnum.SELF_SORT.getSortType());
            if (StringUtils.isEmpty((String)bizSortTable)) {
                LOGGER.info("virtual_customSort_sync_skip,noRegister bizSortTable,dbRouteKey:{}", (Object)dbRouteKey);
                continue;
            }
            SortDataSyncTaskInfo sortDataSyncTaskInfo = sortDataSyncTaskMap.getOrDefault(dbRoute, new SortDataSyncTaskInfo(bizSortTable));
            sortDataSyncTaskInfo.addFieldId(entityNumber, sortFieldId);
            sortDataSyncTaskMap.put(dbRoute, sortDataSyncTaskInfo);
        }
        return sortDataSyncTaskMap;
    }

    @Override
    protected void syncSingleReport(Long rptId) {
        LOGGER.info("virtual_customSort_sync_start:{}", (Object)rptId);
        List<DynamicObject> customSortDys = this.rptCustSortColl.stream().filter(customSortDyo -> rptId.longValue() == customSortDyo.getLong("rptmanage")).collect(Collectors.toList());
        Map<DBRoute, SortDataSyncTaskInfo> sortDataSyncTaskMap = this.getSortDataSyncTaskMap(customSortDys);
        LOGGER.info("virtual_customSort_sync_sortDataSyncTaskMap:{}", sortDataSyncTaskMap);
        for (Map.Entry<DBRoute, SortDataSyncTaskInfo> sortDataSyncTaskEntry : sortDataSyncTaskMap.entrySet()) {
            DBRoute dbRoute = sortDataSyncTaskEntry.getKey();
            SortDataSyncTaskInfo sortDataSyncTaskInfo = sortDataSyncTaskEntry.getValue();
            String bizSortTable = sortDataSyncTaskInfo.getBizSortTable();
            LOGGER.info("virtual_customSort_sync_dbRoute:{}", (Object)dbRoute.getRouteKey());
            Set<Long> fieldIdSet = sortDataSyncTaskInfo.getEntityFieldIdMap().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            LOGGER.info("virtual_customSort_sync_fieldIdSet:{}", fieldIdSet);
            List<Object[]> sortDataList = this.genSortData(fieldIdSet);
            LOGGER.info("virtual_customSort_sync_sortDataList:{}", sortDataList);
            Set<Long> deleteSortFieldIds = sortDataList.stream().map(arr -> (Long)arr[1]).collect(Collectors.toSet());
            LOGGER.info("virtual_customSort_sync_deleteSortFieldIds:{}", deleteSortFieldIds);
            this.syncDataToDb(bizSortTable, dbRoute, sortDataList, deleteSortFieldIds);
        }
        LOGGER.info("virtual_customSort_sync_end:{}", (Object)rptId);
    }

    private List<Object[]> genSortData(Set<Long> fieldIdSet) {
        String hmpSortDataSql = "select fentryid,fid,flong,fstring,fseq from t_hrptmc_customsortety where fid in (" + Joiner.on((String)",").join(fieldIdSet) + " ) ";
        return (List)HRDBUtil.query((DBRoute)DBRoute.of((String)"hmp"), (String)hmpSortDataSql, (Object[])new Object[0], rs -> {
            ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
            while (rs.next()) {
                Object[] objects = new Object[]{rs.getLong("fentryid"), rs.getLong("fid"), rs.getLong("flong"), rs.getString("fstring"), rs.getInt("fseq")};
                dataList.add(objects);
            }
            return dataList;
        });
    }
}

