/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.task;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class RptVirEtySortDataSyncTask
extends AbstractTask {
    private final Map<String, String> entityDbRouteCache = new HashMap<String, String>(16);

    protected Set<Long> getWaitSyncRptPk(Map<String, Object> map) {
        Object rptManage = map.get("rptmanage");
        HashSet<Long> rtpPkSet = new HashSet(16);
        if (rptManage instanceof Long && (Long)rptManage > 0L) {
            rtpPkSet.add((Long)rptManage);
        } else {
            rtpPkSet = this.getAllVirtualRptId();
        }
        return rtpPkSet;
    }

    protected abstract void syncSingleReport(Long var1);

    protected Set<Long> getAllVirtualRptId() {
        HashSet<Long> rtpPkSet = new HashSet<Long>(16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_analyseobject");
        DynamicObjectCollection virtualColl = helper.queryOriginalCollection("id", new QFilter[]{new QFilter("objecttype", "=", (Object)"virtualentity")});
        if (null == virtualColl || virtualColl.size() == 0) {
            return rtpPkSet;
        }
        List virtualAnalyseIds = virtualColl.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper rptHelper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObjectCollection rptManageColl = rptHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("anobjid", "in", virtualAnalyseIds)});
        return rptManageColl.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Set<Long> rptIds = this.getWaitSyncRptPk(map);
        if (CollectionUtils.isEmpty(rptIds)) {
            return;
        }
        for (Long rptId : rptIds) {
            this.syncSingleReport(rptId);
        }
    }

    protected void syncDataToDb(String sortTable, DBRoute dbRoute, List<Object[]> sortDataList, Set<Long> deleteSortFieldIds) {
        try (TXHandle tx = TX.requiresNew();){
            this.deleteOldData(sortTable, dbRoute, deleteSortFieldIds);
            this.insertSortData(sortTable, dbRoute, sortDataList);
        }
    }

    private void deleteOldData(String sortTable, DBRoute dbRoute, Set<Long> deleteSortFieldIds) {
        if (deleteSortFieldIds != null && deleteSortFieldIds.size() > 0) {
            String delSql = "delete from " + sortTable + " where fentitysortfieldid in (" + deleteSortFieldIds.stream().map(String::valueOf).collect(Collectors.joining(",")) + ")";
            HRDBUtil.execute((DBRoute)dbRoute, (String)delSql, null);
        }
    }

    private void insertSortData(String sortTable, DBRoute dbRoute, List<Object[]> sortDataList) {
        if (CollectionUtils.isEmpty(sortDataList)) {
            return;
        }
        String insertSql = "insert into " + sortTable + "(fid,fentitysortfieldid,flong,fstring,findex) values (?,?,?,?,?)";
        HRDBUtil.executeBatch((DBRoute)dbRoute, (String)insertSql, sortDataList);
    }

    public String getDBRouteKey(String entityNumber) {
        MainEntityType dataEntityType;
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            return "";
        }
        String dbRouteKey = this.entityDbRouteCache.get(entityNumber);
        if (HRStringUtils.isEmpty((String)dbRouteKey) && (dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber)) != null) {
            dbRouteKey = dataEntityType.getDBRouteKey();
            this.entityDbRouteCache.put(entityNumber, dbRouteKey);
        }
        return dbRouteKey;
    }

    public String getBizSortTableByDbRouteKey(String dbRouteKey, String sortType) {
        return this.getBizSortEntityDynamicObject(dbRouteKey, sortType, "table");
    }

    private String getBizSortEntityDynamicObject(String dbRouteKey, String sortType, String type) {
        String result = null;
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrptmc_bizsortentity");
        QFilter dbRouteKeyFilter = new QFilter("dbroutekey", "=", (Object)dbRouteKey);
        QFilter sortTypeFilter = new QFilter("sorttype", "=", (Object)sortType);
        QFilter[] qFilters = new QFilter[]{dbRouteKeyFilter, sortTypeFilter};
        DynamicObject dynamicObject = hrBaseServiceHelper.loadDynamicObject(qFilters);
        if (dynamicObject != null) {
            result = "entity".equals(type) ? dynamicObject.getString("sortentity") : dynamicObject.getString("sorttable");
        }
        return result;
    }
}

