/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.datamerge;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hrptc.common.model.datamerge.CompDataGroupBo;
import org.apache.commons.collections.CollectionUtils;

public class DataCompLogService {
    private static final Log LOGGER = LogFactory.getLog(DataCompLogService.class);
    private final String entityNumber = "hrptmc_datacomplog";
    private final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_datacomplog");
    private final String fieldDataA = "dataa";
    private final String fieldDataB = "datab";
    private final String fieldExpMsg = "expmsg";
    private final String fieldCost = "cost";
    private final String fieldReportid = "reportid";
    private final String fieldDatatype = "datatype";
    private final String fieldCompRst = "comprst";
    private final String compRstSame = "same";
    private final String compRstDiff = "diff";
    private final String compRstFail = "fail";
    private final String fieldDealStatus = "dealstatus";
    private final String dealStatusTodo = "todo";
    private final String dealStatusFinish = "finish";
    private final String dealStatusFail = "fail";

    public void writeExpCompLog(String dataAStore, String dataBStore, Long reportPk, String dataType, String expMsg, long cost) {
        LOGGER.info("writeExpCompLog param[dataAStore:{},dataBStore:{},sameData:{}]", new Object[]{dataAStore, dataBStore, expMsg});
        DynamicObject dynamicObject = this.genCompareLogDyo(dataAStore, dataBStore, reportPk, dataType, cost);
        dynamicObject.set("comprst", (Object)"fail");
        if (expMsg.length() > 500) {
            expMsg = expMsg.substring(0, 490);
        }
        dynamicObject.set("expmsg", (Object)expMsg);
        dynamicObject.set("dealstatus", (Object)"finish");
        this.serviceHelper.saveOne(dynamicObject);
    }

    public DynamicObject genCompareLogDyo(String dataAStore, String dataBStore, Long reportPk, String dataType, long cost) {
        String[] orderedStr = this.orderStrings(dataAStore, dataBStore);
        dataAStore = orderedStr[0];
        dataBStore = orderedStr[1];
        DynamicObject dynamicObject = this.serviceHelper.generateEmptyDynamicObject();
        HRBaseUtils.setSysField((DynamicObject)dynamicObject);
        dynamicObject.set("dataa", (Object)dataAStore);
        dynamicObject.set("datab", (Object)dataBStore);
        dynamicObject.set("reportid", (Object)reportPk);
        dynamicObject.set("datatype", (Object)dataType);
        dynamicObject.set("cost", (Object)cost);
        return dynamicObject;
    }

    public void writeCompLog(String dataAStore, String dataBStore, Long reportPk, String dataType, boolean sameData, long cost) {
        LOGGER.info("writeCompLog param[dataAStore:{},dataBStore:{},sameData:{}]", new Object[]{dataAStore, dataBStore, sameData});
        DynamicObject dynamicObject = this.genCompareLogDyo(dataAStore, dataBStore, reportPk, dataType, cost);
        dynamicObject.set("comprst", (Object)(sameData ? "same" : "diff"));
        dynamicObject.set("dealstatus", (Object)(sameData ? "todo" : "finish"));
        this.serviceHelper.saveOne(dynamicObject);
    }

    public List<CompDataGroupBo> querySameDetailLog(String dataType) {
        QFilter[] qFilters = new QFilter[]{new QFilter("dealstatus", "=", (Object)"todo"), new QFilter("comprst", "=", (Object)"same"), new QFilter("datatype", "=", (Object)dataType)};
        DynamicObject[] dynamicObjects = this.serviceHelper.queryOriginalArray("id,reportid,dataa,datab", qFilters);
        ArrayList<CompDataGroupBo> compDataGroupList = new ArrayList<CompDataGroupBo>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            CompDataGroupBo compDataGroup = new CompDataGroupBo();
            compDataGroup.setReportId(Long.valueOf(dynamicObject.getLong("reportid")));
            compDataGroup.setDataAStore(dynamicObject.getString("dataa"));
            compDataGroup.setDataBStore(dynamicObject.getString("datab"));
            compDataGroup.setPk(Long.valueOf(dynamicObject.getLong("id")));
            compDataGroupList.add(compDataGroup);
        }
        return compDataGroupList;
    }

    public void markFinish(List<Long> pkList) {
        DynamicObject[] dynamicObjects;
        if (CollectionUtils.isEmpty(pkList)) {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", pkList), new QFilter("dealstatus", "=", (Object)"todo")};
        for (DynamicObject dynamicObject : dynamicObjects = this.serviceHelper.query("dealstatus", qFilters)) {
            dynamicObject.set("dealstatus", (Object)"finish");
        }
        this.serviceHelper.update(dynamicObjects);
    }

    public boolean existsCompRst(String dataAStore, String dataBStore) {
        String[] orderedStr = this.orderStrings(dataAStore, dataBStore);
        dataAStore = orderedStr[0];
        dataBStore = orderedStr[1];
        QFilter[] qFilters = new QFilter[]{new QFilter("dataa", "=", (Object)dataAStore), new QFilter("datab", "=", (Object)dataBStore)};
        return this.serviceHelper.isExists(qFilters);
    }

    private String[] orderStrings(String a, String b) {
        String[] result = new String[2];
        if (a.compareTo(b) <= 0) {
            result[0] = a;
            result[1] = b;
        } else {
            result[0] = b;
            result[1] = a;
        }
        return result;
    }
}

