/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.datamerge;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hrptc.business.datamerge.DataCompLogService;

public abstract class DataCompareAbstract {
    private static final Log LOGGER = LogFactory.getLog(DataCompareAbstract.class);
    private final DataCompLogService compLogService = new DataCompLogService();

    public void doCompare(String dataAStore, String dataBStore, Long reportPk, String dataType) {
        boolean existsCompRst = this.compLogService.existsCompRst(dataAStore, dataBStore);
        if (existsCompRst) {
            LOGGER.info("DataCompareTemplate_existsCompRst, dataAStore:{},dataBStore:{}", (Object)dataAStore, (Object)dataBStore);
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            boolean dataEqual = this.dataEqual(dataAStore, dataBStore);
            long endTime = System.currentTimeMillis();
            this.compLogService.writeCompLog(dataAStore, dataBStore, reportPk, dataType, dataEqual, endTime - startTime);
        }
        catch (Exception exception) {
            LOGGER.error("DataCompareTemplate_exception: ", (Throwable)exception);
            long endTime = System.currentTimeMillis();
            this.compLogService.writeExpCompLog(dataAStore, dataBStore, reportPk, dataType, this.getStack(exception), endTime - startTime);
        }
    }

    private String getStack(Exception exception) {
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("message: ").append(exception.getMessage()).append("\r\n");
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            errorMsg.append(stackTraceElement.getClassName()).append("  ").append(stackTraceElement.getMethodName()).append(": ").append(stackTraceElement.getLineNumber());
            errorMsg.append("\r\n");
            if (errorMsg.length() > 1000) break;
        }
        if (errorMsg.length() > 1000) {
            return errorMsg.substring(0, 1000);
        }
        return errorMsg.toString();
    }

    protected abstract boolean dataEqual(String var1, String var2);
}

