/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.datamerge;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DataCompareUtil {
    private static final Log LOGGER = LogFactory.getLog(DataCompareUtil.class);
    private static final Integer INTEGER_ONE = 1;

    public static boolean listDataEqual(List<Map<String, Object>> dataListA, List<Map<String, Object>> dataListB) {
        if (dataListA.size() != dataListB.size()) {
            return false;
        }
        Map<Map<String, Object>, Integer> countMapA = DataCompareUtil.getCardinalityMap(dataListA);
        Map<Map<String, Object>, Integer> countMapB = DataCompareUtil.getCardinalityMap(dataListB);
        if (countMapA.size() != countMapB.size()) {
            LOGGER.info("listDataEqual-countsize is inconsistent");
            return false;
        }
        for (Map<String, Object> countMapKey : countMapA.keySet()) {
            if (DataCompareUtil.getFreq(countMapKey, countMapA) == DataCompareUtil.getFreq(countMapKey, countMapB)) continue;
            LOGGER.info("listDataEqual-data is inconsistent, countMapKey:{}", countMapKey);
            return false;
        }
        return true;
    }

    private static Map<Map<String, Object>, Integer> getCardinalityMap(List<Map<String, Object>> dataList) {
        HashMap<Map<String, Object>, Integer> countMap = new HashMap<Map<String, Object>, Integer>();
        for (Map<String, Object> dataMap : dataList) {
            Integer dataCount = (Integer)countMap.get(dataMap);
            if (dataCount == null) {
                countMap.put(dataMap, INTEGER_ONE);
                continue;
            }
            countMap.put(dataMap, dataCount + 1);
        }
        return countMap;
    }

    private static int getFreq(Map<String, Object> mapKey, Map<Map<String, Object>, Integer> freqMap) {
        Integer count = freqMap.get(mapKey);
        if (count != null) {
            return count;
        }
        return 0;
    }
}

