/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.datamerge;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hrptc.business.datamerge.CompRstParseUtil;
import kd.hr.hrptc.business.datamerge.DataCompLogService;
import kd.hr.hrptc.business.datamerge.EsIIndexService;
import kd.hr.hrptc.business.datamerge.EsIdxModLogService;
import kd.hr.hrptc.common.model.datamerge.CompDataGroupBo;
import kd.hr.hrptc.common.model.datamerge.EsIdxModifyBo;

public abstract class DataMergeService {
    private static final Log LOGGER = LogFactory.getLog(DataMergeService.class);
    protected DataCompLogService compLogService = new DataCompLogService();
    protected EsIIndexService esIIndexService = new EsIIndexService();
    protected EsIdxModLogService esIdxModLogService = new EsIdxModLogService();

    public void doMerge() {
        List<CompDataGroupBo> sameCompareLogList = this.sameCompareLogList();
        List<List<String>> sortGroupList = CompRstParseUtil.mergeStoreSort(sameCompareLogList);
        List<EsIdxModifyBo> idxModifyBoList = this.assembleModifyEsIdxList(sortGroupList);
        List<Long> pkList = sameCompareLogList.stream().map(CompDataGroupBo::getPk).collect(Collectors.toList());
        try (TXHandle txHandle = TX.requiresNew();){
            this.esIdxModLogService.writeModLogBatch(idxModifyBoList);
            this.doOperation(idxModifyBoList);
            this.compLogService.markFinish(pkList);
        }
    }

    protected abstract void doOperation(List<EsIdxModifyBo> var1);

    protected abstract List<EsIdxModifyBo> assembleModifyEsIdxList(List<List<String>> var1);

    protected abstract List<CompDataGroupBo> sameCompareLogList();
}

