/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.datamerge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hrptc.business.datamerge.DataMergeService;
import kd.hr.hrptc.business.datamerge.EsIdxRefEntityHolder;
import kd.hr.hrptc.common.model.datamerge.CompDataGroupBo;
import kd.hr.hrptc.common.model.datamerge.EsIdxModifyBo;
import org.apache.commons.collections.CollectionUtils;

public class DetailDataMergeService
extends DataMergeService {
    private static final Log LOGGER = LogFactory.getLog(DetailDataMergeService.class);

    @Override
    protected void doOperation(List<EsIdxModifyBo> idxModifyBoList) {
        Map<String, List<EsIdxModifyBo>> replaceEsIdxGroupMap = idxModifyBoList.stream().collect(Collectors.groupingBy(EsIdxModifyBo::getReplaceIdx));
        for (Map.Entry<String, List<EsIdxModifyBo>> entry : replaceEsIdxGroupMap.entrySet()) {
            String replaceEsIdx = entry.getKey();
            List<String> oldEsPkList = entry.getValue().stream().map(EsIdxModifyBo::getEsIdx).collect(Collectors.toList());
            EsIdxRefEntityHolder.batchModifyRef(oldEsPkList, replaceEsIdx);
        }
        Set<String> allIdxPkList = idxModifyBoList.stream().map(EsIdxModifyBo::getEsIdx).collect(Collectors.toSet());
        Set retainPkList = idxModifyBoList.stream().map(EsIdxModifyBo::getReplaceIdx).collect(Collectors.toSet());
        allIdxPkList.removeAll(retainPkList);
        if (CollectionUtils.isEmpty(allIdxPkList)) {
            return;
        }
        this.deleteEsIdxCheck(allIdxPkList);
        this.esIIndexService.deleteEsIdx(allIdxPkList);
    }

    private void deleteEsIdxCheck(Set<String> allIdxPkList) {
        boolean existsRef = EsIdxRefEntityHolder.existsRef(allIdxPkList);
        if (existsRef) {
            LOGGER.error("exists ref not change allIdxPkList:{}", allIdxPkList);
            throw new KDBizException("exists ref not change");
        }
        boolean allExists = this.esIdxModLogService.allExistsCheck(allIdxPkList);
        if (!allExists) {
            LOGGER.error("es modifylog lost allIdxPkList:{}", allIdxPkList);
            throw new KDBizException("es modifylog lost");
        }
    }

    @Override
    protected List<EsIdxModifyBo> assembleModifyEsIdxList(List<List<String>> sortGroupList) {
        ArrayList<EsIdxModifyBo> idxModifyBoList = new ArrayList<EsIdxModifyBo>(10);
        for (List<String> sortGroup : sortGroupList) {
            if (sortGroup.size() == 1) continue;
            String replaceBdIdx = sortGroup.get(0);
            LOGGER.info("start merge replaceDetailIdx:{}, esIdxs\uff1a{}", (Object)replaceBdIdx, sortGroup);
            DynamicObject[] dynamicObjects = this.esIIndexService.queryByPks(sortGroup);
            Map<String, List<DynamicObject>> esIdxDyoGroupMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dyo -> dyo.getString("basedataesindex")));
            for (Map.Entry<String, List<DynamicObject>> entry : esIdxDyoGroupMap.entrySet()) {
                List<DynamicObject> esIdxDyoList = entry.getValue();
                if (esIdxDyoList.size() < 2) {
                    LOGGER.info("detailDataMerge only one bdIdx:{}", (Object)entry.getKey());
                    continue;
                }
                for (DynamicObject esIdxDyo : esIdxDyoList) {
                    String mainDataIdx = esIdxDyo.getString("id");
                    String bdIdx = esIdxDyo.getString("basedataesindex");
                    if (replaceBdIdx.equals(mainDataIdx)) continue;
                    EsIdxModifyBo esIdxModifyBo = new EsIdxModifyBo(mainDataIdx, bdIdx, replaceBdIdx, "detail");
                    idxModifyBoList.add(esIdxModifyBo);
                }
            }
        }
        return idxModifyBoList;
    }

    @Override
    protected List<CompDataGroupBo> sameCompareLogList() {
        return this.compLogService.querySameDetailLog("detail");
    }
}

