/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.datamerge;

import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.business.datamerge.EsIIndexService;
import kd.hr.hrptc.business.datamerge.EsIdxModLogService;
import kd.hr.hrptc.business.datamerge.EsIdxRefEntityHolder;
import kd.hr.hrptmc.business.center.es.RptCenterEsStorage;

public class EsDataClearService {
    private static final Log LOGGER = LogFactory.getLog(EsDataClearService.class);

    public static void deleteUselessData(Date validDate) {
        EsIdxModLogService esIdxModLogService = new EsIdxModLogService();
        EsIIndexService esIIndexService = new EsIIndexService();
        RptCenterEsStorage esStorage = new RptCenterEsStorage();
        Date now = new Date();
        DynamicObject[] pendDropEsIdxArr = esIdxModLogService.getPendDropEsIdxDyoArr(validDate);
        LOGGER.info("deleteUselessData start clear modlog, size:{}", (Object)pendDropEsIdxArr.length);
        for (DynamicObject esIdxModLogDyo : pendDropEsIdxArr) {
            EsDataClearService.doDeleteEsDataByEsModLog(esIdxModLogService, esIIndexService, esStorage, now, esIdxModLogDyo);
        }
        DynamicObject[] esIdxDyoArr = esIIndexService.queryAbandonIdx(validDate);
        LOGGER.info("deleteUselessData start clear esindex, size:{}", (Object)esIdxDyoArr.length);
        for (DynamicObject esIdxDyo : esIdxDyoArr) {
            EsDataClearService.doDeleteEsDataByEsIdx(esIIndexService, esStorage, esIdxDyo);
        }
    }

    public static void deleteUserDelData() {
        EsIdxModLogService esIdxModLogService = new EsIdxModLogService();
        EsIIndexService esIIndexService = new EsIIndexService();
        RptCenterEsStorage esStorage = new RptCenterEsStorage();
        Date now = new Date();
        DynamicObject[] pendDropEsIdxArr = esIdxModLogService.getUserDelIdxDyoArr();
        LOGGER.info("deleteUserDelData start clear modlog, size:{}", (Object)pendDropEsIdxArr.length);
        for (DynamicObject esIdxModLogDyo : pendDropEsIdxArr) {
            EsDataClearService.doDeleteEsDataByEsModLog(esIdxModLogService, esIIndexService, esStorage, now, esIdxModLogDyo);
        }
    }

    private static void doDeleteEsDataByEsIdx(EsIIndexService esIIndexService, RptCenterEsStorage esStorage, DynamicObject esIdxDyo) {
        String esBdIdx = esIdxDyo.getString("basedataesindex");
        if (HRStringUtils.isNotEmpty((String)esBdIdx) && esIIndexService.existsValidIndex(esBdIdx, true)) {
            LOGGER.error("deleteUselessData_existsValidBdIdx_isUsing index:{}", (Object)esBdIdx);
            return;
        }
        String esInx = esIdxDyo.getString("id");
        HashSet<String> esIdxSet = new HashSet<String>(1);
        esIdxSet.add(esInx);
        boolean existsRef = EsIdxRefEntityHolder.existsRef(esIdxSet);
        if (existsRef) {
            LOGGER.error("deleteUselessData_existsValidIdx_isUsing index:{}", (Object)esInx);
            return;
        }
        esIdxDyo.set("status", (Object)"1");
        HRBaseUtils.setModifyField((DynamicObject)esIdxDyo);
        LOGGER.info("deleteUselessData do delete indexName:{}", (Object)esInx);
        esStorage.deleteIndex(esInx);
        if (HRStringUtils.isNotEmpty((String)esBdIdx)) {
            LOGGER.info("deleteUselessData do delete bdindexName:{}", (Object)esBdIdx);
            esStorage.deleteIndex(esBdIdx);
        }
        LOGGER.info("deleteUselessData update esindex:{}", (Object)esInx);
        esIIndexService.updateOne(esIdxDyo);
    }

    private static void doDeleteEsDataByEsModLog(EsIdxModLogService esIdxModLogService, EsIIndexService esIIndexService, RptCenterEsStorage esStorage, Date updateTime, DynamicObject esIdxModLogDyo) {
        boolean exists;
        String modifyType = esIdxModLogDyo.getString("modifytype");
        String mainIdx = null;
        String bdIdx = null;
        if ("basedata".equals(modifyType)) {
            bdIdx = esIdxModLogDyo.getString("bdidx");
        } else if ("detail".equals(modifyType)) {
            mainIdx = esIdxModLogDyo.getString("esidx");
        } else if ("delete".equals(modifyType)) {
            mainIdx = esIdxModLogDyo.getString("esidx");
            bdIdx = esIdxModLogDyo.getString("bdidx");
        }
        if (HRStringUtils.isNotEmpty(mainIdx)) {
            exists = esIIndexService.existsValidIndex(mainIdx, false);
            if (exists) {
                LOGGER.error("deleteUselessData_index_isUsing index:{}", (Object)mainIdx);
            } else {
                LOGGER.info("deleteUselessData do delete indexName:{}", (Object)mainIdx);
                esStorage.deleteIndex(mainIdx);
            }
        }
        if (HRStringUtils.isNotEmpty((String)bdIdx)) {
            exists = esIIndexService.existsValidIndex(bdIdx, true);
            if (exists) {
                LOGGER.error("deleteUselessData_index_isUsing index:{}", (Object)bdIdx);
            } else {
                LOGGER.info("deleteUselessData do delete indexName:{}", (Object)bdIdx);
                esStorage.deleteIndex(bdIdx);
            }
        }
        LOGGER.info("deleteUselessData update mainIdx:{},bdIdx\uff1a{}", (Object)mainIdx, (Object)bdIdx);
        esIdxModLogDyo.set("dataclear", (Object)true);
        esIdxModLogDyo.set("deldate", (Object)updateTime);
        esIdxModLogService.updateOne(esIdxModLogDyo);
    }
}

