/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.datamerge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.business.datamerge.DataCompareUtil;
import kd.hr.hrptmc.business.center.es.RptCenterEsStorage;
import kd.hr.hrptmc.common.model.center.es.EsDistinctResultVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class EsDataMrService {
    private static final Log LOGGER = LogFactory.getLog(EsDataMrService.class);
    private final RptCenterEsStorage esStorage = new RptCenterEsStorage();
    private final int compBatch = 1000;
    private final int maxCycleIndex = 50000;

    public boolean indexEquals(String indexA, String indexB) {
        this.compIdxCheck(indexA, indexB);
        if (!this.idxMappingSame(indexA, indexB)) {
            LOGGER.info("indexEquals_mapping_diff, [indexA:{},indexB:{}]", (Object)indexA, (Object)indexB);
            return false;
        }
        if (!this.idxHitCountEquals(indexA, indexB)) {
            LOGGER.info("indexEquals_count_diff, [indexA:{},indexB:{}]", (Object)indexA, (Object)indexB);
            return false;
        }
        boolean dataEquals = this.idxDataEquals(indexA, indexB);
        LOGGER.info("indexEquals, [indexA:{},indexB:{}],dataEquals:{}", new Object[]{indexA, indexB, dataEquals});
        return dataEquals;
    }

    private void compIdxCheck(String indexA, String indexB) {
        if (HRStringUtils.equals((String)indexA, (String)indexB)) {
            throw new KDBizException("indexNameEquals");
        }
        if (HRStringUtils.isEmpty((String)indexA) || HRStringUtils.isEmpty((String)indexB)) {
            throw new KDBizException("indexNameEMPTY");
        }
        if (!this.esStorage.isIndexExist(indexA).booleanValue()) {
            throw new KDBizException(indexA + "index not exists");
        }
        if (!this.esStorage.isIndexExist(indexB).booleanValue()) {
            throw new KDBizException(indexB + "index not exists");
        }
    }

    private boolean idxMappingSame(String indexA, String indexB) {
        Map mappingA = this.esStorage.getMapping(indexA);
        if (MapUtils.isEmpty((Map)mappingA)) {
            return false;
        }
        Map mappingB = this.esStorage.getMapping(indexB);
        if (MapUtils.isEmpty((Map)mappingB)) {
            return false;
        }
        return mappingA.equals(mappingB);
    }

    private boolean idxHitCountEquals(String indexA, String indexB) {
        return this.esStorage.count(indexA, null) == this.esStorage.count(indexB, null);
    }

    private boolean idxDataEquals(String indexA, String indexB) {
        Map afterKey = null;
        boolean hasNext = false;
        int loopCount = 0;
        long startTime = System.currentTimeMillis();
        do {
            if (++loopCount > 50000) {
                throw new KDBizException("loopCount overstep maxCycleIndex");
            }
            ArrayList<String> distinctFieldList = new ArrayList<String>(10);
            distinctFieldList.add("id");
            EsDistinctResultVo distinctResultVo = this.esStorage.distinctQuery(indexA, null, distinctFieldList, 1000, afterKey, null);
            if (distinctResultVo == null) {
                LOGGER.error("distinctResultVo is null");
                throw new KDBizException("distinctQuery exception");
            }
            afterKey = distinctResultVo.getAfterKey();
            hasNext = distinctResultVo.getDataList().size() == 1000;
            Object[] idArr = distinctResultVo.getDataList().stream().map(data -> data.get("id")).toArray();
            if (idArr.length == 0) break;
            EsFilterField esFilterField = new EsFilterField(null, "id", "in", idArr);
            ArrayList<EsFilterField> commonFilter = new ArrayList<EsFilterField>(1);
            commonFilter.add(esFilterField);
            long idxACount = this.esStorage.count(indexA, commonFilter);
            long idxBCount = this.esStorage.count(indexB, commonFilter);
            if (idxACount != idxBCount || idxACount == 0L) {
                LOGGER.info("indexEquals_count_diff, [indexA:{}-count:{},indexB:{}-count:{}],idArr:{}", new Object[]{indexA, idxACount, indexB, idxBCount, idArr});
                return false;
            }
            String[] allQueryFieldArr = new String[0];
            List dataListA = this.esStorage.queryListData(indexA, allQueryFieldArr, commonFilter, null, 0, (int)idxACount);
            if (CollectionUtils.isEmpty((Collection)dataListA)) {
                LOGGER.info("indexEquals_detail_data_empty, [indexA:{}],idArr:{}", (Object)indexA, (Object)idArr);
                return false;
            }
            List dataListB = this.esStorage.queryListData(indexB, allQueryFieldArr, commonFilter, null, 0, (int)idxBCount);
            if (CollectionUtils.isEmpty((Collection)dataListB)) {
                LOGGER.info("indexEquals_detail_data_empty, [indexB:{}],idArr:{}", (Object)indexB, (Object)idArr);
                return false;
            }
            boolean dataEqual = DataCompareUtil.listDataEqual(dataListA, dataListB);
            if (dataEqual) continue;
            LOGGER.info("indexEquals_detail_data_diff, [indexA:{},indexB:{}]", (Object)indexA, (Object)indexB);
            return false;
        } while (hasNext);
        long cost = System.currentTimeMillis() - startTime;
        LOGGER.info("idxDataEquals end loopCount:{},time:{} ms", (Object)loopCount, (Object)cost);
        return true;
    }
}

