/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.datamerge;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hrptc.common.model.datamerge.EsIdxModifyBo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class EsIIndexService {
    private static final Log LOGGER = LogFactory.getLog(EsIIndexService.class);
    private final String entityNumber = "hrptmc_esindex";
    private final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_esindex");
    public static final String FIELD_BDIDX = "basedataesindex";
    public static final String FIELD_STATUS = "status";
    public static final String STATUS_NORMAL = "0";
    public static final String STATUS_DELETE = "1";
    public static final String STATUS_EXP = "2";

    public DynamicObject[] queryByBdIdx(List<String> baseDataIdxList) {
        if (CollectionUtils.isEmpty(baseDataIdxList)) {
            return new DynamicObject[0];
        }
        QFilter[] qFilters = new QFilter[]{new QFilter(FIELD_BDIDX, "in", baseDataIdxList), new QFilter(FIELD_STATUS, "=", (Object)STATUS_NORMAL)};
        return this.serviceHelper.queryOriginalArray("id,basedataesindex", qFilters);
    }

    public DynamicObject[] queryByPks(List<String> pkList) {
        if (CollectionUtils.isEmpty(pkList)) {
            return new DynamicObject[0];
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", pkList), new QFilter(FIELD_STATUS, "=", (Object)STATUS_NORMAL)};
        return this.serviceHelper.queryOriginalArray("id,basedataesindex", qFilters);
    }

    public DynamicObject[] queryAbandonIdx(Date validDate) {
        QFilter[] qFilters = new QFilter[]{new QFilter(FIELD_STATUS, "=", (Object)STATUS_EXP), new QFilter("createtime", "<=", (Object)validDate)};
        return this.serviceHelper.loadDynamicObjectArray(qFilters);
    }

    public void updateBdIdx(String id, String baseDataIdx) {
        DynamicObject dynamicObject = this.serviceHelper.queryOne(FIELD_BDIDX, (Object)id);
        dynamicObject.set(FIELD_BDIDX, (Object)baseDataIdx);
        this.serviceHelper.updateOne(dynamicObject);
    }

    public void deleteEsIdx(Set<String> pkSet) {
        LOGGER.info("batch delete hrptmc_esindex pkSet:{}", pkSet);
        this.serviceHelper.delete(pkSet.toArray());
    }

    public void clearBdEsIdx(Set<String> pkSet) {
        LOGGER.info("esindex clearBdEsIdx pkSet:{}", pkSet);
        if (CollectionUtils.isEmpty(pkSet)) {
            return;
        }
        DynamicObject[] dynamicObjects = this.serviceHelper.query("id,modifier,modifytime,basedataesindex", new QFilter[]{new QFilter("id", "in", pkSet)});
        if (dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set(FIELD_BDIDX, (Object)" ");
            HRBaseUtils.setModifyField((DynamicObject)dynamicObject);
        }
        this.serviceHelper.update(dynamicObjects);
    }

    public boolean existsValidIndex(String index, boolean baseDataIdx) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
        qFilterList.add(new QFilter(FIELD_STATUS, "=", (Object)STATUS_NORMAL));
        if (baseDataIdx) {
            qFilterList.add(new QFilter(FIELD_BDIDX, "=", (Object)index));
        } else {
            qFilterList.add(new QFilter("id", "=", (Object)index));
        }
        return this.serviceHelper.isExists(qFilterList.toArray(new QFilter[0]));
    }

    public void updateBdIdxBatch(List<EsIdxModifyBo> idxModifyBoList) {
        DynamicObject[] dynamicObjects;
        Map modifyBoMap = idxModifyBoList.stream().collect(Collectors.toMap(EsIdxModifyBo::getEsIdx, Function.identity()));
        if (MapUtils.isEmpty(modifyBoMap)) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects = this.serviceHelper.query(FIELD_BDIDX, new QFilter[]{new QFilter("id", "in", modifyBoMap.keySet())})) {
            String pkStr = dynamicObject.getString("id");
            EsIdxModifyBo esIdxModifyBo = (EsIdxModifyBo)modifyBoMap.get(pkStr);
            dynamicObject.set(FIELD_BDIDX, (Object)esIdxModifyBo.getReplaceIdx());
        }
        this.serviceHelper.update(dynamicObjects);
    }

    public void updateOne(DynamicObject dynamicObject) {
        this.serviceHelper.updateOne(dynamicObject);
    }
}

