/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.datamerge;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hrptc.common.model.datamerge.EsIdxModifyBo;
import org.apache.commons.collections.CollectionUtils;

public class EsIdxModLogService {
    private static final Log LOGGER = LogFactory.getLog(EsIdxModLogService.class);
    private final String entityNumber = "hrptmc_esidxmodlog";
    private final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_esidxmodlog");
    public static final String FIELD_ESIDX = "esidx";
    public static final String FIELD_BDIDX = "bdidx";
    public static final String FIELD_REPLACEIDX = "replaceidx";
    public static final String FIELD_MODIFYTYPE = "modifytype";
    public static final String FIELD_DATECLEAR = "dataclear";
    public static final String FIELD_DELDATE = "deldate";

    public void writeModLog(String mainDataIdx, String bdIdx, String replaceIdx, String modifyType) {
        DynamicObject dynamicObject = this.serviceHelper.generateEmptyDynamicObject();
        HRBaseUtils.setSysField((DynamicObject)dynamicObject);
        dynamicObject.set(FIELD_ESIDX, (Object)mainDataIdx);
        dynamicObject.set(FIELD_BDIDX, (Object)bdIdx);
        dynamicObject.set(FIELD_REPLACEIDX, (Object)replaceIdx);
        dynamicObject.set(FIELD_MODIFYTYPE, (Object)modifyType);
        this.serviceHelper.saveOne(dynamicObject);
    }

    public boolean allExistsCheck(Set<String> esIdxSet) {
        DynamicObject[] dynamicObjects = this.serviceHelper.queryOriginalArray(FIELD_ESIDX, new QFilter[]{new QFilter(FIELD_ESIDX, "in", esIdxSet)});
        Set dbEsistsEsIdxSet = Arrays.stream(dynamicObjects).map(dyo -> dyo.getString(FIELD_ESIDX)).collect(Collectors.toSet());
        return esIdxSet.equals(dbEsistsEsIdxSet);
    }

    public void writeModLogBatch(List<EsIdxModifyBo> idxModifyBoList) {
        if (CollectionUtils.isEmpty(idxModifyBoList)) {
            return;
        }
        DynamicObjectCollection coll = new DynamicObjectCollection();
        for (EsIdxModifyBo esIdxModifyBo : idxModifyBoList) {
            DynamicObject dynamicObject = this.serviceHelper.generateEmptyDynamicObject();
            HRBaseUtils.setSysField((DynamicObject)dynamicObject);
            dynamicObject.set(FIELD_ESIDX, (Object)esIdxModifyBo.getEsIdx());
            dynamicObject.set(FIELD_BDIDX, (Object)esIdxModifyBo.getBdEsIdx());
            dynamicObject.set(FIELD_REPLACEIDX, (Object)esIdxModifyBo.getReplaceIdx());
            dynamicObject.set(FIELD_MODIFYTYPE, (Object)esIdxModifyBo.getModifyType());
            coll.add((Object)dynamicObject);
        }
        this.serviceHelper.save(coll);
    }

    public DynamicObject[] getPendDropEsIdxDyoArr(Date validDate) {
        QFilter[] qFilters = new QFilter[]{new QFilter(FIELD_DATECLEAR, "=", (Object)false), new QFilter("createtime", "<=", (Object)validDate)};
        return this.serviceHelper.loadDynamicObjectArray(qFilters);
    }

    public DynamicObject[] getUserDelIdxDyoArr() {
        QFilter[] qFilters = new QFilter[]{new QFilter(FIELD_DATECLEAR, "=", (Object)false), new QFilter(FIELD_MODIFYTYPE, "=", (Object)"delete")};
        return this.serviceHelper.loadDynamicObjectArray(qFilters);
    }

    public void updateOne(DynamicObject dynamicObject) {
        this.serviceHelper.updateOne(dynamicObject);
    }
}

