/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.datastore;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.EsCommonUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.business.datastore.AbstractCenterDataStoreService;
import kd.hr.hrptc.business.servicehelper.ReportCenterServiceHelper;
import kd.hr.hrptc.business.servicehelper.ScheduleTaskServiceHelper;
import kd.hr.hrptc.common.constant.subscribe.ReportSubscribeConstants;

public class SubscribeDataStoreService
extends AbstractCenterDataStoreService
implements ReportSubscribeConstants {
    private static final Log LOGGER = LogFactory.getLog(SubscribeDataStoreService.class);
    private final DynamicObject[] tasks;
    private List<String> stopKeyList;

    public SubscribeDataStoreService(Long reportId, DynamicObject[] tasks, QFilter permissionQFilter, Map<String, QFilter> f7PermissionQFilter) {
        super(reportId, permissionQFilter, f7PermissionQFilter);
        this.tasks = tasks;
    }

    @Override
    public void endExecute() {
        super.endExecute();
        Date date = new Date();
        List<String> stopKeyList = this.getStopKeyList();
        Map<String, DynamicObject> taskMap = Arrays.stream(this.tasks).collect(Collectors.toMap(ts -> ts.getString("subscriberecord.id"), ts -> ts, (k1, k2) -> k1));
        String topSubscribeId = this.tasks[0].getString("subscriberecord.id");
        for (String stopKey : stopKeyList) {
            String id = ScheduleTaskServiceHelper.getId(stopKey);
            DynamicObject task = taskMap.get(id);
            if (ScheduleTaskServiceHelper.isStop(stopKey)) {
                task.set("runstatus", (Object)"4");
                ScheduleTaskServiceHelper.removeStopCache(stopKey);
            } else {
                if (HRStringUtils.equals((String)id, (String)topSubscribeId)) {
                    task.set("runstatus", (Object)"3");
                } else {
                    task.set("runstatus", (Object)"1");
                }
                task.set("esindex", (Object)this.esIndex);
            }
            task.set("endtime", (Object)date);
        }
        ReportCenterServiceHelper.SUBSCRIBE_TASK_HELPER.save(this.tasks);
    }

    @Override
    public String generateEsIndex() {
        return EsCommonUtils.getIndexNamePrefix((String)"hr") + "_" + "subscribe" + "_" + this.report.getString("number").toLowerCase(Locale.ROOT) + "_" + System.currentTimeMillis();
    }

    @Override
    protected String generateBaseDataEsIndex(String esIndex) {
        return esIndex + "_basedata";
    }

    @Override
    protected List<String> getStopKeyList() {
        if (this.stopKeyList == null) {
            this.stopKeyList = Lists.newArrayListWithExpectedSize((int)this.tasks.length);
            for (DynamicObject task : this.tasks) {
                long subscribeId = task.getLong("subscriberecord.id");
                String stopKey = ScheduleTaskServiceHelper.getStopKey(subscribeId, false);
                this.stopKeyList.add(stopKey);
            }
        }
        return this.stopKeyList;
    }

    @Override
    protected void writeCount(int count) {
        super.writeCount(count);
        for (DynamicObject task : this.tasks) {
            task.set("count", (Object)count);
        }
    }
}

