/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.servicehelper;

import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.hr.hrptmc.common.constant.center.ReportCenterConstants;

public class ScheduleTaskServiceHelper
implements ReportCenterConstants {
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("hrptmc", true);

    public static void stop(long id, boolean isShare) {
        String stopKey = ScheduleTaskServiceHelper.getStopKey(id, isShare);
        CACHE.put(stopKey, (Object)Boolean.TRUE.toString());
    }

    public static boolean isStop(String stopKey) {
        return Boolean.TRUE.toString().equals(CACHE.get(stopKey));
    }

    public static boolean isStop(List<String> stopKeyList) {
        for (String stopKey : stopKeyList) {
            if (ScheduleTaskServiceHelper.isStop(stopKey)) continue;
            return false;
        }
        return true;
    }

    public static String getStopKey(long id, boolean isShare) {
        if (isShare) {
            return "stop_center_data_store_share_" + id;
        }
        return "stop_center_data_store_subscribe_" + id;
    }

    public static String getId(String stopKey) {
        int index = stopKey.lastIndexOf("_");
        return stopKey.substring(index + 1);
    }

    public static void removeStopCache(String stopKey) {
        CACHE.remove(stopKey);
    }

    public static String getErrorMsg(Exception exception) {
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("message: ").append(exception.getMessage()).append("\r\n");
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            errorMsg.append(stackTraceElement.getClassName()).append("  ").append(stackTraceElement.getMethodName()).append(": ").append(stackTraceElement.getLineNumber());
            errorMsg.append("\r\n");
            if (errorMsg.length() > 1000) break;
        }
        if (errorMsg.length() > 1000) {
            return errorMsg.substring(0, 1000);
        }
        return errorMsg.toString();
    }
}

