/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.share;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import org.apache.commons.collections.CollectionUtils;

public class ReportShareService {
    private static final Log LOGGER = LogFactory.getLog(ReportShareService.class);
    private static final String entityNumber = "hrptmc_sharerecord";
    private final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_sharerecord");

    public static ReportShareService getInstance() {
        return Instance.INSTANCE;
    }

    public DynamicObject[] queryShareData(Long reportId, Date startTime, Date endTime) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(new QFilter("report", "=", (Object)reportId));
        qFilterList.add(new QFilter("esindex", "!=", (Object)Character.valueOf(' ')));
        if (startTime != null) {
            qFilterList.add(new QFilter("createtime", ">=", (Object)startTime));
        }
        if (endTime != null) {
            qFilterList.add(new QFilter("createtime", "<=", (Object)endTime));
        }
        return this.serviceHelper.queryOriginalArray("id,reportname,createtime,shareuser.name,esindex,count", qFilterList.toArray(new QFilter[0]));
    }

    public void clearEsIdx(Set<Long> pkSet) {
        LOGGER.info("clearEsIdx pkSet:{}", pkSet);
        if (CollectionUtils.isEmpty(pkSet)) {
            return;
        }
        DynamicObject[] dynamicObjects = this.serviceHelper.query("id,modifier,modifytime,esindex,errormsg", new QFilter[]{new QFilter("id", "in", pkSet)});
        if (dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("esindex", (Object)" ");
            HRBaseUtils.setModifyField((DynamicObject)dynamicObject);
            dynamicObject.set("errormsg", (Object)("clear;" + dynamicObject.getString("errormsg")));
        }
        this.serviceHelper.update(dynamicObjects);
    }

    public List<Long> queryShareRefAllReportId() {
        String sql = "select distinct freportid from t_hrptmc_sharerecord";
        return (List)HRDBUtil.query((DBRoute)DBRoute.of((String)"hmp"), (String)sql, null, rs -> {
            ArrayList<Long> reportList = new ArrayList<Long>(10);
            while (rs.next()) {
                reportList.add(rs.getLong("freportid"));
            }
            return reportList;
        });
    }

    private static class Instance {
        private static final ReportShareService INSTANCE = new ReportShareService();

        private Instance() {
        }
    }
}

