/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.share;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.EsCommonUtils;
import kd.hr.hrptc.business.datastore.AbstractCenterDataStoreService;
import kd.hr.hrptc.business.servicehelper.ScheduleTaskServiceHelper;
import kd.hr.hrptc.common.constant.share.ReportShareConstants;

public class ShareReportDataStoreService
extends AbstractCenterDataStoreService
implements ReportShareConstants {
    private final HRBaseServiceHelper shareHelper = new HRBaseServiceHelper("hrptmc_sharerecord");
    private final Long shareId;
    private final DynamicObject shareDy;
    private List<String> stopKeyList = null;

    public ShareReportDataStoreService(Long reportId, Long shareId, DynamicObject shareDy, QFilter permissionQFilter, Map<String, QFilter> f7PermissionQFilter) {
        super(reportId, permissionQFilter, f7PermissionQFilter);
        this.shareId = shareId;
        this.shareDy = shareDy;
    }

    @Override
    protected String generateEsIndex() {
        return EsCommonUtils.getIndexNamePrefix((String)"hr") + "_" + "share" + "_" + this.report.getString("number").toLowerCase(Locale.ROOT) + "_" + System.currentTimeMillis();
    }

    @Override
    protected String generateBaseDataEsIndex(String esIndex) {
        return esIndex + "_basedata";
    }

    @Override
    protected void endExecute() {
        Date date = new Date();
        List<String> stopKeyList = this.getStopKeyList();
        if (this.shareDy != null) {
            for (String stopKey : stopKeyList) {
                if (ScheduleTaskServiceHelper.isStop(stopKey)) {
                    this.shareDy.set("runstatus", (Object)"4");
                    ScheduleTaskServiceHelper.removeStopCache(stopKey);
                } else {
                    this.shareDy.set("runstatus", (Object)"3");
                    this.shareDy.set("esindex", (Object)this.esIndex);
                }
                this.shareDy.set("endtime", (Object)date);
            }
            this.shareHelper.saveOne(this.shareDy);
        }
    }

    @Override
    protected List<String> getStopKeyList() {
        if (this.stopKeyList == null) {
            this.stopKeyList = Lists.newArrayListWithExpectedSize((int)1);
            String stopKey = ScheduleTaskServiceHelper.getStopKey(this.shareId, true);
            this.stopKeyList.add(stopKey);
        }
        return this.stopKeyList;
    }

    @Override
    protected void writeCount(int count) {
        super.writeCount(count);
        this.shareDy.set("count", (Object)count);
    }
}

