/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.business.subscribe.ReportMySubscribeService;
import kd.hr.hrptc.business.subscribe.ReportSubscribeConfigService;
import kd.hr.hrptc.business.task.SubscribeScheduleTaskService;
import kd.hr.hrptc.common.constant.subscribe.ReportSubscribeConstants;
import kd.hr.hrptc.common.model.subscribe.ReportMySubscribeBo;
import kd.hr.hrptc.common.model.subscribe.ReportSubscribeConfigBo;

public class ReportSubscribeTask
extends AbstractTask
implements ReportSubscribeConstants {
    private static final Log LOGGER = LogFactory.getLog(ReportSubscribeTask.class);
    private final ReportSubscribeConfigService subscribeService = new ReportSubscribeConfigService();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("ReportSubscribeTask execute params: {}", map);
        String reportIdStr = (String)map.get("reportId");
        String cycle = (String)map.get("cycle");
        String cron = (String)map.get("cron");
        String cronLast = (String)map.get("cronLast");
        long reportId = Long.parseLong(reportIdStr);
        if (HRStringUtils.isEmpty((String)cycle) || HRStringUtils.isEmpty((String)cron)) {
            String userIdStr = (String)map.get("userId");
            long userId = Long.parseLong(userIdStr);
            this.executeForReportAndUser(reportId, userId);
        } else {
            this.execute(reportId, cycle, cron, cronLast);
        }
    }

    private void execute(long reportId, String cycle, String cron, String cronLast) {
        try {
            Date now = new Date();
            List<ReportSubscribeConfigBo> reportSubscribeConfigs = this.subscribeService.getReportSubscribeConfigs(reportId, cycle, cron, cronLast);
            OrmLocaleValue reportName = this.subscribeService.getReportName(reportId);
            ArrayList reportMySubscribeBoList = Lists.newArrayListWithExpectedSize((int)reportSubscribeConfigs.size());
            for (ReportSubscribeConfigBo reportSubscribeConfig : reportSubscribeConfigs) {
                ReportMySubscribeBo mySubscribeBo = this.generateMySubscribe(reportName, reportSubscribeConfig, now);
                reportMySubscribeBoList.add(mySubscribeBo);
            }
            ReportMySubscribeService mySubscribeService = new ReportMySubscribeService();
            mySubscribeService.saveMySubscribeBoList(reportMySubscribeBoList);
            List<Long> subscribeConfigIds = reportSubscribeConfigs.stream().map(ReportSubscribeConfigBo::getId).collect(Collectors.toList());
            this.callService(reportId, subscribeConfigIds);
        }
        catch (Exception exception) {
            LOGGER.error("ReportSubscribeTask execute error: ", (Throwable)exception);
        }
    }

    private void executeForReportAndUser(long reportId, long userId) {
        try {
            Date now = new Date();
            ReportSubscribeConfigBo reportSubscribeConfig = this.subscribeService.getReportSubscribeConfig(reportId, userId);
            OrmLocaleValue reportName = this.subscribeService.getReportName(reportId);
            ReportMySubscribeService mySubscribeService = new ReportMySubscribeService();
            mySubscribeService.saveMySubscribeBo(this.generateMySubscribe(reportName, reportSubscribeConfig, now));
            ArrayList subscribeIds = Lists.newArrayListWithCapacity((int)10);
            subscribeIds.add(reportSubscribeConfig.getId());
            this.callService(reportId, subscribeIds);
        }
        catch (Exception exception) {
            LOGGER.error("ReportSubscribeTask executeForReportAndUser error: ", (Throwable)exception);
        }
    }

    private void callService(long reportId, List<Long> subscribeIds) {
        SubscribeScheduleTaskService scheduleTaskService = new SubscribeScheduleTaskService();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        paramMap.put("reportId", reportId);
        paramMap.put("subscribeId", subscribeIds);
        scheduleTaskService.execute(paramMap);
    }

    private ReportMySubscribeBo generateMySubscribe(OrmLocaleValue reportName, ReportSubscribeConfigBo reportSubscribeConfig, Date now) {
        LocaleString subscribeName = new LocaleString();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String dateStr = dateFormat.format(new Date());
        for (String loId : reportName.keySet()) {
            subscribeName.put(loId, (Object)(reportName.get((Object)loId) + "_" + dateStr));
        }
        ReportMySubscribeBo mySubscribeBo = new ReportMySubscribeBo();
        mySubscribeBo.setId(Long.valueOf(ID.genLongId()));
        mySubscribeBo.setSubscribeName(subscribeName);
        mySubscribeBo.setSubscribeRecord(reportSubscribeConfig);
        mySubscribeBo.setSubscribeUserId(reportSubscribeConfig.getUserId());
        mySubscribeBo.setSubscribeTime(now);
        mySubscribeBo.setTraceId(RequestContext.get().getTraceId());
        mySubscribeBo.setStartTime(new Date());
        mySubscribeBo.setRunStatus("0");
        mySubscribeBo.setReportId(reportSubscribeConfig.getReportId());
        mySubscribeBo.setCycle(reportSubscribeConfig.getCycle());
        return mySubscribeBo;
    }
}

