/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hrptc.business.datastore.SubscribeDataStoreService;
import kd.hr.hrptc.business.servicehelper.ReportCenterServiceHelper;
import kd.hr.hrptc.business.servicehelper.ScheduleTaskServiceHelper;
import kd.hr.hrptc.common.constant.subscribe.ReportSubscribeConstants;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.repdesign.RptPermService;

public class SubscribeScheduleTaskService
implements ReportSubscribeConstants {
    private static final Log LOGGER = LogFactory.getLog(SubscribeScheduleTaskService.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"SubscribeScheduleTaskService#20240715", (int)3);

    public void execute(Map<String, Object> map) {
        THREAD_POOL.execute(() -> {
            block5: {
                DynamicObject[] tasks = null;
                try {
                    Long reportId = (Long)map.get("reportId");
                    List subscribeIdList = (List)map.get("subscribeId");
                    tasks = this.getTasks(subscribeIdList);
                    if (tasks.length != 0) {
                        String traceId = RequestContext.get().getTraceId();
                        for (DynamicObject task : tasks) {
                            task.set("runstatus", (Object)"5");
                            task.set("traceid", (Object)traceId);
                        }
                        HashMap userFilterMap = Maps.newHashMapWithExpectedSize((int)tasks.length);
                        HashMap userF7FilterMap = Maps.newHashMapWithExpectedSize((int)tasks.length);
                        for (DynamicObject task : tasks) {
                            userFilterMap.put(task.getLong("user.id"), null);
                            userF7FilterMap.put(task.getLong("user.id"), null);
                        }
                        QFilter permissionQFilter = this.getPermissionQFilter(userFilterMap, reportId);
                        Map<String, QFilter> f7PermissionQFilter = this.getF7PermissionQFilter(userF7FilterMap, reportId);
                        this.setQFilter(reportId, tasks, userFilterMap, userF7FilterMap);
                        ReportCenterServiceHelper.saveTasks(tasks);
                        SubscribeDataStoreService subscribeDataStoreService = new SubscribeDataStoreService(reportId, tasks, permissionQFilter, f7PermissionQFilter);
                        subscribeDataStoreService.execute();
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("SubscribeScheduleTaskService_execute_error:", (Throwable)ex);
                    if (tasks == null) break block5;
                    this.writeErrorLog(tasks, ex);
                }
            }
        });
    }

    private void setQFilter(long reportId, DynamicObject[] tasks, Map<Long, QFilter> userFilterMap, Map<Long, Map<String, QFilter>> userF7FilterMap) {
        for (DynamicObject task : tasks) {
            long userId = task.getLong("user.id");
            QFilter qFilter = userFilterMap.get(userId);
            Map<String, QFilter> stringQFilterMap = userF7FilterMap.get(userId);
            if (qFilter != null) {
                task.set("dataqfilter", (Object)qFilter.toSerializedString());
            }
            if (stringQFilterMap != null) {
                HashMap serialMap = Maps.newHashMapWithExpectedSize((int)stringQFilterMap.size());
                for (Map.Entry<String, QFilter> entry : stringQFilterMap.entrySet()) {
                    QFilter value = entry.getValue();
                    if (value == null) continue;
                    serialMap.put(entry.getKey(), value.toSerializedString());
                }
                task.set("f7qfilter", (Object)SerializationUtils.toJsonString((Object)serialMap));
            }
            this.setAdminOrgF7QFilter(reportId, userId, stringQFilterMap, task);
        }
    }

    private void setAdminOrgF7QFilter(long reportId, long userId, Map<String, QFilter> f7QFilterMap, DynamicObject task) {
        if (f7QFilterMap == null) {
            return;
        }
        ArrayList<String> fieldAliasList = new ArrayList<String>(f7QFilterMap.keySet());
        Map fieldIdMap = AnalyseObjectService.getInstance().queryAdminOrgFieldIdByFieldAlias(reportId, fieldAliasList);
        if (fieldIdMap.isEmpty()) {
            return;
        }
        boolean isSuperUser = PermissionServiceHelper.isSuperUser((long)userId);
        HashMap adminOrgF7QFilterMap = Maps.newHashMapWithExpectedSize((int)16);
        fieldIdMap.forEach((fieldAlias, fieldId) -> {
            LOGGER.info("getReportCenterF7PermQFilters getAdminOrgStruct userId = {},reportId = {},fieldId = {}", new Object[]{userId, reportId, fieldId});
            ArrayList structIds = !isSuperUser ? Lists.newArrayList((Iterable)RptPermService.getStructIds((long)userId, (long)reportId, (long)fieldId)) : Lists.newArrayListWithExpectedSize((int)0);
            HashMap structQFilter = Maps.newHashMapWithExpectedSize((int)structIds.size());
            for (Long structId : structIds) {
                if (isSuperUser) continue;
                QFilter qFilter = RptPermService.getQueryFieldPerm((long)userId, (long)Long.parseLong(String.valueOf(reportId)), (long)Long.parseLong(String.valueOf(fieldId)), (long)structId);
                LOGGER.info("getReportCenterF7PermQFilters getQueryFieldPerm qFilter={}", (Object)qFilter);
                if (qFilter == null) continue;
                structQFilter.put(structId, qFilter.toSerializedString());
            }
            adminOrgF7QFilterMap.put(fieldAlias, structQFilter);
        });
        LOGGER.info("ReportShareConfigService getReportCenterF7PermQFilters adminorg: {}", (Object)adminOrgF7QFilterMap);
        if (!adminOrgF7QFilterMap.isEmpty()) {
            task.set("admorgf7qfilter", (Object)SerializationUtils.toJsonString((Object)adminOrgF7QFilterMap));
        }
    }

    private QFilter getPermissionQFilter(Map<Long, QFilter> userFilterMap, Long reportId) {
        QFilter qFilter = null;
        for (Map.Entry<Long, QFilter> entry : userFilterMap.entrySet()) {
            QFilter rptPerm = RptPermService.getRptPerm((long)entry.getKey(), (long)reportId);
            if (qFilter != null && rptPerm != null) {
                qFilter.or(rptPerm);
            } else {
                qFilter = rptPerm;
            }
            userFilterMap.put(entry.getKey(), rptPerm);
        }
        return qFilter;
    }

    private Map<String, QFilter> getF7PermissionQFilter(Map<Long, Map<String, QFilter>> userF7FilterMap, Long reportId) {
        Map qFilterMap = null;
        for (Map.Entry<Long, Map<String, QFilter>> entry : userF7FilterMap.entrySet()) {
            Map queryFieldPerm = RptPermService.getQueryFieldPerm((long)entry.getKey(), (long)reportId);
            if (qFilterMap != null) {
                for (Map.Entry permFilterEntry : queryFieldPerm.entrySet()) {
                    QFilter qFilter = (QFilter)qFilterMap.get(permFilterEntry.getKey());
                    if (qFilter != null) {
                        qFilter.or((QFilter)permFilterEntry.getValue());
                    } else {
                        qFilter = (QFilter)permFilterEntry.getValue();
                    }
                    qFilterMap.put(permFilterEntry.getKey(), qFilter);
                }
            } else {
                qFilterMap = queryFieldPerm;
            }
            userF7FilterMap.put(entry.getKey(), queryFieldPerm);
        }
        return qFilterMap;
    }

    private DynamicObject[] getTasks(List<Long> subscribeIdList) {
        QFilter[] qFilters = new QFilter[]{new QFilter("subscriberecord.id", "in", subscribeIdList), new QFilter("runstatus", "=", (Object)"0")};
        return ReportCenterServiceHelper.SUBSCRIBE_TASK_HELPER.query("id,subscriberecord,user,esindex,runstatus,createtime,starttime,endtime,errormsg,count,traceid,dataqfilter,f7qfilter,admorgf7qfilter", qFilters, "createtime asc");
    }

    private void writeErrorLog(DynamicObject[] tasks, Exception exception) {
        String errorMsg = ScheduleTaskServiceHelper.getErrorMsg(exception);
        Date date = new Date();
        for (DynamicObject task : tasks) {
            task.set("errormsg", (Object)errorMsg);
            task.set("endtime", (Object)date);
            task.set("traceid", (Object)RequestContext.get().getTraceId());
            task.set("runstatus", (Object)"2");
        }
        ReportCenterServiceHelper.saveTasks(tasks);
    }
}

