/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.opplugin.validator.anobj;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjPermRuleService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.util.ReportCommonUtils;

@ExcludeFromJacocoGeneratedReport
public class ReportAnalyseObjectValidator
extends AbstractValidator
implements AnalyseObjectConstants {
    public void validate() {
        RuleValidateInfo info;
        String dataFilter;
        String operation = this.getOperateKey();
        if (!HRStringUtils.equals((String)operation, (String)"save")) {
            return;
        }
        ExtendedDataEntity anObjDy = this.getDataEntities()[0];
        String number = anObjDy.getDataEntity().getString("number");
        this.validateDuplicateName(anObjDy);
        if (ReportCommonUtils.validateNumberByISVIsKD()) {
            if (!number.startsWith("kdhr_")) {
                this.addErrorMessage(anObjDy, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801\u4ee5%s\u5f00\u5934\uff0c\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u4e0e\u4e0b\u5212\u7ebf\u3002", (String)"ReportAnalyseObjectValidator_1", (String)"hrmp-hrptmc-opplugin", (Object[])new Object[0]), "kdhr_"));
            }
        } else if (number.startsWith("kdhr_")) {
            this.addErrorMessage(anObjDy, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801\u7981\u6b62\u4ee5%s\u5f00\u5934\uff0c\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u4e0e\u4e0b\u5212\u7ebf\u3002", (String)"ReportAnalyseObjectValidator_2", (String)"hrmp-hrptmc-opplugin", (Object[])new Object[0]), "kdhr_"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(dataFilter = anObjDy.getDataEntity().getString("datafilter"))) && !(info = RuleValidateUtil.validCondition((String)dataFilter, (boolean)true)).isSuccess()) {
            for (String msg : info.getMsgList()) {
                this.addErrorMessage(anObjDy, msg);
            }
        }
        this.validateFieldRefByReport(anObjDy);
        this.validateFieldRefByAnObjPermRule(anObjDy);
    }

    private void validateDuplicateName(ExtendedDataEntity anObjDy) {
        HRBaseServiceHelper helper;
        ILocaleString name = anObjDy.getDataEntity().getLocaleString("name");
        String objType = anObjDy.getDataEntity().getString("objecttype");
        QFilter qFilter = HRStringUtils.equals((String)objType, (String)"template") ? new QFilter("name", "=", (Object)name.getLocaleValue()).and(new QFilter("objecttype", "=", (Object)"template")) : new QFilter("name", "=", (Object)name.getLocaleValue()).and(new QFilter("objecttype", "!=", (Object)"template"));
        if (anObjDy.getDataEntity().getDataEntityState().getFromDatabase()) {
            qFilter.and(new QFilter("id", "!=", anObjDy.getBillPkId()));
        }
        if ((helper = new HRBaseServiceHelper("hrptmc_analyseobject")).isExists(qFilter)) {
            this.addErrorMessage(anObjDy, ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"ReportAnalyseObjectValidator_5", (String)"hrmp-hrptmc-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateFieldRefByReport(ExtendedDataEntity anObjDy) {
        Long anObjId = (Long)anObjDy.getBillPkId();
        if (anObjId == null || anObjId == 0L) {
            return;
        }
        Set refByReportFieldAliasCollection = AnalyseObjectService.getInstance().getRefByReportFieldAliasCollection(anObjId);
        if (refByReportFieldAliasCollection.isEmpty()) {
            return;
        }
        String queryFieldsStr = this.getOption().getVariableValue("queryFields", "");
        String calFieldsStr = this.getOption().getVariableValue("calculateFields", "");
        String groupFieldStr = this.getOption().getVariableValue("cache_group_fields", "");
        List queryFields = Collections.emptyList();
        List calculatedFields = Collections.emptyList();
        List anObjGroupFields = Collections.emptyList();
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            queryFields = JSON.parseArray((String)queryFieldsStr, QueryFieldBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)calFieldsStr)) {
            calculatedFields = JSON.parseArray((String)calFieldsStr, CalculateFieldBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)groupFieldStr)) {
            anObjGroupFields = JSON.parseArray((String)groupFieldStr, AnObjGroupField.class);
        }
        List pivotIndexList = Lists.newArrayListWithCapacity((int)10);
        String pivotDim = anObjDy.getDataEntity().getString("pivotdim");
        String pivotDimVal = anObjDy.getDataEntity().getString("pivotdimval");
        String pivotIndex = anObjDy.getDataEntity().getString("pivotindex");
        if (HRStringUtils.isNotEmpty((String)pivotIndex)) {
            Set refReportUseFieldAliasList = AnalyseObjectService.getInstance().getRefReportUseFieldAliasList(anObjId);
            String[] pivotIndexes = pivotIndex.split(",");
            StringBuilder indexSb = new StringBuilder();
            for (String index : pivotIndexes) {
                if (!refReportUseFieldAliasList.contains(index)) continue;
                indexSb.append(index).append(",");
            }
            if (indexSb.length() > 0) {
                this.addErrorMessage(anObjDy, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u5206\u6790\u5bf9\u8c61\u4e0b\u6709\u62a5\u8868\u5f15\u7528\u4e86%s\u6307\u6807\uff0c\u4e0d\u5141\u8bb8\u8f6c\u7f6e\u8be5\u6307\u6807\u3002", (String)"ReportAnalyseObjectValidator_4", (String)"hrmp-hrptmc-opplugin", (Object[])new Object[0]), indexSb.substring(0, indexSb.length() - 1)));
            }
        }
        if (HRStringUtils.isNotEmpty((String)pivotDim) && HRStringUtils.isNotEmpty((String)pivotDimVal) && HRStringUtils.isNotEmpty((String)pivotIndex)) {
            DynamicObject[] anObjPivotDys = AnalyseObjectService.getInstance().queryAnObjPivotDys(anObjId.longValue());
            pivotIndexList = AnalyseObjectService.getInstance().getAnalysePivotIndexes(anObjPivotDys, queryFields, calculatedFields, false);
        }
        for (String refFieldAlias : refByReportFieldAliasCollection) {
            boolean isRef = queryFields.stream().noneMatch(field -> HRStringUtils.equals((String)field.getFieldAlias(), (String)refFieldAlias) || HRStringUtils.equals((String)field.getHRFilterParam(), (String)refFieldAlias)) && calculatedFields.stream().noneMatch(field -> HRStringUtils.equals((String)field.getFieldNumber(), (String)refFieldAlias) && field.getSelected() != false) && pivotIndexList.stream().noneMatch(field -> HRStringUtils.equals((String)field.getFieldAlias(), (String)refFieldAlias)) && anObjGroupFields.stream().noneMatch(field -> HRStringUtils.equals((String)field.getNumber(), (String)refFieldAlias));
            if (!isRef) continue;
            this.addErrorMessage(anObjDy, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u5206\u6790\u5bf9\u8c61\u4e0b\u6709\u62a5\u8868\u5f15\u7528\u4e86%s\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u79fb\u9664\u8be5\u5b57\u6bb5\u3002", (String)"ReportAnalyseObjectValidator_3", (String)"hrmp-hrptmc-opplugin", (Object[])new Object[0]), refFieldAlias));
        }
    }

    private void validateFieldRefByAnObjPermRule(ExtendedDataEntity anObjDy) {
        Long anObjId = (Long)anObjDy.getBillPkId();
        if (anObjId == null || anObjId == 0L) {
            return;
        }
        Map refAnObjFieldAliasMap = AnObjPermRuleService.getInstance().getPermRuleRefAnObjFieldAliasList(anObjId.longValue());
        if (refAnObjFieldAliasMap.isEmpty()) {
            return;
        }
        String queryFieldsStr = this.getOption().getVariableValue("queryFields", "");
        List queryFields = HRStringUtils.isNotEmpty((String)queryFieldsStr) ? JSON.parseArray((String)queryFieldsStr, QueryFieldBo.class) : Collections.emptyList();
        refAnObjFieldAliasMap.forEach((fieldAlias, fieldName) -> {
            boolean isRef = queryFields.stream().noneMatch(field -> HRStringUtils.equals((String)field.getFieldAlias(), (String)fieldAlias));
            if (isRef) {
                this.addErrorMessage(anObjDy, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u63a7\u6743\u89c4\u5219\u5f15\u7528\u4e86%s\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u79fb\u9664\u8be5\u5b57\u6bb5\u3002", (String)"ReportAnalyseObjectValidator_6", (String)"hrmp-hrptmc-opplugin", (Object[])new Object[0]), fieldName));
            }
        });
    }
}

