/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.opplugin.web.repdesign;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.util.MetaDataUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.ruleengine.utils.IDStringUtils;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.business.datastore.metadata.service.RptMetadataService;
import kd.hr.hrptmc.business.filesource.ReportFileSourceService;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.ReportPermissionService;
import kd.hr.hrptmc.business.repdesign.datastore.ReportDataStoreServiceHelper;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.hisversion.ReportHisVersionService;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.AnObjFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.CustomSortInfo;
import kd.hr.hrptmc.business.repdesign.info.DataFormatInfo;
import kd.hr.hrptmc.business.repdesign.info.DimensionFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.DisplaySchemeChangeInfo;
import kd.hr.hrptmc.business.repdesign.info.DisplaySchemeInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.IndexFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBillHeadInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportMarkInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.SubtotalInfo;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.business.repdesign.jump.ReportJumpConfigService;
import kd.hr.hrptmc.business.task.TaskExecuteUtil;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.model.preindex.DimMapBo;
import kd.hr.hrptmc.common.model.preindex.DimMapEntryBo;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.common.model.repdesign.total.ReportTotalColConfigBo;
import kd.hr.hrptmc.opplugin.validator.repdesign.ReportValidator;

public class ReportManageOp
extends HRDataBaseOp
implements AnalyseObjectConstants,
ReportManageConstants {
    private static final Log LOGGER = LogFactory.getLog(ReportManageOp.class);
    private Set<String> langNumSet;
    HRBaseServiceHelper dispScmHelper = new HRBaseServiceHelper("hrptmc_rptdispscm");
    HRBaseServiceHelper rowDispScmHelper = new HRBaseServiceHelper("hrptmc_rptdispscmrow");
    HRBaseServiceHelper colDispScmHelper = new HRBaseServiceHelper("hrptmc_rptdispscmcol");
    HRBaseServiceHelper idxDispScmHelper = new HRBaseServiceHelper("hrptmc_rptdispscmidx");
    HRBaseServiceHelper rptConfigHelper = new HRBaseServiceHelper("hrptmc_reportconfig");
    HRBaseServiceHelper splitDateHelper = new HRBaseServiceHelper("hrptmc_splitdate");
    HRBaseServiceHelper workRptHelper = new HRBaseServiceHelper("hrptmc_workreport");

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("number");
        fieldKeys.add("name");
        fieldKeys.add("row");
        fieldKeys.add("column");
        fieldKeys.add("publishstatus");
        fieldKeys.add("anobjid");
        fieldKeys.add("publishrptstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new ReportValidator());
    }

    /*
     * Unable to fully structure code
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        var2_2 = args.getOperationKey();
        var3_3 = -1;
        switch (var2_2.hashCode()) {
            case 3522941: {
                if (!var2_2.equals("save")) break;
                var3_3 = 0;
                break;
            }
            case -1335458389: {
                if (!var2_2.equals("delete")) break;
                var3_3 = 1;
            }
        }
        switch (var3_3) {
            case 0: {
                required = TX.required();
                var5_6 = null;
                try {
                    this.saveReport(args);
                }
                catch (Exception e) {
                    required.markRollback();
                    ReportManageOp.LOGGER.info(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"ReportManageOp_1", (String)"hrmp-hrptmc-opplugin", (Object[])new Object[0]), (Object)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"ReportManageOp_1", (String)"hrmp-hrptmc-opplugin", (Object[])new Object[0]));
                }
                if (required == null) break;
                if (var5_6 == null) ** GOTO lbl31
                try {
                    required.close();
                }
                catch (Throwable e) {
                    var5_6.addSuppressed(e);
                }
                break;
lbl31:
                // 1 sources

                required.close();
                break;
                catch (Throwable e) {
                    try {
                        var5_6 = e;
                        throw e;
                    }
                    catch (Throwable var7_15) {
                        if (required != null) {
                            if (var5_6 != null) {
                                try {
                                    required.close();
                                }
                                catch (Throwable var8_17) {
                                    var5_6.addSuppressed(var8_17);
                                }
                            } else {
                                required.close();
                            }
                        }
                        throw var7_15;
                    }
                }
            }
            case 1: {
                required = TX.required();
                var5_7 = null;
                try {
                    for (DynamicObject reportManageDy : args.getDataEntities()) {
                        this.deleteReport(reportManageDy);
                    }
                }
                catch (Exception e) {
                    required.markRollback();
                    ReportManageOp.LOGGER.info(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"ReportManageOp_2", (String)"hrmp-hrptmc-opplugin", (Object[])new Object[0]), (Object)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"ReportManageOp_2", (String)"hrmp-hrptmc-opplugin", (Object[])new Object[0]));
                }
                if (required == null) break;
                if (var5_7 == null) ** GOTO lbl69
                try {
                    required.close();
                }
                catch (Throwable var6_13) {
                    var5_7.addSuppressed(var6_13);
                }
                break;
lbl69:
                // 1 sources

                required.close();
                break;
                catch (Throwable var6_14) {
                    try {
                        var5_7 = var6_14;
                        throw var6_14;
                    }
                    catch (Throwable var10_20) {
                        if (required != null) {
                            if (var5_7 != null) {
                                try {
                                    required.close();
                                }
                                catch (Throwable var11_21) {
                                    var5_7.addSuppressed(var11_21);
                                }
                            } else {
                                required.close();
                            }
                        }
                        throw var10_20;
                    }
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        String operationKey = args.getOperationKey();
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            String tableName = this.operateOption.getVariableValue("fileSourceTableName", null);
            ReportFileSourceService.getInstance().clearFileSourceDataForReportSave(tableName, args.getDataEntities()[0]);
        } else if (HRStringUtils.equals((String)operationKey, (String)"delete")) {
            Arrays.stream(args.getDataEntities()).map(reportDy -> reportDy.getDynamicObject("anobjid").getLong("id")).forEach(anObjId -> ReportFileSourceService.getInstance().dropTableAndClearData(anObjId));
        }
    }

    private void deleteReport(DynamicObject reportManageDy) {
        long reportManageId = reportManageDy.getLong("id");
        ReportDataStoreServiceHelper.deleteReportSchedule((long)reportManageId);
        ReportManageService.deleteRows((Long)reportManageId);
        ReportManageService.deleteCols((Long)reportManageId);
        ReportManageService.deleteWorkRpt((Long)reportManageId);
        List rptConfigIds = ReportManageService.getRptConfigId((Long)reportManageId);
        ReportManageService.deleteRptConfig((Long)reportManageId);
        ReportManageService.deleteCalcField((Long)reportManageId);
        ReportManageService.deletePreIdxRef((Long)reportManageId);
        ReportManageService.deleteDimMapRef((Long)reportManageId);
        ReportManageService.deleteFilter((Long)reportManageId);
        ReportManageService.deleteRptQueryConfig((Long)reportManageId);
        ReportManageService.deleteDispScm((long)reportManageId);
        ReportManageService.deleteUserDispScm((long)reportManageId);
        ReportManageService.deleteUserDispScmChg((Long)reportManageId);
        ReportManageService.deleteCustomSort((long)reportManageId);
        ReportManageService.deleteRptComRef((long)reportManageId);
        ReportManageService.deleteReportMark((long)reportManageId);
        AnalyseObjectService.getInstance().removeRefByReportFieldAliasCache(Long.valueOf(reportManageDy.getDynamicObject("anobjid").getLong("id")));
        rptConfigIds.forEach(ReportManageService::deleteAlgorithmCol);
        ReportManageService.deleteSplitDate((long)reportManageId);
        String number = reportManageDy.getString("number");
        if (this.isMetaExist(number)) {
            try (TXHandle ignored = TX.requiresNew();){
                RptMetadataService.getInstance().deleteMetaData(number);
            }
        }
        ReportHisVersionService.getInstance().updateVersionWhenDeleteReport(reportManageId);
        try {
            ReportManageService.deleteReportCenter((long)reportManageId);
            ReportPermissionService.delRptCtrPerm((Long)reportManageId);
        }
        catch (Exception e) {
            LOGGER.error("updateRptCtrPerm fail:", (Throwable)e);
        }
    }

    private boolean isMetaExist(String metaNumber) {
        if (StringUtils.isEmpty((CharSequence)metaNumber)) {
            return false;
        }
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        return metaDataUtil.checkNumber(metaNumber.toLowerCase());
    }

    private DynamicObject genWorkRptDy(long rptManageId, long workRptId, int i, int key, String rowStr, String colStr) {
        DynamicObject workRptDy = this.workRptHelper.generateEmptyDynamicObject();
        workRptDy.set("id", (Object)workRptId);
        workRptDy.set("index", (Object)i);
        workRptDy.set("key", (Object)key);
        workRptDy.set("rptmanage", (Object)rptManageId);
        workRptDy.set("row", (Object)rowStr);
        workRptDy.set("column", (Object)colStr);
        return workRptDy;
    }

    private void saveReport(BeginOperationTransactionArgs args) {
        DynamicObject reportManageDy = args.getDataEntities()[0];
        long reportManageId = reportManageDy.getLong("id");
        if (0L == reportManageId) {
            reportManageId = ORM.create().genLongId("hrptmc_reportmanage");
            reportManageDy.set("id", (Object)reportManageId);
        }
        ArrayList<SortParam> sortParamList = new ArrayList<SortParam>();
        String reportManageStr = this.getOption().getVariableValue("reportManageConfigInfo");
        if (StringUtils.isNotEmpty((CharSequence)reportManageStr)) {
            ReportManageConfigInfo reportManageConfigInfo = (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)reportManageStr, ReportManageConfigInfo.class);
            List workRptInfos = reportManageConfigInfo.getWorkRpt();
            this.saveSplitDate(reportManageConfigInfo.getAssignObj(), reportManageId);
            DynamicObjectCollection workRptColl = new DynamicObjectCollection();
            for (int i = 0; i < workRptInfos.size(); ++i) {
                WorkRptInfo workRptInfo = (WorkRptInfo)workRptInfos.get(i);
                long workRptId = Long.parseLong(workRptInfo.getWorkRptId());
                List rows = workRptInfo.getRows();
                DynamicObjectCollection rowColls = this.saveRows(rows, reportManageId, workRptId);
                String rowStr = SerializationUtils.toJsonString((Object)rows);
                List columns = workRptInfo.getColumns();
                DynamicObjectCollection colColls = this.saveColumns(columns, reportManageId, workRptId);
                String colStr = SerializationUtils.toJsonString((Object)columns);
                workRptColl.add((Object)this.genWorkRptDy(reportManageId, workRptId, i, workRptInfo.getKey(), rowStr, colStr));
                if (i == 0) {
                    reportManageDy.set("row", (Object)rowStr);
                    reportManageDy.set("column", (Object)colStr);
                }
                this.saveDimMap(workRptInfo.getDimMaps(), reportManageId, workRptId);
                this.saveReportConfig(workRptInfo.getReportConfig(), reportManageId, workRptId, rowColls, colColls);
                sortParamList.add(new SortParam(workRptId, workRptInfo.getReportConfig().getLegend(), rows, columns));
            }
            this.deleteWorkRpt(reportManageId, workRptInfos);
            this.workRptHelper.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)reportManageId)});
            this.workRptHelper.save(workRptColl);
            this.saveSort(sortParamList, reportManageId, reportManageConfigInfo.getAssignObj().getQueryFields());
            this.saveCalcIndex(reportManageId, reportManageConfigInfo.getAssignObj().getReportCalFields());
            this.saveFilter(reportManageId, reportManageConfigInfo.getFilter());
            this.savePreIndexRef(reportManageId);
            this.closeEnableScheme(reportManageId, workRptInfos.size() > 1);
            this.logReportConfigHisVersion(reportManageDy, reportManageConfigInfo);
        }
        this.saveReportMark(reportManageId);
        this.updateRptCtrPerm(reportManageId);
        AnalyseObjectService.getInstance().removeRefByReportFieldAliasCache(Long.valueOf(reportManageDy.getDynamicObject("anobjid").getLong("id")));
        String tableName = ReportFileSourceService.getInstance().getTableName(Long.valueOf(reportManageId));
        this.operateOption.setVariableValue("fileSourceTableName", tableName);
    }

    private void logReportConfigHisVersion(DynamicObject reportManageDy, ReportManageConfigInfo reportManageConfigInfo) {
        String originalManageInfoStr = this.getOption().getVariableValue("oriReportManageConfigInfo", null);
        ReportManageConfigInfo originalManageInfo = null;
        if (HRStringUtils.isNotEmpty((String)originalManageInfoStr)) {
            originalManageInfo = (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)originalManageInfoStr, ReportManageConfigInfo.class);
            String originalAnObjDetailInfoStr = this.getOption().getVariableValue("oriAnObjDetailInfo", null);
            if (HRStringUtils.isNotEmpty((String)originalAnObjDetailInfoStr)) {
                AnObjDetailInfo originalAssignObj = (AnObjDetailInfo)SerializationUtils.fromJsonString((String)originalAnObjDetailInfoStr, AnObjDetailInfo.class);
                originalManageInfo.setAssignObj(originalAssignObj);
            }
        }
        String originalReportHeadInfoStr = this.getOption().getVariableValue("orgBillHeadInfo", null);
        ReportBillHeadInfo originalReportHeadInfo = null;
        if (HRStringUtils.isNotEmpty((String)originalReportHeadInfoStr)) {
            originalReportHeadInfo = (ReportBillHeadInfo)SerializationUtils.fromJsonString((String)originalReportHeadInfoStr, ReportBillHeadInfo.class);
        }
        ReportHisVersionService.getInstance().saveReportHisVersionConfigBo(reportManageDy, reportManageConfigInfo, originalManageInfo, originalReportHeadInfo);
    }

    private void updateRptCtrPerm(long rptManageId) {
        try {
            ReportPermissionService.updateRptCtrPerm((long)rptManageId);
        }
        catch (Exception e) {
            LOGGER.error("updateRptCtrPerm fail:", (Throwable)e);
        }
    }

    private void deleteWorkRpt(long reportManageId, List<WorkRptInfo> workRptInfos) {
        DynamicObject[] workRptDys = this.workRptHelper.queryOriginalArray("id", new QFilter[]{new QFilter("rptmanage", "=", (Object)reportManageId)});
        List<Long> oriWorkRptIds = Arrays.stream(workRptDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        List newWorkRptIds = workRptInfos.stream().map(info -> Long.parseLong(info.getWorkRptId())).collect(Collectors.toList());
        oriWorkRptIds.removeAll(newWorkRptIds);
        if (!CollectionUtils.isEmpty(oriWorkRptIds)) {
            this.deleteWorkRpts(oriWorkRptIds);
        }
    }

    private void deleteWorkRpts(List<Long> workRptIds) {
        ReportManageService.deleteRowsByWorkRpts(workRptIds);
        ReportManageService.deleteColsByWorkRpts(workRptIds);
        ReportManageService.deleteDimMapByWorkRpts(workRptIds);
        ReportManageService.deleteRptCfgByWorkRpts(workRptIds);
        ReportManageService.deleteCustomSortByWorkRpts(workRptIds);
        ReportManageService.deleteComRefByWorkRpts(workRptIds);
    }

    private void saveSplitDate(AnObjDetailInfo anObjDetailInfo, long reportManageId) {
        Sets.SetView addSet;
        List dimensionList = anObjDetailInfo.getDimensionList();
        DynamicObject[] splitDateDys = ReportManageService.getSplitDate((long)reportManageId);
        Map<String, DynamicObject> oldSplitMap = Arrays.stream(splitDateDys).collect(Collectors.toMap(dy -> dy.getString("anobjfield.fieldpath") + "!" + dy.getString("number"), dy -> dy));
        Map<String, String> splitKeyList = dimensionList.stream().filter(DimensionFieldInfo::getSplitDateSub).collect(Collectors.toMap(AnObjFieldInfo::getFieldPath, AnObjFieldInfo::getFieldId));
        Sets.SetView deleteSet = Sets.difference(oldSplitMap.keySet(), splitKeyList.keySet());
        if (!CollectionUtils.isEmpty((Collection)deleteSet)) {
            List ids = Arrays.stream(splitDateDys).filter(arg_0 -> ReportManageOp.lambda$saveSplitDate$6((Set)deleteSet, arg_0)).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            ReportManageService.deleteSplitDate(ids);
        }
        if (!CollectionUtils.isEmpty((Collection)(addSet = Sets.difference(splitKeyList.keySet(), oldSplitMap.keySet())))) {
            DynamicObjectCollection coll = new DynamicObjectCollection();
            for (String key : addSet) {
                DynamicObject dy2 = this.splitDateHelper.generateEmptyDynamicObject();
                dy2.set("number", (Object)key.split("!")[1]);
                dy2.set("anobjfield", (Object)splitKeyList.get(key));
                dy2.set("rptmanage", (Object)reportManageId);
                coll.add((Object)dy2);
            }
            ReportManageService.saveSplitDate((DynamicObjectCollection)coll);
        }
    }

    private boolean isVirtualEntity() {
        ReportManageConfigInfo reportManageConfigInfo;
        String reportManageStr = this.getOption().getVariableValue("reportManageConfigInfo");
        if (StringUtils.isNotEmpty((CharSequence)reportManageStr) && null != (reportManageConfigInfo = (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)reportManageStr, ReportManageConfigInfo.class)).getAssignObj()) {
            return reportManageConfigInfo.getAssignObj().getVirtualEntity();
        }
        return false;
    }

    private void handleFieldSort(List<RowFieldInfo> rows, List<FieldInfo> columns, List<QueryFieldBo> queryFields, HRBaseServiceHelper commonHelper, DynamicObjectCollection commonColls) {
        List fieldSortNumbers = ReportManageService.getFieldSortNumbers(rows, columns);
        List fieldSortList = queryFields.stream().filter(qf -> fieldSortNumbers.contains(qf.getFieldAlias())).map(qf -> {
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.setBaseDataNum(qf.getBaseDataNum());
            fieldInfo.setNumber(qf.getFieldAlias());
            return fieldInfo;
        }).collect(Collectors.toList());
        for (FieldInfo fieldInfo : fieldSortList) {
            this.setCommonSort(fieldInfo, commonHelper, commonColls);
        }
    }

    public static void recursive(List<FieldInfo> fields, Consumer<FieldInfo> consumer) {
        if (kd.bos.util.CollectionUtils.isEmpty(fields)) {
            return;
        }
        for (FieldInfo children : fields) {
            consumer.accept(children);
            if (!kd.bos.util.CollectionUtils.isNotEmpty((Collection)children.getFields())) continue;
            ReportManageOp.recursive(children.getFields(), consumer);
        }
    }

    private void saveSort(List<SortParam> sortParamList, long reportManageId, List<QueryFieldBo> queryFields) {
        ThreadPools.executeOnce((String)"reportSaveSortThread", () -> {
            for (SortParam sortParam : sortParamList) {
                this.saveSort(sortParam.getLegend(), sortParam.getRows(), sortParam.getColumns(), reportManageId, sortParam.getWorkRptId(), queryFields);
            }
            try {
                if (this.isVirtualEntity()) {
                    TaskExecuteUtil.syncVirtualCustomSortData((Long)reportManageId);
                    TaskExecuteUtil.syncVirtualCommonSortData((Long)reportManageId);
                } else {
                    TaskExecuteUtil.syncCustomSortData((Long)reportManageId);
                    TaskExecuteUtil.syncCommonSortData((Long)reportManageId);
                }
            }
            catch (Exception e) {
                LOGGER.error("syncCustomSortData fail:", (Throwable)e);
            }
        });
    }

    private void saveSort(List<FieldInfo> legend, List<RowFieldInfo> rows, List<FieldInfo> columns, long reportManageId, long workRptId, List<QueryFieldBo> queryFields) {
        try {
            LOGGER.info("ReportSort save start:{}", (Object)workRptId);
            ReportManageService.deleteCustomSort((long)workRptId);
            HRBaseServiceHelper customHelper = new HRBaseServiceHelper("hrptmc_customsort");
            HRBaseServiceHelper commonHelper = new HRBaseServiceHelper("hrptmc_commonsort");
            DynamicObjectCollection customColls = new DynamicObjectCollection();
            DynamicObjectCollection commonColls = new DynamicObjectCollection();
            for (RowFieldInfo rowFieldInfo : rows) {
                this.setSort(reportManageId, workRptId, rowFieldInfo.getGroupName(), customHelper, commonHelper, customColls, commonColls);
                if (!rowFieldInfo._isMerge()) continue;
                ReportManageOp.recursive(rowFieldInfo._getChildFields(), fieldInfo -> {
                    if ("1".equals(fieldInfo.getType())) {
                        this.setSort(reportManageId, workRptId, (FieldInfo)fieldInfo, customHelper, commonHelper, customColls, commonColls);
                    }
                });
            }
            for (FieldInfo fieldInfo2 : columns) {
                this.setSort(reportManageId, workRptId, fieldInfo2, customHelper, commonHelper, customColls, commonColls);
            }
            this.handleFieldSort(rows, columns, queryFields, commonHelper, commonColls);
            if (!CollectionUtils.isEmpty(legend)) {
                for (FieldInfo fieldInfo2 : legend) {
                    this.setSort(reportManageId, workRptId, fieldInfo2, customHelper, commonHelper, customColls, commonColls);
                }
            }
            customHelper.save(customColls);
            Object[] pks = this.saveCommonSort(commonHelper, commonColls);
            if (null != pks) {
                List newComSortId = Arrays.stream(pks).map(dy -> ((DynamicObject)dy).getLong("id")).collect(Collectors.toList());
                ReportManageService.saveRptComRef((long)reportManageId, (long)workRptId, newComSortId);
            }
            LOGGER.info("ReportSort save end:{}", (Object)workRptId);
        }
        catch (Exception e) {
            LOGGER.error("ReportSort save error:{}", (Object)workRptId, (Object)e);
        }
    }

    private Object[] saveCommonSort(HRBaseServiceHelper commonHelper, DynamicObjectCollection commonColls) {
        if (commonColls.isEmpty()) {
            return null;
        }
        QFilter qFilter = null;
        for (DynamicObject dy2 : commonColls) {
            QFilter tempQFilter = new QFilter("entitynumber", "=", dy2.get("entitynumber")).and("entityfield", "=", dy2.get("entityfield")).and("locale", "=", dy2.get("locale"));
            if (null == qFilter) {
                qFilter = tempQFilter;
                continue;
            }
            qFilter = qFilter.or(tempQFilter);
        }
        DynamicObject[] commonDys = commonHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        Map<String, Long> idMap = Arrays.stream(commonDys).collect(Collectors.toMap(this::genKey, dy -> dy.getLong("id"), (x, y) -> x));
        for (DynamicObject dy3 : commonColls) {
            String id = this.genKey(dy3);
            if (!idMap.containsKey(id)) continue;
            dy3.set("id", (Object)idMap.get(id));
        }
        commonHelper.deleteByFilter(new QFilter[]{qFilter});
        return commonHelper.save(commonColls);
    }

    private String genKey(DynamicObject dy) {
        return dy.getString("entitynumber") + "!" + dy.getString("entityfield") + "!" + dy.getString("locale");
    }

    private void setSort(long reportManageId, long workRptId, FieldInfo fieldInfo, HRBaseServiceHelper customHelper, HRBaseServiceHelper commonHelper, DynamicObjectCollection customColls, DynamicObjectCollection commonColls) {
        if (SortEnum.CUSTOM.getValue().equals(fieldInfo.getSort())) {
            this.setCustomSort(fieldInfo, reportManageId, workRptId, customHelper, customColls);
        } else if (!SortEnum.NONE.getValue().equals(fieldInfo.getSort())) {
            this.setCommonSort(fieldInfo, commonHelper, commonColls);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void setCustomSort(FieldInfo fieldInfo, long reportManageId, long workRptId, HRBaseServiceHelper customHelper, DynamicObjectCollection customColls) {
        CustomSortInfo customSortInfo = fieldInfo.getCustomSort();
        DynamicObject customSortDy = customHelper.generateEmptyDynamicObject();
        customSortDy.set("rptmanage", (Object)reportManageId);
        customSortDy.set("workrpt", (Object)workRptId);
        customSortDy.set("rptfieldid", (Object)(fieldInfo.getRowFieldId() == null ? 0L : Long.parseLong(fieldInfo.getRowFieldId())));
        customSortDy.set("entitynumber", (Object)customSortInfo.getEntityNumber());
        customSortDy.set("entityfield", (Object)customSortInfo.getField());
        customSortDy.set("fieldtype", (Object)customSortInfo.getFieldType());
        customSortDy.set("valuetype", (Object)customSortInfo.getValueType());
        this.setCustomSortEntry(customSortDy, customSortInfo);
        customColls.add((Object)customSortDy);
    }

    @ExcludeFromJacocoGeneratedReport
    private void setCommonSort(FieldInfo fieldInfo, HRBaseServiceHelper commonHelper, DynamicObjectCollection commonColls) {
        block2: {
            String field;
            Set<String> langNumSet;
            String entityNumber;
            block4: {
                block3: {
                    String string = entityNumber = StringUtils.isNotEmpty((CharSequence)fieldInfo.getBaseDataNum()) ? fieldInfo.getBaseDataNum() : fieldInfo.getEntityNumber();
                    if (!StringUtils.isNotEmpty((CharSequence)entityNumber)) break block2;
                    langNumSet = this.getLangNumSet();
                    String number = fieldInfo.getNumber();
                    String string2 = field = number.contains(".") ? number.substring(number.lastIndexOf(".") + 1) : number;
                    if (!"name".equals(field)) break block3;
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                    String valueType = this.getValueType(mainEntityType.getPrimaryKey().getPropertyType().getTypeName());
                    for (String lang : langNumSet) {
                        DynamicObject commonSortDy = this.genCommonSortDy(commonHelper, lang, entityNumber, "basedata", valueType, field);
                        commonColls.add((Object)commonSortDy);
                    }
                    break block2;
                }
                if (!"number".equals(field)) break block4;
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                String valueType = this.getValueType(mainEntityType.getPrimaryKey().getPropertyType().getTypeName());
                DynamicObject commonSortDy = this.genCommonSortDy(commonHelper, RequestContext.get().getLang().name(), entityNumber, "basedata", valueType, field);
                commonColls.add((Object)commonSortDy);
                break block2;
            }
            if (!HRStringUtils.equals((String)fieldInfo.getControlType(), (String)FieldControlType.COMBO.getValue()) && !HRStringUtils.equals((String)fieldInfo.getControlType(), (String)FieldControlType.MUL_COMBO.getValue())) break block2;
            for (String lang : langNumSet) {
                DynamicObject commonSortDy = this.genCommonSortDy(commonHelper, lang, entityNumber, "enum", "string", field);
                commonColls.add((Object)commonSortDy);
            }
        }
    }

    private DynamicObject genCommonSortDy(HRBaseServiceHelper commonHelper, String lang, String entityNumber, String fieldType, String valueType, String field) {
        DynamicObject commonSortDy = commonHelper.generateEmptyDynamicObject();
        commonSortDy.set("locale", (Object)lang);
        commonSortDy.set("entitynumber", (Object)entityNumber);
        commonSortDy.set("fieldtype", (Object)fieldType);
        commonSortDy.set("valuetype", (Object)valueType);
        commonSortDy.set("entityfield", (Object)field);
        return commonSortDy;
    }

    private String getValueType(String type) {
        return "long".equals(type) ? "long" : "string";
    }

    private void setCustomSortEntry(DynamicObject customSortDy, CustomSortInfo customSortInfo) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_customsort");
        DynamicObjectCollection customSortEntryCol = helper.generateEmptyEntryCollection(customSortDy, "entryentity");
        boolean isString = "string".equals(customSortInfo.getValueType());
        for (int i = 0; i < customSortInfo.getValue().size(); ++i) {
            DynamicObject customSortEntryDy = helper.generateEmptyEntryDynamicObject("entryentity");
            customSortEntryDy.set("seq", (Object)(customSortInfo.getValue().size() - i));
            if (isString) {
                customSortEntryDy.set("string", customSortInfo.getValue().get(i));
            } else {
                customSortEntryDy.set("long", (Object)Long.parseLong((String)customSortInfo.getValue().get(i)));
            }
            customSortEntryCol.add((Object)customSortEntryDy);
        }
    }

    private void saveFilter(long reportManageId, List<FilterBo> filterBos) {
        DynamicObject[] queryFilters = ReportManageService.queryFilter((Long)reportManageId);
        ArrayList longList = Lists.newArrayListWithExpectedSize((int)6);
        DynamicObject[] splitDates = ReportManageService.getSplitDate((long)reportManageId);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_filter");
        DynamicObjectCollection filterColl = new DynamicObjectCollection();
        long[] colIds = ORM.create().genLongIds("hrptmc_colfield", filterBos.size());
        for (int i = 0; i < filterBos.size(); ++i) {
            FilterBo filterBo = filterBos.get(i);
            DynamicObject colDy = helper.generateEmptyDynamicObject();
            String fieldPath = filterBo.getFieldPath();
            if (HRStringUtils.isNotEmpty((String)fieldPath) && fieldPath.contains("!")) {
                String[] stringArray = fieldPath.split("!");
                String type = stringArray[1];
                for (DynamicObject splitDate : splitDates) {
                    String number = splitDate.getString("number");
                    String anObjField = splitDate.getString("anobjfield.id");
                    if (!HRStringUtils.equals((String)filterBo.getFieldId(), (String)anObjField) || !HRStringUtils.equals((String)number, (String)type)) continue;
                    colDy.set("splitdate", splitDate.get("id"));
                    break;
                }
            }
            for (DynamicObject queryFilter : queryFilters) {
                long anoBjFieldId = queryFilter.getLong("anobjfield_id");
                long splitDateId = queryFilter.getLong("splitdate_id");
                if (HRStringUtils.isNotEmpty((String)fieldPath) && fieldPath.contains("!")) {
                    long id = colDy.getLong("splitdate");
                    if (id != splitDateId) continue;
                    colDy = queryFilter;
                    longList.add(queryFilter.getLong("id"));
                    break;
                }
                if (!HRStringUtils.equals((String)String.valueOf(anoBjFieldId), (String)filterBo.getFieldId()) || splitDateId != 0L) continue;
                colDy = queryFilter;
                longList.add(queryFilter.getLong("id"));
                break;
            }
            if (colDy.getLong("id") == 0L) {
                colDy.set("id", (Object)colIds[i]);
            }
            colDy.set("ismust", (Object)(filterBo.getMustInput() ? "1" : "0"));
            colDy.set("basedataismul", (Object)(filterBo.getBaseDataMul() ? "1" : "0"));
            colDy.set("datescope", (Object)filterBo.getDateScope());
            colDy.set("quickscope", (Object)filterBo.getQuickScope());
            colDy.set("datetype", (Object)filterBo.getDateType());
            colDy.set("enable", (Object)(filterBo.getEnable() ? "1" : "0"));
            colDy.set("filtertype", (Object)filterBo.getFilterType());
            colDy.set("hisdate", (Object)filterBo.getHisDate());
            colDy.set("hisscope", (Object)(filterBo.getHisData() ? "1" : "0"));
            colDy.set("orglevel", (Object)(filterBo.getOrgLevel() ? "1" : "0"));
            colDy.set("rptmanage", (Object)reportManageId);
            colDy.set("suborg", (Object)filterBo.getContainSub());
            colDy.set("index", (Object)filterBo.getIndex());
            colDy.set("name", (Object)filterBo.getFilterAlias());
            colDy.set("anobjfield", (Object)this.parseFieldId(filterBo.getFieldId()));
            colDy.set("groupdate", (Object)(filterBo.getGroupDate() ? "1" : "0"));
            colDy.set("begindate", (Object)filterBo.getBeginDateId());
            colDy.set("enddate", (Object)filterBo.getEndDateId());
            colDy.set("textdefaultvalue", (Object)filterBo.getTextDefaultValue());
            colDy.set("textfilterrange", (Object)filterBo.getTextFilterRange());
            colDy.set("datefiltertype", (Object)filterBo.getDateFilterType());
            colDy.set("datefiltertext", (Object)filterBo.getDateFilterText());
            try {
                String string = filterBo.getFilterStartDateStr();
                String filterEndDateStr = filterBo.getFilterEndDateStr();
                if (HRStringUtils.isNotEmpty((String)string)) {
                    Date filterStartDate = HRDateTimeUtils.parseDate((String)string);
                    colDy.set("filterstartdate", (Object)filterStartDate);
                }
                if (HRStringUtils.isNotEmpty((String)filterEndDateStr)) {
                    Date filterEndDate = HRDateTimeUtils.parseDate((String)filterEndDateStr);
                    colDy.set("filterenddate", (Object)filterEndDate);
                }
            }
            catch (ParseException parseException) {
                LOGGER.error((Throwable)parseException);
            }
            colDy.set("bddefaultvalue", (Object)filterBo.getBdDefaultValue());
            colDy.set("bdfilterrange", (Object)filterBo.getBdFilterRange());
            colDy.set("groupfield", (Object)filterBo.getGroupFieldId());
            colDy.set("isgroupfield", (Object)filterBo.getGroupField());
            colDy.set("opt", (Object)filterBo.getOpt());
            filterColl.add((Object)colDy);
        }
        ReportManageService.deleteFilterByQFilters((Long)reportManageId, (List)longList);
        helper.save(filterColl);
    }

    private static String getNameByAlias(FilterBo filterBo) {
        LocaleString filterAlias = filterBo.getFilterAlias();
        return (String)filterAlias.get((Object)RequestContext.get().getLang().name());
    }

    private void saveCalcIndex(long reportManageId, List<CalculateFieldBo> calculateFieldBos) {
        CalculateFieldService.getInstance().saveCalculateFieldForReport(true, Long.valueOf(reportManageId), calculateFieldBos);
    }

    private void saveReportConfig(ReportConfigInfo reportConfigInfo, long reportManageId, long workRptId, DynamicObjectCollection rowColls, DynamicObjectCollection colColls) {
        DynamicObject reportConfigDy = ReportManageService.getRptConfigNotNull((Long)workRptId);
        reportConfigDy.set("type", (Object)reportConfigInfo.getType());
        reportConfigDy.set("total", (Object)reportConfigInfo.getTotal());
        reportConfigDy.set("totalname", (Object)reportConfigInfo.getTotalName());
        SubtotalInfo subtotalInfo = reportConfigInfo.getSubtotal();
        if (subtotalInfo.getSubtotal()) {
            List fields = subtotalInfo.getFields();
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                boolean isRowExist = false;
                FieldInfo next = (FieldInfo)iterator.next();
                for (DynamicObject row : rowColls) {
                    if (!StringUtils.equals((CharSequence)row.getString("numberalias"), (CharSequence)next.getNumberAlias())) continue;
                    next.setRowFieldId(row.getString("id"));
                    isRowExist = true;
                    break;
                }
                if (isRowExist) continue;
                iterator.remove();
            }
            reportConfigDy.set("subtotalfield", (Object)ReportManageOp.getSubTotalIds((MulBasedataDynamicObjectCollection)reportConfigDy.getDynamicObjectCollection("subtotalfield"), fields));
            reportConfigDy.set("subtotalname", (Object)subtotalInfo.getName());
        } else {
            reportConfigDy.set("subtotalfield", null);
        }
        reportConfigDy.set("subtotal", (Object)subtotalInfo.getSubtotal());
        this.saveRowAlgorithm(reportConfigInfo, reportConfigDy);
        reportConfigDy.set("page", (Object)reportConfigInfo.getPage());
        reportConfigDy.set("showseq", (Object)reportConfigInfo.getShowSeq());
        reportConfigDy.set("mergecell", (Object)reportConfigInfo.getMergeCell());
        reportConfigDy.set("freeze", (Object)this.getFreeze(reportConfigInfo));
        this.saveDisplayScheme(reportManageId, workRptId, reportConfigInfo.getDisplaySchemeInfo(), rowColls, colColls);
        if (null != reportConfigInfo.getHeaderMerge()) {
            reportConfigDy.set("headermerge", (Object)SerializationUtils.toJsonString((Object)reportConfigInfo.getHeaderMerge()));
        } else {
            reportConfigDy.set("headermerge", null);
        }
        if (null != reportConfigInfo.getRowColTransposition()) {
            reportConfigDy.set("rowcoltransposition", (Object)SerializationUtils.toJsonString((Object)reportConfigInfo.getRowColTransposition()));
        } else {
            reportConfigDy.set("rowcoltransposition", null);
        }
        reportConfigDy.set("rptmanage", (Object)reportManageId);
        reportConfigDy.set("workrpt", (Object)workRptId);
        this.saveLastStyle(reportConfigInfo, reportConfigDy);
        reportConfigDy.set("rowadvancesort", CollectionUtils.isEmpty((Collection)reportConfigInfo.getAdvanceSortRowList()) ? null : SerializationUtils.toJsonString((Object)reportConfigInfo.getAdvanceSortRowList()));
        reportConfigDy.set("coladvancesort", CollectionUtils.isEmpty((Collection)reportConfigInfo.getAdvanceSortColList()) ? null : SerializationUtils.toJsonString((Object)reportConfigInfo.getAdvanceSortColList()));
        reportConfigDy.set("showdatalabel", (Object)reportConfigInfo.getShowDataLabel());
        reportConfigDy.set("categoryname", (Object)reportConfigInfo.getCategoryName());
        reportConfigDy.set("categoryunit", (Object)reportConfigInfo.getCategoryUnit());
        reportConfigDy.set("valuename", (Object)reportConfigInfo.getValueName());
        reportConfigDy.set("valueunit", (Object)reportConfigInfo.getValueUnit());
        reportConfigDy.set("legend", CollectionUtils.isEmpty((Collection)reportConfigInfo.getLegend()) ? null : SerializationUtils.toJsonString((Object)reportConfigInfo.getLegend()));
        DynamicObject rptConfigDy = (DynamicObject)new HRBaseServiceHelper("hrptmc_reportconfig").saveOne(reportConfigDy);
        this.saveColAlgorithm(reportConfigInfo.getAlgorithmCol(), rptConfigDy.getLong("id"));
        ReportJumpConfigService.getInstance().saveReportJumpConfig(reportManageId, workRptId, reportConfigInfo.getReportJumpConfigList());
    }

    private void saveColAlgorithm(ReportTotalColConfigBo algorithmColInfo, long rptConfigId) {
        HRBaseServiceHelper algorithmColHelper = new HRBaseServiceHelper("hrptmc_algorithmcol");
        if (algorithmColInfo == null) {
            algorithmColHelper.deleteByFilter(new QFilter[]{new QFilter("rptconfig", "=", (Object)rptConfigId)});
            return;
        }
        DynamicObject algorithmColDy = ReportManageService.getAlgorithmCol((long)rptConfigId);
        if (algorithmColDy == null) {
            algorithmColDy = algorithmColHelper.generateEmptyDynamicObject();
            algorithmColDy.set("rptconfig", (Object)rptConfigId);
        }
        algorithmColDy.set("showlocation", (Object)algorithmColInfo.getShowLocation());
        algorithmColDy.set("total", (Object)algorithmColInfo.getShowTotalCol());
        algorithmColDy.set("totalname", (Object)algorithmColInfo.getTotalColName());
        algorithmColDy.set("subtotal", (Object)algorithmColInfo.getShowSubTotalCol());
        algorithmColDy.set("subtotalname", (Object)algorithmColInfo.getSubTotalColName());
        algorithmColDy.set("dimfield", (Object)algorithmColInfo.getDimField());
        DynamicObjectCollection algorithmTypeColl = algorithmColDy.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)algorithmColInfo.getIndexAlgorithmList())) {
            this.saveAlgorithmType(algorithmColInfo.getIndexAlgorithmList(), algorithmTypeColl, algorithmColHelper, "entryentity");
            algorithmColDy.set("entryentity", (Object)algorithmTypeColl);
        } else {
            algorithmTypeColl.clear();
        }
        algorithmColHelper.saveOne(algorithmColDy);
    }

    @ExcludeFromJacocoGeneratedReport
    private void saveAlgorithmType(List<Map<String, String>> indexAlgorithmList, DynamicObjectCollection algorithmTypeColl, HRBaseServiceHelper algorithmTypeHelper, String entryEntity) {
        if (CollectionUtils.isEmpty(indexAlgorithmList)) {
            algorithmTypeColl.clear();
            return;
        }
        List oldIndexFieldList = algorithmTypeColl.stream().map(dy -> dy.getString("numberalias")).collect(Collectors.toList());
        List newIndexFieldList = indexAlgorithmList.stream().map(map -> (String)map.get("indexField")).collect(Collectors.toList());
        List deleteList = (List)org.apache.commons.collections.CollectionUtils.subtract(oldIndexFieldList, newIndexFieldList);
        List addList = (List)org.apache.commons.collections.CollectionUtils.subtract(newIndexFieldList, oldIndexFieldList);
        for (int i = 0; i < indexAlgorithmList.size(); ++i) {
            Map<String, String> map2 = indexAlgorithmList.get(i);
            if (addList.contains(map2.get("indexField"))) {
                DynamicObject algorithmTypeDy = algorithmTypeHelper.generateEmptyEntryDynamicObject(entryEntity);
                algorithmTypeDy.set("seq", (Object)i);
                algorithmTypeDy.set("numberalias", (Object)map2.get("indexField"));
                algorithmTypeDy.set("algorithm", (Object)map2.get("algorithm"));
                algorithmTypeColl.add((Object)algorithmTypeDy);
                continue;
            }
            if (deleteList.contains(map2.get("indexField"))) {
                algorithmTypeColl.removeIf(dy -> dy.getString("numberalias").equals(map2.get("indexField")));
                continue;
            }
            ((DynamicObject)algorithmTypeColl.get(i)).set("seq", (Object)i);
            ((DynamicObject)algorithmTypeColl.get(i)).set("algorithm", (Object)map2.get("algorithm"));
        }
    }

    private void saveRowAlgorithm(ReportConfigInfo reportConfigInfo, DynamicObject reportConfigDy) {
        List indexAlgorithmList = reportConfigInfo.getIndexAlgorithmList();
        DynamicObjectCollection rowAlgorithmColl = reportConfigDy.getDynamicObjectCollection("entryentity1");
        this.saveAlgorithmType(indexAlgorithmList, rowAlgorithmColl, this.rptConfigHelper, "entryentity1");
        reportConfigDy.set("entryentity1", (Object)rowAlgorithmColl);
    }

    private void saveLastStyle(ReportConfigInfo reportConfigInfo, DynamicObject reportConfigDy) {
        DynamicObjectCollection styleColl = reportConfigDy.getDynamicObjectCollection("entryentity");
        if (styleColl == null) {
            styleColl = this.rptConfigHelper.generateEmptyEntryCollection(reportConfigDy, "entryentity");
        } else {
            styleColl.clear();
        }
        styleColl.add((Object)this.getStyleDy(reportConfigInfo.getHls().getCs(), "0"));
        styleColl.add((Object)this.getStyleDy(reportConfigInfo.getHls().getBgs(), "1"));
        styleColl.add((Object)this.getStyleDy(reportConfigInfo.getBls().getCs(), "2"));
        styleColl.add((Object)this.getStyleDy(reportConfigInfo.getBls().getBgs(), "3"));
        reportConfigDy.set("headstyle", null == reportConfigInfo.getHs() ? null : SerializationUtils.toJsonString((Object)reportConfigInfo.getHs()));
        reportConfigDy.set("entryentity", (Object)styleColl);
    }

    private DynamicObject getStyleDy(List<String> colors, String styleType) {
        DynamicObject styleDy = this.rptConfigHelper.generateEmptyEntryDynamicObject("entryentity");
        styleDy.set("laststyle", (Object)SerializationUtils.toJsonString(colors));
        styleDy.set("styletype", (Object)styleType);
        return styleDy;
    }

    private int getFreeze(ReportConfigInfo reportConfigInfo) {
        return null != reportConfigInfo.getFreezeCol() && reportConfigInfo.getFreezeCol().getIsFreeze() ? reportConfigInfo.getFreezeCol().getFreezeNum() : -1;
    }

    private static MulBasedataDynamicObjectCollection getSubTotalIds(MulBasedataDynamicObjectCollection collection, List<FieldInfo> rowFieldIds) {
        long[] ids = DB.genLongIds((String)collection.getDynamicObjectType().getAlias(), (int)rowFieldIds.size());
        collection.clear();
        for (int i = 0; i < rowFieldIds.size(); ++i) {
            DynamicObject dy = collection.addNew();
            dy.set("pkid", (Object)ids[i]);
            dy.set("fbasedataid_id", (Object)rowFieldIds.get(i).getRowFieldId());
        }
        return collection;
    }

    private List<Long> getRowFieldIds(List<RowFieldInfo> rows) {
        ArrayList<Long> rowFieldIds = new ArrayList<Long>(rows.size());
        for (RowFieldInfo rowFieldInfo : rows) {
            if (IDStringUtils.idNotEmpty((String)rowFieldInfo.getGroupName().getRowFieldId())) {
                rowFieldIds.add(Long.parseLong(rowFieldInfo.getGroupName().getRowFieldId()));
            }
            ReportManageOp.recursive(rowFieldInfo._getChildFields(), fieldInfo -> {
                if (IDStringUtils.idNotEmpty((String)fieldInfo.getRowFieldId())) {
                    rowFieldIds.add(Long.parseLong(fieldInfo.getRowFieldId()));
                }
            });
        }
        return rowFieldIds;
    }

    private DynamicObjectCollection saveRows(List<RowFieldInfo> rows, long rptManageId, long workRptId) {
        if (CollectionUtils.isEmpty(rows)) {
            ReportManageService.deleteRowsByWorkRpt((Long)workRptId);
            return new DynamicObjectCollection();
        }
        List<Long> rowFieldIds = this.getRowFieldIds(rows);
        DynamicObject[] oldRowDys = ReportManageService.getRowFields(rowFieldIds);
        Map<String, DynamicObject> oldRowFieldMap = Arrays.stream(oldRowDys).collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_rowfield");
        helper.deleteByFilter(new QFilter[]{new QFilter("workrpt", "=", (Object)workRptId), new QFilter("id", "not in", rowFieldIds)});
        DynamicObjectCollection rowColls = new DynamicObjectCollection();
        long[] rowsId = ORM.create().genLongIds("hrptmc_rowfield", rows.size());
        AtomicInteger childrenSize = new AtomicInteger();
        for (RowFieldInfo rowFieldInfo : rows) {
            if (!rowFieldInfo._isMerge()) continue;
            childrenSize.addAndGet(rowFieldInfo._getChildFields().size());
            ReportManageOp.recursive(rowFieldInfo._getChildFields(), fieldInfo -> {
                if (!CollectionUtils.isEmpty((Collection)fieldInfo.getFields())) {
                    childrenSize.addAndGet(fieldInfo.getFields().size());
                }
            });
        }
        long[] childRowsIds = ORM.create().genLongIds("hrptmc_rowfield", childrenSize.get());
        Stack longStack = new Stack();
        Arrays.stream(childRowsIds).forEach(longStack::push);
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject rowDy;
            RowFieldInfo rowFieldInfo = rows.get(i);
            if (!oldRowFieldMap.containsKey(rowFieldInfo.getGroupName().getRowFieldId())) {
                rowDy = helper.generateEmptyDynamicObject();
                rowDy.set("id", (Object)rowsId[i]);
            } else {
                rowDy = oldRowFieldMap.get(rowFieldInfo.getGroupName().getRowFieldId());
            }
            rowColls.add((Object)rowDy);
            if (rowFieldInfo._isMerge()) {
                this.fieldInfo2RowDy(helper, rowDy, rowFieldInfo.getGroupName(), i, rptManageId, workRptId, null, rowFieldInfo.getType());
                Long parentId = Long.parseLong(rowFieldInfo.getGroupName().getRowFieldId());
                int finalI = i;
                ReportManageOp.recursive(rowFieldInfo._getChildFields(), fieldInfo -> {
                    DynamicObject childRowDy;
                    if (!oldRowFieldMap.containsKey(fieldInfo.getRowFieldId())) {
                        childRowDy = helper.generateEmptyDynamicObject();
                        childRowDy.set("id", longStack.pop());
                    } else {
                        childRowDy = (DynamicObject)oldRowFieldMap.get(fieldInfo.getRowFieldId());
                    }
                    this.fieldInfo2RowDy(helper, childRowDy, (FieldInfo)fieldInfo, finalI, rptManageId, workRptId, parentId, null);
                    rowColls.add((Object)childRowDy);
                });
                continue;
            }
            this.fieldInfo2RowDy(helper, rowDy, rowFieldInfo.getGroupName(), i, rptManageId, workRptId, null, null);
        }
        helper.save(rowColls);
        return rowColls;
    }

    private Long parseFieldId(String fieldId) {
        return StringUtils.isEmpty((CharSequence)fieldId) ? 0L : Long.parseLong(fieldId);
    }

    private void fieldInfo2RowDy(HRBaseServiceHelper helper, DynamicObject rowDy, FieldInfo fieldInfo, int seq, Long rptManageId, Long workRptId, Long parentId, String mergeType) {
        rowDy.set("bizindex", (Object)seq);
        rowDy.set("displayname", (Object)fieldInfo.getDisplayName());
        rowDy.set("numberalias", (Object)fieldInfo.getNumberAlias());
        rowDy.set("type", (Object)fieldInfo.getType());
        rowDy.set("algorithm", (Object)fieldInfo.getAlgorithm());
        this.setDataFormat(helper, rowDy, fieldInfo.getDataFormat());
        rowDy.set("sort", (Object)fieldInfo.getSort());
        rowDy.set("showemptycol", (Object)fieldInfo.getShowEmptyCol());
        rowDy.set("displaymode", (Object)fieldInfo.getDisplayMode());
        rowDy.set("orgversiondate", (Object)fieldInfo.getOrgVersionDate());
        rowDy.set("parentid", (Object)parentId);
        rowDy.set("mergetype", (Object)mergeType);
        rowDy.set("rptmanage", (Object)rptManageId);
        rowDy.set("workrpt", (Object)workRptId);
        this.setFieldRefId(rowDy, fieldInfo);
        fieldInfo.setRowFieldId(rowDy.getString("id"));
    }

    private void setFieldRefId(DynamicObject fieldDy, FieldInfo fieldInfo) {
        String fieldSrc = fieldInfo.getFieldSrc();
        Long fieldId = this.parseFieldId(fieldInfo.getFieldId());
        if ("0".equals(fieldSrc)) {
            fieldDy.set("anobjfield", (Object)fieldId);
        } else if ("1".equals(fieldSrc)) {
            fieldDy.set("calcidxfield", (Object)fieldId);
        } else if ("2".equals(fieldSrc)) {
            fieldDy.set("preidxfield", (Object)fieldId);
        }
    }

    private void setDataFormat(HRBaseServiceHelper helper, DynamicObject fieldDy, DataFormatInfo dataFormatInfo) {
        DynamicObjectCollection dataFormatCol;
        if (null == dataFormatInfo) {
            return;
        }
        if (fieldDy.getDataEntityState().getFromDatabase()) {
            dataFormatCol = fieldDy.getDynamicObjectCollection("entryentity");
            dataFormatCol.clear();
        } else {
            dataFormatCol = helper.generateEmptyEntryCollection(fieldDy, "entryentity");
        }
        DynamicObject dataFormatDy = helper.generateEmptyEntryDynamicObject("entryentity");
        dataFormatDy.set("datedisplaymode", (Object)dataFormatInfo.getDisplayMode());
        dataFormatDy.set("nullrule", (Object)dataFormatInfo.getNullRule());
        dataFormatDy.set("decimaldigits", (Object)dataFormatInfo.getDecimalDigits());
        dataFormatDy.set("roundmethod", (Object)dataFormatInfo.getRoundMethod());
        dataFormatCol.add((Object)dataFormatDy);
    }

    private List<Long> getColFieldIds(List<FieldInfo> columns) {
        ArrayList<Long> colFieldIds = new ArrayList<Long>(columns.size());
        for (FieldInfo fieldInfo : columns) {
            if (!IDStringUtils.idNotEmpty((String)fieldInfo.getRowFieldId())) continue;
            colFieldIds.add(Long.parseLong(fieldInfo.getRowFieldId()));
        }
        return colFieldIds;
    }

    private DynamicObjectCollection saveColumns(List<FieldInfo> columns, long reportManageId, long workRptId) {
        if (CollectionUtils.isEmpty(columns)) {
            ReportManageService.deleteColsByWorkRpt((Long)workRptId);
            return new DynamicObjectCollection();
        }
        List<Long> colFieldIds = this.getColFieldIds(columns);
        DynamicObject[] oldColDys = ReportManageService.getColFields(colFieldIds);
        Map<String, DynamicObject> oldColFieldMap = Arrays.stream(oldColDys).collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_colfield");
        helper.deleteByFilter(new QFilter[]{new QFilter("workrpt", "=", (Object)workRptId), new QFilter("id", "not in", colFieldIds)});
        DynamicObjectCollection colColls = new DynamicObjectCollection();
        long[] colIds = ORM.create().genLongIds("hrptmc_colfield", columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            DynamicObject colDy;
            FieldInfo fieldInfo = columns.get(i);
            if (oldColFieldMap.containsKey(fieldInfo.getRowFieldId())) {
                colDy = oldColFieldMap.get(fieldInfo.getRowFieldId());
            } else {
                colDy = helper.generateEmptyDynamicObject();
                colDy.set("id", (Object)colIds[i]);
            }
            this.fieldInfo2ColDy(helper, colDy, fieldInfo, i, reportManageId, workRptId);
            colColls.add((Object)colDy);
        }
        helper.save(colColls);
        return colColls;
    }

    private void fieldInfo2ColDy(HRBaseServiceHelper helper, DynamicObject colDy, FieldInfo fieldInfo, int seq, Long rptManageId, Long workRptId) {
        colDy.set("bizindex", (Object)seq);
        colDy.set("displayname", (Object)fieldInfo.getDisplayName());
        colDy.set("numberalias", (Object)fieldInfo.getNumberAlias());
        colDy.set("rptmanage", (Object)rptManageId);
        colDy.set("workrpt", (Object)workRptId);
        colDy.set("sort", (Object)fieldInfo.getSort());
        colDy.set("showemptycol", (Object)fieldInfo.getShowEmptyCol());
        this.setFieldRefId(colDy, fieldInfo);
        this.setDataFormat(helper, colDy, fieldInfo.getDataFormat());
        fieldInfo.setRowFieldId(colDy.getString("id"));
    }

    private void savePreIndexRef(long reportManageId) {
        String cachePreIdxStr = this.getOption().getVariableValue("rptPreIndex");
        if (StringUtils.isNotEmpty((CharSequence)cachePreIdxStr)) {
            List indexFieldInfos = SerializationUtils.fromJsonStringToList((String)cachePreIdxStr, IndexFieldInfo.class);
            if (CollectionUtils.isEmpty((Collection)indexFieldInfos)) {
                this.clearIndexesAndDimMaps(reportManageId);
                return;
            }
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportpreindex");
            ReportManageService.deletePreIdxRef((Long)reportManageId);
            long[] ids = ORM.create().genLongIds("hrptmc_reportpreindex", indexFieldInfos.size());
            DynamicObject[] batchSave = new DynamicObject[indexFieldInfos.size()];
            for (int i = 0; i < indexFieldInfos.size(); ++i) {
                DynamicObject dy = helper.generateEmptyDynamicObject();
                dy.set("id", (Object)ids[i]);
                dy.set("report", (Object)reportManageId);
                dy.set("preindex", (Object)this.parseFieldId(((IndexFieldInfo)indexFieldInfos.get(i)).getFieldId()));
                batchSave[i] = dy;
            }
            helper.save(batchSave);
        } else {
            this.clearIndexesAndDimMaps(reportManageId);
        }
    }

    private void clearIndexesAndDimMaps(long reportManageId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportpreindex");
        QFilter[] qFilters = new QFilter[]{new QFilter("report", "=", (Object)reportManageId)};
        helper.deleteByFilter(qFilters);
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrptmc_dimmap");
        dimHelper.deleteByFilter(qFilters);
    }

    private void saveDimMap(List<DimMapBo> dimMapBoList, long reportManageId, long workRptId) {
        if (CollectionUtils.isEmpty(dimMapBoList)) {
            HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrptmc_dimmap");
            QFilter[] qFilters = new QFilter[]{new QFilter("workrpt", "=", (Object)workRptId)};
            dimHelper.deleteByFilter(qFilters);
            return;
        }
        HRBaseServiceHelper dimMapHelper = new HRBaseServiceHelper("hrptmc_dimmap");
        ReportManageService.deleteDimMapRef((Long)workRptId);
        long[] dimIds = ORM.create().genLongIds("hrptmc_dimmap", dimMapBoList.size());
        DynamicObject[] batchSave = new DynamicObject[dimMapBoList.size()];
        for (int i = 0; i < dimMapBoList.size(); ++i) {
            DimMapBo dimMapInfo = dimMapBoList.get(i);
            DynamicObject dy = dimMapHelper.generateEmptyDynamicObject();
            dy.set("id", (Object)dimIds[i]);
            dy.set("preindexnumber", (Object)dimMapInfo.getPreIndexNumber());
            dy.set("preindex", (Object)dimMapInfo.getPreIndexId());
            dy.set("report", (Object)reportManageId);
            dy.set("workrpt", (Object)workRptId);
            List dimMapEntryBoList = dimMapInfo.getDimMapEntryBos();
            DynamicObjectCollection newEntries = dimMapHelper.generateEmptyEntryCollection(dy, "entryentity");
            for (DimMapEntryBo entryBo : dimMapEntryBoList) {
                DynamicObject newEntry = dimMapHelper.generateEmptyEntryDynamicObject("entryentity");
                newEntry.set("dimnumber", (Object)entryBo.getDimNumber());
                newEntry.set("dim", (Object)entryBo.getDim());
                newEntry.set("dimtype", (Object)entryBo.getDimType());
                newEntry.set("dimrealfrom", (Object)entryBo.getDimRealFrom());
                newEntry.set("dimfrom", (Object)entryBo.getDimFrom());
                newEntry.set("paramrule", (Object)entryBo.getParamRule());
                newEntry.set("preindexparam", (Object)entryBo.getPreIndexParam());
                newEntries.add((Object)newEntry);
            }
            dy.set("entryentity", (Object)newEntries);
            batchSave[i] = dy;
        }
        dimMapHelper.save(batchSave);
    }

    private boolean isDispScmChange() {
        boolean isDispScmChange = Boolean.parseBoolean(this.getOption().getVariableValue("dispScmChange", ""));
        LOGGER.info("isDispScmChange:{}", (Object)isDispScmChange);
        return isDispScmChange;
    }

    private boolean isDispScmPublish() {
        return Boolean.parseBoolean(this.getOption().getVariableValue("dispScmPublish", ""));
    }

    @ExcludeFromJacocoGeneratedReport
    private void saveDisplayScheme(long rptManageId, long workRptId, DisplaySchemeInfo displaySchemeInfo, DynamicObjectCollection rowColls, DynamicObjectCollection colColls) {
        if (!this.isDispScmChange()) {
            return;
        }
        if (null == displaySchemeInfo || displaySchemeInfo.isEmpty() || rowColls.isEmpty() && colColls.isEmpty()) {
            ReportManageService.deleteDispScm((long)rptManageId);
            if (this.isDispScmPublish()) {
                ReportManageService.deleteUserDispScm((long)rptManageId);
                ReportManageService.batchUpdateUserDispScmChg((Long)rptManageId, (boolean)false, (String)"0");
            }
        } else {
            DynamicObjectCollection rowDispScmColl = new DynamicObjectCollection();
            DynamicObjectCollection colDispScmColl = new DynamicObjectCollection();
            DynamicObjectCollection idxDispScmColl = new DynamicObjectCollection();
            long dispScmId = this.handleDispScmRef(rowDispScmColl, colDispScmColl, idxDispScmColl, rptManageId, workRptId, displaySchemeInfo, rowColls, colColls);
            if (this.isDispScmPublish()) {
                DynamicObject[] userDispScmDys = ReportManageService.getUserDispScmByRptId((long)rptManageId);
                this.handleUserDispScm(rptManageId, userDispScmDys, dispScmId, rowDispScmColl, colDispScmColl, idxDispScmColl);
                ReportManageService.batchSaveUserDispScm((DynamicObject[])userDispScmDys);
                ReportManageService.batchUpdateUserDispScmChg((Long)rptManageId, (boolean)false, (String)"1");
            }
            ReportManageService.deleteDispScmRefByScmId((long)dispScmId);
            this.rowDispScmHelper.save(rowDispScmColl);
            this.colDispScmHelper.save(colDispScmColl);
            this.idxDispScmHelper.save(idxDispScmColl);
            if (rowDispScmColl.size() == 0 && colDispScmColl.size() == 0 && idxDispScmColl.size() == 0 && dispScmId != 0L) {
                this.dispScmHelper.deleteOne((Object)dispScmId);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<Long, String> getLv2Head(long rptManageId, DynamicObjectCollection rowDispScmColl) {
        List disabledRowIds = rowDispScmColl.stream().filter(dy -> !dy.getBoolean("enable")).map(dy -> dy.getLong("rowfield")).collect(Collectors.toList());
        HRBaseServiceHelper rowFieldHelper = new HRBaseServiceHelper("hrptmc_rowfield");
        QFilter[] qFilters = new QFilter[]{new QFilter("type", "=", (Object)"0").and("rptmanage", "=", (Object)rptManageId).or(new QFilter("parentid", "!=", (Object)0).and(new QFilter("id", "in", disabledRowIds)))};
        DynamicObject[] rowFieldDys = rowFieldHelper.query("id,type,parentid.id,displayname", qFilters);
        if (rowFieldDys == null || rowFieldDys.length == 0) {
            return new HashMap<Long, String>();
        }
        HashMap<Long, String> textFieldMap = new HashMap<Long, String>(rowFieldDys.length);
        HashMap<Long, String> childMap = new HashMap<Long, String>(rowFieldDys.length);
        for (DynamicObject rowFieldDy : rowFieldDys) {
            if ("0".equals(rowFieldDy.getString("type"))) {
                textFieldMap.put(rowFieldDy.getLong("id"), rowFieldDy.getString("displayname"));
                continue;
            }
            childMap.put(rowFieldDy.getLong("id"), rowFieldDy.getString("parentid.id"));
        }
        childMap.replaceAll((k, v) -> (String)textFieldMap.get(Long.parseLong(v)));
        return childMap;
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleUserDispScm(long rptManageId, DynamicObject[] userDispScmDys, long dispScmId, DynamicObjectCollection rowDispScmColl, DynamicObjectCollection colDispScmColl, DynamicObjectCollection idxDispScmColl) {
        DynamicObject[] rowDispScmDys = this.rowDispScmHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("rptdispscm", "=", (Object)dispScmId)});
        DynamicObject[] colDispScmDys = this.colDispScmHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("rptdispscm", "=", (Object)dispScmId)});
        DynamicObject[] idxDispScmDys = this.idxDispScmHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("rptdispscm", "=", (Object)dispScmId)});
        DisplaySchemeChangeInfo rowDispScmMap = this.getDispScmChangeInfo(rowDispScmColl, rowDispScmDys, "rowfield");
        DisplaySchemeChangeInfo colDispScmMap = this.getDispScmChangeInfo(colDispScmColl, colDispScmDys, "colfield");
        DisplaySchemeChangeInfo idxDispScmMap = this.getDispScmChangeInfo(idxDispScmColl, idxDispScmDys, "rowfield");
        List deleteRowFieldId = rowDispScmMap.getDeleteColls().stream().map(dy -> dy.getLong("rowfield_id")).collect(Collectors.toList());
        List deleteColFieldId = colDispScmMap.getDeleteColls().stream().map(dy -> dy.getLong("colfield_id")).collect(Collectors.toList());
        List deleteIdxFieldId = idxDispScmMap.getDeleteColls().stream().map(dy -> dy.getLong("rowfield_id")).collect(Collectors.toList());
        List updateFalseRowFieldId = rowDispScmMap.getUpdateFalseColls().stream().map(dy -> dy.getLong("rowfield")).collect(Collectors.toList());
        Map lv2HeadMap = ReportManageService.getLv2HeadByRowFieldId(updateFalseRowFieldId);
        Map<Long, String> lv2HeadMap2 = this.getLv2Head(rptManageId, rowDispScmColl);
        List disableRowFieldId = rowDispScmMap.getDisableColls().stream().map(dy -> dy.getLong("rowfield")).collect(Collectors.toList());
        List updateFalseColFieldId = colDispScmMap.getUpdateFalseColls().stream().map(dy -> dy.getLong("colfield")).collect(Collectors.toList());
        List updateFalseIdxFieldId = idxDispScmMap.getUpdateFalseColls().stream().map(dy -> dy.getLong("rowfield")).collect(Collectors.toList());
        for (DynamicObject userDispScmDy : userDispScmDys) {
            Object rowDispScmDy2;
            DynamicObjectCollection userRowDispScmColl = userDispScmDy.getDynamicObjectCollection("rowentryentity");
            DynamicObjectCollection userColDispScmColl = userDispScmDy.getDynamicObjectCollection("colentryentity");
            DynamicObjectCollection userIdxDispScmColl = userDispScmDy.getDynamicObjectCollection("indexentryentity");
            userRowDispScmColl.removeIf(userRowDispScmDy -> deleteRowFieldId.contains(userRowDispScmDy.getLong("rowfield_id")));
            userColDispScmColl.removeIf(userColDispScmDy -> deleteColFieldId.contains(userColDispScmDy.getLong("colfield_id")));
            userIdxDispScmColl.removeIf(userIdxDispScmDy -> deleteIdxFieldId.contains(userIdxDispScmDy.getLong("indexfield_id")));
            userRowDispScmColl.forEach(userRowDispScmDy -> {
                if (updateFalseRowFieldId.contains(userRowDispScmDy.getLong("rowfield_id"))) {
                    userRowDispScmDy.set("rowsecondaryheader", lv2HeadMap.get(userRowDispScmDy.getLong("rowfield_id")));
                    userRowDispScmDy.set("rowhide", (Object)false);
                }
                if (disableRowFieldId.contains(userRowDispScmDy.getLong("rowfield_id"))) {
                    userRowDispScmDy.set("rowsecondaryheader", (Object)lv2HeadMap2.getOrDefault(userRowDispScmDy.getLong("rowfield_id"), ""));
                }
            });
            userColDispScmColl.forEach(userColDispScmDy -> {
                if (updateFalseColFieldId.contains(userColDispScmDy.getLong("colfield_id"))) {
                    userColDispScmDy.set("colhide", (Object)false);
                }
            });
            userIdxDispScmColl.forEach(userIdxDispScmDy -> {
                if (updateFalseIdxFieldId.contains(userIdxDispScmDy.getLong("indexfield_id"))) {
                    userIdxDispScmDy.set("indexhide", (Object)false);
                }
            });
            int rowSize = userRowDispScmColl.size();
            for (Object rowDispScmDy2 : rowDispScmMap.getNewColls()) {
                DynamicObject dy2 = userRowDispScmColl.addNew();
                Long rowFieldId = rowDispScmDy2.getLong("rowfield");
                dy2.set("rowfield", (Object)rowFieldId);
                dy2.set("rowsecondaryheader", lv2HeadMap.get(rowFieldId));
                dy2.set("rowfreeze", (Object)false);
                dy2.set("rowhide", (Object)rowDispScmDy2.getBoolean("enable"));
                dy2.set("seq", (Object)(++rowSize));
            }
            int colSize = userColDispScmColl.size();
            rowDispScmDy2 = colDispScmMap.getNewColls().iterator();
            while (rowDispScmDy2.hasNext()) {
                DynamicObject colDispScmDy = (DynamicObject)rowDispScmDy2.next();
                DynamicObject dy3 = userColDispScmColl.addNew();
                dy3.set("colfield", (Object)colDispScmDy.getLong("colfield"));
                dy3.set("colhide", (Object)false);
                dy3.set("seq", (Object)(++colSize));
            }
            int idxSize = userIdxDispScmColl.size();
            for (DynamicObject idxDispScmDy : idxDispScmMap.getNewColls()) {
                DynamicObject dy4 = userIdxDispScmColl.addNew();
                dy4.set("indexfield", (Object)idxDispScmDy.getLong("rowfield"));
                dy4.set("indexhide", (Object)false);
                dy4.set("seq", (Object)(++idxSize));
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private long handleDispScmRef(DynamicObjectCollection rowDispScmColl, DynamicObjectCollection colDispScmColl, DynamicObjectCollection idxDispScmColl, long rptManageId, long workRptId, DisplaySchemeInfo displaySchemeInfo, DynamicObjectCollection rowColls, DynamicObjectCollection colColls) {
        long dispScmId;
        DynamicObject dy = this.dispScmHelper.queryOne("id,workrpt", new QFilter("rptmanage", "=", (Object)rptManageId));
        if (null != dy) {
            dispScmId = dy.getLong("id");
            if (null == dy.getDynamicObject("workrpt") || workRptId != dy.getDynamicObject("workrpt").getLong("id")) {
                dy.set("workrpt", (Object)workRptId);
                this.dispScmHelper.saveOne(dy);
            }
        } else {
            dispScmId = ORM.create().genLongId("hrptmc_rptdispscm");
            DynamicObject dispScmDy = this.dispScmHelper.generateEmptyDynamicObject();
            dispScmDy.set("id", (Object)dispScmId);
            dispScmDy.set("rptmanage", (Object)rptManageId);
            dispScmDy.set("workrpt", (Object)workRptId);
            this.dispScmHelper.saveOne(dispScmDy);
        }
        DynamicObject[] rowDispScmDys = this.rowDispScmHelper.queryOriginalArray("id", new QFilter[]{new QFilter("rptdispscm", "=", (Object)dispScmId)});
        if (null != colColls && colColls.size() > 0) {
            DynamicObject[] colDispScmDys = this.colDispScmHelper.queryOriginalArray("id", new QFilter[]{new QFilter("rptdispscm", "=", (Object)dispScmId)});
            DynamicObject[] idxDispScmDys = this.idxDispScmHelper.queryOriginalArray("id", new QFilter[]{new QFilter("rptdispscm", "=", (Object)dispScmId)});
            int rowSeq = 0;
            int idxSeq = 0;
            for (DynamicObject rowDy : rowColls) {
                if ("1".equals(rowDy.getString("type"))) {
                    DynamicObject rowDispScmDy = this.rowDispScmHelper.generateEmptyDynamicObject();
                    if (null != rowDispScmDys && rowDispScmDys.length > rowSeq) {
                        rowDispScmDy.set("id", (Object)rowDispScmDys[rowSeq].getLong("id"));
                    }
                    rowDispScmDy.set("bizindex", (Object)(++rowSeq));
                    rowDispScmDy.set("rptdispscm", (Object)dispScmId);
                    rowDispScmDy.set("rowfield", (Object)rowDy.getLong("id"));
                    rowDispScmDy.set("enable", (Object)displaySchemeInfo.getSelectedRowField().contains(rowDy.getString("numberalias")));
                    rowDispScmColl.add((Object)rowDispScmDy);
                    continue;
                }
                DynamicObject idxDispScmDy = this.idxDispScmHelper.generateEmptyDynamicObject();
                if (null != idxDispScmDys && idxDispScmDys.length > idxSeq) {
                    idxDispScmDy.set("id", (Object)idxDispScmDys[idxSeq].getLong("id"));
                }
                idxDispScmDy.set("bizindex", (Object)(++idxSeq));
                idxDispScmDy.set("rptdispscm", (Object)dispScmId);
                idxDispScmDy.set("rowfield", (Object)rowDy.getLong("id"));
                idxDispScmDy.set("enable", (Object)displaySchemeInfo.getSelectedIdxField().contains(rowDy.getString("numberalias")));
                idxDispScmColl.add((Object)idxDispScmDy);
            }
            for (int i = 0; i < colColls.size(); ++i) {
                DynamicObject colDispScmDy = this.colDispScmHelper.generateEmptyDynamicObject();
                if (null != colDispScmDys && colDispScmDys.length > i) {
                    colDispScmDy.set("id", (Object)colDispScmDys[i].getLong("id"));
                }
                colDispScmDy.set("bizindex", (Object)(i + 1));
                colDispScmDy.set("rptdispscm", (Object)dispScmId);
                colDispScmDy.set("colfield", (Object)((DynamicObject)colColls.get(i)).getLong("id"));
                colDispScmDy.set("enable", (Object)displaySchemeInfo.getSelectedColField().contains(((DynamicObject)colColls.get(i)).getString("numberalias")));
                colDispScmColl.add((Object)colDispScmDy);
            }
        } else {
            int j = 0;
            for (int i = 0; i < rowColls.size(); ++i) {
                if ("0".equals(((DynamicObject)rowColls.get(i)).getString("type"))) continue;
                DynamicObject rowDispScmDy = this.rowDispScmHelper.generateEmptyDynamicObject();
                if (null != rowDispScmDys && rowDispScmDys.length > j) {
                    rowDispScmDy.set("id", (Object)rowDispScmDys[j].getLong("id"));
                }
                rowDispScmDy.set("bizindex", (Object)(++j));
                rowDispScmDy.set("rptdispscm", (Object)dispScmId);
                rowDispScmDy.set("rowfield", (Object)((DynamicObject)rowColls.get(i)).getLong("id"));
                rowDispScmDy.set("enable", (Object)displaySchemeInfo.getSelectedRowField().contains(((DynamicObject)rowColls.get(i)).getString("numberalias")));
                rowDispScmColl.add((Object)rowDispScmDy);
            }
        }
        return dispScmId;
    }

    @ExcludeFromJacocoGeneratedReport
    private DisplaySchemeChangeInfo getDispScmChangeInfo(DynamicObjectCollection dyObjColls, DynamicObject[] dyObjs, String key) {
        Map<String, DynamicObject> dyObjCollsMap = dyObjColls.stream().collect(Collectors.toMap(dy -> dy.getString(key), dy -> dy));
        Map<String, DynamicObject> dyObjsMap = Arrays.stream(dyObjs).collect(Collectors.toMap(dy -> dy.getString(key + "_id"), dy -> dy));
        DisplaySchemeChangeInfo displaySchemeChangeInfo = new DisplaySchemeChangeInfo();
        for (DynamicObject dy2 : dyObjColls) {
            if (dy2.getBoolean("enable")) {
                displaySchemeChangeInfo.getEnableColls().add((Object)dy2);
            } else {
                displaySchemeChangeInfo.getDisableColls().add((Object)dy2);
            }
            if (dyObjsMap.containsKey(dy2.getString(key))) {
                if (dyObjsMap.get(dy2.getString(key)).getBoolean("enable") == dy2.getBoolean("enable")) continue;
                if (dy2.getBoolean("enable")) {
                    displaySchemeChangeInfo.getUpdateTrueColls().add((Object)dy2);
                    continue;
                }
                displaySchemeChangeInfo.getUpdateFalseColls().add((Object)dy2);
                continue;
            }
            displaySchemeChangeInfo.getNewColls().add((Object)dy2);
        }
        for (DynamicObject dy3 : dyObjs) {
            if (dyObjCollsMap.containsKey(dy3.getString(key + "_id"))) continue;
            displaySchemeChangeInfo.getDeleteColls().add((Object)dy3);
        }
        return displaySchemeChangeInfo;
    }

    private Set<String> getLangNumSet() {
        if (this.langNumSet == null) {
            InteServiceImpl intService = new InteServiceImpl();
            this.langNumSet = intService.getEnabledLang().stream().map(EnabledLang::getNumber).collect(Collectors.toSet());
        }
        return this.langNumSet;
    }

    @ExcludeFromJacocoGeneratedReport
    private void saveReportMark(long rptManageId) {
        String reportMarkInfoStr = this.getOption().getVariableValue("reportMarkInfo");
        if (StringUtils.isNotEmpty((CharSequence)reportMarkInfoStr)) {
            ReportMarkInfo reportMarkInfo = (ReportMarkInfo)SerializationUtils.fromJsonString((String)reportMarkInfoStr, ReportMarkInfo.class);
            HRBaseServiceHelper rptMarkHelper = new HRBaseServiceHelper("hrptmc_reportmark");
            DynamicObject rptMarkDy = rptMarkHelper.loadDynamicObject(new QFilter("rptmanage", "=", (Object)rptManageId));
            if (null == rptMarkDy) {
                rptMarkDy = rptMarkHelper.generateEmptyDynamicObject();
                rptMarkDy.set("rptmanage", (Object)rptManageId);
                rptMarkDy.set("show", (Object)reportMarkInfo.getIsShow());
                rptMarkHelper.saveOne(rptMarkDy);
            } else if (!reportMarkInfo.getIsShow().equals(rptMarkDy.getString("show"))) {
                rptMarkDy.set("show", (Object)reportMarkInfo.getIsShow());
                rptMarkHelper.saveOne(rptMarkDy);
            }
            DynamicObjectCollection dyColls = new DynamicObjectCollection();
            HRBaseServiceHelper rptMarkCntHelper = new HRBaseServiceHelper("hrptmc_rptmarkcontent");
            DynamicObject[] rptMarkCntDys = rptMarkCntHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmark", "=", (Object)rptMarkDy.getLong("id"))});
            if (rptMarkCntDys == null || rptMarkCntDys.length == 0) {
                for (Map.Entry entry : reportMarkInfo.getLocaleContent().entrySet()) {
                    DynamicObject rptMarkCntDy = rptMarkCntHelper.generateEmptyDynamicObject();
                    rptMarkCntDy.set("locale", entry.getKey());
                    rptMarkCntDy.set("markcontent", entry.getValue());
                    rptMarkCntDy.set("rptmark", (Object)rptMarkDy.getLong("id"));
                    dyColls.add((Object)rptMarkCntDy);
                }
            } else {
                Map<String, DynamicObject> rptMarkCntMap = Arrays.stream(rptMarkCntDys).collect(Collectors.toMap(dy -> dy.getString("locale"), dy -> dy));
                for (Map.Entry entry : reportMarkInfo.getLocaleContent().entrySet()) {
                    DynamicObject rptMarkCntDy;
                    if (rptMarkCntMap.containsKey(entry.getKey())) {
                        rptMarkCntDy = rptMarkCntMap.get(entry.getKey());
                        rptMarkCntDy.set("markcontent", entry.getValue());
                        dyColls.add((Object)rptMarkCntDy);
                        continue;
                    }
                    rptMarkCntDy = rptMarkCntHelper.generateEmptyDynamicObject();
                    rptMarkCntDy.set("locale", entry.getKey());
                    rptMarkCntDy.set("markcontent", entry.getValue());
                    rptMarkCntDy.set("rptmark", (Object)rptMarkDy.getLong("id"));
                    dyColls.add((Object)rptMarkCntDy);
                }
            }
            rptMarkCntHelper.save(dyColls);
        }
    }

    private void closeEnableScheme(long reportId, boolean isMulWorkConfig) {
        if (isMulWorkConfig) {
            DynamicObject config = ReportManageService.getParamConfigWithSchedule((long)reportId);
            ReportManageService.closeEnableScheme((DynamicObject)config);
        }
    }

    private static /* synthetic */ boolean lambda$saveSplitDate$6(Set deleteSet, DynamicObject dy) {
        return deleteSet.contains(dy.getString("anobjfield.fieldpath") + "!" + dy.getString("number"));
    }

    static class SortParam
    implements Serializable {
        private static final long serialVersionUID = 844633697175128795L;
        private long workRptId;
        private List<FieldInfo> legend;
        private List<RowFieldInfo> rows;
        private List<FieldInfo> columns;

        public SortParam() {
        }

        public SortParam(long workRptId, List<FieldInfo> legend, List<RowFieldInfo> rows, List<FieldInfo> columns) {
            this.workRptId = workRptId;
            this.legend = legend;
            this.rows = rows;
            this.columns = columns;
        }

        public long getWorkRptId() {
            return this.workRptId;
        }

        public void setWorkRptId(long workRptId) {
            this.workRptId = workRptId;
        }

        public List<FieldInfo> getLegend() {
            return this.legend;
        }

        public void setLegend(List<FieldInfo> legend) {
            this.legend = legend;
        }

        public List<RowFieldInfo> getRows() {
            return this.rows;
        }

        public void setRows(List<RowFieldInfo> rows) {
            this.rows = rows;
        }

        public List<FieldInfo> getColumns() {
            return this.columns;
        }

        public void setColumns(List<FieldInfo> columns) {
            this.columns = columns;
        }
    }
}

