/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.center;

import java.util.EventObject;
import java.util.List;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.TemplateTreePlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.utils.DbTypeConverter;
import kd.hr.hrptmc.common.constant.center.ReportCenterGroupConstants;
import org.apache.commons.lang3.StringUtils;

public class ReportCenterGroupList
extends TemplateTreePlugin
implements ReportCenterGroupConstants {
    private static final Log LOGGER = LogFactory.getLog(ReportCenterGroupList.class);

    public void initialize() {
        try {
            super.initialize();
            this.setInitTreeNodeFilter(this.getTreeListView());
        }
        catch (Exception exception) {
            LOGGER.error("initialize_error_", (Throwable)exception);
        }
    }

    public void initTreeToolbar(EventObject e) {
        try {
            super.initTreeToolbar(e);
            this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow", "iscontainlower"});
        }
        catch (Exception exception) {
            LOGGER.error("initTreeToolbar_error_", (Throwable)exception);
        }
    }

    public void initializeTree(EventObject e) {
        try {
            this.initGroupTree(this.getTreeListView());
        }
        catch (Exception exception) {
            LOGGER.error("initializeTree_error_", (Throwable)exception);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent event) {
        try {
            super.buildTreeListFilter(event);
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            if (listShowParameter.isLookUp()) {
                String originFormId = (String)listShowParameter.getCustomParam("originFormId");
                String originFieldKey = (String)listShowParameter.getCustomParam("originFieldKey");
                if ("hrptc_reportgroup".equals(originFormId) && "parent".equals(originFieldKey)) {
                    event.addQFilter(new QFilter("isendgroup", "=", (Object)Boolean.FALSE));
                } else {
                    event.addQFilter(new QFilter("isendgroup", "=", (Object)Boolean.TRUE));
                }
                this.buildTreeChildFilter(event.getFilters());
                event.setCancel(true);
            }
        }
        catch (Exception exception) {
            LOGGER.error("buildTreeListFilter_error_", (Throwable)exception);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            String originFormId = (String)listShowParameter.getCustomParam("originFormId");
            String originFieldKey = (String)listShowParameter.getCustomParam("originFieldKey");
            if ("hrptc_reportgroup".equals(originFormId) && "parent".equals(originFieldKey)) {
                e.getQFilters().add(new QFilter("isendgroup", "=", (Object)Boolean.FALSE));
            } else {
                e.getQFilters().add(new QFilter("isendgroup", "=", (Object)Boolean.TRUE));
            }
        }
    }

    private void buildTreeChildFilter(List<QFilter> filters) {
        boolean containNow = true;
        FieldEdit nowEdit = (FieldEdit)this.getControl("iscontainnow");
        if (nowEdit != null) {
            containNow = (Boolean)nowEdit.getModel().getValue("iscontainnow");
        }
        ITreeModel treeListModel = this.getTreeListView().getTreeModel();
        String currentId = String.valueOf(treeListModel.getCurrentNodeId());
        GroupProp groupProp = treeListModel.getGroupProp();
        TreeNode root = treeListModel.getRoot();
        TreeNode currentNode = root.getTreeNode(currentId);
        if (currentNode != null) {
            String longNumber = currentNode.getLongNumber();
            int dbType = groupProp.getDbType();
            Object id = DbTypeConverter.safeConvert((int)dbType, (Object)currentId);
            QFilter filter = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)longNumber)) {
                if (containNow && ((ParentBasedataProp)groupProp).isShowTreeNow()) {
                    filter.or(new QFilter("id", "=", id));
                }
                ListView view = (ListView)this.getView();
                EntityType et = view.getListModel().getDataEntityType();
                BasedataEntityType bet = groupProp.getEntityType();
                if (et.getName().equals(bet.getName())) {
                    String longNumberDLM = ((ParentBasedataProp)groupProp).getLongNumberDLM();
                    filter.or(new QFilter("longnumber", "like", (Object)(longNumber + longNumberDLM + "%")));
                }
            } else if (containNow && ((ParentBasedataProp)groupProp).isShowTreeNow()) {
                filter.or(new QFilter("id", "=", id));
            }
            if (filters.isEmpty()) {
                filters.add(filter);
            } else {
                filters.get(0).and(filter);
            }
        }
    }
}

