/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.center;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ActiveViewEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.common.constant.center.ReportCenterEntityConstants;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.common.constant.center.ReportCenterGroupConstants;

public class ReportCenterList
extends StandardTreeListPlugin
implements ReportCenterEntityConstants,
ReportCenterGroupConstants {
    private static final Log LOGGER = LogFactory.getLog(ReportCenterList.class);
    private static final String CACHE_KEY_CANCEL_TIMES = "cancelTimes";

    public void initialize() {
        try {
            super.initialize();
            this.setInitTreeNodeFilter(this.getTreeListView());
        }
        catch (Exception exception) {
            LOGGER.error("initialize_error_", (Throwable)exception);
        }
    }

    public void activeView(ActiveViewEvent evt) {
        super.activeView(evt);
        String viewKey = evt.getView();
        if ("cardview".equals(viewKey)) {
            ListView listView = (ListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            if (selectedRows == null || selectedRows.isEmpty()) {
                this.getPageCache().put(CACHE_KEY_CANCEL_TIMES, "1");
            } else {
                this.getPageCache().put(CACHE_KEY_CANCEL_TIMES, "2");
            }
        }
    }

    public void treeToolbarClick(EventObject e) {
        try {
            ITreeModel treeModel = this.getTreeModel();
            String currentNodeId = (String)treeModel.getCurrentNodeId();
            Control ctl = (Control)e.getSource();
            if (ctl.getKey().equals("btndel")) {
                if (this.getTreeModel().getRoot().getId().equals(currentNodeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u6839\u8282\u70b9\u3002", (String)"ReportCenterList_0", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isBlank((CharSequence)currentNodeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5206\u7ec4\u8282\u70b9\u3002", (String)"ReportCenterList_1", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                    return;
                }
                TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId);
                List<String> nodeIds = this.getAllTreeNodeChildNodeIds(currentNode);
                nodeIds.add(currentNodeId);
                List nodeLongIds = nodeIds.stream().map(Long::parseLong).collect(Collectors.toList());
                boolean existsReport = CENTER_HELPER.isExists(new QFilter("reportgroup", "in", nodeLongIds));
                if (existsReport) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u5185\u5b58\u5728\u5df2\u53d1\u5e03\u62a5\u8868\uff0c\u8bf7\u8c03\u6574\u540e\u91cd\u8bd5", (String)"ReportCenterList_3", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                } else {
                    IOperationResult result = this.getTreeModel().deleteGroup(nodeLongIds.toArray());
                    if (result.isSuccess()) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ReportCenterList_4", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showOperationResult((OperationResult)result, ResManager.loadKDString((String)"\u5220\u9664", (String)"ReportCenterList_5", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                    }
                    if (!result.getSuccessPkIds().isEmpty()) {
                        currentNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId);
                        this.getTreeModel().deleteNode(currentNode, false);
                        TreeNode parentNode = this.getTreeModel().getRoot().getTreeNode(currentNode.getParentid());
                        if (parentNode != null) {
                            this.updatePageCache(null);
                            this.treeListView.getTreeModel().refreshNode((Object)parentNode.getId());
                            this.treeListView.refreshTreeNode(parentNode.getId());
                            this.treeListView.getTreeView().treeNodeClick(parentNode.getParentid(), parentNode.getId());
                        }
                    }
                }
                return;
            }
            super.treeToolbarClick(e);
        }
        catch (Exception exception) {
            LOGGER.error("treeToolbarClick_error_", (Throwable)exception);
        }
    }

    public void initializeTree(EventObject evt) {
        try {
            this.initGroupTree(this.getTreeListView());
        }
        catch (Exception exception) {
            LOGGER.error("initializeTree_error_", (Throwable)exception);
        }
    }

    public void setFilter(SetFilterEvent e) {
        QFilter listFilter = this.getTreeListView().getTreeModel().getListFilter();
        if (listFilter != null) {
            e.addCustomQFilter(listFilter);
        }
        super.setFilter(e);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent evt) {
        try {
            long currUserId;
            QFilter startFilter;
            String currentNodeId = (String)evt.getNodeId();
            List filters = evt.getFilters();
            if (!filters.isEmpty()) {
                startFilter = (QFilter)filters.get(0);
            } else {
                startFilter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
                filters.add(startFilter);
            }
            if (!String.valueOf(1000L).equals(currentNodeId)) {
                TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId);
                List<String> childNodeIds = this.getAllTreeNodeChildNodeIds(treeNode);
                childNodeIds.add(currentNodeId);
                QFilter qFilter = new QFilter("reportgroup", "in", childNodeIds.stream().map(Long::parseLong).collect(Collectors.toList()));
                startFilter.and(qFilter);
            }
            if (!PermissionServiceHelper.isSuperUser((long)(currUserId = RequestContext.get().getCurrUserId()))) {
                HashSet reportIds = Sets.newHashSetWithExpectedSize((int)16);
                HRBaseServiceHelper userPermHelper = new HRBaseServiceHelper("hrptc_userperm");
                DynamicObject userPermDy = userPermHelper.loadDynamicObject(new QFilter("user", "=", (Object)currUserId));
                if (userPermDy != null) {
                    DynamicObjectCollection selectReportEntry = userPermDy.getDynamicObjectCollection("selectreportentry");
                    Date nowDate = HRDateTimeUtils.getNowDate();
                    LOGGER.info("buildTreeListFilter_selectReportEntry_size = ", (Object)selectReportEntry.size());
                    for (DynamicObject selectReportEntryDy : selectReportEntry) {
                        DynamicObject selectReportDy = selectReportEntryDy.getDynamicObject("selectreport");
                        if (selectReportDy == null) continue;
                        Date startDate = selectReportEntryDy.getDate("selectstartdate");
                        Date endDate = selectReportEntryDy.getDate("selectenddate");
                        if (startDate.compareTo(nowDate) > 0 || endDate.compareTo(nowDate) < 0) continue;
                        reportIds.add(selectReportDy.getLong("id"));
                    }
                    DynamicObjectCollection permDataEntry = userPermDy.getDynamicObjectCollection("rptpermdataentry");
                    LOGGER.info("buildTreeListFilter_permDataEntry_size = ", (Object)permDataEntry.size());
                    for (DynamicObject permDataEntryDy : permDataEntry) {
                        DynamicObject reportDy = permDataEntryDy.getDynamicObject("report");
                        if (reportDy == null) continue;
                        Date startDate = permDataEntryDy.getDate("startdate");
                        Date endDate = permDataEntryDy.getDate("enddate");
                        if (startDate.compareTo(nowDate) > 0 || endDate.compareTo(nowDate) < 0) continue;
                        reportIds.add(reportDy.getLong("id"));
                    }
                } else {
                    LOGGER.info("buildTreeListFilter_userPermDy_is_null");
                }
                if (userPermDy == null || reportIds.isEmpty()) {
                    startFilter.and(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
                } else {
                    startFilter.and(new QFilter("reportmanage", "in", (Object)reportIds));
                }
                LOGGER.info("buildTreeListFilter_startFilter = ", (Object)startFilter);
            }
            evt.setCancel(true);
        }
        catch (Exception exception) {
            LOGGER.error("buildTreeListFilter_error_", (Throwable)exception);
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        try {
            super.beforePackageData(e);
            DynamicObjectCollection pageData = e.getPageData();
            ArrayList reportManageIds = Lists.newArrayListWithExpectedSize((int)pageData.size());
            for (DynamicObject dataDy : pageData) {
                DynamicObject[] reportManageDy = dataDy.getDynamicObject("reportmanage");
                if (reportManageDy == null) continue;
                reportManageIds.add(reportManageDy.getPkValue());
            }
            DynamicObject[] batchWorkRpt = ReportManageService.getBatchWorkRpt((Collection)reportManageIds);
            HashMap manageIdToWorkIdMap = Maps.newHashMapWithExpectedSize((int)batchWorkRpt.length);
            for (DynamicObject rpt : batchWorkRpt) {
                DynamicObject rptManageDy = rpt.getDynamicObject("rptmanage");
                if (rpt.getInt("index") != 0 || manageIdToWorkIdMap.containsKey(rptManageDy.getPkValue())) continue;
                manageIdToWorkIdMap.put(rptManageDy.getPkValue(), rpt.getPkValue());
            }
            DynamicObject[] batchRptConfigs = ReportManageService.getBatchRptConfigs(manageIdToWorkIdMap.values());
            HashMap workIdToPicturePathMap = Maps.newHashMapWithExpectedSize((int)batchRptConfigs.length);
            for (DynamicObject batchRptConfig : batchRptConfigs) {
                DynamicObject workDy = batchRptConfig.getDynamicObject("workrpt");
                String reportType = batchRptConfig.getString("type");
                if (workDy == null) continue;
                Object workId = workDy.getPkValue();
                if ("1".equals(reportType)) {
                    workIdToPicturePathMap.put(workId, "/kingdee/hr/images/pc/other/hr_fxb_45_32.png");
                    continue;
                }
                if ("2".equals(reportType)) {
                    workIdToPicturePathMap.put(workId, "/kingdee/hr/images/pc/other/hr_zzt_45_32.png");
                    continue;
                }
                if ("3".equals(reportType)) {
                    workIdToPicturePathMap.put(workId, "/kingdee/hr/images/pc/other/hr_zxt_45_32.png");
                    continue;
                }
                if ("4".equals(reportType)) {
                    workIdToPicturePathMap.put(workId, "/kingdee/hr/images/pc/other/hr_bt_45_32.png");
                    continue;
                }
                workIdToPicturePathMap.put(workId, "/kingdee/hr/images/pc/other/hr_lb_45_32.png");
            }
            String url = UrlService.getDomainContextUrl();
            for (DynamicObject dataDy : pageData) {
                String description;
                DynamicObject reportManageDy = dataDy.getDynamicObject("reportmanage");
                if (reportManageDy == null) continue;
                Object workId = manageIdToWorkIdMap.get(reportManageDy.getPkValue());
                if (workId != null) {
                    String picturePatch = (String)workIdToPicturePathMap.get(workId);
                    dataDy.set("reportpicture", (Object)(url + picturePatch));
                }
                if (!HRStringUtils.isNotEmpty((String)(description = reportManageDy.getString("description"))) || description.length() <= 27) continue;
                reportManageDy.set("description", (Object)(description.substring(0, 27) + "..."));
            }
        }
        catch (Exception exception) {
            LOGGER.error("beforePackageData_error_", (Throwable)exception);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        try {
            super.listRowClick(evt);
            String selectView = this.getPageCache().get("selectview");
            String cancelTimes = this.getPageCache().get(CACHE_KEY_CANCEL_TIMES);
            int cancelTimesInt = 0;
            if (HRStringUtils.isNotEmpty((String)cancelTimes)) {
                cancelTimesInt = Integer.parseInt(cancelTimes);
            }
            if ("cardview".equals(selectView) && cancelTimesInt == 0) {
                int row = evt.getRow();
                ListSelectedRowCollection allRowCollection = ((BillList)evt.getSource()).getCurrentListAllRowCollection();
                if (row >= 0 && allRowCollection.size() > row) {
                    ListSelectedRow selectedRow = allRowCollection.get(row);
                    this.showReportForm(selectedRow.getPrimaryKeyValue());
                }
            }
            if (cancelTimesInt > 0) {
                this.getPageCache().put(CACHE_KEY_CANCEL_TIMES, String.valueOf(--cancelTimesInt));
            }
        }
        catch (Exception exception) {
            LOGGER.error("listRowClick_error_", (Throwable)exception);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        try {
            String billFormId = ((BillList)args.getHyperLinkClickEvent().getSource()).getBillFormId();
            if ("hrptc_reportcenter".equals(billFormId)) {
                BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
                ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
                this.showReportForm(currentRow.getPrimaryKeyValue());
                args.setCancel(true);
            }
        }
        catch (Exception exception) {
            args.setCancel(true);
            LOGGER.error("billListHyperLinkClick_error_", (Throwable)exception);
        }
    }

    private List<String> getAllTreeNodeChildNodeIds(TreeNode parentNode) {
        ArrayList childNodeIds = Lists.newArrayListWithExpectedSize((int)10);
        List children = parentNode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                childNodeIds.add(child.getId());
                childNodeIds.addAll(this.getAllTreeNodeChildNodeIds(child));
            }
        }
        return childNodeIds;
    }

    private void updatePageCache(List<TreeNode> treeNodes) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String treeNodesString = null;
        if (treeNodes != null) {
            treeNodesString = SerializationUtils.toJsonString(treeNodes);
        }
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        pageCache.put(matchNodesCacheKey, treeNodesString);
        pageCache.put(searchNodesCacheKey, treeNodesString);
        pageCache.put(searchIndexCacheKey, String.valueOf(0));
    }

    private void showReportForm(Object reportCenterId) {
        DynamicObject dy = CENTER_HELPER.loadSingle(reportCenterId);
        DynamicObject reportManage = dy.getDynamicObject("reportmanage");
        if (reportManage != null) {
            String formNumber = reportManage.getString("number");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(formNumber);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setHasRight(true);
            showParameter.setCustomParam("openFrom", (Object)"reportCenter");
            showParameter.setCustomParam("CUSTOM_PARAM_PUBLISH_TYPE", (Object)"reportCenter");
            showParameter.setCustomParam("reportId", (Object)reportManage.getLong("id"));
            showParameter.setCustomParam("reportName", (Object)reportManage.getLocaleString("name").getLocaleValue());
            showParameter.setCustomParam("reportNumber", (Object)formNumber);
            showParameter.setCustomParam("reportGroupId", this.getTreeModel().getCurrentNodeId());
            this.getView().showForm(showParameter);
        }
    }
}

