/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrptc.common.constant.perm.ReportUserPermConstants;
import kd.hr.hrptc.common.model.perm.FieldDimType;
import kd.hr.hrptc.formplugin.perm.model.PermFieldData;
import kd.hr.hrptc.formplugin.perm.model.PermGroup;
import kd.hr.hrptc.formplugin.perm.model.UserRepPermData;
import kd.hr.hrptc.formplugin.perm.utils.ReportUserPermFormUtils;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;

public class ReportUserPermCopyEdit
extends HRDataBaseEdit
implements ReportUserPermConstants,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(ReportUserPermCopyEdit.class);
    private static final String FIELD_SOURCE_USER = "sourceuser";
    private static final String FIELD_TARGET_USER = "targetuser";
    private static final String FIELD_START_DATE = "startdate";
    private static final String FIELD_END_DATE = "enddate";
    private static final String ENTRY_REPORT_PERM_ENTRY = "reportpermentry";
    private static final String FIELD_REPORT = "report";
    private static final String FIELD_DATA_RANGE = "datarange";
    private static final String FIELD_DATE_RANGE_START = "daterangestart";
    private static final String FIELD_DATE_RANGE_END = "daterangeend";
    private static final String CONTROL_OK = "btnok";

    public void registerListener(EventObject e) {
        try {
            super.registerListener(e);
            this.addClickListeners(new String[]{CONTROL_OK});
            BasedataEdit sourceUserEdit = (BasedataEdit)this.getView().getControl(FIELD_SOURCE_USER);
            sourceUserEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        catch (Exception exception) {
            LOGGER.error("registerListener_error_", (Throwable)exception);
        }
    }

    public void beforeBindData(EventObject e) {
        try {
            DynamicObject userPermDy;
            super.beforeBindData(e);
            Object sourceId = this.getView().getFormShowParameter().getCustomParam("CUSTOM_PARAM_SOURCE_DATA_ID");
            if (sourceId != null && (userPermDy = USER_PERM_HELPER.loadSingle((Object)Long.parseLong(String.valueOf(sourceId)))) != null) {
                DynamicObject user = userPermDy.getDynamicObject("user");
                this.getModel().setValue(FIELD_SOURCE_USER, user.getPkValue());
                List<UserRepPermData> userRepPermDataList = this.buildPermDataList(userPermDy);
                this.setEntryData(userRepPermDataList);
            }
        }
        catch (Exception exception) {
            LOGGER.error("beforeBindData_error_", (Throwable)exception);
        }
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        try {
            super.propertyChanged(changedArgs);
            String fieldKey = changedArgs.getProperty().getName();
            ChangeData changeData = changedArgs.getChangeSet()[0];
            if (HRStringUtils.equals((String)FIELD_SOURCE_USER, (String)fieldKey)) {
                DynamicObject userPermDy;
                Object newUser = changeData.getNewValue();
                this.clearEntry();
                if (newUser != null && (userPermDy = USER_PERM_HELPER.loadDynamicObject(new QFilter("user", "=", ((DynamicObject)newUser).getPkValue()))) != null) {
                    List<UserRepPermData> userRepPermDataList = this.buildPermDataList(userPermDy);
                    this.setEntryData(userRepPermDataList);
                    this.getView().updateView(ENTRY_REPORT_PERM_ENTRY);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("propertyChanged_error_", (Throwable)exception);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        try {
            String fieldKey = beforeF7SelectEvent.getProperty().getName();
            if (HRStringUtils.equals((String)fieldKey, (String)FIELD_SOURCE_USER)) {
                List customQFilters = beforeF7SelectEvent.getCustomQFilters();
                DynamicObject[] userPermDys = USER_PERM_HELPER.queryOriginalArray("user", new QFilter[0]);
                if (userPermDys == null || userPermDys.length == 0) {
                    customQFilters.add(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
                } else {
                    ArrayList userIds = Lists.newArrayListWithExpectedSize((int)userPermDys.length);
                    for (DynamicObject userPermDy : userPermDys) {
                        userIds.add(userPermDy.getLong("user"));
                    }
                    customQFilters.add(new QFilter("id", "in", (Object)userIds));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("beforeF7Select_error_", (Throwable)exception);
        }
    }

    public void click(EventObject evt) {
        try {
            super.click(evt);
            Control ctlSource = (Control)evt.getSource();
            String key = ctlSource.getKey();
            if (CONTROL_OK.equals(key)) {
                IDataModel model = this.getModel();
                DynamicObject sourceUser = (DynamicObject)model.getValue(FIELD_SOURCE_USER);
                if (sourceUser == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u590d\u5236\u7684\u7528\u6237\u3002", (String)"ReportUserPermCopyEdit_0", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                    return;
                }
                MulBasedataDynamicObjectCollection targetUsers = (MulBasedataDynamicObjectCollection)model.getValue(FIELD_TARGET_USER);
                if (targetUsers == null || targetUsers.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u7528\u6237\u3002", (String)"ReportUserPermCopyEdit_1", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject[] dbUserPerms = USER_PERM_HELPER.query("user", new QFilter[]{new QFilter("user", "in", targetUsers.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).collect(Collectors.toSet()))});
                if (dbUserPerms != null && dbUserPerms.length > 0) {
                    Set existUserNames = Arrays.stream(dbUserPerms).map(userPerm -> userPerm.getDynamicObject("user")).map(user -> user.getString("name")).collect(Collectors.toSet());
                    this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u76ee\u6807\u7528\u6237{0}\u5df2\u7ecf\u5b58\u5728\u6743\u9650\u6570\u636e\u3002", (String)"ReportUserPermCopyEdit_2", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", existUserNames)));
                    return;
                }
                EntryGrid control = (EntryGrid)this.getView().getControl(ENTRY_REPORT_PERM_ENTRY);
                int[] selectRows = control.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u590d\u5236\u7684\u62a5\u8868\u6743\u9650\u6570\u636e\u3002", (String)"ReportUserPermCopyEdit_3", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                    return;
                }
                Date startDate = (Date)this.getModel().getValue(FIELD_START_DATE);
                if (startDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6743\u9650\u6709\u6548\u671f\u3002", (String)"ReportUserPermCopyEdit_4", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                    return;
                }
                Date endDate = (Date)this.getModel().getValue(FIELD_END_DATE);
                if (endDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6743\u9650\u6709\u6548\u671f\u3002", (String)"ReportUserPermCopyEdit_4", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection reportPermEntry = model.getEntryEntity(ENTRY_REPORT_PERM_ENTRY);
                ArrayList selectReportIds = Lists.newArrayListWithExpectedSize((int)reportPermEntry.size());
                for (int selectRow : selectRows) {
                    DynamicObject entryDy = (DynamicObject)reportPermEntry.get(selectRow);
                    DynamicObject reportDy = entryDy.getDynamicObject(FIELD_REPORT);
                    selectReportIds.add(reportDy.getLong("id"));
                }
                DynamicObject userPermDy = USER_PERM_HELPER.loadDynamicObject(new QFilter("user", "=", sourceUser.getPkValue()));
                ArrayList copyDys = Lists.newArrayListWithExpectedSize((int)targetUsers.size());
                for (DynamicObject targetUserEntry : targetUsers) {
                    DynamicObject targetUser = targetUserEntry.getDynamicObject("fbasedataid");
                    DynamicObject copyDy = USER_PERM_HELPER.generateEmptyDynamicObject();
                    HRDynamicObjectUtils.copy((DynamicObject)userPermDy, (DynamicObject)copyDy);
                    copyDy.set("user", (Object)targetUser);
                    DynamicObjectCollection permDataEntry = copyDy.getDynamicObjectCollection("rptpermdataentry");
                    long currUserId = RequestContext.get().getCurrUserId();
                    Iterator iterator = permDataEntry.iterator();
                    while (iterator.hasNext()) {
                        long reportId;
                        DynamicObject permDataEntryDy = (DynamicObject)iterator.next();
                        DynamicObject reportDy = permDataEntryDy.getDynamicObject(FIELD_REPORT);
                        if (reportDy != null && !selectReportIds.contains(reportId = reportDy.getLong("id"))) {
                            iterator.remove();
                            continue;
                        }
                        permDataEntryDy.set("permuser", (Object)targetUser);
                        permDataEntryDy.set("modifyuser", (Object)currUserId);
                        permDataEntryDy.set(FIELD_START_DATE, (Object)startDate);
                        permDataEntryDy.set(FIELD_END_DATE, (Object)endDate);
                    }
                    DynamicObjectCollection selectReportEntry = copyDy.getDynamicObjectCollection("selectreportentry");
                    Iterator selectReportEntryIterator = selectReportEntry.iterator();
                    while (selectReportEntryIterator.hasNext()) {
                        long reportId;
                        DynamicObject selectReportEntryDy = (DynamicObject)selectReportEntryIterator.next();
                        DynamicObject reportDy = selectReportEntryDy.getDynamicObject("selectreport");
                        if (reportDy != null && !selectReportIds.contains(reportId = reportDy.getLong("id"))) {
                            selectReportEntryIterator.remove();
                            continue;
                        }
                        selectReportEntryDy.set("selectuser", (Object)targetUser);
                        selectReportEntryDy.set("selectadminuser", (Object)currUserId);
                        selectReportEntryDy.set("selectstartdate", (Object)startDate);
                        selectReportEntryDy.set("selectenddate", (Object)endDate);
                    }
                    copyDy.set("creator", (Object)currUserId);
                    copyDy.set("createtime", (Object)HRDateTimeUtils.getNowDateTime());
                    copyDy.set("modifier", (Object)currUserId);
                    copyDy.set("modifytime", (Object)HRDateTimeUtils.getNowDateTime());
                    copyDys.add(copyDy);
                }
                USER_PERM_HELPER.save(copyDys.toArray(new DynamicObject[0]));
                this.getView().close();
            }
        }
        catch (Exception exception) {
            LOGGER.error("click_error_", (Throwable)exception);
        }
    }

    private void setEntryData(List<UserRepPermData> userRepPermDataList) {
        if (userRepPermDataList != null && !userRepPermDataList.isEmpty()) {
            int[] rowIndices = this.getModel().batchCreateNewEntryRow(ENTRY_REPORT_PERM_ENTRY, userRepPermDataList.size());
            for (int index = 0; index < rowIndices.length; ++index) {
                int rowIndex = rowIndices[index];
                UserRepPermData userRepPermData = userRepPermDataList.get(index);
                List<PermGroup> permGroups = userRepPermData.getPermGroups();
                StringBuilder showName = new StringBuilder();
                for (int groupIndex = 0; groupIndex < permGroups.size(); ++groupIndex) {
                    PermGroup group = permGroups.get(groupIndex);
                    List<PermFieldData> permFieldData = group.getUserRepPermFieldData();
                    for (PermFieldData fieldData : permFieldData) {
                        if (fieldData.isHasSubGroup()) {
                            List<PermFieldData> subGroupFields = fieldData.getSubGroupFields();
                            for (PermFieldData subGroupField : subGroupFields) {
                                showName.append(subGroupField.getDimName()).append('-');
                                showName.append(subGroupField.getDimSubGroupName()).append(':');
                                showName.append(subGroupField.getShowData());
                                showName.append('\n');
                            }
                            continue;
                        }
                        showName.append(fieldData.getDimName()).append(':');
                        if (fieldData.isNoLimit()) {
                            showName.append(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"", (String)"", (Object[])new Object[0]));
                        } else {
                            showName.append(fieldData.getShowData());
                        }
                        showName.append('\n');
                    }
                    if (groupIndex == permGroups.size() - 1) continue;
                    showName.append(ResManager.loadKDString((String)"\u6216", (String)"", (String)"", (Object[])new Object[0]));
                    showName.append('\n');
                }
                this.getModel().setValue(FIELD_REPORT, (Object)Long.parseLong(userRepPermData.getReportId()), rowIndex);
                this.getModel().setValue(FIELD_DATA_RANGE, (Object)showName.toString(), rowIndex);
                this.getModel().setValue(FIELD_DATE_RANGE_START, (Object)userRepPermData.getStartDate(), rowIndex);
                this.getModel().setValue(FIELD_DATE_RANGE_END, (Object)userRepPermData.getEndDate(), rowIndex);
            }
        }
    }

    private List<UserRepPermData> buildPermDataList(DynamicObject userPermDy) {
        DynamicObjectCollection selectReportEntry = userPermDy.getDynamicObjectCollection("selectreportentry");
        LinkedHashMap repPermDataMap = Maps.newLinkedHashMapWithExpectedSize((int)selectReportEntry.size());
        HashSet selectReportIds = Sets.newHashSetWithExpectedSize((int)selectReportEntry.size());
        for (DynamicObject selectReportEntryDy : selectReportEntry) {
            DynamicObject reportDy = selectReportEntryDy.getDynamicObject("selectreport");
            if (reportDy == null) continue;
            UserRepPermData repPermData = new UserRepPermData(reportDy.getString("id"), reportDy.getString("name"), reportDy.getString("description"));
            Date startDate = selectReportEntryDy.getDate("selectstartdate");
            Date endDate = selectReportEntryDy.getDate("selectenddate");
            repPermData.setStartDate(startDate);
            repPermData.setEndDate(endDate);
            repPermDataMap.put(repPermData.getReportId(), repPermData);
            selectReportIds.add(Long.parseLong(repPermData.getReportId()));
        }
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        DynamicObject[] fieldMapArray = REP_FIELD_MAP_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "in", (Object)selectReportIds)});
        Map<String, QueryFieldBo> queryFieldBoMap = ReportUserPermFormUtils.initQueryFieldBoMap(fieldMapArray);
        DynamicObjectCollection rptPermDataEntry = userPermDy.getDynamicObjectCollection("rptpermdataentry");
        HashMap entityNumberToIdMap = Maps.newHashMapWithExpectedSize((int)rptPermDataEntry.size());
        for (DynamicObject rptPermDataEntryDy : rptPermDataEntry) {
            String data;
            String fieldId;
            QueryFieldBo queryFieldBo;
            DynamicObject fieldDy = rptPermDataEntryDy.getDynamicObject("queryfield");
            if (fieldDy == null || (queryFieldBo = queryFieldBoMap.get(fieldId = fieldDy.getString("id"))) == null || !HRStringUtils.isNotEmpty((String)queryFieldBo.getBaseDataNum())) continue;
            Set ids = (Set)entityNumberToIdMap.get(queryFieldBo.getBaseDataNum());
            if (ids == null) {
                ids = Sets.newHashSetWithExpectedSize((int)rptPermDataEntry.size());
            }
            if (HRStringUtils.isNotEmpty((String)(data = rptPermDataEntryDy.getString("data")))) {
                String[] idArray = data.split(",");
                Collections.addAll(ids, idArray);
            }
            entityNumberToIdMap.put(queryFieldBo.getBaseDataNum(), ids);
        }
        Map<String, String> baseDataIdToShowNameMap = ReportUserPermFormUtils.getBaseDataIdToShowNameMap(mainEntityTypeUtil, entityNumberToIdMap);
        HashMap fieldDataMap = Maps.newHashMapWithExpectedSize((int)rptPermDataEntry.size());
        for (DynamicObject rptPermDataEntryDy : rptPermDataEntry) {
            String fieldId;
            QueryFieldBo queryFieldBo;
            String groupKey;
            DynamicObject reportDy = rptPermDataEntryDy.getDynamicObject(FIELD_REPORT);
            DynamicObject fieldDy = rptPermDataEntryDy.getDynamicObject("queryfield");
            if (reportDy == null || fieldDy == null) continue;
            UserRepPermData userRepPermData = (UserRepPermData)repPermDataMap.get(reportDy.getString("id"));
            Map<String, PermGroup> permGroupMap = userRepPermData.getPermGroupMap();
            PermGroup group = permGroupMap.get(groupKey = rptPermDataEntryDy.getString("permgroup"));
            if (group == null) {
                group = new PermGroup(groupKey);
                List<PermGroup> permGroups = userRepPermData.getPermGroups();
                permGroups.add(group);
            }
            if ((queryFieldBo = queryFieldBoMap.get(fieldId = fieldDy.getString("id"))) == null) continue;
            List<PermFieldData> permFieldDataList = group.getUserRepPermFieldData();
            PermFieldData permFieldData = new PermFieldData();
            String fieldDimType = this.getFieldDimType(queryFieldBo);
            String mergeDimKey = this.getMergeDimKey(mainEntityTypeUtil, queryFieldBo, fieldDimType);
            permFieldData.setFieldId(fieldId);
            permFieldData.setDimNumber(mergeDimKey);
            String fieldUniqueKey = userRepPermData.getReportId() + "|" + groupKey + "&" + mergeDimKey;
            String data = rptPermDataEntryDy.getString("data");
            permFieldData.setNoLimit(rptPermDataEntryDy.getBoolean("nolimit"));
            ComboProp ids = data.split(",");
            PermFieldData fieldData = (PermFieldData)fieldDataMap.get(fieldUniqueKey);
            String entityNumber = queryFieldBo._getFieldEntityNumber();
            MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(entityNumber);
            if (FieldDimType.COMBO.getValue().equals(fieldDimType)) {
                DynamicProperty fieldProperty = this.getFieldProperty(mainEntityType, queryFieldBo.getFieldPath());
                if (fieldProperty != null) {
                    permFieldData.setDimName(fieldProperty.getDisplayName().getLocaleValue());
                    ComboProp comboProp = (ComboProp)fieldProperty;
                    ArrayList showNames = Lists.newArrayListWithExpectedSize((int)((ComboProp)ids).length);
                    for (ComboProp id : ids) {
                        String name = comboProp.getItemByName((String)id);
                        if (!HRStringUtils.isNotEmpty((String)name)) continue;
                        showNames.add(name);
                    }
                    permFieldData.setShowData(String.join((CharSequence)"\u3001", showNames));
                }
            } else {
                permFieldData.setDimName(mainEntityType.getDisplayName().getLocaleValue());
                ArrayList showNames = Lists.newArrayListWithExpectedSize((int)((String[])ids).length);
                for (ComboProp id : ids) {
                    String name = baseDataIdToShowNameMap.get(entityNumber + "_" + (String)id);
                    if (!HRStringUtils.isNotEmpty((String)name)) continue;
                    showNames.add(name);
                }
                permFieldData.setShowData(String.join((CharSequence)"\u3001", showNames));
            }
            DynamicObject adminOrgStructDy = rptPermDataEntryDy.getDynamicObject("adminorgstruct");
            if (adminOrgStructDy != null) {
                permFieldData.setDimSubGroupName(adminOrgStructDy.getString("name"));
                if (fieldData == null) {
                    fieldData = new PermFieldData();
                    fieldData.setFieldId(permFieldData.getFieldId());
                    fieldData.setDimName(permFieldData.getDimName());
                    fieldData.setHasSubGroup(true);
                    permFieldDataList.add(fieldData);
                }
                List<PermFieldData> subGroupFields = fieldData.getSubGroupFields();
                subGroupFields.add(permFieldData);
                fieldDataMap.put(fieldUniqueKey, fieldData);
                continue;
            }
            permFieldDataList.add(permFieldData);
        }
        return Lists.newArrayList(repPermDataMap.values());
    }

    private void clearEntry() {
        DynamicObjectCollection reportPermDataEntry = this.getModel().getEntryEntity(ENTRY_REPORT_PERM_ENTRY);
        reportPermDataEntry.clear();
        this.getModel().updateEntryCache(reportPermDataEntry);
        this.getView().updateView(ENTRY_REPORT_PERM_ENTRY);
    }
}

