/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.perm.processor;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.common.constant.perm.ReportUserPermConstants;
import kd.hr.hrptc.common.model.perm.AdminOrgFieldStructureVO;
import kd.hr.hrptc.common.model.perm.AdminOrgStructureVO;
import kd.hr.hrptc.common.model.perm.FieldDimType;
import kd.hr.hrptc.formplugin.perm.ReportUserPermEdit;
import kd.hr.hrptc.formplugin.perm.model.PermFieldData;
import kd.hr.hrptc.formplugin.perm.model.PermGroup;
import kd.hr.hrptc.formplugin.perm.model.UserRepPermData;
import kd.hr.hrptc.formplugin.perm.model.UserRepPermDataRangeReturnVO;
import kd.hr.hrptc.formplugin.perm.processor.ReportUserPermVOProcessor;
import kd.hr.hrptc.formplugin.perm.utils.ReportUserPermFormUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;

public class ReportUserPermDataProcessor
implements ReportUserPermConstants {
    private final MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
    private final ReportUserPermEdit plugin;
    private final ReportUserPermVOProcessor voProcessor;

    public ReportUserPermDataProcessor(ReportUserPermEdit plugin, ReportUserPermVOProcessor voProcessor) {
        this.plugin = plugin;
        this.voProcessor = voProcessor;
    }

    private IDataModel getModel() {
        return this.plugin.getView().getModel();
    }

    private IFormView getView() {
        return this.plugin.getView();
    }

    public void updateDisableReportFieldEntry(Long reportId, Long fieldId, Boolean open) {
        DynamicObjectCollection disableFieldEntry = this.getModel().getEntryEntity("fielddisableentry");
        Iterator iterator = disableFieldEntry.iterator();
        boolean find = false;
        while (iterator.hasNext()) {
            DynamicObject disableFieldEntryDy = (DynamicObject)iterator.next();
            DynamicObject disableReport = disableFieldEntryDy.getDynamicObject("disablefieldreport");
            DynamicObject disableField = disableFieldEntryDy.getDynamicObject("disablefield");
            if (disableReport != null && disableField != null) {
                if (!disableReport.getPkValue().equals(reportId) || !disableField.getPkValue().equals(fieldId) || !open.booleanValue()) continue;
                iterator.remove();
                find = true;
                continue;
            }
            iterator.remove();
        }
        this.getModel().updateEntryCache(disableFieldEntry);
        if (!find && !open.booleanValue()) {
            int newEntryRow = this.getModel().createNewEntryRow("fielddisableentry");
            this.getModel().setValue("disablefieldreport", (Object)reportId, newEntryRow);
            this.getModel().setValue("disablefield", (Object)fieldId, newEntryRow);
            DynamicObjectCollection entity = this.getModel().getEntryEntity("fielddisableentry");
            this.getModel().updateEntryCache(entity);
        }
    }

    public void updateOnePermDataEntry(Long reportId, Long fieldId, boolean open, boolean mustInput) {
        DynamicObjectCollection repPermDataEntry = this.getModel().getEntryEntity("rptpermdataentry");
        if (open) {
            DynamicObject queryField = QUERY_FIELD_HELPER.loadSingle((Object)fieldId);
            List queryFieldBos = AnalyseObjectService.getInstance().assembleQueryFields(new DynamicObject[]{queryField});
            Map adminOrgFieldStructureVOMap = this.getAdminOrgFieldStructList(this.getView(), queryFieldBos);
            HashSet mergeGroupKeySet = Sets.newHashSetWithExpectedSize((int)repPermDataEntry.size());
            HashSet independentGroupKeySet = Sets.newHashSetWithExpectedSize((int)repPermDataEntry.size());
            boolean isIndependentReport = false;
            for (DynamicObject repPermDataEntryDy : repPermDataEntry) {
                DynamicObject report = repPermDataEntryDy.getDynamicObject("report");
                boolean isMerge = repPermDataEntryDy.getBoolean("ismerge");
                if (isMerge) {
                    mergeGroupKeySet.add(repPermDataEntryDy.getString("permgroup"));
                    continue;
                }
                if (report.getLong("id") != reportId.longValue()) continue;
                isIndependentReport = true;
                independentGroupKeySet.add(repPermDataEntryDy.getString("permgroup"));
            }
            Map<Object, Object> mergeGroupMap = Maps.newHashMapWithExpectedSize((int)0);
            if (!isIndependentReport) {
                UserRepPermDataRangeReturnVO rangeReturnVO = this.voProcessor.getUserRepPermDataRangeReturnVO();
                List<PermGroup> mergeRepPermData = rangeReturnVO.getMergeRepPermData();
                mergeGroupMap = mergeRepPermData.stream().collect(Collectors.toMap(PermGroup::getGroupKey, Function.identity()));
            }
            for (QueryFieldBo queryFieldBo : queryFieldBos) {
                HashSet groupKeySet;
                String fieldDimType = this.getFieldDimType(queryFieldBo);
                UserRepPermData userRepPermData = new UserRepPermData();
                userRepPermData.setReportId(String.valueOf(reportId));
                userRepPermData.setMerge(!isIndependentReport);
                HashSet hashSet = groupKeySet = isIndependentReport ? independentGroupKeySet : mergeGroupKeySet;
                if (groupKeySet.isEmpty()) {
                    groupKeySet.add("group_1");
                }
                for (String groupKey : groupKeySet) {
                    PermGroup group = (PermGroup)mergeGroupMap.get(groupKey);
                    if (group == null) {
                        group = new PermGroup(groupKey);
                    }
                    List<PermFieldData> fieldData = group.getUserRepPermFieldData();
                    Map<String, PermFieldData> dimUniqueFieldMap = this.getDimUniqueFieldMap(fieldData);
                    String mergeDimKey = this.getMergeDimKey(this.mainEntityTypeUtil, queryFieldBo, fieldDimType);
                    String dimUniqueKey = groupKey + "&" + mergeDimKey;
                    if (FieldDimType.ADMIN_ORG.getValue().equals(fieldDimType)) {
                        String adminOrgFieldUniqueKey = this.getAdminOrgFieldUniqueKey(queryFieldBo.getEntityNumber(), queryFieldBo.getFieldNumber(), queryFieldBo._getFieldEntityNumber());
                        AdminOrgFieldStructureVO fieldStructureVO = (AdminOrgFieldStructureVO)adminOrgFieldStructureVOMap.get(adminOrgFieldUniqueKey);
                        if (fieldStructureVO == null) continue;
                        Collection structureVOList = fieldStructureVO._getStructureVOList();
                        for (AdminOrgStructureVO structureVO : structureVOList) {
                            String subDimUniqueKey = dimUniqueKey + "#" + structureVO.getId();
                            PermFieldData subGroupField = new PermFieldData();
                            subGroupField.setFieldId(String.valueOf(fieldId));
                            subGroupField.setDimSubGroupId(structureVO.getId());
                            subGroupField.setMustInput(mustInput);
                            PermFieldData oldField = dimUniqueFieldMap.get(subDimUniqueKey);
                            if (oldField != null) {
                                subGroupField.setNoLimit(oldField.isNoLimit());
                                subGroupField.setData(oldField.getData());
                                subGroupField.setIncludeSub(oldField.isIncludeSub());
                            }
                            this.addNewPermFieldEntryData(userRepPermData, group, subGroupField, true);
                        }
                        continue;
                    }
                    PermFieldData oldField = dimUniqueFieldMap.get(dimUniqueKey);
                    PermFieldData userRepPermField = new PermFieldData();
                    userRepPermField.setFieldId(String.valueOf(fieldId));
                    userRepPermField.setMustInput(mustInput);
                    if (oldField != null) {
                        userRepPermField.setNoLimit(oldField.isNoLimit());
                        userRepPermField.setData(oldField.getData());
                        userRepPermField.setIncludeSub(oldField.isIncludeSub());
                    }
                    this.addNewPermFieldEntryData(userRepPermData, group, userRepPermField, false);
                }
            }
            this.getModel().updateEntryCache(this.getModel().getEntryEntity("rptpermdataentry"));
        } else {
            Iterator iterator = repPermDataEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject repPermDataEntryDy = (DynamicObject)iterator.next();
                DynamicObject queryFieldDy = repPermDataEntryDy.getDynamicObject("queryfield");
                DynamicObject reportDy = repPermDataEntryDy.getDynamicObject("report");
                if (reportDy == null || queryFieldDy == null || !String.valueOf(reportId).equals(reportDy.getString("id")) || !String.valueOf(fieldId).equals(queryFieldDy.getString("id"))) continue;
                iterator.remove();
            }
            this.getModel().updateEntryCache(repPermDataEntry);
        }
        this.getView().getPageCache().put("CACHE_KEY_IS_PERM_DATA_CHANGE", "true");
    }

    public void updatePermDataEntry(List<UserRepPermData> userRepPermDataList, boolean updateData) {
        List<PermGroup> permGroups;
        String reportId;
        Object permField;
        UserRepPermData userRepPermData;
        DynamicObjectCollection repPermDataEntry = this.getModel().getEntryEntity("rptpermdataentry");
        Map<String, UserRepPermData> userRepPermDataMap = userRepPermDataList.stream().collect(Collectors.toMap(UserRepPermData::getReportId, Function.identity()));
        Map<Object, Boolean> selectedReportIsMergeMap = ReportUserPermFormUtils.getSelectedReportIsMergeMap(this.getModel());
        Set oldReportIdSet = selectedReportIsMergeMap.keySet().stream().map(String::valueOf).collect(Collectors.toSet());
        HashSet deleteReportIdSet = Sets.newHashSet(oldReportIdSet);
        deleteReportIdSet.removeAll(userRepPermDataMap.keySet());
        Iterator iterator = repPermDataEntry.iterator();
        boolean isChange = false;
        HashMap oldReportGroupMap = Maps.newHashMapWithExpectedSize((int)oldReportIdSet.size());
        while (iterator.hasNext()) {
            DynamicObject repPermData = (DynamicObject)iterator.next();
            DynamicObject reportDy = repPermData.getDynamicObject("report");
            if (reportDy == null) continue;
            String reportId2 = reportDy.getString("id");
            if (deleteReportIdSet.contains(reportId2)) {
                iterator.remove();
                isChange = true;
                continue;
            }
            PermGroup permGroup = this.getPermGroupByEntryDy(repPermData, userRepPermDataMap);
            if (permGroup == null) {
                iterator.remove();
                isChange = true;
                continue;
            }
            userRepPermData = userRepPermDataMap.get(reportId2);
            oldReportGroupMap.putIfAbsent(reportId2, Sets.newHashSetWithExpectedSize((int)userRepPermData.getPermGroupMap().size()));
            oldReportGroupMap.computeIfPresent(reportId2, (oldKey, oldValue) -> {
                oldValue.add(permGroup.getGroupKey());
                return oldValue;
            });
            permField = this.getPermFieldDataByEntryDy(repPermData, userRepPermDataMap);
            if (permField != null && ((PermFieldData)permField).isOpen()) continue;
            iterator.remove();
            isChange = true;
        }
        if (updateData) {
            for (DynamicObject repPermData : repPermDataEntry) {
                DynamicObject reportDy = repPermData.getDynamicObject("report");
                reportId = reportDy.getString("id");
                userRepPermData = userRepPermDataMap.get(reportId);
                permField = this.getPermFieldDataByEntryDy(repPermData, userRepPermDataMap);
                if (permField == null) continue;
                repPermData.set("ismerge", (Object)userRepPermData.isMerge());
                repPermData.set("data", (Object)((PermFieldData)permField).getData());
                repPermData.set("nolimit", (Object)((PermFieldData)permField).isNoLimit());
                repPermData.set("includesub", (Object)((PermFieldData)permField).isIncludeSub());
                isChange = true;
            }
        }
        this.getModel().updateEntryCache(repPermDataEntry);
        HashSet newRepPermReportIds = Sets.newHashSet(userRepPermDataMap.keySet());
        newRepPermReportIds.removeAll(oldReportIdSet);
        for (String newReportId : newRepPermReportIds) {
            UserRepPermData userRepPermData2 = userRepPermDataMap.get(newReportId);
            permGroups = userRepPermData2.getPermGroups();
            for (PermGroup permGroup : permGroups) {
                List<PermFieldData> userRepPermFieldData = permGroup.getUserRepPermFieldData();
                for (PermFieldData userRepPermField : userRepPermFieldData) {
                    if (userRepPermField.isHasSubGroup()) {
                        List<PermFieldData> subGroupFields = userRepPermField.getSubGroupFields();
                        for (PermFieldData subGroupField : subGroupFields) {
                            this.addNewPermFieldEntryData(userRepPermData2, permGroup, subGroupField, true);
                            isChange = true;
                        }
                        continue;
                    }
                    this.addNewPermFieldEntryData(userRepPermData2, permGroup, userRepPermField, false);
                    isChange = true;
                }
            }
        }
        for (UserRepPermData userRepPermData3 : userRepPermDataList) {
            reportId = userRepPermData3.getReportId();
            if (newRepPermReportIds.contains(reportId)) continue;
            permGroups = userRepPermData3.getPermGroups();
            Set oldGroupKeys = (Set)oldReportGroupMap.get(reportId);
            for (PermGroup permGroup : permGroups) {
                String groupKey = permGroup.getGroupKey();
                if (oldGroupKeys.contains(groupKey)) continue;
                List<PermFieldData> userRepPermFieldData = permGroup.getUserRepPermFieldData();
                for (PermFieldData userRepPermField : userRepPermFieldData) {
                    if (userRepPermField.isHasSubGroup()) {
                        List<PermFieldData> subGroupFields = userRepPermField.getSubGroupFields();
                        for (PermFieldData subGroupField : subGroupFields) {
                            this.addNewPermFieldEntryData(userRepPermData3, permGroup, subGroupField, true);
                            isChange = true;
                        }
                        continue;
                    }
                    this.addNewPermFieldEntryData(userRepPermData3, permGroup, userRepPermField, false);
                    isChange = true;
                }
            }
        }
        this.getModel().updateEntryCache(this.getModel().getEntryEntity("rptpermdataentry"));
        if (isChange) {
            this.getView().getPageCache().put("CACHE_KEY_IS_PERM_DATA_CHANGE", "true");
        }
        this.updateSelectReportGroups();
    }

    private PermGroup getPermGroupByEntryDy(DynamicObject permDataEntryDy, Map<String, UserRepPermData> userRepPermDataMap) {
        DynamicObject reportDy = permDataEntryDy.getDynamicObject("report");
        String permGroupKey = permDataEntryDy.getString("permgroup");
        String reportId = reportDy.getString("id");
        UserRepPermData userRepPermData = userRepPermDataMap.get(reportId);
        if (userRepPermData == null) {
            return null;
        }
        Map<String, PermGroup> permGroupMap = userRepPermData.getPermGroupMap();
        return permGroupMap.get(permGroupKey);
    }

    private PermFieldData getPermFieldDataByEntryDy(DynamicObject permDataEntryDy, Map<String, UserRepPermData> userRepPermDataMap) {
        DynamicObject queryFieldDy;
        String fieldId;
        DynamicObject reportDy = permDataEntryDy.getDynamicObject("report");
        String permGroupKey = permDataEntryDy.getString("permgroup");
        String reportId = reportDy.getString("id");
        UserRepPermData userRepPermData = userRepPermDataMap.get(reportId);
        Map<String, PermGroup> permGroupMap = userRepPermData.getPermGroupMap();
        PermGroup permGroup = permGroupMap.get(permGroupKey);
        Map<String, PermFieldData> permFieldMap = permGroup.getUserRepPermFieldDataMap();
        PermFieldData fieldData = permFieldMap.get(fieldId = (queryFieldDy = permDataEntryDy.getDynamicObject("queryfield")).getString("id"));
        if (fieldData.isHasSubGroup()) {
            DynamicObject adminOrgStructDy = permDataEntryDy.getDynamicObject("adminorgstruct");
            if (adminOrgStructDy == null) {
                return null;
            }
            Map<String, PermFieldData> subGroupFieldMap = fieldData._getSubGroupFieldMap();
            fieldData = subGroupFieldMap.get(adminOrgStructDy.getString("id"));
        }
        return fieldData;
    }

    private void addNewPermFieldEntryData(UserRepPermData userRepPermData, PermGroup permGroup, PermFieldData userRepPermFieldData, boolean isSubGroup) {
        String reportId = userRepPermData.getReportId();
        int newEntryRow = this.getModel().createNewEntryRow("rptpermdataentry");
        this.getModel().setValue("report", (Object)Long.parseLong(reportId), newEntryRow);
        this.getModel().setValue("permgroup", (Object)permGroup.getGroupKey(), newEntryRow);
        this.getModel().setValue("queryfield", (Object)Long.parseLong(userRepPermFieldData.getFieldId()), newEntryRow);
        this.getModel().setValue("ismerge", (Object)userRepPermData.isMerge(), newEntryRow);
        this.getModel().setValue("data", (Object)userRepPermFieldData.getData(), newEntryRow);
        this.getModel().setValue("mustinput", (Object)userRepPermFieldData.isMustInput(), newEntryRow);
        this.getModel().setValue("nolimit", (Object)userRepPermFieldData.isNoLimit(), newEntryRow);
        this.getModel().setValue("includesub", (Object)userRepPermFieldData.isIncludeSub(), newEntryRow);
        if (isSubGroup) {
            this.getModel().setValue("adminorgstruct", (Object)Long.parseLong(userRepPermFieldData.getDimSubGroupId()), newEntryRow);
        }
    }

    public void updateReportMergeTag(Object independentReportId, Object mergeReportId) {
        List<PermFieldData> subGroupFields;
        List<PermFieldData> newFieldPermDataList;
        Object group;
        DynamicObject dimMapDy;
        DynamicObject[] dbRepDimMapDys;
        HashSet invokeReportIdSet = Sets.newHashSetWithExpectedSize((int)2);
        if (independentReportId != null) {
            invokeReportIdSet.add(Long.parseLong(String.valueOf(independentReportId)));
        }
        if (mergeReportId != null) {
            invokeReportIdSet.add(Long.parseLong(String.valueOf(mergeReportId)));
        }
        DynamicObjectCollection permDataEntry = this.getModel().getEntryEntity("rptpermdataentry");
        UserRepPermDataRangeReturnVO rangeReturnVO = this.voProcessor.getUserRepPermDataRangeReturnVO();
        Iterator iterator = permDataEntry.iterator();
        while (iterator.hasNext()) {
            DynamicObject permDataDy = (DynamicObject)iterator.next();
            DynamicObject reportDy = permDataDy.getDynamicObject("report");
            if (!String.valueOf(reportDy.getPkValue()).equals(String.valueOf(independentReportId)) && !String.valueOf(reportDy.getPkValue()).equals(String.valueOf(mergeReportId))) continue;
            iterator.remove();
        }
        this.getModel().updateEntryCache(permDataEntry);
        List<PermGroup> mergeRepPermData = rangeReturnVO.getMergeRepPermData();
        HashMap reportIdToFieldMapDyMap = Maps.newHashMapWithExpectedSize((int)2);
        for (DynamicObject dbRepDimMapDy : dbRepDimMapDys = REP_FIELD_MAP_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "in", (Object)invokeReportIdSet)})) {
            reportIdToFieldMapDyMap.put(dbRepDimMapDy.getDynamicObject("rptmanage").getString("id"), dbRepDimMapDy);
        }
        Map<String, QueryFieldBo> queryFieldBoMap = ReportUserPermFormUtils.initQueryFieldBoMap(reportIdToFieldMapDyMap.values().toArray(new DynamicObject[0]));
        Map adminOrgFieldStructureVOMap = this.getAdminOrgFieldStructList(this.getView(), queryFieldBoMap.values());
        Map<String, Set<String>> disableFieldMap = this.voProcessor.getDisableFieldMap();
        HashMap reportIdIsMergeMap = Maps.newHashMapWithExpectedSize((int)1);
        if (mergeReportId != null) {
            dimMapDy = (DynamicObject)reportIdToFieldMapDyMap.get(String.valueOf(mergeReportId));
            reportIdIsMergeMap.put(mergeReportId, true);
            UserRepPermData newMergeRepPermData = this.voProcessor.buildRepPermDimMap(dimMapDy, disableFieldMap, reportIdIsMergeMap, queryFieldBoMap, adminOrgFieldStructureVOMap);
            if (mergeRepPermData.isEmpty()) {
                group = new PermGroup("group_1");
                newFieldPermDataList = newMergeRepPermData.getUserRepPermFieldData();
                for (PermFieldData fieldData : newFieldPermDataList) {
                    if (!fieldData.isOpen()) continue;
                    if (fieldData.isHasSubGroup()) {
                        subGroupFields = fieldData.getSubGroupFields();
                        for (PermFieldData subGroupField : subGroupFields) {
                            this.addNewPermFieldEntryData(newMergeRepPermData, (PermGroup)group, subGroupField, true);
                        }
                        continue;
                    }
                    this.addNewPermFieldEntryData(newMergeRepPermData, (PermGroup)group, fieldData, false);
                }
            } else {
                for (PermGroup mergeGroup : mergeRepPermData) {
                    List<PermFieldData> permFieldDataList = mergeGroup.getUserRepPermFieldData();
                    Map<String, PermFieldData> fieldDataMap = this.getDimUniqueFieldMap(permFieldDataList);
                    List<PermFieldData> newFieldPermDataList2 = newMergeRepPermData.getUserRepPermFieldData();
                    for (PermFieldData fieldData : newFieldPermDataList2) {
                        if (!fieldData.isOpen()) continue;
                        QueryFieldBo queryFieldBo = queryFieldBoMap.get(fieldData.getFieldId());
                        String fieldDimType = this.getFieldDimType(queryFieldBo);
                        String mergeDimKey = this.getMergeDimKey(this.mainEntityTypeUtil, queryFieldBo, fieldDimType);
                        String dimUniqueKey = mergeGroup.getGroupKey() + "&" + mergeDimKey;
                        if (fieldData.isHasSubGroup()) {
                            List<PermFieldData> subGroupFields2 = fieldData.getSubGroupFields();
                            for (PermFieldData subGroupField : subGroupFields2) {
                                String subDimUniqueKey = dimUniqueKey + "#" + subGroupField.getDimSubGroupId();
                                PermFieldData oldFieldData = fieldDataMap.get(subDimUniqueKey);
                                if (oldFieldData != null) {
                                    subGroupField.setData(oldFieldData.getData());
                                    subGroupField.setNoLimit(oldFieldData.isNoLimit());
                                }
                                this.addNewPermFieldEntryData(newMergeRepPermData, mergeGroup, subGroupField, true);
                            }
                            continue;
                        }
                        PermFieldData oldFieldData = fieldDataMap.get(dimUniqueKey);
                        if (oldFieldData != null) {
                            fieldData.setData(oldFieldData.getData());
                            fieldData.setNoLimit(oldFieldData.isNoLimit());
                        }
                        this.addNewPermFieldEntryData(newMergeRepPermData, mergeGroup, fieldData, false);
                    }
                }
            }
        }
        if (independentReportId != null) {
            dimMapDy = (DynamicObject)reportIdToFieldMapDyMap.get(String.valueOf(independentReportId));
            reportIdIsMergeMap.put(Long.parseLong(String.valueOf(independentReportId)), false);
            UserRepPermData newIndependentRepPermData = this.voProcessor.buildRepPermDimMap(dimMapDy, disableFieldMap, reportIdIsMergeMap, queryFieldBoMap, adminOrgFieldStructureVOMap);
            group = new PermGroup("group_1");
            newFieldPermDataList = newIndependentRepPermData.getUserRepPermFieldData();
            for (PermFieldData fieldData : newFieldPermDataList) {
                if (!fieldData.isOpen()) continue;
                if (fieldData.isHasSubGroup()) {
                    subGroupFields = fieldData.getSubGroupFields();
                    for (PermFieldData subGroupField : subGroupFields) {
                        this.addNewPermFieldEntryData(newIndependentRepPermData, (PermGroup)group, subGroupField, true);
                    }
                    continue;
                }
                this.addNewPermFieldEntryData(newIndependentRepPermData, (PermGroup)group, fieldData, false);
            }
        }
        DynamicObjectCollection newEntry = this.getModel().getEntryEntity("rptpermdataentry");
        this.getModel().updateEntryCache(newEntry);
        String sortReportIdStr = this.getView().getPageCache().get("CACHE_KEY_OF_INDEPENDENT_REPORT_SORT_INDEX");
        if (HRStringUtils.isNotEmpty((String)sortReportIdStr)) {
            List sortReportIds = JSONArray.parseArray((String)sortReportIdStr, String.class);
            if (independentReportId == null && mergeReportId != null) {
                sortReportIds.remove(String.valueOf(mergeReportId));
            } else if (independentReportId != null && mergeReportId != null) {
                Integer reportIndex = null;
                for (int index = 0; index < sortReportIds.size(); ++index) {
                    String reportId = (String)sortReportIds.get(index);
                    if (!mergeReportId.equals(reportId)) continue;
                    reportIndex = index;
                    break;
                }
                if (reportIndex != null) {
                    sortReportIds.set(reportIndex, String.valueOf(independentReportId));
                }
            } else if (independentReportId != null) {
                sortReportIds.add(String.valueOf(independentReportId));
            }
            this.getView().getPageCache().put("CACHE_KEY_OF_INDEPENDENT_REPORT_SORT_INDEX", JSONArray.toJSONString((Object)sortReportIds));
        } else if (independentReportId != null && mergeReportId == null) {
            this.getView().getPageCache().put("CACHE_KEY_OF_INDEPENDENT_REPORT_SORT_INDEX", JSONArray.toJSONString((Object)Lists.newArrayList((Object[])new String[]{String.valueOf(independentReportId)})));
        }
        ReportUserPermFormUtils.changeSelectReportIsMerge(this.getModel(), mergeReportId, true);
        ReportUserPermFormUtils.changeSelectReportIsMerge(this.getModel(), independentReportId, false);
    }

    private Map<String, PermFieldData> getDimUniqueFieldMap(List<PermFieldData> permFieldDataList) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)permFieldDataList.size());
        for (PermFieldData fieldData : permFieldDataList) {
            if (fieldData.isHasSubGroup()) {
                List<PermFieldData> subGroupFields = fieldData.getSubGroupFields();
                for (PermFieldData subGroupField : subGroupFields) {
                    map.put(subGroupField.getDimUniqueKey(), subGroupField);
                }
                continue;
            }
            map.put(fieldData.getDimUniqueKey(), fieldData);
        }
        return map;
    }

    private void updateSelectReportGroups() {
        DynamicObject groupKeyEntryDy;
        DynamicObjectCollection groupKeyEntry;
        Set groupKeys;
        Set<Long> transSelectNodeIds = ReportUserPermFormUtils.getTransSelectNodeIds(this.getView());
        DynamicObjectCollection permDataEntry = this.getModel().getEntryEntity("rptpermdataentry");
        HashMap reportIdToGroupSet = Maps.newHashMapWithExpectedSize((int)permDataEntry.size());
        HashMap reportIdIsMerge = Maps.newHashMapWithExpectedSize((int)permDataEntry.size());
        for (int index = 0; index < permDataEntry.size(); ++index) {
            DynamicObject permDataEntryDy = (DynamicObject)permDataEntry.get(index);
            DynamicObject reportDy = permDataEntryDy.getDynamicObject("report");
            String groupKey = permDataEntryDy.getString("permgroup");
            String reportId = reportDy.getString("id");
            reportIdToGroupSet.putIfAbsent(reportId, Sets.newHashSetWithExpectedSize((int)permDataEntry.size()));
            reportIdToGroupSet.computeIfPresent(reportId, (key, value) -> {
                value.add(groupKey);
                return value;
            });
            reportIdIsMerge.putIfAbsent(reportId, permDataEntryDy.getBoolean("ismerge"));
        }
        DynamicObjectCollection selectReportEntry = this.getModel().getEntryEntity("selectreportentry");
        Iterator iterator = selectReportEntry.iterator();
        HashSet selectReportIds = Sets.newHashSetWithExpectedSize((int)selectReportEntry.size());
        while (iterator.hasNext()) {
            Boolean isMerge;
            DynamicObject selectReportEntryDy = (DynamicObject)iterator.next();
            DynamicObject selectReportDy = selectReportEntryDy.getDynamicObject("selectreport");
            if (selectReportDy == null) {
                iterator.remove();
                continue;
            }
            String selectReportId = selectReportDy.getString("id");
            long longReportId = Long.parseLong(selectReportId);
            if (!transSelectNodeIds.contains(longReportId)) {
                iterator.remove();
                continue;
            }
            selectReportIds.add(longReportId);
            groupKeys = (Set)reportIdToGroupSet.get(selectReportId);
            if (groupKeys != null) {
                groupKeyEntry = selectReportEntryDy.getDynamicObjectCollection("selectreportgroupentry");
                groupKeyEntry.clear();
                for (String groupKey : groupKeys) {
                    groupKeyEntryDy = groupKeyEntry.addNew();
                    groupKeyEntryDy.set("selectreportgroupkey", (Object)groupKey);
                }
            }
            if ((isMerge = (Boolean)reportIdIsMerge.get(selectReportId)) == null) {
                selectReportEntryDy.set("selectreportismerge", (Object)true);
                continue;
            }
            selectReportEntryDy.set("selectreportismerge", (Object)isMerge);
        }
        this.getModel().updateEntryCache(selectReportEntry);
        transSelectNodeIds.removeAll(selectReportIds);
        SubEntryProp subSelectGroupEntryProp = (SubEntryProp)this.getModel().getProperty("selectreportgroupentry");
        for (Long newSelectId : transSelectNodeIds) {
            int newEntryRow = this.getModel().createNewEntryRow("selectreportentry");
            this.getModel().setValue("selectreport", (Object)newSelectId, newEntryRow);
            Boolean isMerge = (Boolean)reportIdIsMerge.get(String.valueOf(newSelectId));
            if (isMerge == null) {
                this.getModel().setValue("selectreportismerge", (Object)true, newEntryRow);
            } else {
                this.getModel().setValue("selectreportismerge", (Object)isMerge, newEntryRow);
            }
            if ((groupKeys = (Set)reportIdToGroupSet.get(String.valueOf(newSelectId))) == null) continue;
            groupKeyEntry = (DynamicObjectCollection)this.getModel().getValue("selectreportgroupentry", newEntryRow);
            for (String groupKey : groupKeys) {
                groupKeyEntryDy = (DynamicObject)subSelectGroupEntryProp.getDynamicCollectionItemPropertyType().createInstance();
                groupKeyEntryDy.set("selectreportgroupkey", (Object)groupKey);
                groupKeyEntry.add((Object)groupKeyEntryDy);
            }
            this.getModel().setValue("selectreportgroupentry", (Object)groupKeyEntry, newEntryRow);
        }
        this.getModel().updateEntryCache(this.getModel().getEntryEntity("selectreportentry"));
    }

    public void initPermDataEntry() {
        UserRepPermData repPermData;
        Map<Object, Boolean> selectedReportIsMergeMap = ReportUserPermFormUtils.getSelectedReportIsMergeMap(this.getModel());
        Map<String, Set<String>> disableFieldMap = this.voProcessor.getDisableFieldMap();
        DynamicObject[] fieldMapDys = REP_FIELD_MAP_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "in", selectedReportIsMergeMap.keySet())});
        Map<String, QueryFieldBo> queryFieldBoMap = ReportUserPermFormUtils.initQueryFieldBoMap(fieldMapDys);
        Map adminOrgFieldStructureVOMap = this.getAdminOrgFieldStructList(this.getView(), queryFieldBoMap.values());
        DynamicObjectCollection permDataEntry = this.getModel().getEntryEntity("rptpermdataentry");
        HashMap reportIdToGroupSet = Maps.newHashMapWithExpectedSize((int)permDataEntry.size());
        HashMap entryDyMap = Maps.newHashMapWithExpectedSize((int)permDataEntry.size());
        for (int index = 0; index < permDataEntry.size(); ++index) {
            DynamicObject permDataEntryDy = (DynamicObject)permDataEntry.get(index);
            DynamicObject reportDy = permDataEntryDy.getDynamicObject("report");
            String reportId = reportDy.getString("id");
            String groupKey = permDataEntryDy.getString("permgroup");
            reportIdToGroupSet.putIfAbsent(reportId, Sets.newHashSetWithExpectedSize((int)permDataEntry.size()));
            reportIdToGroupSet.computeIfPresent(reportId, (key, value) -> {
                value.add(groupKey);
                return value;
            });
            DynamicObject queryFieldDy = permDataEntryDy.getDynamicObject("queryfield");
            String fieldId = queryFieldDy.getString("id");
            DynamicObject admOrgStructDy = permDataEntryDy.getDynamicObject("adminorgstruct");
            StringBuilder mapKey = new StringBuilder();
            mapKey.append(reportId).append("_").append(groupKey).append("_").append(fieldId);
            if (admOrgStructDy != null) {
                mapKey.append("_").append(admOrgStructDy.getString("id"));
            }
            entryDyMap.put(mapKey.toString(), permDataEntryDy);
        }
        DynamicObjectCollection selectReportEntry = this.getModel().getEntryEntity("selectreportentry");
        HashSet disableReports = Sets.newHashSetWithExpectedSize((int)selectReportEntry.size());
        for (DynamicObject[] selectReportEntryDy : selectReportEntry) {
            DynamicObject selectReportDy = selectReportEntryDy.getDynamicObject("selectreport");
            String reportId = selectReportDy.getString("id");
            if (reportIdToGroupSet.containsKey(reportId)) continue;
            DynamicObjectCollection selectReportGroups = selectReportEntryDy.getDynamicObjectCollection("selectreportgroupentry");
            if (!selectReportGroups.isEmpty()) {
                HashSet groupKeys = Sets.newHashSetWithExpectedSize((int)selectReportGroups.size());
                for (DynamicObject groupEntryDy : selectReportGroups) {
                    String groupKey = groupEntryDy.getString("selectreportgroupkey");
                    if (!HRStringUtils.isNotEmpty((String)groupKey)) continue;
                    groupKeys.add(groupKey);
                }
                reportIdToGroupSet.put(reportId, groupKeys);
                continue;
            }
            disableReports.add(reportId);
        }
        HashMap repFieldMap = Maps.newHashMapWithExpectedSize((int)fieldMapDys.length);
        for (DynamicObject fieldMapDy : fieldMapDys) {
            repPermData = this.voProcessor.buildRepPermDimMap(fieldMapDy, disableFieldMap, selectedReportIsMergeMap, queryFieldBoMap, adminOrgFieldStructureVOMap);
            repFieldMap.put(repPermData.getReportId(), repPermData);
        }
        HashSet disableReportFields = Sets.newHashSetWithExpectedSize((int)permDataEntry.size());
        HashSet enableReportFields = Sets.newHashSetWithExpectedSize((int)permDataEntry.size());
        for (Map.Entry entry : reportIdToGroupSet.entrySet()) {
            String reportId = (String)entry.getKey();
            Set groupSet = (Set)entry.getValue();
            UserRepPermData repPermData2 = (UserRepPermData)repFieldMap.get(reportId);
            List<PermFieldData> permFieldDataList = repPermData2.getUserRepPermFieldData();
            for (String groupKey : groupSet) {
                PermGroup newGroup = new PermGroup(groupKey);
                for (PermFieldData permFieldData : permFieldDataList) {
                    String mapKey = reportId + "_" + groupKey + "_" + permFieldData.getFieldId();
                    if (permFieldData.isHasSubGroup()) {
                        DynamicObject entryDy;
                        String subMapKey;
                        List<PermFieldData> subGroupFields = permFieldData.getSubGroupFields();
                        boolean find = false;
                        for (PermFieldData subGroupField : subGroupFields) {
                            subMapKey = mapKey + "_" + subGroupField.getDimSubGroupId();
                            entryDy = (DynamicObject)entryDyMap.get(subMapKey);
                            if (entryDy == null) continue;
                            entryDy.set("mustinput", (Object)subGroupField.isMustInput());
                            find = true;
                            enableReportFields.add(reportId + "|" + permFieldData.getFieldId());
                        }
                        if (!find) {
                            disableReportFields.add(reportId + "|" + permFieldData.getFieldId());
                            continue;
                        }
                        for (PermFieldData subGroupField : subGroupFields) {
                            subMapKey = mapKey + "_" + subGroupField.getDimSubGroupId();
                            entryDy = (DynamicObject)entryDyMap.get(subMapKey);
                            if (entryDy != null) continue;
                            this.addNewPermFieldEntryData(repPermData2, newGroup, subGroupField, true);
                        }
                        continue;
                    }
                    DynamicObject entryDy = (DynamicObject)entryDyMap.get(mapKey);
                    if (entryDy == null) {
                        disableReportFields.add(reportId + "|" + permFieldData.getFieldId());
                        continue;
                    }
                    entryDy.set("mustinput", (Object)permFieldData.isMustInput());
                    enableReportFields.add(reportId + "|" + permFieldData.getFieldId());
                }
            }
        }
        for (String disableReportField : disableReportFields) {
            int newEntryRow;
            String[] keys = disableReportField.split("\\|");
            Set<String> fields = disableFieldMap.get(keys[0]);
            if (fields == null) {
                newEntryRow = this.getModel().createNewEntryRow("fielddisableentry");
                this.getModel().setValue("disablefieldreport", (Object)Long.parseLong(keys[0]), newEntryRow);
                this.getModel().setValue("disablefield", (Object)Long.parseLong(keys[1]), newEntryRow);
                continue;
            }
            if (fields.contains(keys[1])) continue;
            newEntryRow = this.getModel().createNewEntryRow("fielddisableentry");
            this.getModel().setValue("disablefieldreport", (Object)Long.parseLong(keys[0]), newEntryRow);
            this.getModel().setValue("disablefield", (Object)Long.parseLong(keys[1]), newEntryRow);
        }
        for (String disableReport : disableReports) {
            repPermData = (UserRepPermData)repFieldMap.get(disableReport);
            List<PermFieldData> permFieldDataList = repPermData.getUserRepPermFieldData();
            for (PermFieldData permFieldData : permFieldDataList) {
                int newEntryRow = this.getModel().createNewEntryRow("fielddisableentry");
                this.getModel().setValue("disablefieldreport", (Object)Long.parseLong(disableReport), newEntryRow);
                this.getModel().setValue("disablefield", (Object)Long.parseLong(permFieldData.getFieldId()), newEntryRow);
            }
        }
        DynamicObjectCollection disableFieldEntry = this.getModel().getEntryEntity("fielddisableentry");
        Iterator disableFieldEntryIterator = disableFieldEntry.iterator();
        while (disableFieldEntryIterator.hasNext()) {
            DynamicObject disableFieldEntryDy = (DynamicObject)disableFieldEntryIterator.next();
            DynamicObject reportDy = disableFieldEntryDy.getDynamicObject("disablefieldreport");
            DynamicObject fieldDy = disableFieldEntryDy.getDynamicObject("disablefield");
            if (reportDy != null && fieldDy != null) {
                String reportId = reportDy.getString("id");
                String fieldId = fieldDy.getString("id");
                if (!enableReportFields.contains(reportId + "|" + fieldId)) continue;
                disableFieldEntryIterator.remove();
                continue;
            }
            disableFieldEntryIterator.remove();
        }
        this.getModel().updateEntryCache(disableFieldEntry);
        this.getModel().updateEntryCache(this.getModel().getEntryEntity("rptpermdataentry"));
    }

    public void deleteSelectReport(Set<String> reportIds) {
        if (reportIds != null && !reportIds.isEmpty()) {
            DynamicObjectCollection selectReportEntry = this.getModel().getEntryEntity("selectreportentry");
            Iterator iterator = selectReportEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject selectReportEntryDy = (DynamicObject)iterator.next();
                DynamicObject reportDy = selectReportEntryDy.getDynamicObject("selectreport");
                if (reportDy == null || !reportIds.contains(reportDy.getString("id"))) continue;
                iterator.remove();
            }
            this.getModel().updateEntryCache(selectReportEntry);
            DynamicObjectCollection disableFieldEntry = this.getModel().getEntryEntity("fielddisableentry");
            Iterator disableFieldIterator = disableFieldEntry.iterator();
            while (disableFieldIterator.hasNext()) {
                DynamicObject disableFieldEntryDy = (DynamicObject)disableFieldIterator.next();
                DynamicObject disableReport = disableFieldEntryDy.getDynamicObject("disablefieldreport");
                if (disableReport == null || !reportIds.contains(disableReport.getString("id"))) continue;
                disableFieldIterator.remove();
            }
            this.getModel().updateEntryCache(disableFieldEntry);
        }
    }

    public void updateSelectReportSort() {
        String sortReportStr = this.getView().getPageCache().get("CACHE_KEY_OF_INDEPENDENT_REPORT_SORT_INDEX");
        if (HRStringUtils.isNotEmpty((String)sortReportStr)) {
            List sortReportIds = JSONArray.parseArray((String)sortReportStr, String.class);
            DynamicObjectCollection selectReportEntry = this.getModel().getEntryEntity("selectreportentry");
            HashMap sortReportIndexMap = Maps.newHashMapWithExpectedSize((int)sortReportIds.size());
            for (int index = 0; index < sortReportIds.size(); ++index) {
                sortReportIndexMap.put(sortReportIds.get(index), index);
            }
            selectReportEntry.sort((x, y) -> {
                boolean xIsMerge = x.getBoolean("selectreportismerge");
                boolean yIsMerge = y.getBoolean("selectreportismerge");
                if (xIsMerge) {
                    return -1;
                }
                if (yIsMerge) {
                    return 1;
                }
                DynamicObject xReportDy = x.getDynamicObject("selectreport");
                DynamicObject yReportDy = y.getDynamicObject("selectreport");
                if (xReportDy != null && yReportDy != null) {
                    String xReportId = xReportDy.getString("id");
                    String yReportId = yReportDy.getString("id");
                    Integer xIndex = (Integer)sortReportIndexMap.get(xReportId);
                    Integer yIndex = (Integer)sortReportIndexMap.get(yReportId);
                    if (xIndex != null && yIndex != null) {
                        return xIndex - yIndex;
                    }
                    if (xIndex != null) {
                        return -1;
                    }
                    return 0;
                }
                if (xReportDy != null) {
                    return -1;
                }
                return 0;
            });
            this.getModel().updateEntryCache(selectReportEntry);
        }
    }
}

