/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.perm.processor;

import com.cronutils.utils.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.business.servicehelper.RptDimMapServiceHelper;
import kd.hr.hrptc.common.constant.perm.ReportUserPermConstants;
import kd.hr.hrptc.common.model.perm.AdminOrgFieldStructureVO;
import kd.hr.hrptc.common.model.perm.AdminOrgStructureVO;
import kd.hr.hrptc.common.model.perm.FieldDimType;
import kd.hr.hrptc.formplugin.perm.model.PermFieldData;
import kd.hr.hrptc.formplugin.perm.model.PermGroup;
import kd.hr.hrptc.formplugin.perm.model.RptAllotUserPermReturnVO;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;

public class RptAlocPermVOProcessor
implements ReportUserPermConstants {
    private static final Log LOGGER = LogFactory.getLog(RptAlocPermVOProcessor.class);
    private final AbstractFormPlugin plugin;
    private final MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
    HRBaseServiceHelper QUERY_FIELD_HELPER = new HRBaseServiceHelper("hrptmc_anobjqueryfield");

    public RptAlocPermVOProcessor(AbstractFormPlugin plugin) {
        this.plugin = plugin;
    }

    private RptAllotUserPermReturnVO getRptAllotUserPermReturnVO(Map<Long, Boolean> queryFieldMustMap) {
        RptAllotUserPermReturnVO returnVO = new RptAllotUserPermReturnVO();
        Map<String, QueryFieldBo> queryFieldBoMap = this.getQueryFieldBoMap(new ArrayList<Object>(queryFieldMustMap.keySet()));
        Map<String, Set<String>> entityNumberToIdsMap = this.getEntityNumberToIdsMap(queryFieldBoMap);
        Map<String, String> baseDataIdToShowNameMap = this.getBaseDataIdToShowNameMap(entityNumberToIdsMap);
        Map adminOrgFieldStructureVOMap = this.getAdminOrgFieldStructList(this.plugin.getView(), queryFieldBoMap.values());
        HashMap fieldDataMap = Maps.newHashMapWithExpectedSize((int)queryFieldBoMap.size());
        HashSet mergeDimKeys = Sets.newHashSetWithExpectedSize((int)queryFieldBoMap.size());
        PermGroup permGroup = new PermGroup("group_1");
        for (QueryFieldBo queryFieldBo : queryFieldBoMap.values()) {
            PermFieldData fieldData;
            String fieldDimType = this.getFieldDimType(queryFieldBo);
            String data = "";
            String mergeDimKey = this.getMergeDimKey(queryFieldBo, fieldDimType);
            String dimUniqueKey = "group_1&" + mergeDimKey;
            String dimSubGroupId = null;
            ArrayList userRepPermFieldData = permGroup.getUserRepPermFieldData();
            if (userRepPermFieldData == null) {
                userRepPermFieldData = Lists.newArrayListWithExpectedSize((int)queryFieldBoMap.size());
                permGroup.setUserRepPermFieldData(userRepPermFieldData);
            }
            if (mergeDimKeys.add(dimUniqueKey)) {
                fieldData = this.buildPermFieldData(queryFieldMustMap.get(Long.parseLong(queryFieldBo.getId())), false, false, fieldDimType, dimUniqueKey, mergeDimKey, queryFieldBo, data, dimSubGroupId, baseDataIdToShowNameMap, adminOrgFieldStructureVOMap);
                userRepPermFieldData.add(fieldData);
                fieldDataMap.put(dimUniqueKey, fieldData);
                continue;
            }
            if (!this.isAdminOrg(fieldDimType)) continue;
            fieldData = (PermFieldData)fieldDataMap.get(dimUniqueKey);
            fieldData.setDimSubGroupId(dimSubGroupId);
            fieldData.setData(data);
            fieldData.setSubGroupFields(this.buildSubGroupFields(fieldData, queryFieldBo, adminOrgFieldStructureVOMap));
        }
        returnVO.setMergeRepPermData(Collections.singletonList(permGroup));
        return returnVO;
    }

    private RptAllotUserPermReturnVO sort(RptAllotUserPermReturnVO vo) {
        for (PermGroup permGroup : vo.getMergeRepPermData()) {
            permGroup.setUserRepPermFieldData(this.sort(permGroup.getUserRepPermFieldData()));
        }
        return vo;
    }

    private List<PermFieldData> sort(List<PermFieldData> sortData) {
        ArrayList<PermFieldData> userRepPermFieldData = new ArrayList<PermFieldData>(sortData.size());
        LOGGER.info("sortData:{}", sortData);
        userRepPermFieldData.addAll(sortData.stream().filter(da -> this.isAdminOrg(da.getFieldDimType())).collect(Collectors.toList()));
        for (PermFieldData permFieldData : userRepPermFieldData) {
            ArrayList<PermFieldData> subDataList = new ArrayList<PermFieldData>(sortData.size());
            subDataList.addAll(permFieldData.getSubGroupFields().stream().filter(sub -> !this.isNull((PermFieldData)sub)).collect(Collectors.toList()));
            subDataList.addAll(permFieldData.getSubGroupFields().stream().filter(this::isNull).collect(Collectors.toList()));
            permFieldData.setSubGroupFields(subDataList);
        }
        LOGGER.info("sortData:{}", sortData);
        userRepPermFieldData.addAll(sortData.stream().filter(da -> !this.isAdminOrg(da.getFieldDimType()) && !this.isNull((PermFieldData)da)).collect(Collectors.toList()));
        LOGGER.info("sortData:{}", sortData);
        userRepPermFieldData.addAll(sortData.stream().filter(da -> !this.isAdminOrg(da.getFieldDimType()) && this.isNull((PermFieldData)da)).collect(Collectors.toList()));
        LOGGER.info("sortData:{}", sortData);
        return userRepPermFieldData;
    }

    private boolean isNull(PermFieldData permFieldData) {
        return !permFieldData.isNoLimit() && StringUtils.isEmpty((CharSequence)permFieldData.getData());
    }

    private boolean isAdminOrg(String fieldDimType) {
        return FieldDimType.ADMIN_ORG.getValue().equals(fieldDimType);
    }

    private RptAllotUserPermReturnVO getRptAllotUserPermReturnVO(DynamicObjectCollection reportPermDataEntry) {
        RptAllotUserPermReturnVO returnVO = new RptAllotUserPermReturnVO();
        Map<String, QueryFieldBo> queryFieldBoMap = this.getQueryFieldBoMap(reportPermDataEntry);
        Map<String, Set<String>> entityNumberToIdsMap = this.getEntityNumberToIdsMap(reportPermDataEntry, queryFieldBoMap);
        Map<String, String> baseDataIdToShowNameMap = this.getBaseDataIdToShowNameMap(entityNumberToIdsMap);
        Map adminOrgFieldStructureVOMap = this.getAdminOrgFieldStructList(this.plugin.getView(), queryFieldBoMap.values());
        LinkedHashMap mergeGroupMap = Maps.newLinkedHashMapWithExpectedSize((int)reportPermDataEntry.size());
        HashMap fieldDataMap = Maps.newHashMapWithExpectedSize((int)reportPermDataEntry.size());
        HashSet mergeDimKeys = Sets.newHashSetWithExpectedSize((int)reportPermDataEntry.size());
        for (DynamicObject dy : reportPermDataEntry) {
            PermFieldData fieldData;
            ArrayList userRepPermFieldData;
            DynamicObject queryField = dy.getDynamicObject("queryfield");
            String fieldId = String.valueOf(queryField.getPkValue());
            QueryFieldBo queryFieldBo = queryFieldBoMap.get(fieldId);
            String fieldDimType = this.getFieldDimType(queryFieldBo);
            String data = dy.getString("data");
            String groupKey = dy.getString("permgroup");
            String mergeDimKey = this.getMergeDimKey(queryFieldBo, fieldDimType);
            String dimUniqueKey = groupKey + "&" + mergeDimKey;
            DynamicObject adminOrgStructDy = dy.getDynamicObject("adminorgstruct");
            String dimSubGroupId = adminOrgStructDy == null ? null : String.valueOf(adminOrgStructDy.getPkValue());
            PermGroup permGroup = (PermGroup)mergeGroupMap.get(groupKey);
            if (permGroup == null) {
                permGroup = new PermGroup(groupKey);
                mergeGroupMap.put(groupKey, permGroup);
            }
            if ((userRepPermFieldData = permGroup.getUserRepPermFieldData()) == null) {
                userRepPermFieldData = Lists.newArrayListWithExpectedSize((int)reportPermDataEntry.size());
                permGroup.setUserRepPermFieldData(userRepPermFieldData);
            }
            if (mergeDimKeys.add(dimUniqueKey)) {
                fieldData = this.buildPermFieldData(dy.getBoolean("mustinput"), dy.getBoolean("nolimit"), dy.getBoolean("includesub"), fieldDimType, dimUniqueKey, mergeDimKey, queryFieldBo, data, dimSubGroupId, baseDataIdToShowNameMap, adminOrgFieldStructureVOMap);
                userRepPermFieldData.add(fieldData);
                fieldDataMap.put(dimUniqueKey, fieldData);
            } else if (this.isAdminOrg(fieldDimType)) {
                fieldData = (PermFieldData)fieldDataMap.get(dimUniqueKey);
                fieldData.setDimSubGroupId(dimSubGroupId);
                fieldData.setData(data);
                fieldData.setShowData(this.getShowName(data, baseDataIdToShowNameMap, dy.getBoolean("includesub")));
                fieldData.setIncludeSub(dy.getBoolean("includesub"));
                fieldData.setSubGroupFields(this.buildSubGroupFields(fieldData, queryFieldBo, adminOrgFieldStructureVOMap));
            }
            returnVO.setMergeRepPermData(Lists.newArrayList(mergeGroupMap.values()));
        }
        return returnVO;
    }

    private Map<String, QueryFieldBo> getQueryFieldBoMap(DynamicObjectCollection reportPermDataEntry) {
        ArrayList queryFieldIds = Lists.newArrayListWithExpectedSize((int)reportPermDataEntry.size());
        for (DynamicObject reportPermDataEntryDy : reportPermDataEntry) {
            DynamicObject queryFieldDy = reportPermDataEntryDy.getDynamicObject("queryfield");
            if (queryFieldDy == null) continue;
            queryFieldIds.add(queryFieldDy.getPkValue());
        }
        return this.getQueryFieldBoMap(queryFieldIds);
    }

    private Map<String, QueryFieldBo> getQueryFieldBoMap(List<Object> queryFieldIds) {
        DynamicObject[] queryFieldDys = this.QUERY_FIELD_HELPER.loadDynamicObjectArray(queryFieldIds.toArray());
        List queryFieldBos = AnalyseObjectService.getInstance().assembleQueryFields(queryFieldDys);
        return queryFieldBos.stream().collect(Collectors.toMap(QueryFieldCommonBo::getId, Function.identity(), (oldValue, newValue) -> oldValue));
    }

    private Map<String, String> getBaseDataIdToShowNameMap(Map<String, Set<String>> entityNumberToIdsMap) {
        HashMap showMap = Maps.newHashMapWithExpectedSize((int)entityNumberToIdsMap.size());
        for (Map.Entry<String, Set<String>> dataMapEntry : entityNumberToIdsMap.entrySet()) {
            DynamicObject[] dbDys;
            MainEntityType mainEntityType = this.mainEntityTypeUtil.getMainEntityType(dataMapEntry.getKey());
            Set<String> value = dataMapEntry.getValue();
            if (!(mainEntityType instanceof BasedataEntityType) || value.isEmpty()) continue;
            String nameProperty = ((BasedataEntityType)mainEntityType).getNameProperty();
            ISimpleProperty primaryKey = mainEntityType.getPrimaryKey();
            Set<Object> ids = primaryKey instanceof LongProp ? value.stream().map(Long::parseLong).collect(Collectors.toSet()) : Sets.newHashSet(value);
            HRBaseServiceHelper helper = new HRBaseServiceHelper(mainEntityType.getName());
            String selectFieldStr = primaryKey.getName() + "," + nameProperty;
            for (DynamicObject dbDy : dbDys = helper.queryOriginalArray(selectFieldStr, new QFilter[]{new QFilter(primaryKey.getName(), "in", (Object)ids)})) {
                showMap.put(dbDy.getString(primaryKey.getName()), dbDy.getString(nameProperty));
            }
        }
        return showMap;
    }

    private String getMergeDimKey(QueryFieldBo queryFieldBo, String fieldDimType) {
        MainEntityType mainEntityType;
        DynamicProperty fieldProperty;
        String entityNumber = queryFieldBo._getFieldEntityNumber();
        String fieldNumber = queryFieldBo.getFieldNumber();
        if (FieldDimType.COMBO.getValue().equals(fieldDimType)) {
            return entityNumber + "$" + fieldNumber;
        }
        if (FieldDimType.BASE_DATA.getValue().equals(fieldDimType)) {
            return entityNumber;
        }
        if (this.isAdminOrg(fieldDimType)) {
            return entityNumber;
        }
        if (FieldDimType.BU.getValue().equals(fieldDimType) && (fieldProperty = this.getFieldProperty(mainEntityType = this.mainEntityTypeUtil.getMainEntityType(queryFieldBo.getEntityNumber()), queryFieldBo.getFieldPath())) instanceof OrgProp) {
            OrgViewSchemeProp orgViewScheme = ((OrgProp)fieldProperty).getOrgViewScheme();
            String orgViewSchemeNumber = orgViewScheme == null ? null : orgViewScheme.getNumber();
            return entityNumber + "#" + ((OrgProp)fieldProperty).getOrgFunc() + "#" + orgViewSchemeNumber;
        }
        return entityNumber;
    }

    private String getShowName(String permData, Map<String, String> baseDataIdToShowNameMap, boolean includeSub) {
        if (HRStringUtils.isNotEmpty((String)permData)) {
            String[] ids = permData.split(",");
            ArrayList showNames = Lists.newArrayListWithExpectedSize((int)ids.length);
            for (String id : ids) {
                String showName = baseDataIdToShowNameMap.get(id);
                if (!HRStringUtils.isNotEmpty((String)showName)) continue;
                if (includeSub) {
                    showName = String.format(ResManager.loadKDString((String)"%s\uff08\u5305\u542b\u4e0b\u7ea7\uff09", (String)"RptAlocPermVOProcessor_1", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]), showName);
                }
                showNames.add(showName);
            }
            return String.join((CharSequence)",", showNames);
        }
        return "";
    }

    private PermFieldData buildPermFieldData(boolean mustInput, boolean noLimit, boolean includeSub, String fieldDimType, String dimUniqueKey, String mergeDimKey, QueryFieldBo queryFieldBo, String permData, String dimSubGroupId, Map<String, String> baseDataIdToShowNameMap, Map<String, AdminOrgFieldStructureVO> adminOrgFieldStructureVOMap) {
        PermFieldData fieldData = new PermFieldData();
        fieldData.setFieldId(queryFieldBo.getId());
        fieldData.setData(permData);
        fieldData.setFieldDimType(fieldDimType);
        fieldData.setDimUniqueKey(dimUniqueKey);
        fieldData.setDimNumber(mergeDimKey);
        fieldData.setDimSubGroupId(dimSubGroupId);
        fieldData.setMustInput(mustInput);
        fieldData.setNoLimit(noLimit);
        String entityNumber = queryFieldBo._getFieldEntityNumber();
        MainEntityType mainEntityType = this.mainEntityTypeUtil.getMainEntityType(entityNumber);
        fieldData.setShowData(this.getShowName(permData, baseDataIdToShowNameMap, includeSub));
        if (FieldDimType.COMBO.getValue().equals(fieldDimType)) {
            DynamicProperty fieldProperty = this.getFieldProperty(mainEntityType, queryFieldBo.getFieldPath());
            if (fieldProperty != null) {
                fieldData.setDimName(fieldProperty.getDisplayName().getLocaleValue());
            }
            fieldData.setComboItems(queryFieldBo.getData());
        } else if (this.isAdminOrg(fieldDimType)) {
            fieldData.setDimName(mainEntityType.getDisplayName().getLocaleValue());
            fieldData.setIncludeSub(includeSub);
            fieldData.setSubGroupFields(this.buildSubGroupFields(fieldData, queryFieldBo, adminOrgFieldStructureVOMap));
            fieldData.setBaseDataNumber(entityNumber);
        } else if (FieldDimType.BU.getValue().equals(fieldDimType)) {
            DynamicProperty fieldProperty = this.getFieldProperty(this.mainEntityTypeUtil.getMainEntityType(queryFieldBo.getEntityNumber()), queryFieldBo.getFieldPath());
            if (fieldProperty instanceof OrgProp) {
                fieldData.setOrgFuncId(((OrgProp)fieldProperty).getOrgFunc());
                OrgViewSchemeProp orgViewScheme = ((OrgProp)fieldProperty).getOrgViewScheme();
                String orgViewSchemeNumber = orgViewScheme == null ? "" : orgViewScheme.getNumber();
                fieldData.setOrgViewSchemeNumber(orgViewSchemeNumber);
            }
            fieldData.setBaseDataNumber(entityNumber);
            fieldData.setDimName(mainEntityType.getDisplayName().getLocaleValue());
        } else {
            fieldData.setBaseDataNumber(entityNumber);
            fieldData.setDimName(mainEntityType.getDisplayName().getLocaleValue());
        }
        return fieldData;
    }

    private List<PermFieldData> buildSubGroupFields(PermFieldData parentField, QueryFieldBo queryFieldBo, Map<String, AdminOrgFieldStructureVO> adminOrgFieldStructureVOMap) {
        String adminOrgFieldUniqueKey = this.getAdminOrgFieldUniqueKey(queryFieldBo.getEntityNumber(), queryFieldBo.getFieldNumber(), queryFieldBo._getFieldEntityNumber());
        AdminOrgFieldStructureVO adminOrgFieldStructureVO = adminOrgFieldStructureVOMap.get(adminOrgFieldUniqueKey);
        List<PermFieldData> subGroupFieldList = parentField.getSubGroupFields();
        if (adminOrgFieldStructureVO != null) {
            String dimSubGroupId = parentField.getDimSubGroupId();
            Collection structures = null;
            if (HRStringUtils.isNotEmpty((String)dimSubGroupId)) {
                Map structureVOMap = adminOrgFieldStructureVO.getStructureVOMap();
                AdminOrgStructureVO structureVO = (AdminOrgStructureVO)structureVOMap.get(dimSubGroupId);
                if (structureVO != null) {
                    structures = Lists.newArrayList((Object[])new AdminOrgStructureVO[]{structureVO});
                }
            } else {
                structures = adminOrgFieldStructureVO._getStructureVOList();
                structures = structures.stream().sorted(Comparator.comparingLong(vo -> Long.parseLong(vo.getId()))).collect(Collectors.toList());
            }
            if (structures != null) {
                for (AdminOrgStructureVO structureVO : structures) {
                    PermFieldData subGroupField = new PermFieldData();
                    subGroupField.setMustInput(false);
                    subGroupField.setFieldId(parentField.getFieldId());
                    subGroupField.setDimName(parentField.getDimName());
                    subGroupField.setOpen(parentField.isOpen());
                    subGroupField.setDimSubGroupId(structureVO.getId());
                    subGroupField.setDimSubGroupName(structureVO.getName());
                    subGroupField.setData(parentField.getData());
                    subGroupField.setShowData(parentField.getShowData());
                    subGroupField.setIncludeSub(parentField.isIncludeSub());
                    subGroupFieldList.add(subGroupField);
                }
            }
        }
        parentField.setDimSubGroupId("");
        parentField.setData("");
        return subGroupFieldList;
    }

    private Map<String, Set<String>> getEntityNumberToIdsMap(DynamicObjectCollection reportPermDataEntry, Map<String, QueryFieldBo> queryFieldBoMap) {
        HashMap entityNumberToIdsMap = Maps.newHashMapWithExpectedSize((int)reportPermDataEntry.size());
        for (DynamicObject reportPermDataEntryDy : reportPermDataEntry) {
            QueryFieldBo queryFieldBo;
            DynamicObject queryFieldDy = reportPermDataEntryDy.getDynamicObject("queryfield");
            String data = reportPermDataEntryDy.getString("data");
            if (queryFieldDy == null || !HRStringUtils.isNotEmpty((String)data) || (queryFieldBo = queryFieldBoMap.get(queryFieldDy.getString("id"))) == null) continue;
            String fieldDimType = this.getFieldDimType(queryFieldBo);
            if (FieldDimType.COMBO.getValue().equals(fieldDimType)) continue;
            String entityNumber = queryFieldBo._getFieldEntityNumber();
            String[] ids = data.split(",");
            entityNumberToIdsMap.putIfAbsent(entityNumber, Sets.newHashSetWithExpectedSize((int)reportPermDataEntry.size()));
            entityNumberToIdsMap.computeIfPresent(entityNumber, (oldKey, set) -> {
                set.addAll(Sets.newHashSet((Object[])ids));
                return set;
            });
        }
        return entityNumberToIdsMap;
    }

    private Map<String, Set<String>> getEntityNumberToIdsMap(Map<String, QueryFieldBo> queryFieldBoMap) {
        HashMap entityNumberToIdsMap = Maps.newHashMapWithExpectedSize((int)queryFieldBoMap.size());
        for (QueryFieldBo queryFieldBo : queryFieldBoMap.values()) {
            String entityNumber = queryFieldBo._getFieldEntityNumber();
            entityNumberToIdsMap.putIfAbsent(entityNumber, Collections.emptySet());
        }
        return entityNumberToIdsMap;
    }

    public RptAllotUserPermReturnVO getPermInitData(long rptManageId) {
        DynamicObject rptDimMapDy = RptDimMapServiceHelper.getRptDimByRptId((Long)rptManageId);
        DynamicObjectCollection coll = rptDimMapDy.getDynamicObjectCollection("entryentity");
        Map<Long, Boolean> queryFieldMustMap = coll.stream().collect(Collectors.toMap(dy -> dy.getLong("aoqfield.id"), dy -> dy.getBoolean("ismust")));
        return this.sort(this.getRptAllotUserPermReturnVO(queryFieldMustMap));
    }

    public RptAllotUserPermReturnVO getPackageData(long rptManageId, DynamicObjectCollection reportPermDataEntry) {
        RptAllotUserPermReturnVO initPermData = this.getPermInitData(rptManageId);
        RptAllotUserPermReturnVO permData = this.getRptAllotUserPermReturnVO(reportPermDataEntry);
        return this.sort(this.getPackageData(initPermData, permData));
    }

    private RptAllotUserPermReturnVO getPackageData(RptAllotUserPermReturnVO permInitData, RptAllotUserPermReturnVO permDataVO) {
        List<PermGroup> permGroups = permDataVO.getMergeRepPermData();
        if (!CollectionUtils.isEmpty(permGroups)) {
            String cloneStr = SerializationUtils.toJsonString((Object)permInitData.getMergeRepPermData().get(0));
            HashMap<String, PermFieldData> permGroupMap = new HashMap<String, PermFieldData>(16);
            ArrayList<PermGroup> packageInitPermFieldDataList = new ArrayList<PermGroup>(10);
            for (PermGroup permGroup : permGroups) {
                for (PermFieldData permFieldData1 : permGroup.getUserRepPermFieldData()) {
                    if (CollectionUtils.isEmpty(permFieldData1.getSubGroupFields())) {
                        permGroupMap.put(permFieldData1.getDimUniqueKey(), permFieldData1);
                        continue;
                    }
                    for (PermFieldData permFieldData : permFieldData1.getSubGroupFields()) {
                        permGroupMap.put(permFieldData1.getDimUniqueKey() + "&" + permFieldData.getDimSubGroupId(), permFieldData);
                    }
                }
                PermGroup initPermGroup = (PermGroup)SerializationUtils.fromJsonString((String)cloneStr.replaceAll("group_1&", permGroup.getGroupKey() + "&"), PermGroup.class);
                initPermGroup.setGroupKey(permGroup.getGroupKey());
                List<PermFieldData> initPermFieldDataList = initPermGroup.getUserRepPermFieldData();
                for (int i = 0; i < initPermFieldDataList.size(); ++i) {
                    PermFieldData initPermFieldData = initPermFieldDataList.get(i);
                    if (CollectionUtils.isEmpty(initPermFieldData.getSubGroupFields())) {
                        PermFieldData permData = (PermFieldData)permGroupMap.get(initPermFieldData.getDimUniqueKey());
                        if (null == permData) continue;
                        permData.setMustInput(initPermFieldData.isMustInput());
                        initPermFieldDataList.set(i, permData);
                        continue;
                    }
                    List<PermFieldData> initSubGroupFieldList = initPermFieldData.getSubGroupFields();
                    for (int j = 0; j < initSubGroupFieldList.size(); ++j) {
                        PermFieldData initSubPermFieldData = initSubGroupFieldList.get(j);
                        initSubPermFieldData = permGroupMap.getOrDefault(initPermFieldData.getDimUniqueKey() + "&" + initSubPermFieldData.getDimSubGroupId(), initSubPermFieldData);
                        initSubGroupFieldList.set(j, initSubPermFieldData);
                    }
                    initPermFieldData.setSubGroupFields(initSubGroupFieldList);
                }
                initPermGroup.setUserRepPermFieldData(initPermFieldDataList);
                packageInitPermFieldDataList.add(initPermGroup);
            }
            permInitData.setMergeRepPermData(packageInitPermFieldDataList);
        }
        return permInitData;
    }
}

