/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.permission;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.listop.ReturnData;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrptc.business.util.RptDimMapUtil;
import kd.hr.hrptc.common.constant.permission.EntityConstants;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class RptSelectDimFieldList
extends AbstractListPlugin
implements EntityConstants {
    private static final Log LOGGER = LogFactory.getLog(RptSelectDimFieldList.class);
    private static final HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptc_dimfield");
    private static final String CALLBACK_DEL_DIMENSION = "deldimensioncallback";

    private DynamicObject map2Dy(Long key, Map<String, String> map) {
        DynamicObject dy = helper.generateEmptyDynamicObject();
        dy.set("id", (Object)key);
        dy.set("propkey", (Object)map.get("number"));
        dy.set("propname", (Object)new LocaleString(map.get("name")));
        dy.set("description", (Object)map.get("baseDataNum"));
        return dy;
    }

    private Map<String, Map<String, String>> getPermissionFieldMap() {
        String permissionFieldStr = (String)this.getView().getFormShowParameter().getCustomParam("permissionFieldMap");
        LOGGER.info("permissionFieldStr:{}", (Object)permissionFieldStr);
        return (Map)SerializationUtils.fromJsonString((String)permissionFieldStr, Map.class);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final Map<String, Map<String, String>> permissionFieldMap = this.getPermissionFieldMap();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
                for (Map.Entry entry : permissionFieldMap.entrySet()) {
                    dynamicObjects.add((Object)RptSelectDimFieldList.this.map2Dy(Long.parseLong((String)entry.getKey()), (Map)entry.getValue()));
                }
                QueryResult queryResult = this.getQueryResult();
                queryResult.setDataCount(permissionFieldMap.size());
                queryResult.setBillDataCount(permissionFieldMap.size());
                queryResult.setCollection(dynamicObjects);
                return dynamicObjects;
            }
        });
    }

    public void listRowClick(ListRowClickEvent evt) {
        this.setName(evt.getListSelectedRowCollection());
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        try {
            Class<?> clazz = Class.forName("kd.bos.mvc.form.FormView");
            Field field = clazz.getDeclaredField("formOperate");
            ReflectionUtils.makeAccessible((Field)field);
            Object formOperate = field.get(e.getSource());
            if (formOperate instanceof ReturnData) {
                ListSelectedRowCollection oldSelected = ((ListShowParameter)this.getView().getFormShowParameter()).getListSelectedRowCollection();
                ListSelectedRowCollection newSelected = ((ListView)e.getSource()).getSelectedRows();
                List oldSelectedIds = oldSelected.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
                List newSelectedIds = newSelected.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
                ArrayList<String> selectedEntity = new ArrayList<String>(10);
                for (ListSelectedRow row2 : newSelected) {
                    Map<String, String> paramMap = this.getPermissionFieldMap().get(row2.getPrimaryKeyValue().toString());
                    String entityNumber = paramMap.get("baseDataNum");
                    if (StringUtils.isEmpty((Object)entityNumber)) continue;
                    if ("haos_adminorghr".equals(entityNumber)) {
                        entityNumber = paramMap.get("entityNumber") + "." + paramMap.get("baseDataNum");
                    }
                    if (selectedEntity.contains(entityNumber)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u5b58\u5728\u91cd\u590d\u6570\u636e,\u8bf7\u68c0\u67e5\u3002", (String)"RptSelectDimFieldList_1", (String)"hrmp-hrptc-formplugin", (Object[])new Object[]{paramMap.get("name")}));
                        e.setCancel(true);
                        return;
                    }
                    selectedEntity.add(entityNumber);
                }
                List deleteList = (List)CollectionUtils.subtract(oldSelectedIds, newSelectedIds);
                if (this.checkPermission(deleteList)) {
                    String tips = ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u7ef4\u5ea6\u6620\u5c04\u5df2\u88ab\u5f15\u7528\uff0c\u5220\u9664\u540e\u62a5\u8868\u5c06\u4e0d\u518d\u8fdb\u884c\u6570\u636e\u6743\u9650\u63a7\u6743\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"RptDimMapEdit_3", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(tips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_DEL_DIMENSION, (IFormPlugin)this));
                    e.setCancel(true);
                    return;
                }
                this.setName(newSelected);
            }
        }
        catch (Exception ex) {
            LOGGER.error("invoke error!", (Throwable)ex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (result == MessageBoxResult.Yes && CALLBACK_DEL_DIMENSION.equals(callBackId)) {
            this.getView().getFormShowParameter().setCustomParam("close", (Object)true);
            this.getView().close();
        }
    }

    private boolean checkPermission(List<Long> deleteList) {
        long rptManageId = (Long)this.getView().getFormShowParameter().getCustomParam("rptManageId");
        return RptDimMapUtil.checkDimMapRef((long)rptManageId, deleteList);
    }

    private void setName(ListSelectedRowCollection selectedRowCollection) {
        try {
            for (ListSelectedRow row : selectedRowCollection) {
                for (Map.Entry<String, Map<String, String>> entry : this.getPermissionFieldMap().entrySet()) {
                    if (!Objects.equals(Long.parseLong(entry.getKey()), row.getPrimaryKeyValue())) continue;
                    row.setName(entry.getValue().get("name"));
                    row.setNumber(entry.getValue().get("number"));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("setName error!", (Throwable)e);
        }
    }
}

