/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.share;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.IListView;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hrptc.business.share.ReportShareConfigService;
import kd.hr.hrptc.common.constant.share.ReportShareConstants;
import kd.hr.hrptmc.common.model.reportcenter.share.ReportShareConfigBo;
import kd.hr.hrptmc.common.model.reportcenter.share.ReportShareFilterRangeBo;

public class ReportShareListPlugin
extends HRDataBaseList
implements ReportShareConstants {
    private final ReportShareConfigService shareConfigService = new ReportShareConfigService();
    private static final Log LOGGER = LogFactory.getLog(ReportShareListPlugin.class);
    private static final String BTN_CANCEL_SHARE = "cancelbtn";
    private final ReportShareConfigService shareService = new ReportShareConfigService();

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (!this.isShareRecordList()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CANCEL_SHARE});
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.isShareRecordList()) {
            e.getQFilters().add(new QFilter("shareuser", "=", (Object)RequestContext.get().getCurrUserId()));
        } else if (this.isMyShareList()) {
            e.getQFilters().add(new QFilter("receiveuser.fbasedataid.id", "=", (Object)RequestContext.get().getCurrUserId()));
        }
    }

    public void packageData(PackageDataEvent event) {
        try {
            this.doPackageData(event);
        }
        catch (Exception exception) {
            LOGGER.error("ReportShareListPlugin packageData error: ", (Throwable)exception);
        }
    }

    private void doPackageData(PackageDataEvent event) {
        DynamicObject rowData;
        String shareStatus;
        if (!this.isShareRecordList() && !this.isMyShareList()) {
            return;
        }
        ColumnDesc columnDesc = (ColumnDesc)event.getSource();
        if (columnDesc == null) {
            return;
        }
        if (columnDesc instanceof ListOperationColumnDesc && columnDesc.getKey().equals("operation")) {
            DynamicObject rowData2 = event.getRowData();
            String shareStatus2 = rowData2.getString("sharestatus");
            if (HRStringUtils.equals((String)shareStatus2, (String)"cancel")) {
                List operationColItems = (List)event.getFormatValue();
                ((OperationColItem)operationColItems.get(0)).setVisible(false);
            }
            return;
        }
        String fieldNum = columnDesc.getFieldProp().getName();
        if (HRStringUtils.equals((String)fieldNum, (String)"expiration") && HRStringUtils.equals((String)(shareStatus = (rowData = event.getRowData()).getString("sharestatus")), (String)"cancel")) {
            if (this.isShareRecordList()) {
                event.setFormatValue((Object)ResManager.loadKDString((String)"\u5df2\u53d6\u6d88\u5206\u4eab", (String)"ReportShareListPlugin_1", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
            }
            if (this.isMyShareList()) {
                event.setFormatValue((Object)ResManager.loadKDString((String)"\u5206\u4eab\u4eba\u5df2\u53d6\u6d88\u5206\u4eab", (String)"ReportShareListPlugin_2", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        try {
            if (StringUtils.equals((CharSequence)"reportnumber", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
                args.setCancel(true);
                Long shareRecordId = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
                if (this.validateExpirationAndStatus(shareRecordId)) {
                    this.showShareReport(shareRecordId);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReportShareListPlugin billListHyperLinkClick error: ", (Throwable)exception);
        }
    }

    private boolean validateExpirationAndStatus(Long shareRecordId) {
        DynamicObject shareDy = this.shareService.queryExpirationAndStatus(shareRecordId.longValue());
        if (shareDy == null) {
            return false;
        }
        String runStatus = shareDy.getString("runstatus");
        if (HRStringUtils.equals((String)runStatus, (String)"0") || HRStringUtils.equals((String)runStatus, (String)"5")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u4eab\u6570\u636e\u5b58\u50a8\u4e2d\uff0c\u6b64\u8fc7\u7a0b\u9884\u8ba1\u6301\u7eed\u51e0\u5206\u949f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReportShareListPlugin_5", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.equals((String)runStatus, (String)"2")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u4eab\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ReportShareListPlugin_6", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.equals((String)runStatus, (String)"4")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u4eab\u5df2\u88ab\u4e2d\u6b62\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ReportShareListPlugin_7", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.isMyShareList()) {
            String shareStatus = shareDy.getString("sharestatus");
            Date expiration = shareDy.getDate("expiration");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date today = calendar.getTime();
            if (expiration.getTime() < today.getTime() || HRStringUtils.equals((String)shareStatus, (String)"cancel")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u4eab\u4eba\u5df2\u53d6\u6d88\u5206\u4eab\u6216\u5df2\u8d85\u51fa\u5206\u4eab\u6709\u6548\u671f\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"ReportShareListPlugin_3", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        try {
            if (this.isShareRecordList() && HRStringUtils.equals((String)operateKey, (String)"cancelshare")) {
                ((IListView)this.getView()).refresh();
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReportShareListPlugin afterDoOperation error: ", (Throwable)exception);
        }
    }

    private void showShareReport(Long shareRecordId) {
        ReportShareConfigBo reportShareConfigBo = this.shareConfigService.getReportShareConfigBo(shareRecordId.longValue());
        if (reportShareConfigBo.getEsIndex() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u6e05\u7406\u3002", (String)"ReportShareListPlugin_4", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
            return;
        }
        String reportNumber = reportShareConfigBo.getReportNumber();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setHasRight(true);
        showParameter.setFormId(reportNumber);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Date shareTime = reportShareConfigBo.getShareTime();
        showParameter.setCustomParam("shareId", (Object)shareRecordId);
        showParameter.setCustomParam("isVersion", (Object)Boolean.TRUE);
        showParameter.setCustomParam("versionTime", (Object)shareTime);
        showParameter.setCustomParam("openFrom", (Object)"share");
        String shareSource = reportShareConfigBo.getShareSource();
        showParameter.setCustomParam("shareSource", (Object)shareSource);
        showParameter.setCustomParam("reportEsIndexId", (Object)reportShareConfigBo.getEsIndex());
        showParameter.setCustomParam("baseDataEsIndexId", (Object)reportShareConfigBo.getBaseDataEsIndex());
        showParameter.setCustomParam("baseDataPermQFilter", (Object)reportShareConfigBo.getF7QFilter());
        showParameter.setCustomParam("adminOrgF7PermQFilter", (Object)reportShareConfigBo.getAdminOrgF7QFilter());
        showParameter.setCustomParam("CUSTOM_PARAM_PUBLISH_TYPE", (Object)"reportCenter");
        if (HRStringUtils.equals((String)shareSource, (String)"ReportSubscribe")) {
            showParameter.setCustomParam("reportFilter", (Object)reportShareConfigBo.getReportQFilterStr());
        }
        showParameter.setCustomParam("onlyQueryResult", (Object)reportShareConfigBo.isOnlyQueryResult());
        if (reportShareConfigBo.getShareFilterRangeBoList() != null) {
            showParameter.setCustomParam("shareFilterRangeBoList", (Object)SerializationUtils.toJsonString((Object)reportShareConfigBo.getShareFilterRangeBoList()));
            Optional<ReportShareFilterRangeBo> userdispscmOp = reportShareConfigBo.getShareFilterRangeBoList().stream().filter(bo -> HRStringUtils.equals((String)bo.getFieldAlias(), (String)"userdispscm")).findAny();
            userdispscmOp.ifPresent(reportShareFilterRangeBo -> showParameter.setCustomParam("shareReportUserDisplayScheme", (Object)reportShareFilterRangeBo.getUserDisplayScheme()));
            Optional<ReportShareFilterRangeBo> containSubOp = reportShareConfigBo.getShareFilterRangeBoList().stream().filter(bo -> HRStringUtils.equals((String)bo.getFieldAlias(), (String)"containsub")).findAny();
            containSubOp.ifPresent(reportShareFilterRangeBo -> showParameter.setCustomParam("shareReportContainSub", (Object)reportShareFilterRangeBo.getContainSub()));
        }
        this.getView().showForm(showParameter);
    }

    private boolean isShareRecordList() {
        String billFormId = ((IListView)this.getView()).getBillFormId();
        return HRStringUtils.equals((String)billFormId, (String)"hrptmc_sharerecord");
    }

    private boolean isMyShareList() {
        String billFormId = ((IListView)this.getView()).getBillFormId();
        return HRStringUtils.equals((String)billFormId, (String)"hrptmc_sharerecord_layout");
    }
}

