/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.formplugin.subscribe;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hrptc.business.subscribe.ReportMySubscribeService;
import kd.hr.hrptc.common.constant.subscribe.ReportSubscribeConstants;
import kd.hr.hrptc.common.model.subscribe.ReportMySubscribeBo;
import kd.hr.hrptmc.business.repdesign.hisversion.ReportHisVersionService;

public class ReportMySubscribeListPlugin
extends HRDataBaseList
implements ReportSubscribeConstants {
    private final ReportMySubscribeService mySubscribeService = new ReportMySubscribeService();
    private static final Log LOGGER = LogFactory.getLog(ReportMySubscribeListPlugin.class);

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String billFormId = ((IListView)this.getView()).getBillFormId();
        if (HRStringUtils.equals((String)billFormId, (String)"hrptmc_mysubscribe")) {
            e.getQFilters().add(new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId()));
            e.getQFilters().add(new QFilter("runstatus", "in", (Object)new String[]{"1", "3"}));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        try {
            if (StringUtils.equals((CharSequence)"name", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
                args.setCancel(true);
                Long subscribeId = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
                this.showSubscribeReport(subscribeId);
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReportMySubscribeListPlugin billListHyperLinkClick error: ", (Throwable)exception);
        }
    }

    public void packageData(PackageDataEvent event) {
        try {
            this.doPackageData(event);
        }
        catch (Exception exception) {
            LOGGER.error("ReportShareListPlugin packageData error: ", (Throwable)exception);
        }
    }

    private void doPackageData(PackageDataEvent event) {
        if (!(event.getSource() instanceof DynamicTextColumnDesc)) {
            return;
        }
        DynamicTextColumnDesc dataSource = (DynamicTextColumnDesc)event.getSource();
        if (HRStringUtils.equals((String)dataSource.getFieldKey(), (String)"datasource")) {
            long reportId = event.getRowData().getLong("report");
            Date subscribeTime = event.getRowData().getDate("createtime");
            Map reportNumberAndName = ReportHisVersionService.getInstance().getReportNumberAndName(reportId, subscribeTime);
            LocaleString reportName = (LocaleString)reportNumberAndName.get("name");
            event.setFormatValue((Object)reportName.getLocaleValue());
        }
    }

    private void showSubscribeReport(Long subscribeId) {
        ReportMySubscribeBo mySubscribeBo = this.mySubscribeService.getMySubscribeBo(subscribeId.longValue());
        if (mySubscribeBo.getEsIndex() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u6e05\u7406\u3002", (String)"ReportMySubscribeListPlugin_1", (String)"hrmp-hrptc-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(mySubscribeBo.getReportNumber());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(true);
        showParameter.setCustomParam("mySubScribeId", (Object)mySubscribeBo.getId());
        showParameter.setCustomParam("reportId", (Object)mySubscribeBo.getReportId());
        showParameter.setCustomParam("reportName", (Object)mySubscribeBo.getReportName());
        showParameter.setCustomParam("reportNumber", (Object)mySubscribeBo.getReportNumber());
        showParameter.setCustomParam("openFrom", (Object)"mySubscribe");
        showParameter.setCustomParam("reportEsIndexId", (Object)mySubscribeBo.getEsIndex());
        showParameter.setCustomParam("baseDataEsIndexId", (Object)mySubscribeBo.getBaseDataEsIndex());
        showParameter.setCustomParam("baseDataPermQFilter", (Object)mySubscribeBo.getF7QFilter());
        showParameter.setCustomParam("adminOrgF7PermQFilter", (Object)mySubscribeBo.getAdminOrgF7QFilter());
        if (HRStringUtils.isNotEmpty((String)mySubscribeBo.getDataQFilter())) {
            showParameter.setCustomParam("reportDataPermQFilter", (Object)mySubscribeBo.getDataQFilter());
        }
        showParameter.setCustomParam("isVersion", (Object)Boolean.TRUE);
        showParameter.setCustomParam("versionTime", (Object)mySubscribeBo.getSubscribeTime());
        showParameter.setCustomParam("sharesource", (Object)"ReportSubscribe");
        showParameter.setCustomParam("CUSTOM_PARAM_PUBLISH_TYPE", (Object)"reportCenter");
        this.getView().showForm(showParameter);
    }
}

